/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsDependentEnum<T> {
    private static final String DEPENDENT_PERSISTENT_LIST_START_PREFIX = "vfs_enum_";
    private final File myFile;
    private final DataExternalizer<T> myKeyDescriptor;
    private int myVersion;
    private boolean myMarkedForInvalidation;
    private final ConcurrentList<T> myInstances = ContainerUtil.createConcurrentList();
    private final ConcurrentMap<T, Integer> myInstanceToId = ContainerUtil.newConcurrentMap();
    private final Object myLock = new Object();
    private boolean myTriedToLoadFile;

    public VfsDependentEnum(String fileName, KeyDescriptor<T> descriptor, int version) {
        this.myFile = new File(FSRecords.basePath(), DEPENDENT_PERSISTENT_LIST_START_PREFIX + fileName + FSRecords.VFS_FILES_EXTENSION);
        this.myKeyDescriptor = descriptor;
        this.myVersion = version;
    }

    static File getBaseFile() {
        return new File(FSRecords.basePath(), DEPENDENT_PERSISTENT_LIST_START_PREFIX);
    }

    public int getId(@NotNull T s) throws IOException {
        Integer integer;
        if (s == null) {
            VfsDependentEnum.$$$reportNull$$$0(0);
        }
        if ((integer = (Integer)this.myInstanceToId.get(s)) != null) {
            return integer;
        }
        Object object = this.myLock;
        synchronized (object) {
            integer = (Integer)this.myInstanceToId.get(s);
            if (integer != null) {
                return integer;
            }
            try {
                boolean loaded = this.loadFromFile();
                if (loaded && (integer = (Integer)this.myInstanceToId.get(s)) != null) {
                    return integer;
                }
                int enumerated = this.myInstances.size() + 1;
                this.register(s, enumerated);
                this.saveToFile(s);
                return enumerated;
            }
            catch (IOException e) {
                throw this.invalidate(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(@NotNull T instance) throws IOException {
        if (instance == null) {
            VfsDependentEnum.$$$reportNull$$$0(1);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.myFile, true);
        DataOutputStream output = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        try {
            if (this.myFile.length() == 0L) {
                DataInputOutputUtil.writeTIME((DataOutput)output, (long)FSRecords.getCreationTimestamp());
                DataInputOutputUtil.writeINT((DataOutput)output, (int)this.myVersion);
            }
            this.myKeyDescriptor.save((DataOutput)output, instance);
        }
        finally {
            try {
                output.close();
                fileOutputStream.getFD().sync();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean loadFromFile() throws IOException {
        if (!this.myTriedToLoadFile && this.myInstances.size() == 0 && this.myFile.exists()) {
            this.myTriedToLoadFile = true;
            DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.myFile)));
            long vfsVersion = DataInputOutputUtil.readTIME((DataInput)input);
            if (vfsVersion != FSRecords.getCreationTimestamp()) {
                try {
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                FileUtil.deleteWithRenaming((File)this.myFile);
                return false;
            }
            ArrayList<Object> elements = new ArrayList<Object>();
            THashMap elementToIdMap = new THashMap();
            int savedVersion = DataInputOutputUtil.readINT((DataInput)input);
            try {
                if (savedVersion == this.myVersion) {
                    while (input.available() > 0) {
                        Object instance = this.myKeyDescriptor.read((DataInput)input);
                        assert (instance != null);
                        elements.add(instance);
                        elementToIdMap.put(instance, elements.size());
                    }
                    this.myInstances.addAll(elements);
                    this.myInstanceToId.putAll((Map<T, Integer>)elementToIdMap);
                    boolean bl = true;
                    return bl;
                }
                throw new IOException("Version mismatch: current " + this.myVersion + ", previous:" + savedVersion + ", file:" + this.myFile);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    @Nullable
    private IOException invalidate(@Nullable Throwable e) {
        if (!this.myMarkedForInvalidation) {
            this.doInvalidation(e);
            this.myMarkedForInvalidation = true;
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return null;
    }

    protected void doInvalidation(Throwable e) {
        FileUtil.deleteWithRenaming((File)this.myFile);
        FSRecords.requestVfsRebuild(e);
    }

    private void register(@NotNull T instance, int id) {
        if (instance == null) {
            VfsDependentEnum.$$$reportNull$$$0(2);
        }
        this.myInstanceToId.put(instance, id);
        assert (id == this.myInstances.size() + 1);
        this.myInstances.add(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public T getById(int id) throws IOException {
        boolean loaded;
        block11: {
            Object instance;
            assert (id > 0);
            if (--id < this.myInstances.size() && (instance = this.myInstances.get(id)) != null) {
                Object object = instance;
                if (object != null) return (T)object;
                VfsDependentEnum.$$$reportNull$$$0(3);
                return (T)object;
            }
            Object object = this.myLock;
            // MONITORENTER : object
            if (id < this.myInstances.size() && (instance = this.myInstances.get(id)) != null) {
                Object object2 = instance;
                // MONITOREXIT : object
                if (object2 != null) return (T)object2;
                VfsDependentEnum.$$$reportNull$$$0(4);
                return (T)object2;
            }
            loaded = this.loadFromFile();
            if (!loaded || (instance = this.myInstances.get(id)) == null) break block11;
            Object object3 = instance;
            // MONITOREXIT : object
            if (object3 != null) return (T)object3;
            VfsDependentEnum.$$$reportNull$$$0(5);
            return (T)object3;
        }
        try {
            assert (false) : "Reading nonexistent value:" + id + "," + this.myFile + ", loaded:" + loaded;
        }
        catch (IOException e) {
            throw this.invalidate(e);
        }
        catch (AssertionError e) {
            this.invalidate((Throwable)((Object)e));
            throw e;
        }
        VfsDependentEnum.$$$reportNull$$$0(6);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/VfsDependentEnum";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/VfsDependentEnum";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getById";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

