/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.PaintersHelper;
import com.intellij.openapi.wm.impl.ToolWindowHeader;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.ImageLoader;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeBackgroundUtil {
    public static final String EDITOR_PROP = "idea.background.editor";
    public static final String FRAME_PROP = "idea.background.frame";
    public static final String TARGET_PROP = "idea.background.target";
    private static final Set<String> ourKnownNames;
    static final RenderingHints.Key ADJUST_ALPHA;

    @NotNull
    public static Graphics2D withEditorBackground(@NotNull Graphics g, @NotNull JComponent component) {
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(0);
        }
        if (component == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(1);
        }
        if (IdeBackgroundUtil.suppressBackground(component)) {
            Graphics2D graphics2D = (Graphics2D)g;
            if (graphics2D == null) {
                IdeBackgroundUtil.$$$reportNull$$$0(2);
            }
            return graphics2D;
        }
        Graphics2D graphics2D = IdeBackgroundUtil.withNamedPainters(g, EDITOR_PROP, component);
        if (graphics2D == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(3);
        }
        return graphics2D;
    }

    @NotNull
    public static Graphics2D withFrameBackground(@NotNull Graphics g, @NotNull JComponent component) {
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(4);
        }
        if (component == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(5);
        }
        if (IdeBackgroundUtil.suppressBackground(component)) {
            Graphics2D graphics2D = (Graphics2D)g;
            if (graphics2D == null) {
                IdeBackgroundUtil.$$$reportNull$$$0(6);
            }
            return graphics2D;
        }
        Graphics2D graphics2D = IdeBackgroundUtil.withNamedPainters(g, FRAME_PROP, component);
        if (graphics2D == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(7);
        }
        return graphics2D;
    }

    private static boolean suppressBackground(JComponent component) {
        String type = IdeBackgroundUtil.getComponentType(component);
        if (type == null) {
            return false;
        }
        String spec = System.getProperty(TARGET_PROP, "*");
        boolean allInclusive = spec.startsWith("*");
        return allInclusive && spec.contains("-" + type) || !allInclusive && !spec.contains(type);
    }

    private static String getComponentType(JComponent component) {
        return component instanceof JTree ? "tree" : (component instanceof JList ? "list" : (component instanceof JTable ? "table" : (component instanceof JViewport ? "viewport" : (component instanceof JTabbedPane ? "tabs" : (component instanceof JButton ? "button" : (component instanceof ActionToolbar ? "toolbar" : (component instanceof EditorsSplitters ? "frame" : (component instanceof EditorComponentImpl ? "editor" : (component instanceof EditorGutterComponentEx ? "editor" : (component instanceof JBLoadingPanel ? "loading" : (component instanceof JBTabs ? "tabs" : (component instanceof ToolWindowHeader ? "title" : (component instanceof JBPanelWithEmptyText ? "panel" : (component instanceof JPanel && ourKnownNames.contains(component.getName()) ? component.getName() : null))))))))))))));
    }

    @NotNull
    public static Graphics2D getOriginalGraphics(@NotNull Graphics g) {
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(8);
        }
        Graphics2D graphics2D = g instanceof MyGraphics ? ((MyGraphics)((Object)g)).getDelegate() : (Graphics2D)g;
        if (graphics2D == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(9);
        }
        return graphics2D;
    }

    @NotNull
    public static Graphics2D withNamedPainters(@NotNull Graphics g, @NotNull String paintersName, @NotNull JComponent component) {
        PaintersHelper helper;
        JRootPane rootPane;
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(10);
        }
        if (paintersName == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(11);
        }
        if (component == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(12);
        }
        Component glassPane = (rootPane = component.getRootPane()) == null ? null : rootPane.getGlassPane();
        PaintersHelper paintersHelper = helper = glassPane instanceof IdeGlassPaneImpl ? ((IdeGlassPaneImpl)glassPane).getNamedPainters(paintersName) : null;
        if (helper == null || !helper.needsRepaint()) {
            Graphics2D graphics2D = (Graphics2D)g;
            if (graphics2D == null) {
                IdeBackgroundUtil.$$$reportNull$$$0(13);
            }
            return graphics2D;
        }
        Graphics2D graphics2D = MyGraphics.wrap(g, helper, component);
        if (graphics2D == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(14);
        }
        return graphics2D;
    }

    public static void initEditorPainters(@NotNull IdeGlassPaneImpl glassPane) {
        if (glassPane == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(15);
        }
        PaintersHelper.initWallpaperPainter(EDITOR_PROP, glassPane.getNamedPainters(EDITOR_PROP));
    }

    public static void initFramePainters(@NotNull IdeGlassPaneImpl glassPane) {
        Image centerImage;
        if (glassPane == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(16);
        }
        PaintersHelper painters = glassPane.getNamedPainters(FRAME_PROP);
        PaintersHelper.initWallpaperPainter(FRAME_PROP, painters);
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        String path = null;
        URL url = path == null ? null : ((Object)((Object)appInfo)).getClass().getResource(path);
        Image image = centerImage = url == null ? null : ImageLoader.loadFromUrl((URL)url);
        if (centerImage != null) {
            painters.addPainter((Painter)PaintersHelper.newImagePainter(centerImage, Fill.PLAIN, Anchor.TOP_CENTER, 1.0f, (Insets)JBUI.insets((int)10, (int)0, (int)0, (int)0)), null);
        }
        painters.addPainter((Painter)new AbstractPainter(){
            EditorEmptyTextPainter p = (EditorEmptyTextPainter)ServiceManager.getService(EditorEmptyTextPainter.class);

            public boolean needsRepaint() {
                return true;
            }

            public void executePaint(Component component, Graphics2D g) {
                this.p.paintEmptyText((JComponent)component, g);
            }
        }, null);
    }

    @NotNull
    public static Color getIdeBackgroundColor() {
        Color result2 = UIUtil.getSlightlyDarkerColor((Color)UIUtil.getPanelBackground());
        Color color = UIUtil.isUnderDarcula() ? new Color(40, 40, 41) : UIUtil.getSlightlyDarkerColor((Color)UIUtil.getSlightlyDarkerColor((Color)result2));
        if (color == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(17);
        }
        return color;
    }

    public static void createTemporaryBackgroundTransform(JPanel root, String tmp, Disposable disposable) {
        PaintersHelper paintersHelper = new PaintersHelper(root);
        PaintersHelper.initWallpaperPainter(tmp, paintersHelper);
        Disposer.register((Disposable)disposable, (Disposable)JBSwingUtilities.addGlobalCGTransform((t, v) -> {
            if (!UIUtil.isAncestor((Component)root, (Component)t)) {
                return v;
            }
            return MyGraphics.wrap(v, paintersHelper, t);
        }));
    }

    public static void createTemporaryBackgroundTransform(JPanel root, Image image, Fill fill, Anchor anchor2, float alpha, Insets insets, Disposable disposable) {
        PaintersHelper paintersHelper = new PaintersHelper(root);
        paintersHelper.addPainter((Painter)PaintersHelper.newImagePainter(image, fill, anchor2, alpha, insets), root);
        Disposer.register((Disposable)disposable, (Disposable)JBSwingUtilities.addGlobalCGTransform((t, v) -> {
            if (!UIUtil.isAncestor((Component)root, (Component)t)) {
                return v;
            }
            return MyGraphics.wrap(v, paintersHelper, t);
        }));
    }

    @NotNull
    public static String getBackgroundSpec(@Nullable Project project, @NotNull String propertyName) {
        String spec;
        if (propertyName == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(18);
        }
        String string = spec = project == null || project.isDisposed() ? null : PropertiesComponent.getInstance((Project)project).getValue(propertyName);
        if (spec == null) {
            spec = PropertiesComponent.getInstance().getValue(propertyName);
        }
        String string2 = StringUtil.notNullize((String)spec, (String)System.getProperty(propertyName, ""));
        if (string2 == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(19);
        }
        return string2;
    }

    public static boolean isEditorBackgroundImageSet(@Nullable Project project) {
        return StringUtil.isNotEmpty((String)IdeBackgroundUtil.getBackgroundSpec(project, EDITOR_PROP));
    }

    public static void repaintAllWindows() {
        for (Window window : Window.getWindows()) {
            window.repaint();
        }
    }

    static {
        JBSwingUtilities.addGlobalCGTransform((PairFunction)new MyTransform());
        ourKnownNames = ContainerUtil.newHashSet((Object[])new String[]{"navbar", "terminal"});
        ADJUST_ALPHA = new RenderingHints.Key(1){

            @Override
            public boolean isCompatibleValue(Object val) {
                return val instanceof Boolean;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paintersName";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "glassPane";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withEditorBackground";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withFrameBackground";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalGraphics";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withNamedPainters";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeBackgroundColor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withEditorBackground";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 19: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withFrameBackground";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalGraphics";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withNamedPainters";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initEditorPainters";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initFramePainters";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundSpec";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTransform
    implements PairFunction<JComponent, Graphics2D, Graphics2D> {
        private MyTransform() {
        }

        public Graphics2D fun(JComponent c, Graphics2D g) {
            Graphics2D gg;
            String type = IdeBackgroundUtil.getComponentType(c);
            if (type == null) {
                return g;
            }
            if ("frame".equals(type)) {
                return IdeBackgroundUtil.withFrameBackground(g, c);
            }
            if ("editor".equals(type)) {
                EditorImpl editor;
                EditorImpl editorImpl = c instanceof EditorComponentImpl ? ((EditorComponentImpl)c).getEditor() : (editor = c instanceof EditorGutterComponentEx ? (Editor)CommonDataKeys.EDITOR.getData((DataProvider)c) : null);
                if (editor != null) {
                    if (!(g instanceof MyGraphics) && Boolean.TRUE.equals(EditorTextField.SUPPLEMENTARY_KEY.get((UserDataHolder)editor))) {
                        return g;
                    }
                    if (c instanceof EditorComponentImpl && editor.isDumb()) {
                        return MyGraphics.unwrap(g);
                    }
                    Graphics2D gg2 = IdeBackgroundUtil.withEditorBackground(g, c);
                    if (gg2 instanceof MyGraphics) {
                        Color background1 = ((EditorEx)editor).getBackgroundColor();
                        Color background2 = ((EditorEx)editor).getGutterComponentEx().getBackground();
                        ((MyGraphics)((Object)gg2)).preserved = color -> color != background1 && color != background2;
                    }
                    return gg2;
                }
            }
            if ((gg = IdeBackgroundUtil.withEditorBackground(g, c)) instanceof MyGraphics) {
                JComponent view;
                Component component = view = c instanceof JViewport ? ((JViewport)c).getView() : c;
                Color selectionColor = view instanceof JTree ? UIUtil.getTreeSelectionBackground() : (view instanceof JList ? UIUtil.getListSelectionBackground() : (view instanceof JTable ? UIUtil.getTableSelectionBackground() : null));
                ((MyGraphics)((Object)gg)).preserved = color -> color == selectionColor;
            }
            return gg;
        }
    }

    private static class MyGraphics
    extends Graphics2DDelegate {
        final PaintersHelper helper;
        final int[] offsets;
        Condition<Color> preserved;

        static Graphics2D wrap(Graphics g, PaintersHelper helper, JComponent component) {
            MyGraphics gg = g instanceof MyGraphics ? (MyGraphics)((Object)g) : null;
            return new MyGraphics(gg != null ? gg.myDelegate : g, helper, helper.computeOffsets(g, component), gg != null ? gg.preserved : null);
        }

        static Graphics2D unwrap(Graphics g) {
            return g instanceof MyGraphics ? ((MyGraphics)((Object)g)).getDelegate() : (Graphics2D)g;
        }

        MyGraphics(Graphics g, PaintersHelper helper, int[] offsets, Condition<Color> preserved) {
            super((Graphics2D)g);
            this.helper = helper;
            this.offsets = offsets;
            this.preserved = preserved;
        }

        @NotNull
        public Graphics create() {
            MyGraphics myGraphics = new MyGraphics(this.getDelegate().create(), this.helper, this.offsets, this.preserved);
            if (myGraphics == null) {
                MyGraphics.$$$reportNull$$$0(0);
            }
            return myGraphics;
        }

        public void clearRect(int x, int y, int width, int height) {
            super.clearRect(x, y, width, height);
            this.runAllPainters(x, y, width, height, null, this.getColor());
        }

        public void fillRect(int x, int y, int width, int height) {
            super.fillRect(x, y, width, height);
            this.runAllPainters(x, y, width, height, null, this.getColor());
        }

        public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            super.fillArc(x, y, width, height, startAngle, arcAngle);
            this.runAllPainters(x, y, width, height, new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2), this.getColor());
        }

        public void fillOval(int x, int y, int width, int height) {
            super.fillOval(x, y, width, height);
            this.runAllPainters(x, y, width, height, new Ellipse2D.Double(x, y, width, height), this.getColor());
        }

        public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            super.fillPolygon(xPoints, yPoints, nPoints);
            Polygon s = new Polygon(xPoints, yPoints, nPoints);
            Rectangle r = s.getBounds();
            this.runAllPainters(r.x, r.y, r.width, r.height, s, this.getColor());
        }

        public void fillPolygon(Polygon s) {
            super.fillPolygon(s);
            Rectangle r = s.getBounds();
            this.runAllPainters(r.x, r.y, r.width, r.height, s, this.getColor());
        }

        public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            super.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
            this.runAllPainters(x, y, width, height, new RoundRectangle2D.Double(x, y, width, height, arcHeight, arcHeight), this.getColor());
        }

        public void fill(Shape s) {
            super.fill(s);
            Rectangle r = s.getBounds();
            this.runAllPainters(r.x, r.y, r.width, r.height, s, this.getColor());
        }

        public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
            super.drawImage(img, op, x, y);
            this.runAllPainters(x, y, img.getWidth(), img.getHeight(), null, img);
        }

        public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, width, height, observer);
            this.runAllPainters(x, y, width, height, null, img);
            return b;
        }

        public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, observer);
            this.runAllPainters(x, y, img.getWidth(null), img.getHeight(null), null, img);
            return b;
        }

        @Nullable
        private static Shape calcTempClip(@Nullable Shape prevClip, @NotNull Shape forcedClip) {
            if (forcedClip == null) {
                MyGraphics.$$$reportNull$$$0(1);
            }
            if (prevClip == null) {
                return forcedClip;
            }
            if (prevClip instanceof Rectangle2D && forcedClip instanceof Rectangle2D) {
                Rectangle2D r = ((Rectangle2D)prevClip).createIntersection((Rectangle2D)forcedClip);
                return r.isEmpty() ? null : r;
            }
            Area area = new Area(prevClip);
            area.intersect(new Area(forcedClip));
            return area.getBounds().isEmpty() ? null : area;
        }

        void runAllPainters(int x, int y, int width, int height, @Nullable Shape sourceShape, @Nullable Object reason) {
            boolean preserve;
            Shape prevClip;
            Shape tmpClip;
            if (width <= 1 || height <= 1) {
                return;
            }
            if (reason instanceof Color && ((Color)reason).getAlpha() < 255) {
                return;
            }
            if (reason instanceof Image) {
                if (!(reason instanceof BufferedImage)) {
                    return;
                }
                if (((BufferedImage)reason).getColorModel().hasAlpha()) {
                    return;
                }
            }
            if ((tmpClip = MyGraphics.calcTempClip(prevClip = this.getClip(), sourceShape != null ? sourceShape : new Rectangle(x, y, width, height))) == null) {
                return;
            }
            boolean bl = preserve = this.preserved != null && reason instanceof Color && this.preserved.value((Object)((Color)reason));
            if (preserve) {
                this.myDelegate.setRenderingHint(ADJUST_ALPHA, Boolean.TRUE);
            }
            this.setClip(tmpClip);
            this.helper.runAllPainters(this.myDelegate, this.offsets);
            this.setClip(prevClip);
            if (preserve) {
                this.myDelegate.setRenderingHint(ADJUST_ALPHA, Boolean.FALSE);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil$MyGraphics";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forcedClip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil$MyGraphics";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "calcTempClip";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Anchor {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        MIDDLE_LEFT,
        CENTER,
        MIDDLE_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }

    public static enum Fill {
        PLAIN,
        SCALE,
        TILE;

    }
}

