/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.IdeFocusManagerHeadless;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowHeadlessManagerImpl
extends ToolWindowManagerEx {
    private final Map<String, ToolWindow> myToolWindows = new HashMap<String, ToolWindow>();
    private final Project myProject;

    public ToolWindowHeadlessManagerImpl(Project project) {
        this.myProject = project;
    }

    public boolean canShowNotification(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(0);
        }
        return false;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String htmlBody) {
        if (toolWindowId == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(2);
        }
        if (htmlBody == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(3);
        }
    }

    private ToolWindow doRegisterToolWindow(String id, @Nullable Disposable parentDisposable) {
        MockToolWindow tw = new MockToolWindow(this.myProject);
        this.myToolWindows.put(id, tw);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> this.unregisterToolWindow(id));
        }
        return tw;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode) {
        if (id == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(4);
        }
        if (component == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(5);
        }
        if (anchor2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(7);
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, parentDisposable);
        if (toolWindow == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(8);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2) {
        if (id == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(9);
        }
        if (component == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(10);
        }
        if (anchor2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(11);
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, null);
        if (toolWindow == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(12);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode, boolean canCloseContents) {
        if (id == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(13);
        }
        if (component == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(14);
        }
        if (anchor2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(15);
        }
        if (parentDisposable == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(16);
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, parentDisposable);
        if (toolWindow == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(17);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable) {
        if (id == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(18);
        }
        if (component == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(19);
        }
        if (anchor2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(20);
        }
        if (parentDisposable == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(21);
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, parentDisposable);
        if (toolWindow == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(22);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2) {
        if (id == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(23);
        }
        if (anchor2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(24);
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, null);
        if (toolWindow == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(25);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2, boolean secondary) {
        if (id == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(26);
        }
        if (anchor2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(27);
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, null);
        if (toolWindow == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(28);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean dumbAware) {
        if (id == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(29);
        }
        if (anchor2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(30);
        }
        if (parentDisposable == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(31);
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, parentDisposable);
        if (toolWindow == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(32);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode, boolean secondary) {
        if (id == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(33);
        }
        if (anchor2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(34);
        }
        if (parentDisposable == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(35);
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, parentDisposable);
        if (toolWindow == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(36);
        }
        return toolWindow;
    }

    public void unregisterToolWindow(@NotNull String id) {
        if (id == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(37);
        }
        this.myToolWindows.remove(id);
    }

    public void activateEditorComponent() {
    }

    public boolean isEditorComponentActive() {
        return false;
    }

    @NotNull
    public String[] getToolWindowIds() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(38);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getActiveToolWindowId() {
        return null;
    }

    public ToolWindow getToolWindow(@Nullable String id) {
        return this.myToolWindows.get(id);
    }

    public void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(39);
        }
    }

    @NotNull
    public IdeFocusManager getFocusManager() {
        IdeFocusManagerHeadless ideFocusManagerHeadless = IdeFocusManagerHeadless.INSTANCE;
        if (ideFocusManagerHeadless == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(40);
        }
        return ideFocusManagerHeadless;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String text, @Nullable Icon icon, @Nullable HyperlinkListener listener2) {
        if (toolWindowId == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(41);
        }
        if (type == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(42);
        }
        if (text == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(43);
        }
    }

    public Balloon getToolWindowBalloon(String id) {
        return null;
    }

    public boolean isMaximized(@NotNull ToolWindow wnd) {
        if (wnd == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(44);
        }
        return false;
    }

    public void setMaximized(@NotNull ToolWindow wnd, boolean maximized) {
        if (wnd == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(45);
        }
    }

    @Override
    public void initToolWindow(@NotNull ToolWindowEP bean) {
        if (bean == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(46);
        }
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2) {
        if (listener2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(47);
        }
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(48);
        }
        if (parentDisposable == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(49);
        }
    }

    @Override
    public void removeToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2) {
        if (listener2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(50);
        }
    }

    @Override
    public String getLastActiveToolWindowId() {
        return null;
    }

    @Override
    public String getLastActiveToolWindowId(Condition<JComponent> condition) {
        return null;
    }

    @Override
    public DesktopLayout getLayout() {
        return new DesktopLayout();
    }

    @Override
    public void setLayoutToRestoreLater(DesktopLayout layout) {
    }

    @Override
    public DesktopLayout getLayoutToRestoreLater() {
        return new DesktopLayout();
    }

    @Override
    public void setLayout(@NotNull DesktopLayout layout) {
        if (layout == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(51);
        }
    }

    @Override
    public void clearSideStack() {
    }

    @Override
    public void hideToolWindow(@NotNull String id, boolean hideSide) {
        if (id == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(52);
        }
    }

    @Override
    @NotNull
    public List<String> getIdsOn(@NotNull ToolWindowAnchor anchor2) {
        if (anchor2 == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(53);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (arrayList == null) {
            ToolWindowHeadlessManagerImpl.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 2: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlBody";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 20: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 7: 
            case 16: 
            case 21: 
            case 31: 
            case 35: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wnd";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 47: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl";
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "registerToolWindow";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowIds";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusManager";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdsOn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canShowNotification";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "notifyByBalloon";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "registerToolWindow";
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 54: {
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "unregisterToolWindow";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isMaximized";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setMaximized";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addToolWindowManagerListener";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "removeToolWindowManagerListener";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "setLayout";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "hideToolWindow";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getIdsOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MockContentManager
    implements ContentManager {
        private final EventDispatcher<ContentManagerListener> myDispatcher = EventDispatcher.create(ContentManagerListener.class);
        private final List<Content> myContents = new ArrayList<Content>();
        private Content mySelected;

        private MockContentManager() {
        }

        @NotNull
        public ActionCallback getReady(@NotNull Object requestor) {
            if (requestor == null) {
                MockContentManager.$$$reportNull$$$0(0);
            }
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                MockContentManager.$$$reportNull$$$0(1);
            }
            return actionCallback;
        }

        public void addContent(@NotNull Content content) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(2);
            }
            this.addContent(content, -1);
        }

        public void addContent(@NotNull Content content, int order) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(3);
            }
            this.myContents.add(order == -1 ? this.myContents.size() : order, content);
            if (content instanceof ContentImpl && content.getManager() == null) {
                ((ContentImpl)content).setManager(this);
            }
            Disposer.register((Disposable)this, (Disposable)content);
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(content), ContentManagerEvent.ContentOperation.add);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e);
            if (this.mySelected == null) {
                this.setSelectedContent(content);
            }
        }

        public void addContent(@NotNull Content content, Object constraints) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(4);
            }
            this.addContent(content);
        }

        public void addSelectedContent(@NotNull Content content) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(5);
            }
            this.addContent(content);
            this.setSelectedContent(content);
        }

        public void addContentManagerListener(@NotNull ContentManagerListener l) {
            if (l == null) {
                MockContentManager.$$$reportNull$$$0(6);
            }
            this.myDispatcher.getListeners().add(0, l);
        }

        public void addDataProvider(@NotNull DataProvider provider) {
            if (provider == null) {
                MockContentManager.$$$reportNull$$$0(7);
            }
        }

        public boolean canCloseAllContents() {
            return false;
        }

        public boolean canCloseContents() {
            return false;
        }

        public Content findContent(String displayName) {
            for (Content each : this.myContents) {
                if (!each.getDisplayName().equals(displayName)) continue;
                return each;
            }
            return null;
        }

        public List<AnAction> getAdditionalPopupActions(@NotNull Content content) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(8);
            }
            return Collections.emptyList();
        }

        @NotNull
        public String getCloseActionName() {
            if ("close" == null) {
                MockContentManager.$$$reportNull$$$0(9);
            }
            return "close";
        }

        @NotNull
        public String getCloseAllButThisActionName() {
            if ("closeallbutthis" == null) {
                MockContentManager.$$$reportNull$$$0(10);
            }
            return "closeallbutthis";
        }

        @NotNull
        public String getPreviousContentActionName() {
            if ("previous" == null) {
                MockContentManager.$$$reportNull$$$0(11);
            }
            return "previous";
        }

        @NotNull
        public String getNextContentActionName() {
            if ("next" == null) {
                MockContentManager.$$$reportNull$$$0(12);
            }
            return "next";
        }

        @NotNull
        public JComponent getComponent() {
            JLabel jLabel = new JLabel();
            if (jLabel == null) {
                MockContentManager.$$$reportNull$$$0(13);
            }
            return jLabel;
        }

        public Content getContent(JComponent component) {
            Content[] contents;
            for (Content content : contents = this.getContents()) {
                if (!Comparing.equal((Object)component, (Object)content.getComponent())) continue;
                return content;
            }
            return null;
        }

        @Nullable
        public Content getContent(int index) {
            return this.myContents.get(index);
        }

        public int getContentCount() {
            return this.myContents.size();
        }

        @NotNull
        public Content[] getContents() {
            Content[] contentArray = this.myContents.toArray(new Content[this.myContents.size()]);
            if (contentArray == null) {
                MockContentManager.$$$reportNull$$$0(14);
            }
            return contentArray;
        }

        public int getIndexOfContent(Content content) {
            return this.myContents.indexOf(content);
        }

        @Nullable
        public Content getSelectedContent() {
            return this.mySelected;
        }

        @NotNull
        public Content[] getSelectedContents() {
            Content[] contentArray;
            if (this.mySelected != null) {
                Content[] contentArray2 = new Content[1];
                contentArray = contentArray2;
                contentArray2[0] = this.mySelected;
            } else {
                contentArray = new Content[]{};
            }
            if (contentArray == null) {
                MockContentManager.$$$reportNull$$$0(15);
            }
            return contentArray;
        }

        public boolean isSelected(@NotNull Content content) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(16);
            }
            return content == this.mySelected;
        }

        public void removeAllContents(boolean dispose2) {
            for (Content content : this.getContents()) {
                this.removeContent(content, dispose2);
            }
        }

        public boolean removeContent(@NotNull Content content, boolean dispose2) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(17);
            }
            boolean wasSelected = this.mySelected == content;
            int oldIndex = this.myContents.indexOf(content);
            if (wasSelected) {
                this.removeFromSelection(content);
            }
            boolean result2 = this.myContents.remove(content);
            if (dispose2) {
                Disposer.dispose((Disposable)content);
            }
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, oldIndex, ContentManagerEvent.ContentOperation.remove);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentRemoved(e);
            Content item = (Content)ContainerUtil.getFirstItem(this.myContents);
            if (item != null) {
                this.setSelectedContent(item);
            }
            return result2;
        }

        @NotNull
        public ActionCallback removeContent(@NotNull Content content, boolean dispose2, boolean trackFocus, boolean implicitFocus) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(18);
            }
            this.removeContent(content, dispose2);
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                MockContentManager.$$$reportNull$$$0(19);
            }
            return actionCallback;
        }

        public void removeContentManagerListener(@NotNull ContentManagerListener l) {
            if (l == null) {
                MockContentManager.$$$reportNull$$$0(20);
            }
            this.myDispatcher.removeListener((EventListener)l);
        }

        public void removeFromSelection(@NotNull Content content) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(21);
            }
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(this.mySelected), ContentManagerEvent.ContentOperation.remove);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
        }

        public ActionCallback selectNextContent() {
            return ActionCallback.DONE;
        }

        public ActionCallback selectPreviousContent() {
            return ActionCallback.DONE;
        }

        public void setSelectedContent(@NotNull Content content) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(22);
            }
            if (this.mySelected != null) {
                this.removeFromSelection(this.mySelected);
            }
            this.mySelected = content;
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(content), ContentManagerEvent.ContentOperation.add);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(23);
            }
            this.setSelectedContent(content);
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                MockContentManager.$$$reportNull$$$0(24);
            }
            return actionCallback;
        }

        public void setSelectedContent(@NotNull Content content, boolean requestFocus) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(25);
            }
            this.setSelectedContent(content);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(26);
            }
            ActionCallback actionCallback = this.setSelectedContentCB(content);
            if (actionCallback == null) {
                MockContentManager.$$$reportNull$$$0(27);
            }
            return actionCallback;
        }

        public void setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(28);
            }
            this.setSelectedContent(content);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(29);
            }
            ActionCallback actionCallback = this.setSelectedContentCB(content);
            if (actionCallback == null) {
                MockContentManager.$$$reportNull$$$0(30);
            }
            return actionCallback;
        }

        @NotNull
        public ActionCallback setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus, boolean implicit) {
            if (content == null) {
                MockContentManager.$$$reportNull$$$0(31);
            }
            ActionCallback actionCallback = this.setSelectedContentCB(content);
            if (actionCallback == null) {
                MockContentManager.$$$reportNull$$$0(32);
            }
            return actionCallback;
        }

        @NotNull
        public ActionCallback requestFocus(@Nullable Content content, boolean forced) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                MockContentManager.$$$reportNull$$$0(33);
            }
            return actionCallback;
        }

        public void dispose() {
            this.myContents.clear();
            this.mySelected = null;
            this.myDispatcher.getListeners().clear();
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isSingleSelection() {
            return true;
        }

        @NotNull
        public ContentFactory getFactory() {
            ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
            if (contentFactory == null) {
                MockContentManager.$$$reportNull$$$0(34);
            }
            return contentFactory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 19: 
                case 24: 
                case 27: 
                case 30: 
                case 32: 
                case 33: 
                case 34: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 19: 
                case 24: 
                case 27: 
                case 30: 
                case 32: 
                case 33: 
                case 34: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestor";
                    break;
                }
                case 1: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 19: 
                case 24: 
                case 27: 
                case 30: 
                case 32: 
                case 33: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 16: 
                case 17: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 6: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "l";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReady";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCloseActionName";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCloseAllButThisActionName";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousContentActionName";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextContentActionName";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContents";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedContents";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "removeContent";
                    break;
                }
                case 24: 
                case 27: 
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSelectedContentCB";
                    break;
                }
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSelectedContent";
                    break;
                }
                case 33: {
                    objectArray = objectArray2;
                    objectArray2[1] = "requestFocus";
                    break;
                }
                case 34: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReady";
                    break;
                }
                case 1: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 19: 
                case 24: 
                case 27: 
                case 30: 
                case 32: 
                case 33: 
                case 34: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addContent";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addSelectedContent";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addContentManagerListener";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addDataProvider";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getAdditionalPopupActions";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "removeContent";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "removeContentManagerListener";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "removeFromSelection";
                    break;
                }
                case 22: 
                case 25: 
                case 28: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelectedContent";
                    break;
                }
                case 23: 
                case 26: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelectedContentCB";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 19: 
                case 24: 
                case 27: 
                case 30: 
                case 32: 
                case 33: 
                case 34: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MockToolWindow
    implements ToolWindowEx {
        ContentManager myContentManager;

        public MockToolWindow(@NotNull Project project) {
            if (project == null) {
                MockToolWindow.$$$reportNull$$$0(0);
            }
            this.myContentManager = new MockContentManager();
            Disposer.register((Disposable)project, (Disposable)this.myContentManager);
        }

        public boolean isActive() {
            return false;
        }

        public void activate(@Nullable Runnable runnable2) {
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isVisible() {
            return false;
        }

        public void setShowStripeButton(boolean show) {
        }

        public boolean isShowStripeButton() {
            return false;
        }

        @NotNull
        public ActionCallback getReady(@NotNull Object requestor) {
            if (requestor == null) {
                MockToolWindow.$$$reportNull$$$0(1);
            }
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                MockToolWindow.$$$reportNull$$$0(2);
            }
            return actionCallback;
        }

        public void show(@Nullable Runnable runnable2) {
        }

        public void hide(@Nullable Runnable runnable2) {
        }

        public ToolWindowAnchor getAnchor() {
            return ToolWindowAnchor.BOTTOM;
        }

        public void setAnchor(@NotNull ToolWindowAnchor anchor2, @Nullable Runnable runnable2) {
            if (anchor2 == null) {
                MockToolWindow.$$$reportNull$$$0(3);
            }
        }

        public boolean isSplitMode() {
            return false;
        }

        public void setSplitMode(boolean isSideTool, @Nullable Runnable runnable2) {
        }

        public boolean isAutoHide() {
            return false;
        }

        public void setAutoHide(boolean state) {
        }

        public void setToHideOnEmptyContent(boolean hideOnEmpty) {
        }

        public boolean isToHideOnEmptyContent() {
            return false;
        }

        public ToolWindowType getType() {
            return ToolWindowType.SLIDING;
        }

        public void setType(@NotNull ToolWindowType type, @Nullable Runnable runnable2) {
            if (type == null) {
                MockToolWindow.$$$reportNull$$$0(4);
            }
        }

        public Icon getIcon() {
            return null;
        }

        public void setIcon(Icon icon) {
        }

        public String getTitle() {
            return "";
        }

        public void setTitle(String title) {
        }

        @NotNull
        public String getStripeTitle() {
            if ("" == null) {
                MockToolWindow.$$$reportNull$$$0(5);
            }
            return "";
        }

        public void setStripeTitle(@NotNull String title) {
            if (title == null) {
                MockToolWindow.$$$reportNull$$$0(6);
            }
        }

        public boolean isAvailable() {
            return false;
        }

        public void setContentUiType(@NotNull ToolWindowContentUiType type, @Nullable Runnable runnable2) {
            if (type == null) {
                MockToolWindow.$$$reportNull$$$0(7);
            }
        }

        public void setDefaultContentUiType(@NotNull ToolWindowContentUiType type) {
            if (type == null) {
                MockToolWindow.$$$reportNull$$$0(8);
            }
        }

        @NotNull
        public ToolWindowContentUiType getContentUiType() {
            ToolWindowContentUiType toolWindowContentUiType = ToolWindowContentUiType.TABBED;
            if (toolWindowContentUiType == null) {
                MockToolWindow.$$$reportNull$$$0(9);
            }
            return toolWindowContentUiType;
        }

        public void setAvailable(boolean available, @Nullable Runnable runnable2) {
        }

        public void installWatcher(ContentManager contentManager) {
        }

        public JComponent getComponent() {
            return null;
        }

        public ContentManager getContentManager() {
            return this.myContentManager;
        }

        public void setDefaultState(@Nullable ToolWindowAnchor anchor2, @Nullable ToolWindowType type, @Nullable Rectangle floatingBounds) {
        }

        public void activate(@Nullable Runnable runnable2, boolean autoFocusContents) {
        }

        public void activate(@Nullable Runnable runnable2, boolean autoFocusContents, boolean forced) {
        }

        public void showContentPopup(InputEvent inputEvent) {
        }

        public ActionCallback getActivation() {
            return ActionCallback.DONE;
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public ToolWindowType getInternalType() {
            return ToolWindowType.DOCKED;
        }

        @Override
        public void stretchWidth(int value) {
        }

        @Override
        public void stretchHeight(int value) {
        }

        @Override
        public InternalDecorator getDecorator() {
            return null;
        }

        @Override
        public void setAdditionalGearActions(ActionGroup additionalGearActions) {
        }

        @Override
        public void setTitleActions(AnAction ... actions) {
        }

        @Override
        public void setUseLastFocusedOnActivation(boolean focus) {
        }

        @Override
        public boolean isUseLastFocusedOnActivation() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestor";
                    break;
                }
                case 2: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReady";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStripeTitle";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentUiType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReady";
                    break;
                }
                case 2: 
                case 5: 
                case 9: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setAnchor";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setType";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setStripeTitle";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setContentUiType";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultContentUiType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

