/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.MoreIcon;
import com.intellij.openapi.wm.impl.content.SelectContentStep;
import com.intellij.openapi.wm.impl.content.TabbedContentTabLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

class TabContentLayout
extends ContentLayout {
    static final int MORE_ICON_BORDER = 6;
    LayoutData myLastLayout;
    ArrayList<ContentTabLabel> myTabs = new ArrayList();
    final Map<Content, ContentTabLabel> myContent2Tabs = new HashMap<Content, ContentTabLabel>();
    private Map<String, BufferedImage> myCached = new com.intellij.util.containers.HashMap();
    private final MoreIcon myMoreIcon = new MoreIcon(){

        @Override
        protected Rectangle getIconRec() {
            return TabContentLayout.this.myLastLayout.moreRect;
        }

        @Override
        protected boolean isActive() {
            return TabContentLayout.this.myUi.myWindow.isActive();
        }

        @Override
        protected int getIconY(Rectangle iconRec) {
            return iconRec.height / 2 - this.getIconHeight() / 2;
        }
    };

    TabContentLayout(ToolWindowContentUi ui) {
        super(ui);
        new BaseButtonBehavior(this.myUi){

            protected void execute(MouseEvent e) {
                Rectangle moreRect;
                if (!TabContentLayout.this.myUi.isCurrent(TabContentLayout.this)) {
                    return;
                }
                if (TabContentLayout.this.myLastLayout != null && (moreRect = TabContentLayout.this.myLastLayout.moreRect) != null && moreRect.contains(e.getPoint())) {
                    TabContentLayout.showPopup(e, ContainerUtil.filter(TabContentLayout.this.myTabs, TabContentLayout.this.myLastLayout.toDrop::contains));
                }
            }
        };
    }

    @Override
    public void init() {
        this.reset();
        this.myIdLabel = new BaseLabel(this.myUi, false){

            @Override
            protected boolean allowEngravement() {
                return this.myUi.myWindow.isActive();
            }
        };
        for (int i = 0; i < this.myUi.myManager.getContentCount(); ++i) {
            this.contentAdded(new ContentManagerEvent((Object)this, this.myUi.myManager.getContent(i), i));
        }
    }

    @Override
    public void reset() {
        this.myTabs.clear();
        this.myContent2Tabs.clear();
        this.myIdLabel = null;
    }

    private static void showPopup(MouseEvent e, List<ContentTabLabel> tabs) {
        List contentsToShow = ContainerUtil.map(tabs, ContentTabLabel::getContent);
        SelectContentStep step = new SelectContentStep(contentsToShow);
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).show(new RelativePoint(e));
    }

    @Override
    public void layout() {
        Rectangle bounds = this.myUi.getBounds();
        ContentManager manager = this.myUi.myManager;
        LayoutData data = new LayoutData(this.myUi);
        data.eachX = 2;
        data.eachY = 0;
        if (this.isIdVisible()) {
            this.myIdLabel.setBounds(data.eachX, data.eachY, this.myIdLabel.getPreferredSize().width, bounds.height);
            data.eachX += this.myIdLabel.getPreferredSize().width;
        }
        int tabsStart = data.eachX;
        if (manager.getContentCount() == 0) {
            return;
        }
        Content selected = manager.getSelectedContent();
        if (selected == null) {
            selected = manager.getContents()[0];
        }
        if (this.myLastLayout != null && this.myLastLayout.layoutSize.equals(bounds.getSize()) && this.myLastLayout.contentCount == manager.getContentCount()) {
            for (ContentTabLabel each : this.myTabs) {
                if (!each.isValid()) break;
                if (each.getContent() != selected || each.getBounds().width == 0) continue;
                data = this.myLastLayout;
                data.fullLayout = false;
            }
        }
        if (data.fullLayout) {
            for (ContentTabLabel eachTab : this.myTabs) {
                Dimension eachSize = eachTab.getPreferredSize();
                data.requiredWidth += eachSize.width;
                ++data.requiredWidth;
                data.toLayout.add(eachTab);
            }
            data.moreRectWidth = this.myMoreIcon.getIconWidth() + 12;
            data.toFitWidth = bounds.getSize().width - data.eachX;
            ContentTabLabel selectedTab = this.myContent2Tabs.get(selected);
            while (data.requiredWidth > data.toFitWidth && data.toLayout.size() > 1) {
                if (data.toLayout.get(0) != selectedTab) {
                    TabContentLayout.dropTab(data, data.toLayout.remove(0));
                    continue;
                }
                if (data.toLayout.get(data.toLayout.size() - 1) == selectedTab) break;
                TabContentLayout.dropTab(data, data.toLayout.remove(data.toLayout.size() - 1));
            }
            boolean reachedBounds = false;
            data.moreRect = null;
            for (ContentTabLabel each : data.toLayout) {
                data.eachY = 0;
                Dimension eachSize = each.getPreferredSize();
                if (data.eachX + eachSize.width < data.toFitWidth + tabsStart) {
                    each.setBounds(data.eachX, data.eachY, eachSize.width, bounds.height - data.eachY);
                    data.eachX += eachSize.width;
                    continue;
                }
                if (!reachedBounds) {
                    int width = bounds.width - data.eachX - data.moreRectWidth;
                    each.setBounds(data.eachX, data.eachY, width, bounds.height - data.eachY);
                    data.eachX += width;
                } else {
                    each.setBounds(0, 0, 0, 0);
                }
                reachedBounds = true;
            }
            for (ContentTabLabel each : data.toDrop) {
                each.setBounds(0, 0, 0, 0);
            }
        }
        if (data.toDrop.size() > 0) {
            data.moreRect = new Rectangle(data.eachX + 6, 0, this.myMoreIcon.getIconWidth(), bounds.height);
            int selectedIndex = manager.getIndexOfContent(manager.getSelectedContent());
            if (selectedIndex == 0) {
                this.myMoreIcon.setPaintedIcons(false, true);
            } else if (selectedIndex == manager.getContentCount() - 1) {
                this.myMoreIcon.setPaintedIcons(true, false);
            } else {
                this.myMoreIcon.setPaintedIcons(true, true);
            }
        } else {
            data.moreRect = null;
        }
        this.myLastLayout = data;
    }

    @Override
    public int getMinimumWidth() {
        int result2 = 0;
        if (this.myIdLabel != null) {
            result2 += this.myIdLabel.getPreferredSize().width;
            Insets insets = this.myIdLabel.getInsets();
            if (insets != null) {
                result2 += insets.left + insets.right;
            }
        }
        if (this.myLastLayout != null) {
            result2 += this.myLastLayout.moreRectWidth + this.myLastLayout.requiredWidth;
            result2 -= this.myLastLayout.toLayout.size() > 1 ? this.myLastLayout.moreRectWidth + 1 : -14;
        }
        return result2;
    }

    static void dropTab(LayoutData data, ContentTabLabel toDropLabel) {
        data.requiredWidth -= toDropLabel.getPreferredSize().width + 1;
        data.toDrop.add(toDropLabel);
        if (data.toDrop.size() == 1) {
            data.toFitWidth -= data.moreRectWidth;
        }
    }

    boolean isToDrawTabs() {
        return this.myTabs.size() > 1;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isToDrawTabs()) {
            return;
        }
        boolean prevSelected = false;
        for (int i = 0; i < this.myTabs.size(); ++i) {
            BufferedImage image;
            boolean last = i == this.myTabs.size() - 1 || i + 1 < this.myTabs.size() && this.myTabs.get((int)(i + 1)).getBounds().width == 0;
            ContentTabLabel each = this.myTabs.get(i);
            Rectangle r = each.getBounds();
            StringBuilder key = new StringBuilder().append(i);
            if (each.isSelected()) {
                key.append('s');
            }
            if (prevSelected) {
                key.append('p');
            }
            if (last) {
                key.append('l');
            }
            if (this.myUi.myWindow.isActive()) {
                key.append('a');
            }
            if ((image = this.myCached.get(key.toString())) == null || image.getWidth() != r.width || image.getHeight() != r.height) {
                image = TabContentLayout.drawToBuffer(r, each.isSelected(), last, prevSelected, this.myUi.myWindow.isActive());
                this.myCached.put(key.toString(), image);
            }
            if (image != null) {
                UIUtil.drawImage((Graphics)g, (Image)image, (int)(this.isIdVisible() ? r.x : r.x - 2), (int)r.y, null);
            }
            prevSelected = each.isSelected();
        }
    }

    @Nullable
    private static BufferedImage drawToBuffer(Rectangle r, boolean selected, boolean last, boolean prevSelected, boolean active) {
        if (r.width <= 0 || r.height <= 0) {
            return null;
        }
        BufferedImage image = UIUtil.createImage((int)r.width, (int)r.height, (int)2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (selected) {
            if (!UIUtil.isUnderDarcula()) {
                g2d.setColor(active ? new Color(0, 0, 0, 70) : new Color(0, 0, 0, 90));
                g2d.fillRect(0, 0, r.width, r.height);
                g2d.setColor(new Color(0, 0, 0, 140));
                g2d.drawLine(0, 0, r.width - 1, 0);
                g2d.drawLine(0, 1, 0, r.height - 1);
                g2d.setColor(new Color(0, 0, 0, 20));
                g2d.drawLine(1, 1, r.width - 1, 1);
                g2d.drawLine(1, 2, 1, r.height - 2);
                g2d.drawLine(1, r.height - 1, r.width - 1, r.height - 1);
                g2d.setColor(new Color(0, 0, 0, 60));
                g2d.drawLine(r.width - 1, 1, r.width - 1, r.height - 2);
            }
            if (active) {
                g2d.setColor(new Color(100, 150, 230, 50));
                g2d.fill(new Rectangle(0, 0, r.width, r.height));
            }
        } else {
            g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)new Color(0, 0, 0, 10), (float)0.0f, (float)r.height, (Color)new Color(0, 0, 0, 30)));
            g2d.fillRect(0, 0, r.width, r.height);
            Color c = new Color(255, 255, 255, UIUtil.isUnderDarcula() ? 10 : 80);
            if (last) {
                if (prevSelected) {
                    g2d.setColor(c);
                    g2d.drawRect(0, 0, r.width - 2, r.height - 1);
                } else {
                    g2d.setColor(c);
                    g2d.drawRect(1, 0, r.width - 3, r.height - 1);
                    g2d.setColor(new Color(0, 0, 0, 60));
                    g2d.drawLine(0, 0, 0, r.height);
                }
                g2d.setColor(new Color(0, 0, 0, 60));
                g2d.drawLine(r.width - 1, 0, r.width - 1, r.height);
            } else if (prevSelected) {
                g2d.setColor(c);
                g2d.drawRect(0, 0, r.width - 1, r.height - 1);
            } else {
                g2d.setColor(c);
                g2d.drawRect(1, 0, r.width - 2, r.height - 1);
                g2d.setColor(new Color(0, 0, 0, 60));
                g2d.drawLine(0, 0, 0, r.height);
            }
        }
        g2d.dispose();
        return image;
    }

    @Override
    public void paintChildren(Graphics g) {
        if (!this.isToDrawTabs()) {
            return;
        }
        if (this.myLastLayout != null && this.myLastLayout.moreRect != null) {
            this.myMoreIcon.paintIcon(this.myUi, g);
        }
    }

    @Override
    public void update() {
        for (ContentTabLabel each : this.myTabs) {
            each.update();
        }
        this.updateIdLabel(this.myIdLabel);
    }

    @Override
    public void rebuild() {
        this.myUi.removeAll();
        this.myUi.add(this.myIdLabel);
        ToolWindowContentUi.initMouseListeners(this.myIdLabel, this.myUi, true);
        for (ContentTabLabel each : this.myTabs) {
            this.myUi.add(each);
            ToolWindowContentUi.initMouseListeners(each, this.myUi, false);
        }
        this.myCached.clear();
    }

    @Override
    public void contentAdded(ContentManagerEvent event) {
        Content content = event.getContent();
        ContentTabLabel tab = content instanceof TabbedContent ? new TabbedContentTabLabel((TabbedContent)content, this) : new ContentTabLabel(content, this);
        this.myTabs.add(event.getIndex(), tab);
        this.myContent2Tabs.put(content, tab);
        if (content instanceof DnDTarget) {
            DnDTarget target2 = (DnDTarget)content;
            DnDSupport.createBuilder((JComponent)tab).setDropHandler((DnDDropHandler)target2).setTargetChecker((DnDTargetChecker)target2).setCleanUpOnLeaveCallback(() -> target2.cleanUpOnLeave()).install();
        }
        this.myCached.clear();
    }

    @Override
    public void contentRemoved(ContentManagerEvent event) {
        ContentTabLabel tab = this.myContent2Tabs.get(event.getContent());
        if (tab != null) {
            this.myTabs.remove(tab);
            this.myContent2Tabs.remove(event.getContent());
        }
        this.myCached.clear();
    }

    @Override
    public boolean shouldDrawDecorations() {
        return this.isToDrawTabs();
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        Content selected = this.myUi.myManager.getSelectedContent();
        if (selected != null) {
            ContentTabLabel tab = this.myContent2Tabs.get(selected);
            listPopup.showUnderneathOf((Component)tab);
        } else {
            listPopup.showUnderneathOf((Component)this.myIdLabel);
        }
    }

    @Override
    public RelativeRectangle getRectangleFor(Content content) {
        ContentTabLabel label = this.myContent2Tabs.get(content);
        return new RelativeRectangle((Component)label.getParent(), label.getBounds());
    }

    @Override
    public Component getComponentFor(Content content) {
        return this.myContent2Tabs.get(content);
    }

    @Override
    public String getCloseActionName() {
        return UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
    }

    @Override
    public String getCloseAllButThisActionName() {
        return UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
    }

    @Override
    public String getPreviousContentActionName() {
        return "Select Previous Tab";
    }

    @Override
    public String getNextContentActionName() {
        return "Select Next Tab";
    }

    static class LayoutData {
        int toFitWidth;
        int requiredWidth;
        Dimension layoutSize;
        boolean fullLayout = true;
        int moreRectWidth;
        ArrayList<ContentTabLabel> toLayout = new ArrayList();
        Collection<ContentTabLabel> toDrop = new HashSet<ContentTabLabel>();
        Rectangle moreRect;
        public int eachX;
        public int eachY;
        public int contentCount;

        LayoutData(ToolWindowContentUi ui) {
            this.layoutSize = ui.getSize();
            this.contentCount = ui.myManager.getContentCount();
        }
    }
}

