/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementFactoryImpl
extends XmlElementFactory {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(XmlElementFactoryImpl.class);

    public XmlElementFactoryImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public XmlTag createTagFromText(@NotNull @NonNls CharSequence text, @NotNull Language language) throws IncorrectOperationException {
        XmlDocument document;
        XmlTag tag;
        if (text == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(0);
        }
        if (language == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(1);
        }
        assert (language instanceof XMLLanguage) : "Tag can be created only for xml language";
        LanguageFileType type = language.getAssociatedFileType();
        if (type == null) {
            type = XmlFileType.INSTANCE;
        }
        if ((tag = (document = this.createXmlDocument(text, "dummy." + type.getDefaultExtension(), (FileType)type)).getRootTag()) == null) {
            throw new IncorrectOperationException("Incorrect tag text");
        }
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(2);
        }
        return xmlTag;
    }

    @NotNull
    public XmlTag createTagFromText(@NotNull CharSequence text) throws IncorrectOperationException {
        if (text == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(3);
        }
        XmlTag xmlTag = this.createTagFromText(text, (Language)XMLLanguage.INSTANCE);
        if (xmlTag == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(4);
        }
        return xmlTag;
    }

    @NotNull
    public XmlAttribute createXmlAttribute(@NotNull String name, @NotNull String value) throws IncorrectOperationException {
        if (name == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(5);
        }
        if (value == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(6);
        }
        XmlAttribute xmlAttribute = this.createAttribute(name, value, (FileType)XmlFileType.INSTANCE);
        if (xmlAttribute == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(7);
        }
        return xmlAttribute;
    }

    @NotNull
    public XmlAttribute createAttribute(@NotNull @NonNls String name, @NotNull String value, @Nullable PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(8);
        }
        if (value == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(9);
        }
        XmlAttribute xmlAttribute = this.createAttribute(name, value, (FileType)(PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false) instanceof HtmlTag ? HtmlFileType.INSTANCE : XmlFileType.INSTANCE));
        if (xmlAttribute == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(10);
        }
        return xmlAttribute;
    }

    @NotNull
    private XmlAttribute createAttribute(@NotNull String name, @NotNull String value, @NotNull FileType fileType) {
        char quoteChar;
        if (name == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(11);
        }
        if (value == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(12);
        }
        if (fileType == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(13);
        }
        if (!value.contains("\"")) {
            quoteChar = '\"';
        } else if (!value.contains("'")) {
            quoteChar = '\'';
        } else {
            quoteChar = '\"';
            value = StringUtil.replace((String)value, (String)"\"", (String)"&quot;");
        }
        XmlDocument document = this.createXmlDocument("<tag " + name + "=" + quoteChar + value + quoteChar + "/>", "dummy.xml", fileType);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        XmlAttribute[] attributes = tag.getAttributes();
        LOG.assertTrue(attributes.length == 1, (Object)document.getText());
        XmlAttribute xmlAttribute = attributes[0];
        if (xmlAttribute == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(14);
        }
        return xmlAttribute;
    }

    @NotNull
    public XmlText createDisplayText(@NotNull String s) throws IncorrectOperationException {
        XmlTag tagFromText;
        XmlText[] textElements;
        if (s == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(15);
        }
        if ((textElements = (tagFromText = this.createTagFromText("<a>" + XmlTagUtil.getCDATAQuote((String)s) + "</a>")).getValue().getTextElements()).length == 0) {
            XmlText xmlText = (XmlText)ASTFactory.composite(XmlElementType.XML_TEXT);
            if (xmlText == null) {
                XmlElementFactoryImpl.$$$reportNull$$$0(16);
            }
            return xmlText;
        }
        XmlText xmlText = textElements[0];
        if (xmlText == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(17);
        }
        return xmlText;
    }

    @NotNull
    public XmlTag createXHTMLTagFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(18);
        }
        XmlDocument document = this.createXmlDocument(text, "dummy.xhtml", (FileType)XHtmlFileType.INSTANCE);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(19);
        }
        return xmlTag;
    }

    @NotNull
    public XmlTag createHTMLTagFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(20);
        }
        XmlDocument document = this.createXmlDocument(text, "dummy.html", (FileType)HtmlFileType.INSTANCE);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(21);
        }
        return xmlTag;
    }

    private XmlDocument createXmlDocument(@NonNls CharSequence text, @NonNls String fileName, FileType fileType) {
        XmlFile xmlFile;
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, fileType, text);
        if (fileFromText instanceof XmlFile) {
            xmlFile = (XmlFile)fileFromText;
        } else {
            xmlFile = (XmlFile)fileFromText.getViewProvider().getPsi(((LanguageFileType)fileType).getLanguage());
            assert (xmlFile != null);
        }
        XmlDocument document = xmlFile.getDocument();
        assert (document != null);
        return document;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/XmlElementFactoryImpl";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/XmlElementFactoryImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagFromText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createXmlAttribute";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttribute";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createDisplayText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createXHTMLTagFromText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createHTMLTagFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTagFromText";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createXmlAttribute";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAttribute";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDisplayText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createXHTMLTagFromText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createHTMLTagFromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

