/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.project.ProjectKt;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLargeFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiVFSListener
implements VirtualFileListener,
BulkFileListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.impl.PsiVFSListener");
    private final FileTypeManager myFileTypeManager;
    private final ProjectRootManager myProjectRootManager;
    private final PsiManagerImpl myManager;
    private final FileManagerImpl myFileManager;
    private final Project myProject;
    private boolean myReportedUnloadedPsiChange;
    private static final AtomicBoolean ourGlobalListenerInstalled = new AtomicBoolean(false);

    private static void installGlobalListener() {
        if (ourGlobalListenerInstalled.compareAndSet(false, true)) {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                public void before(@NotNull List<? extends VFileEvent> events) {
                    if (events == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                        PsiVFSListener listener2 = (PsiVFSListener)project.getComponent(PsiVFSListener.class);
                        listener2.before(events);
                    }
                }

                public void after(@NotNull List<? extends VFileEvent> events) {
                    Project[] projects;
                    if (events == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                        PushedFilePropertiesUpdater updater = PushedFilePropertiesUpdater.getInstance((Project)project);
                        if (!(updater instanceof PushedFilePropertiesUpdaterImpl)) continue;
                        ((PushedFilePropertiesUpdaterImpl)updater).processAfterVfsChanges(events);
                    }
                    for (Project project : projects) {
                        PsiVFSListener listener2 = (PsiVFSListener)project.getComponent(PsiVFSListener.class);
                        listener2.myReportedUnloadedPsiChange = false;
                        listener2.after(events);
                        listener2.myReportedUnloadedPsiChange = false;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "events";
                    objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "before";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "after";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public PsiVFSListener(Project project) {
        PsiVFSListener.installGlobalListener();
        this.myProject = project;
        this.myFileTypeManager = FileTypeManager.getInstance();
        this.myProjectRootManager = ProjectRootManager.getInstance((Project)project);
        this.myManager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
        this.myFileManager = (FileManagerImpl)this.myManager.getFileManager();
        StartupManager.getInstance((Project)project).registerPreStartupActivity(() -> {
            MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
            connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyModuleRootListener());
            connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

                public void fileTypesChanged(@NotNull FileTypeEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    PsiVFSListener.this.myFileManager.processFileTypesChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/impl/file/impl/PsiVFSListener$2", "fileTypesChanged"));
                }
            });
            connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new MyFileDocumentManagerAdapter());
            this.myFileManager.markInitialized();
        });
    }

    @Nullable
    private PsiDirectory getCachedDirectory(VirtualFile parent) {
        return parent == null ? null : this.myFileManager.getCachedDirectory(parent);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(0);
        }
        this.fileCreated((VirtualFileEvent)event);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(1);
        }
        VirtualFile vFile = event.getFile();
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDirectory item;
            VirtualFile parent = vFile.getParent();
            PsiDirectory parentDir = this.getCachedDirectory(parent);
            if (parentDir == null) {
                this.handleVfsChangeWithoutPsi(vFile);
                return;
            }
            Object object = item = vFile.isDirectory() ? this.myFileManager.findDirectory(vFile) : this.myFileManager.findFile(vFile);
            if (item != null && item.getProject() == this.myManager.getProject()) {
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
                treeEvent.setParent((PsiElement)parentDir);
                this.myManager.beforeChildAddition(treeEvent);
                treeEvent.setChild((PsiElement)item);
                this.myManager.childAdded(treeEvent);
            }
        });
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        VirtualFile vFile;
        VirtualFile parent;
        PsiDirectory parentDir;
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(2);
        }
        if ((parentDir = this.getCachedDirectory(parent = (vFile = event.getFile()).getParent())) == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDirectory item;
            Object object = item = vFile.isDirectory() ? this.myFileManager.findDirectory(vFile) : this.myFileManager.getCachedPsiFile(vFile);
            if (item != null) {
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
                treeEvent.setParent((PsiElement)parentDir);
                treeEvent.setChild((PsiElement)item);
                this.myManager.beforeChildRemoval(treeEvent);
            }
        });
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        PsiFile element;
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(3);
        }
        VirtualFile vFile = event.getFile();
        VirtualFile parent = event.getParent();
        PsiDirectory parentDir = this.getCachedDirectory(parent);
        PsiFile psiFile = this.myFileManager.getCachedPsiFileInner(vFile);
        if (psiFile != null) {
            this.clearViewProvider(vFile, "PSI fileDeleted");
            element = psiFile;
        } else {
            PsiDirectory psiDir = this.myFileManager.getCachedDirectory(vFile);
            if (psiDir != null) {
                this.myFileManager.removeInvalidFilesAndDirs(false);
                element = psiDir;
            } else {
                if (parent != null) {
                    this.handleVfsChangeWithoutPsi(parent);
                    return;
                }
                element = null;
            }
        }
        if (element != null && parentDir != null) {
            ApplicationManager.getApplication().runWriteAction(() -> this.lambda$fileDeleted$3(parentDir, (PsiElement)element));
        }
    }

    private void clearViewProvider(@NotNull VirtualFile vFile, @NotNull String why) {
        if (vFile == null) {
            PsiVFSListener.$$$reportNull$$$0(4);
        }
        if (why == null) {
            PsiVFSListener.$$$reportNull$$$0(5);
        }
        DebugUtil.startPsiModification(why);
        try {
            this.myFileManager.setViewProvider(vFile, null);
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        PsiDirectory parentDir;
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(6);
        }
        VirtualFile vFile = event.getFile();
        String propertyName = event.getPropertyName();
        FileViewProvider viewProvider = this.myFileManager.findCachedViewProvider(vFile);
        VirtualFile parent = vFile.getParent();
        PsiDirectory psiDirectory = parentDir = viewProvider != null && parent != null ? this.myFileManager.findDirectory(parent) : this.getCachedDirectory(parent);
        if (parent != null && parentDir == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (event == null) {
                PsiVFSListener.$$$reportNull$$$0(15);
            }
            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeEvent.setParent((PsiElement)parentDir);
            if ("name".equals(propertyName)) {
                String newName = (String)event.getNewValue();
                if (parentDir == null) {
                    return;
                }
                if (vFile.isDirectory()) {
                    PsiDirectory psiDir = this.myFileManager.findDirectory(vFile);
                    if (psiDir != null) {
                        if (!this.myFileTypeManager.isFileIgnored(newName)) {
                            treeEvent.setChild((PsiElement)psiDir);
                            treeEvent.setPropertyName("directoryName");
                            treeEvent.setOldValue(vFile.getName());
                            treeEvent.setNewValue(newName);
                            this.myManager.beforePropertyChange(treeEvent);
                        } else {
                            treeEvent.setChild((PsiElement)psiDir);
                            this.myManager.beforeChildRemoval(treeEvent);
                        }
                    } else if (!(Registry.is((String)"ide.hide.excluded.files") && this.isExcludeRoot(vFile) || this.myFileTypeManager.isFileIgnored(newName))) {
                        this.myManager.beforeChildAddition(treeEvent);
                    }
                } else {
                    FileViewProvider viewProvider1 = this.myFileManager.findViewProvider(vFile);
                    PsiFile psiFile = viewProvider1.getPsi(viewProvider1.getBaseLanguage());
                    PsiFile psiFile1 = this.createFileCopyWithNewName(vFile, newName);
                    if (psiFile != null) {
                        if (psiFile1 == null) {
                            treeEvent.setChild((PsiElement)psiFile);
                            this.myManager.beforeChildRemoval(treeEvent);
                        } else if (!psiFile1.getClass().equals(psiFile.getClass())) {
                            treeEvent.setOldChild((PsiElement)psiFile);
                            this.myManager.beforeChildReplacement(treeEvent);
                        } else {
                            treeEvent.setChild((PsiElement)psiFile);
                            treeEvent.setPropertyName("fileName");
                            treeEvent.setOldValue(vFile.getName());
                            treeEvent.setNewValue(newName);
                            this.myManager.beforePropertyChange(treeEvent);
                        }
                    } else if (psiFile1 != null) {
                        this.myManager.beforeChildAddition(treeEvent);
                    }
                }
            } else if ("writable".equals(propertyName)) {
                PsiFile psiFile = this.myFileManager.getCachedPsiFileInner(vFile);
                if (psiFile == null) {
                    return;
                }
                treeEvent.setElement((PsiElement)psiFile);
                treeEvent.setPropertyName("writable");
                treeEvent.setOldValue(event.getOldValue());
                treeEvent.setNewValue(event.getNewValue());
                this.myManager.beforePropertyChange(treeEvent);
            }
        });
    }

    private boolean isExcludeRoot(VirtualFile file2) {
        VirtualFile[] excludeRoots;
        VirtualFile parent = file2.getParent();
        if (parent == null) {
            return false;
        }
        Module module = this.myProjectRootManager.getFileIndex().getModuleForFile(parent);
        if (module == null) {
            return false;
        }
        for (VirtualFile root : excludeRoots = ModuleRootManager.getInstance((Module)module).getExcludeRoots()) {
            if (!root.equals(file2)) continue;
            return true;
        }
        return false;
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        PsiDirectory parentDir;
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(7);
        }
        String propertyName = event.getPropertyName();
        VirtualFile vFile = event.getFile();
        FileViewProvider oldFileViewProvider = this.myFileManager.findCachedViewProvider(vFile);
        PsiFile oldPsiFile = this.myFileManager.getCachedPsiFile(vFile);
        VirtualFile parent = vFile.getParent();
        PsiDirectory psiDirectory = parentDir = oldPsiFile != null && parent != null ? this.myFileManager.findDirectory(parent) : this.getCachedDirectory(parent);
        if (oldFileViewProvider != null && "FileContentUtilCore.saveOrReload".equals(event.getRequestor())) {
            this.myFileManager.forceReload(vFile);
            return;
        }
        if (parentDir == null) {
            boolean fire;
            boolean bl = fire = "name".equals(propertyName) && vFile.isDirectory();
            if (fire) {
                PsiDirectory psiDir = this.myFileManager.getCachedDirectory(vFile);
                boolean bl2 = fire = psiDir != null;
            }
            if (!fire && !"writable".equals(propertyName)) {
                this.handleVfsChangeWithoutPsi(vFile);
                return;
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (event == null) {
                PsiVFSListener.$$$reportNull$$$0(14);
            }
            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeEvent.setParent((PsiElement)parentDir);
            if ("name".equals(propertyName)) {
                if (vFile.isDirectory()) {
                    PsiDirectory psiDir = this.myFileManager.getCachedDirectory(vFile);
                    if (psiDir != null) {
                        if (this.myFileTypeManager.isFileIgnored(vFile)) {
                            this.myFileManager.removeFilesAndDirsRecursively(vFile);
                            treeEvent.setChild((PsiElement)psiDir);
                            this.myManager.childRemoved(treeEvent);
                        } else {
                            treeEvent.setElement((PsiElement)psiDir);
                            treeEvent.setPropertyName("directoryName");
                            treeEvent.setOldValue(event.getOldValue());
                            treeEvent.setNewValue(event.getNewValue());
                            this.myManager.propertyChanged(treeEvent);
                        }
                    } else {
                        PsiDirectory psiDir1 = this.myFileManager.findDirectory(vFile);
                        if (psiDir1 != null) {
                            treeEvent.setChild((PsiElement)psiDir1);
                            this.myManager.childAdded(treeEvent);
                        }
                    }
                } else {
                    FileViewProvider fileViewProvider = this.myFileManager.createFileViewProvider(vFile, true);
                    PsiFile newPsiFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
                    if (oldPsiFile != null) {
                        if (newPsiFile == null) {
                            this.clearViewProvider(vFile, "PSI renamed");
                            treeEvent.setChild((PsiElement)oldPsiFile);
                            this.myManager.childRemoved(treeEvent);
                        } else if (!FileManagerImpl.areViewProvidersEquivalent(fileViewProvider, oldFileViewProvider)) {
                            this.myFileManager.setViewProvider(vFile, fileViewProvider);
                            treeEvent.setOldChild((PsiElement)oldPsiFile);
                            treeEvent.setNewChild((PsiElement)newPsiFile);
                            this.myManager.childReplaced(treeEvent);
                        } else {
                            FileManagerImpl.clearPsiCaches(oldFileViewProvider);
                            treeEvent.setElement((PsiElement)oldPsiFile);
                            treeEvent.setPropertyName("fileName");
                            treeEvent.setOldValue(event.getOldValue());
                            treeEvent.setNewValue(event.getNewValue());
                            this.myManager.propertyChanged(treeEvent);
                        }
                    } else if (newPsiFile != null) {
                        this.myFileManager.setViewProvider(vFile, fileViewProvider);
                        if (parentDir != null) {
                            treeEvent.setChild((PsiElement)newPsiFile);
                            this.myManager.childAdded(treeEvent);
                        }
                    }
                }
            } else if ("writable".equals(propertyName)) {
                if (oldPsiFile == null) {
                    return;
                }
                treeEvent.setElement((PsiElement)oldPsiFile);
                treeEvent.setPropertyName("writable");
                treeEvent.setOldValue(event.getOldValue());
                treeEvent.setNewValue(event.getNewValue());
                this.myManager.propertyChanged(treeEvent);
            } else if ("encoding".equals(propertyName)) {
                if (oldPsiFile == null) {
                    return;
                }
                treeEvent.setElement((PsiElement)oldPsiFile);
                treeEvent.setPropertyName("encoding");
                treeEvent.setOldValue(event.getOldValue());
                treeEvent.setNewValue(event.getNewValue());
                this.myManager.propertyChanged(treeEvent);
            }
        });
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(8);
        }
        VirtualFile vFile = event.getFile();
        PsiDirectory oldParentDir = this.myFileManager.findDirectory(event.getOldParent());
        PsiDirectory newParentDir = this.myFileManager.findDirectory(event.getNewParent());
        if (oldParentDir == null && newParentDir == null) {
            return;
        }
        if (this.myFileTypeManager.isFileIgnored(vFile)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            boolean isExcluded;
            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
            boolean bl = isExcluded = vFile.isDirectory() && Registry.is((String)"ide.hide.excluded.files") && this.myProjectRootManager.getFileIndex().isExcluded(vFile);
            if (oldParentDir != null && !isExcluded) {
                if (newParentDir != null) {
                    treeEvent.setOldParent((PsiElement)oldParentDir);
                    treeEvent.setNewParent((PsiElement)newParentDir);
                    if (vFile.isDirectory()) {
                        PsiDirectory psiDir = this.myFileManager.findDirectory(vFile);
                        treeEvent.setChild((PsiElement)psiDir);
                    } else {
                        PsiFile psiFile = this.myFileManager.findFile(vFile);
                        treeEvent.setChild((PsiElement)psiFile);
                    }
                    this.myManager.beforeChildMovement(treeEvent);
                } else {
                    treeEvent.setParent((PsiElement)oldParentDir);
                    if (vFile.isDirectory()) {
                        PsiDirectory psiDir = this.myFileManager.findDirectory(vFile);
                        treeEvent.setChild((PsiElement)psiDir);
                    } else {
                        PsiFile psiFile = this.myFileManager.findFile(vFile);
                        treeEvent.setChild((PsiElement)psiFile);
                    }
                    this.myManager.beforeChildRemoval(treeEvent);
                }
            } else {
                LOG.assertTrue(newParentDir != null);
                treeEvent.setParent((PsiElement)newParentDir);
                this.myManager.beforeChildAddition(treeEvent);
            }
        });
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        PsiDirectory newElement;
        FileViewProvider newViewProvider;
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(9);
        }
        VirtualFile vFile = event.getFile();
        PsiDirectory oldParentDir = this.myFileManager.findDirectory(event.getOldParent());
        PsiDirectory newParentDir = this.myFileManager.findDirectory(event.getNewParent());
        if (oldParentDir == null && newParentDir == null) {
            return;
        }
        PsiDirectory oldElement = vFile.isDirectory() ? this.myFileManager.getCachedDirectory(vFile) : this.myFileManager.getCachedPsiFileInner(vFile);
        this.myFileManager.removeInvalidFilesAndDirs(true);
        if (!vFile.isDirectory()) {
            newViewProvider = this.myFileManager.createFileViewProvider(vFile, true);
            newElement = newViewProvider.getPsi(this.myFileManager.findViewProvider(vFile).getBaseLanguage());
        } else {
            newElement = this.myFileManager.findDirectory(vFile);
            newViewProvider = null;
        }
        if (oldElement == null && newElement == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.lambda$fileMoved$7((PsiElement)oldElement, vFile, newViewProvider, newParentDir, (PsiElement)newElement, oldParentDir));
    }

    @Nullable
    private PsiFile createFileCopyWithNewName(VirtualFile vFile, String name) {
        FileTypeManager instance = FileTypeManager.getInstance();
        if (instance.isFileIgnored(name)) {
            return null;
        }
        FileType fileTypeByFileName = instance.getFileTypeByFileName(name);
        Document document = FileDocumentManager.getInstance().getDocument(vFile);
        return PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText(name, fileTypeByFileName, document != null ? document.getCharsSequence() : "", vFile.getModificationStamp(), true, false);
    }

    private void handleVfsChangeWithoutPsi(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            PsiVFSListener.$$$reportNull$$$0(10);
        }
        if (!this.myReportedUnloadedPsiChange && this.isInRootModel(vFile)) {
            this.myFileManager.firePropertyChangedForUnloadedPsi();
            this.myReportedUnloadedPsiChange = true;
        }
    }

    private boolean isInRootModel(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiVFSListener.$$$reportNull$$$0(11);
        }
        if (ProjectKt.getStateStore(this.myProject).isProjectFile(file2)) {
            return false;
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        return index.isInContent(file2) || index.isInLibraryClasses(file2) || index.isInLibrarySource(file2);
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(12);
        }
        for (VFileEvent vFileEvent : events) {
            BulkVirtualFileListenerAdapter.fireBefore((VirtualFileListener)this, (VFileEvent)vFileEvent);
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(13);
        }
        for (VFileEvent vFileEvent : events) {
            BulkVirtualFileListenerAdapter.fireAfter((VirtualFileListener)this, (VFileEvent)vFileEvent);
        }
    }

    private /* synthetic */ void lambda$fileMoved$7(PsiElement oldElement, VirtualFile vFile, FileViewProvider newViewProvider, PsiDirectory newParentDir, PsiElement newElement, PsiDirectory oldParentDir) {
        PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
        if (oldElement == null) {
            this.myFileManager.setViewProvider(vFile, newViewProvider);
            treeEvent.setParent((PsiElement)newParentDir);
            treeEvent.setChild(newElement);
            this.myManager.childAdded(treeEvent);
        } else if (newElement == null) {
            this.clearViewProvider(vFile, "PSI moved");
            treeEvent.setParent((PsiElement)oldParentDir);
            treeEvent.setChild(oldElement);
            this.myManager.childRemoved(treeEvent);
        } else if (newElement instanceof PsiDirectory || FileManagerImpl.areViewProvidersEquivalent(newViewProvider, ((PsiFile)oldElement).getViewProvider())) {
            treeEvent.setOldParent((PsiElement)oldParentDir);
            treeEvent.setNewParent((PsiElement)newParentDir);
            treeEvent.setChild(oldElement);
            this.myManager.childMoved(treeEvent);
        } else {
            this.myFileManager.setViewProvider(vFile, newViewProvider);
            PsiTreeChangeEventImpl treeRemoveEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeRemoveEvent.setParent((PsiElement)oldParentDir);
            treeRemoveEvent.setChild(oldElement);
            this.myManager.childRemoved(treeRemoveEvent);
            PsiTreeChangeEventImpl treeAddEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeAddEvent.setParent((PsiElement)newParentDir);
            treeAddEvent.setChild(newElement);
            this.myManager.childAdded(treeAddEvent);
        }
    }

    private /* synthetic */ void lambda$fileDeleted$3(PsiDirectory parentDir, PsiElement element) {
        PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
        treeEvent.setParent((PsiElement)parentDir);
        treeEvent.setChild(element);
        this.myManager.childRemoved(treeEvent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "why";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCopied";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileDeletion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDeleted";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "clearViewProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforePropertyChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileMovement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "handleVfsChangeWithoutPsi";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isInRootModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$propertyChanged$5";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$beforePropertyChange$4";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyFileDocumentManagerAdapter
    extends FileDocumentManagerAdapter {
        private MyFileDocumentManagerAdapter() {
        }

        public void fileWithNoDocumentChanged(@NotNull VirtualFile file2) {
            PsiFile psiFile;
            if (file2 == null) {
                MyFileDocumentManagerAdapter.$$$reportNull$$$0(0);
            }
            if ((psiFile = PsiVFSListener.this.myFileManager.getCachedPsiFileInner(file2)) != null) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (file2 == null) {
                        MyFileDocumentManagerAdapter.$$$reportNull$$$0(4);
                    }
                    if (FileDocumentManagerImpl.recomputeFileTypeIfNecessary(file2)) {
                        PsiVFSListener.this.myFileManager.forceReload(file2);
                    } else {
                        PsiVFSListener.this.myFileManager.reloadPsiAfterTextChange(psiFile, file2);
                    }
                });
            } else {
                PsiVFSListener.this.handleVfsChangeWithoutPsi(file2);
            }
        }

        public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
            if (file2 == null) {
                MyFileDocumentManagerAdapter.$$$reportNull$$$0(1);
            }
            if (document == null) {
                MyFileDocumentManagerAdapter.$$$reportNull$$$0(2);
            }
            PsiFile psiFile = PsiVFSListener.this.myFileManager.getCachedPsiFileInner(file2);
            if (!file2.isValid() || psiFile == null || !FileUtilRt.isTooLarge((long)file2.getLength()) || psiFile instanceof PsiLargeFile) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (file2 == null) {
                    MyFileDocumentManagerAdapter.$$$reportNull$$$0(3);
                }
                PsiVFSListener.this.myFileManager.reloadPsiAfterTextChange(psiFile, file2);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener$MyFileDocumentManagerAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileWithNoDocumentChanged";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileContentReloaded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$fileContentReloaded$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$fileWithNoDocumentChanged$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyModuleRootListener
    implements ModuleRootListener {
        private VirtualFile[] myOldContentRoots;
        private int depthCounter;

        private MyModuleRootListener() {
        }

        public void beforeRootsChange(ModuleRootEvent event) {
            if (!PsiVFSListener.this.myFileManager.isInitialized()) {
                return;
            }
            if (event.isCausedByFileTypesChange()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                ++this.depthCounter;
                if (this.depthCounter > 1) {
                    return;
                }
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                treeEvent.setPropertyName("roots");
                VirtualFile[] contentRoots = PsiVFSListener.this.myProjectRootManager.getContentRoots();
                LOG.assertTrue(this.myOldContentRoots == null);
                this.myOldContentRoots = contentRoots;
                treeEvent.setOldValue(contentRoots);
                PsiVFSListener.this.myManager.beforePropertyChange(treeEvent);
            });
        }

        public void rootsChanged(ModuleRootEvent event) {
            PsiVFSListener.this.myFileManager.dispatchPendingEvents();
            if (!PsiVFSListener.this.myFileManager.isInitialized()) {
                return;
            }
            if (event.isCausedByFileTypesChange()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                --this.depthCounter;
                assert (this.depthCounter >= 0) : this.depthCounter;
                if (this.depthCounter > 0) {
                    return;
                }
                DebugUtil.startPsiModification(null);
                try {
                    PsiVFSListener.this.myFileManager.invalidateAllPsi();
                }
                catch (Exception e) {
                    DebugUtil.finishPsiModification();
                }
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                treeEvent.setPropertyName("roots");
                VirtualFile[] contentRoots = PsiVFSListener.this.myProjectRootManager.getContentRoots();
                treeEvent.setNewValue(contentRoots);
                LOG.assertTrue(this.myOldContentRoots != null);
                treeEvent.setOldValue(this.myOldContentRoots);
                this.myOldContentRoots = null;
                PsiVFSListener.this.myManager.propertyChanged(treeEvent);
            });
        }
    }
}

