/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemanticEditorPosition {
    private final EditorEx myEditor;
    private final HighlighterIterator myIterator;
    private final CharSequence myChars;
    private final Function<IElementType, SyntaxElement> myTypeMapper;

    public SemanticEditorPosition(@NotNull EditorEx editor, int offset, @NotNull Function<IElementType, SyntaxElement> typeMapper) {
        if (editor == null) {
            SemanticEditorPosition.$$$reportNull$$$0(0);
        }
        if (typeMapper == null) {
            SemanticEditorPosition.$$$reportNull$$$0(1);
        }
        this(editor, editor.getHighlighter().createIterator(offset), typeMapper);
    }

    private SemanticEditorPosition(@NotNull EditorEx editor, @NotNull HighlighterIterator iterator, @NotNull Function<IElementType, SyntaxElement> typeMapper) {
        if (editor == null) {
            SemanticEditorPosition.$$$reportNull$$$0(2);
        }
        if (iterator == null) {
            SemanticEditorPosition.$$$reportNull$$$0(3);
        }
        if (typeMapper == null) {
            SemanticEditorPosition.$$$reportNull$$$0(4);
        }
        this.myEditor = editor;
        this.myChars = editor.getDocument().getCharsSequence();
        this.myIterator = iterator;
        this.myTypeMapper = typeMapper;
    }

    public void moveBeforeOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(5);
        }
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition beforeOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(6);
        }
        return this.copyAnd(position -> {
            if (syntaxElement == null) {
                SemanticEditorPosition.$$$reportNull$$$0(45);
            }
            position.moveBeforeOptional(syntaxElement);
        });
    }

    public void moveBeforeOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(7);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition beforeOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(8);
        }
        return this.copyAnd(position -> {
            if (elements == null) {
                SemanticEditorPosition.$$$reportNull$$$0(44);
            }
            position.moveBeforeOptionalMix(elements);
        });
    }

    public void moveAfterOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(9);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition afterOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(10);
        }
        return this.copyAnd(position -> {
            if (elements == null) {
                SemanticEditorPosition.$$$reportNull$$$0(43);
            }
            position.moveAfterOptionalMix(elements);
        });
    }

    public boolean isAtMultiline() {
        if (!this.myIterator.atEnd()) {
            return CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)this.myIterator.getStart(), (int)this.myIterator.getEnd());
        }
        return false;
    }

    public void moveBefore() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition before() {
        return this.copyAnd(position -> position.moveBefore());
    }

    public void moveAfterOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(11);
        }
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition afterOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(12);
        }
        return this.copyAnd(position -> {
            if (syntaxElement == null) {
                SemanticEditorPosition.$$$reportNull$$$0(42);
            }
            position.moveAfterOptional(syntaxElement);
        });
    }

    public void moveAfter() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition after() {
        return this.copyAnd(position -> position.moveAfter());
    }

    public void moveBeforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(13);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(14);
        }
        int parenLevel = 0;
        while (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            this.myIterator.retreat();
            if (rightParenthesis.equals(currElement)) {
                ++parenLevel;
                continue;
            }
            if (!leftParenthesis.equals(currElement) || --parenLevel >= 1) continue;
            break;
        }
    }

    public SemanticEditorPosition beforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(15);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(16);
        }
        return this.copyAnd(position -> {
            if (leftParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(40);
            }
            if (rightParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(41);
            }
            position.moveBeforeParentheses(leftParenthesis, rightParenthesis);
        });
    }

    public void moveToLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(17);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(18);
        }
        this.moveToLeftParenthesisBackwardsSkippingNested(leftParenthesis, rightParenthesis, (Condition<SyntaxElement>)Conditions.alwaysFalse());
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(19);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(20);
        }
        return this.copyAnd(position -> {
            if (leftParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(38);
            }
            if (rightParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(39);
            }
            position.moveToLeftParenthesisBackwardsSkippingNested(leftParenthesis, rightParenthesis);
        });
    }

    public void moveToLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis, @NotNull Condition<SyntaxElement> terminationCondition) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(21);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(22);
        }
        if (terminationCondition == null) {
            SemanticEditorPosition.$$$reportNull$$$0(23);
        }
        while (!this.myIterator.atEnd() && !terminationCondition.value((Object)this.map(this.myIterator.getTokenType()))) {
            if (rightParenthesis.equals(this.map(this.myIterator.getTokenType()))) {
                this.moveBeforeParentheses(leftParenthesis, rightParenthesis);
            } else if (leftParenthesis.equals(this.map(this.myIterator.getTokenType()))) break;
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis, @NotNull Condition<SyntaxElement> terminationCondition) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(24);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(25);
        }
        if (terminationCondition == null) {
            SemanticEditorPosition.$$$reportNull$$$0(26);
        }
        return this.copyAnd(position -> {
            if (leftParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(35);
            }
            if (rightParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(36);
            }
            if (terminationCondition == null) {
                SemanticEditorPosition.$$$reportNull$$$0(37);
            }
            position.moveToLeftParenthesisBackwardsSkippingNested(leftParenthesis, rightParenthesis, terminationCondition);
        });
    }

    public boolean isAfterOnSameLine(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(27);
        }
        this.myIterator.retreat();
        while (!this.myIterator.atEnd() && !this.isAtMultiline()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return true;
            }
            this.myIterator.retreat();
        }
        return false;
    }

    public boolean isAt(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(28);
        }
        return !this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()));
    }

    public boolean isAt(@NotNull IElementType elementType) {
        if (elementType == null) {
            SemanticEditorPosition.$$$reportNull$$$0(29);
        }
        return !this.myIterator.atEnd() && this.myIterator.getTokenType() == elementType;
    }

    public boolean isAtEnd() {
        return this.myIterator.atEnd();
    }

    public int getStartOffset() {
        return this.myIterator.getStart();
    }

    public boolean isAtAnyOf(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(30);
        }
        if (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return true;
            }
        }
        return false;
    }

    public CharSequence getChars() {
        return this.myChars;
    }

    public int findStartOf(@NotNull SyntaxElement element) {
        if (element == null) {
            SemanticEditorPosition.$$$reportNull$$$0(31);
        }
        while (!this.myIterator.atEnd()) {
            if (element.equals(this.map(this.myIterator.getTokenType()))) {
                return this.myIterator.getStart();
            }
            this.myIterator.retreat();
        }
        return -1;
    }

    public boolean hasEmptyLineAfter(int offset) {
        for (int i = offset + 1; i < this.myIterator.getEnd(); ++i) {
            if (this.myChars.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    public EditorEx getEditor() {
        return this.myEditor;
    }

    @Nullable
    public Language getLanguage() {
        return !this.myIterator.atEnd() ? this.myIterator.getTokenType().getLanguage() : null;
    }

    public boolean isAtLanguage(@Nullable Language language) {
        if (language != null && !this.myIterator.atEnd()) {
            return language == Language.ANY || this.myIterator.getTokenType().getLanguage().is(language);
        }
        return false;
    }

    @Nullable
    public SyntaxElement getCurrElement() {
        return !this.myIterator.atEnd() ? this.map(this.myIterator.getTokenType()) : null;
    }

    public boolean matchesRule(@NotNull Rule rule) {
        if (rule == null) {
            SemanticEditorPosition.$$$reportNull$$$0(32);
        }
        return rule.check(this);
    }

    public SyntaxElement map(@NotNull IElementType elementType) {
        if (elementType == null) {
            SemanticEditorPosition.$$$reportNull$$$0(33);
        }
        return this.myTypeMapper.apply(elementType);
    }

    public String toString() {
        return this.myIterator.getTokenType().toString();
    }

    public SemanticEditorPosition copy() {
        if (!this.myIterator.atEnd()) {
            return new SemanticEditorPosition(this.myEditor, this.myIterator.getStart(), this.myTypeMapper);
        }
        HighlighterIteratorWrapper wrapper = new HighlighterIteratorWrapper(this.myIterator){

            @Override
            public void advance() {
            }

            @Override
            public void retreat() {
            }
        };
        return new SemanticEditorPosition(this.myEditor, wrapper, this.myTypeMapper);
    }

    public SemanticEditorPosition copyAnd(@NotNull Consumer<SemanticEditorPosition> modifier) {
        if (modifier == null) {
            SemanticEditorPosition.$$$reportNull$$$0(34);
        }
        SemanticEditorPosition position = this.copy();
        modifier.accept(position);
        return position;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 28: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 35: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftParenthesis";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 36: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightParenthesis";
                break;
            }
            case 23: 
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminationCondition";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElements";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "moveBeforeOptional";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeOptional";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "moveBeforeOptionalMix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeOptionalMix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "moveAfterOptionalMix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "afterOptionalMix";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "moveAfterOptional";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "afterOptional";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "moveBeforeParentheses";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeParentheses";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "moveToLeftParenthesisBackwardsSkippingNested";
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "findLeftParenthesisBackwardsSkippingNested";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "isAfterOnSameLine";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "isAt";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "isAtAnyOf";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "findStartOf";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesRule";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "map";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "copyAnd";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findLeftParenthesisBackwardsSkippingNested$8";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findLeftParenthesisBackwardsSkippingNested$7";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$beforeParentheses$6";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$afterOptional$4";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$afterOptionalMix$2";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$beforeOptionalMix$1";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$beforeOptional$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Rule {
        public boolean check(SemanticEditorPosition var1);
    }

    public static interface SyntaxElement {
    }
}

