/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html.dtd;

import com.intellij.html.RelaxedHtmlNSDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SimpleFieldCache;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSTypeDescriptorProvider;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlNSDescriptorImpl
implements XmlNSDescriptor,
DumbAware,
XmlNSTypeDescriptorProvider {
    private final XmlNSDescriptor myDelegate;
    private final boolean myRelaxed;
    private final boolean myCaseSensitive;
    private static final SimpleFieldCache<Map<String, XmlElementDescriptor>, HtmlNSDescriptorImpl> myCachedDeclsCache = new SimpleFieldCache<Map<String, XmlElementDescriptor>, HtmlNSDescriptorImpl>(){

        protected Map<String, XmlElementDescriptor> compute(HtmlNSDescriptorImpl htmlNSDescriptor) {
            return htmlNSDescriptor.doBuildCachedMap();
        }

        protected Map<String, XmlElementDescriptor> getValue(HtmlNSDescriptorImpl htmlNSDescriptor) {
            return htmlNSDescriptor.myCachedDecls;
        }

        protected void putValue(Map<String, XmlElementDescriptor> map, HtmlNSDescriptorImpl htmlNSDescriptor) {
            htmlNSDescriptor.myCachedDecls = map;
        }
    };
    private volatile Map<String, XmlElementDescriptor> myCachedDecls;

    public HtmlNSDescriptorImpl(XmlNSDescriptor _delegate) {
        this(_delegate, _delegate instanceof RelaxedHtmlNSDescriptor, false);
    }

    public HtmlNSDescriptorImpl(XmlNSDescriptor _delegate, boolean relaxed, boolean caseSensitive) {
        this.myDelegate = _delegate;
        this.myRelaxed = relaxed;
        this.myCaseSensitive = caseSensitive;
    }

    @Nullable
    public static XmlAttributeDescriptor getCommonAttributeDescriptor(@NotNull String attributeName, @Nullable XmlTag context) {
        XmlElementDescriptor descriptor;
        if (attributeName == null) {
            HtmlNSDescriptorImpl.$$$reportNull$$$0(0);
        }
        if ((descriptor = HtmlNSDescriptorImpl.guessTagForCommonAttributes(context)) != null) {
            return descriptor.getAttributeDescriptor(attributeName, context);
        }
        return null;
    }

    @NotNull
    public static XmlAttributeDescriptor[] getCommonAttributeDescriptors(XmlTag context) {
        XmlElementDescriptor descriptor = HtmlNSDescriptorImpl.guessTagForCommonAttributes(context);
        if (descriptor != null) {
            XmlAttributeDescriptor[] xmlAttributeDescriptorArray = descriptor.getAttributesDescriptors(context);
            if (xmlAttributeDescriptorArray == null) {
                HtmlNSDescriptorImpl.$$$reportNull$$$0(1);
            }
            return xmlAttributeDescriptorArray;
        }
        if (XmlAttributeDescriptor.EMPTY == null) {
            HtmlNSDescriptorImpl.$$$reportNull$$$0(2);
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    @Nullable
    public static XmlElementDescriptor guessTagForCommonAttributes(@Nullable XmlTag context) {
        if (context == null) {
            return null;
        }
        XmlNSDescriptor nsDescriptor = context.getNSDescriptor(context.getNamespace(), false);
        if (nsDescriptor instanceof HtmlNSDescriptorImpl) {
            XmlElementDescriptor descriptor = ((HtmlNSDescriptorImpl)nsDescriptor).getElementDescriptorByName("div");
            descriptor = descriptor == null ? ((HtmlNSDescriptorImpl)nsDescriptor).getElementDescriptorByName("span") : descriptor;
            return descriptor;
        }
        return null;
    }

    private Map<String, XmlElementDescriptor> buildDeclarationMap() {
        return (Map)myCachedDeclsCache.get((Object)this);
    }

    private HashMap<String, XmlElementDescriptor> doBuildCachedMap() {
        XmlElementDescriptor[] elements;
        HashMap<String, XmlElementDescriptor> decls = new HashMap<String, XmlElementDescriptor>();
        for (XmlElementDescriptor element : elements = this.myDelegate == null ? XmlElementDescriptor.EMPTY_ARRAY : this.myDelegate.getRootElementsDescriptors(null)) {
            decls.put(element.getName(), new HtmlElementDescriptorImpl(element, this.myRelaxed, this.myCaseSensitive));
        }
        return decls;
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        XmlElementDescriptor xmlElementDescriptor;
        if (tag == null) {
            HtmlNSDescriptorImpl.$$$reportNull$$$0(3);
        }
        if ((xmlElementDescriptor = this.getElementDescriptorByName(tag.getLocalName())) == null && this.myRelaxed) {
            xmlElementDescriptor = this.myDelegate.getElementDescriptor(tag);
        }
        return xmlElementDescriptor;
    }

    private XmlElementDescriptor getElementDescriptorByName(String name) {
        if (!this.myCaseSensitive) {
            name = name.toLowerCase();
        }
        return this.buildDeclarationMap().get(name);
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        XmlElementDescriptor[] xmlElementDescriptorArray = this.myDelegate == null ? XmlElementDescriptor.EMPTY_ARRAY : this.myDelegate.getRootElementsDescriptors(document);
        if (xmlElementDescriptorArray == null) {
            HtmlNSDescriptorImpl.$$$reportNull$$$0(4);
        }
        return xmlElementDescriptorArray;
    }

    @Nullable
    public XmlFile getDescriptorFile() {
        return this.myDelegate == null ? null : this.myDelegate.getDescriptorFile();
    }

    public PsiElement getDeclaration() {
        return this.myDelegate == null ? null : this.myDelegate.getDeclaration();
    }

    public String getName(PsiElement context) {
        return this.myDelegate == null ? "" : this.myDelegate.getName(context);
    }

    public String getName() {
        return this.myDelegate == null ? "" : this.myDelegate.getName();
    }

    public void init(PsiElement element) {
        this.myDelegate.init(element);
    }

    @NotNull
    public Object[] getDependences() {
        Object[] objectArray = this.myDelegate == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : this.myDelegate.getDependences();
        if (objectArray == null) {
            HtmlNSDescriptorImpl.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String name, XmlTag context) {
        return this.myDelegate instanceof XmlNSTypeDescriptorProvider ? ((XmlNSTypeDescriptorProvider)this.myDelegate).getTypeDescriptor(name, context) : null;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(XmlTag descriptorTag) {
        return this.myDelegate instanceof XmlNSTypeDescriptorProvider ? ((XmlNSTypeDescriptorProvider)this.myDelegate).getTypeDescriptor(descriptorTag) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/html/dtd/HtmlNSDescriptorImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/html/dtd/HtmlNSDescriptorImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonAttributeDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElementsDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAttributeDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

