/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceProviderBean;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceProvidersRegistryImpl
extends ReferenceProvidersRegistry {
    private static final LanguageExtension<PsiReferenceContributor> CONTRIBUTOR_EXTENSION = new LanguageExtension(PsiReferenceContributor.EP_NAME.getName());
    private static final LanguageExtension<PsiReferenceProviderBean> REFERENCE_PROVIDER_EXTENSION = new LanguageExtension(PsiReferenceProviderBean.EP_NAME.getName());
    private final Map<Language, PsiReferenceRegistrarImpl> myRegistrars = ContainerUtil.newConcurrentMap();

    @NotNull
    private static PsiReferenceRegistrarImpl createRegistrar(Language language) {
        PsiReferenceRegistrarImpl registrar = new PsiReferenceRegistrarImpl();
        for (PsiReferenceContributor contributor : CONTRIBUTOR_EXTENSION.allForLanguageOrAny(language)) {
            contributor.registerReferenceProviders((PsiReferenceRegistrar)registrar);
        }
        List referenceProviderBeans = REFERENCE_PROVIDER_EXTENSION.allForLanguageOrAny(language);
        for (final PsiReferenceProviderBean providerBean : referenceProviderBeans) {
            ElementPattern pattern = providerBean.createElementPattern();
            if (pattern == null) continue;
            registrar.registerReferenceProvider(pattern, new PsiReferenceProvider(){
                PsiReferenceProvider myProvider;

                @NotNull
                public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (context == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (this.myProvider == null) {
                        this.myProvider = providerBean.instantiate();
                        if (this.myProvider == null) {
                            this.myProvider = ReferenceProvidersRegistry.NULL_REFERENCE_PROVIDER;
                        }
                    }
                    PsiReference[] psiReferenceArray = this.myProvider.getReferencesByElement(element, context);
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getReferencesByElement";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getReferencesByElement";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
        registrar.markInitialized();
        PsiReferenceRegistrarImpl psiReferenceRegistrarImpl = registrar;
        if (psiReferenceRegistrarImpl == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceRegistrarImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiReferenceRegistrarImpl getRegistrar(@NotNull Language language) {
        PsiReferenceRegistrarImpl registrar;
        if (language == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(1);
        }
        if ((registrar = this.myRegistrars.get(language)) == null) {
            ReferenceProvidersRegistryImpl referenceProvidersRegistryImpl = this;
            synchronized (referenceProvidersRegistryImpl) {
                registrar = this.myRegistrars.get(language);
                if (registrar == null) {
                    registrar = ReferenceProvidersRegistryImpl.createRegistrar(language);
                    this.myRegistrars.put(language, registrar);
                }
            }
        }
        PsiReferenceRegistrarImpl psiReferenceRegistrarImpl = registrar;
        if (psiReferenceRegistrarImpl == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(2);
        }
        return psiReferenceRegistrarImpl;
    }

    @Override
    @NotNull
    protected PsiReference[] doGetReferencesFromProviders(@NotNull PsiElement context, @NotNull PsiReferenceService.Hints hints) {
        List<ProviderBinding.ProviderInfo<ProcessingContext>> providers;
        MultiMap<Double, PsiReference[]> allReferencesMap;
        if (context == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(3);
        }
        if (hints == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(4);
        }
        if ((allReferencesMap = ReferenceProvidersRegistryImpl.mapNotEmptyReferencesFromProviders(context, providers = this.getRegistrar(context.getLanguage()).getPairsByElement(context, hints))).isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        List result2 = ContainerUtil.newSmartList();
        double maxPriority = ReferenceProvidersRegistryImpl.getMaxPriority(allReferencesMap.keySet());
        List<PsiReference> maxPriorityRefs = ReferenceProvidersRegistryImpl.collectReferences(allReferencesMap.get((Object)maxPriority));
        ContainerUtil.addAllNotNull((Collection)result2, maxPriorityRefs);
        ContainerUtil.addAllNotNull((Collection)result2, ReferenceProvidersRegistryImpl.getLowerPriorityReferences(allReferencesMap, maxPriority, maxPriorityRefs));
        PsiReference[] psiReferenceArray = result2.toArray(new PsiReference[result2.size()]);
        if (psiReferenceArray == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    @NotNull
    private static MultiMap<Double, PsiReference[]> mapNotEmptyReferencesFromProviders(@NotNull PsiElement context, @NotNull List<ProviderBinding.ProviderInfo<ProcessingContext>> providers) {
        if (context == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(7);
        }
        if (providers == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(8);
        }
        MultiMap map = new MultiMap();
        for (ProviderBinding.ProviderInfo<ProcessingContext> trinity : providers) {
            PsiReference[] refs = ReferenceProvidersRegistryImpl.getReferences(context, trinity);
            if (refs.length <= 0) continue;
            map.putValue((Object)trinity.priority, (Object)refs);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(9);
        }
        return multiMap;
    }

    @NotNull
    private static PsiReference[] getReferences(@NotNull PsiElement context, @NotNull ProviderBinding.ProviderInfo<ProcessingContext> providerInfo) {
        PsiReference[] psiReferenceArray;
        if (context == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(10);
        }
        if (providerInfo == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(11);
        }
        try {
            psiReferenceArray = providerInfo.provider.getReferencesByElement(context, (ProcessingContext)providerInfo.processingContext);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(13);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiReferenceArray == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(12);
        }
        return psiReferenceArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static List<PsiReference> getLowerPriorityReferences(@NotNull MultiMap<Double, PsiReference[]> allReferencesMap, double maxPriority, @NotNull List<PsiReference> list2) {
        if (allReferencesMap == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(14);
        }
        if (list2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(15);
        }
        List result2 = ContainerUtil.newSmartList();
        for (Map.Entry entry : allReferencesMap.entrySet()) {
            if (maxPriority == (Double)entry.getKey()) continue;
            for (Object[] references : (Collection)entry.getValue()) {
                void maxPriorityRefs;
                if (!ReferenceProvidersRegistryImpl.haveNotIntersectedTextRanges((List<PsiReference>)maxPriorityRefs, (PsiReference[])references)) continue;
                ContainerUtil.addAllNotNull((Collection)result2, (Object[])references);
            }
        }
        List list3 = result2;
        if (list3 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(16);
        }
        return list3;
    }

    private static boolean haveNotIntersectedTextRanges(@NotNull List<PsiReference> higherPriorityRefs, @NotNull PsiReference[] lowerPriorityRefs) {
        if (higherPriorityRefs == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(17);
        }
        if (lowerPriorityRefs == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(18);
        }
        for (PsiReference ref : lowerPriorityRefs) {
            if (ref == null) continue;
            for (PsiReference reference : higherPriorityRefs) {
                if (reference == null || !ReferenceRange.containsRangeInElement((PsiReference)reference, (TextRange)ref.getRangeInElement())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static List<PsiReference> collectReferences(@Nullable Collection<PsiReference[]> references) {
        if (references == null) {
            List<PsiReference> list2 = Collections.emptyList();
            if (list2 == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(19);
            }
            return list2;
        }
        List list3 = ContainerUtil.newSmartList();
        for (Object[] objectArray : references) {
            ContainerUtil.addAllNotNull((Collection)list3, (Object[])objectArray);
        }
        List list4 = list3;
        if (list4 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(20);
        }
        return list4;
    }

    private static double getMaxPriority(@NotNull Set<Double> doubles) {
        if (doubles == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(21);
        }
        double maxPriority = -100.0;
        for (Double aDouble : doubles) {
            if (!(aDouble > maxPriority)) continue;
            maxPriority = aDouble;
        }
        return maxPriority;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerInfo";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allReferencesMap";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxPriorityRefs";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "higherPriorityRefs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lowerPriorityRefs";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doubles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRegistrar";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrar";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetReferencesFromProviders";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotEmptyReferencesFromProviders";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLowerPriorityReferences";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRegistrar";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetReferencesFromProviders";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mapNotEmptyReferencesFromProviders";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLowerPriorityReferences";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "haveNotIntersectedTextRanges";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMaxPriority";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

