/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.RangeMarkerWindow;
import com.intellij.psi.impl.source.tree.injected.ShredImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.ImmutableCharSequence;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DocumentWindowImpl
extends UserDataHolderBase
implements Disposable,
DocumentWindow,
DocumentEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.injected.editor.DocumentWindowImpl");
    private final DocumentEx myDelegate;
    private final boolean myOneLine;
    private Place myShreds;
    private final int myPrefixLineCount;
    private final int mySuffixLineCount;
    private final Object myLock;
    private CachedText myCachedText;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentWindowImpl(@NotNull DocumentEx delegate, @NotNull Place shreds) {
        if (delegate == null) {
            DocumentWindowImpl.$$$reportNull$$$0(0);
        }
        if (shreds == null) {
            DocumentWindowImpl.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myDelegate = delegate;
        this.myOneLine = ContainerUtil.and((Iterable)((Object)shreds), s -> ((ShredImpl)s).isOneLine());
        Object object = this.myLock;
        synchronized (object) {
            this.myShreds = shreds;
        }
        this.myPrefixLineCount = Math.max(1, 1 + StringUtil.countNewLines((CharSequence)((PsiLanguageInjectionHost.Shred)shreds.get(0)).getPrefix()));
        this.mySuffixLineCount = Math.max(1, 1 + StringUtil.countNewLines((CharSequence)((PsiLanguageInjectionHost.Shred)shreds.get(shreds.size() - 1)).getSuffix()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means we were unable to calculate")
    LogicalPosition hostToInjectedInVirtualSpace(@NotNull LogicalPosition hPos) {
        if (hPos == null) {
            DocumentWindowImpl.$$$reportNull$$$0(2);
        }
        int hLineStartOffset = hPos.line >= this.myDelegate.getLineCount() ? this.myDelegate.getTextLength() : this.myDelegate.getLineStartOffset(hPos.line);
        int iLineStartOffset = this.hostToInjected(hLineStartOffset);
        int iLine = this.getLineNumber(iLineStartOffset);
        Object object = this.myLock;
        synchronized (object) {
            for (int i = this.myShreds.size() - 1; i >= 0; --i) {
                Segment hostRangeMarker;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(i);
                if (!shred.isValid() || (hostRangeMarker = shred.getHostRangeMarker()) == null) continue;
                int hShredEndOffset = hostRangeMarker.getEndOffset();
                int hShredStartOffset = hostRangeMarker.getStartOffset();
                int hShredStartLine = this.myDelegate.getLineNumber(hShredStartOffset);
                int hShredEndLine = this.myDelegate.getLineNumber(hShredEndOffset);
                if (hShredStartLine > hPos.line || hPos.line > hShredEndLine) continue;
                int hColumnOfShredEnd = hShredEndOffset - hLineStartOffset;
                int iColumnOfShredEnd = this.hostToInjected(hShredEndOffset) - iLineStartOffset;
                int iColumn = iColumnOfShredEnd + hPos.column - hColumnOfShredEnd;
                return new LogicalPosition(iLine, iColumn);
            }
        }
        return null;
    }

    public int getLineCount() {
        return 1 + StringUtil.countNewLines((CharSequence)this.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineStartOffset(int line) {
        LOG.assertTrue(line >= 0, (Object)line);
        if (line == 0) {
            return 0;
        }
        String hostText = this.myDelegate.getText();
        int[] pos = new int[2];
        Object object = this.myLock;
        synchronized (object) {
            Iterator iterator = this.myShreds.iterator();
            while (iterator.hasNext()) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                int found = DocumentWindowImpl.countNewLinesIn(shred.getPrefix(), pos, line);
                if (found != -1) {
                    return found;
                }
                CharSequence text = hostText.subSequence(hostRange.getStartOffset(), hostRange.getEndOffset());
                found = DocumentWindowImpl.countNewLinesIn(text, pos, line);
                if (found != -1) {
                    return found;
                }
                found = DocumentWindowImpl.countNewLinesIn(shred.getSuffix(), pos, line);
                if (found == -1) continue;
                return found;
            }
        }
        return pos[1];
    }

    private static int countNewLinesIn(CharSequence text, int[] pos, int line) {
        int offsetInside = 0;
        int i = StringUtil.indexOf((CharSequence)text, (char)'\n');
        while (i != -1) {
            int curLine = pos[0] = pos[0] + 1;
            int lineLength = i + 1 - offsetInside;
            int offset = pos[1] = pos[1] + lineLength;
            offsetInside += lineLength;
            if (curLine == line) {
                return offset;
            }
            i = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)offsetInside);
        }
        pos[1] = pos[1] + (text.length() - offsetInside);
        return -1;
    }

    public int getLineEndOffset(int line) {
        LOG.assertTrue(line >= 0, (Object)line);
        if (line == this.getLineCount() - 1) {
            return this.getTextLength();
        }
        int startOffsetOfNextLine = this.getLineStartOffset(line + 1);
        return startOffsetOfNextLine == 0 || this.getText().charAt(startOffsetOfNextLine - 1) != '\n' ? startOffsetOfNextLine : startOffsetOfNextLine - 1;
    }

    @NotNull
    public String getText() {
        CachedText cachedText = this.myCachedText;
        if (cachedText == null || cachedText.getModificationStamp() != this.getModificationStamp()) {
            this.myCachedText = cachedText = new CachedText(this.calcText(), this.getModificationStamp());
        }
        String string = cachedText.getText();
        if (string == null) {
            DocumentWindowImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String calcText() {
        StringBuilder text = new StringBuilder();
        CharSequence hostText = this.myDelegate.getCharsSequence();
        Object object = this.myLock;
        synchronized (object) {
            Iterator iterator = this.myShreds.iterator();
            while (iterator.hasNext()) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                text.append(shred.getPrefix());
                text.append(hostText, hostRange.getStartOffset(), hostRange.getEndOffset());
                text.append(shred.getSuffix());
            }
        }
        String string = text.toString();
        if (string == null) {
            DocumentWindowImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        CharSequence charSequence = ImmutableCharSequence.asImmutable((CharSequence)this.getText());
        if (charSequence == null) {
            DocumentWindowImpl.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTextLength() {
        int length = 0;
        Object object = this.myLock;
        synchronized (object) {
            Iterator iterator = this.myShreds.iterator();
            while (iterator.hasNext()) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                length += shred.getPrefix().length();
                length += hostRange.getEndOffset() - hostRange.getStartOffset();
                length += shred.getSuffix().length();
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber(int offset) {
        int lineNumber = 0;
        String hostText = this.myDelegate.getText();
        Object object = this.myLock;
        synchronized (object) {
            Iterator iterator = this.myShreds.iterator();
            while (iterator.hasNext()) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
                String prefix = shred.getPrefix();
                String suffix = shred.getSuffix();
                lineNumber += StringUtil.getLineBreakCount((CharSequence)prefix.substring(0, Math.min(offset, prefix.length())));
                if (offset < prefix.length()) {
                    return lineNumber;
                }
                offset -= prefix.length();
                Segment currentRange = shred.getHostRangeMarker();
                if (currentRange == null) continue;
                int rangeLength = currentRange.getEndOffset() - currentRange.getStartOffset();
                CharSequence rangeText = hostText.subSequence(currentRange.getStartOffset(), currentRange.getEndOffset());
                lineNumber += StringUtil.getLineBreakCount((CharSequence)rangeText.subSequence(0, Math.min(offset, rangeLength)));
                if (offset < rangeLength) {
                    return lineNumber;
                }
                lineNumber += StringUtil.getLineBreakCount((CharSequence)suffix.substring(0, Math.min(offset -= rangeLength, suffix.length())));
                if (offset < suffix.length()) {
                    return lineNumber;
                }
                offset -= suffix.length();
            }
        }
        lineNumber = this.getLineCount() - 1;
        return lineNumber < 0 ? 0 : lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextRange getHostRange(int hostOffset) {
        Object object = this.myLock;
        synchronized (object) {
            Iterator iterator = this.myShreds.iterator();
            while (iterator.hasNext()) {
                ProperTextRange textRange;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
                Segment currentRange = shred.getHostRangeMarker();
                if (currentRange == null || !(textRange = ProperTextRange.create((Segment)currentRange)).grown(1).contains(hostOffset)) continue;
                return textRange;
            }
        }
        return null;
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            DocumentWindowImpl.$$$reportNull$$$0(6);
        }
        assert (this.intersectWithEditable(new TextRange(offset, offset)) != null);
        if (this.isOneLine()) {
            s = StringUtil.replace((String)s.toString(), (String)"\n", (String)"");
        }
        this.myDelegate.insertString(this.injectedToHost(offset), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteString(int startOffset, int endOffset) {
        ArrayList<TextRange> hostRangesToDelete;
        assert (this.intersectWithEditable(new TextRange(startOffset, startOffset)) != null);
        assert (this.intersectWithEditable(new TextRange(endOffset, endOffset)) != null);
        Object object = this.myLock;
        synchronized (object) {
            hostRangesToDelete = new ArrayList<TextRange>(this.myShreds.size());
            int offset = startOffset;
            int curRangeStart = 0;
            Iterator iterator = this.myShreds.iterator();
            while (iterator.hasNext()) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
                if (offset < (curRangeStart += shred.getPrefix().length())) {
                    offset = curRangeStart;
                }
                if (offset >= endOffset) break;
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                int hostRangeLength = hostRange.getEndOffset() - hostRange.getStartOffset();
                TextRange range2 = TextRange.from((int)curRangeStart, (int)hostRangeLength);
                if (range2.contains(offset)) {
                    TextRange rangeToDelete = new TextRange(offset, Math.min(range2.getEndOffset(), endOffset));
                    hostRangesToDelete.add(rangeToDelete.shiftRight(hostRange.getStartOffset() - curRangeStart));
                    offset = rangeToDelete.getEndOffset();
                }
                curRangeStart += hostRangeLength;
                curRangeStart += shred.getSuffix().length();
            }
        }
        int delta = 0;
        for (TextRange hostRangeToDelete : hostRangesToDelete) {
            this.myDelegate.deleteString(hostRangeToDelete.getStartOffset() + delta, hostRangeToDelete.getEndOffset() + delta);
            delta -= hostRangeToDelete.getLength();
        }
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            DocumentWindowImpl.$$$reportNull$$$0(7);
        }
        if (this.isOneLine()) {
            s = StringUtil.replace((String)s.toString(), (String)"\n", (String)"");
        }
        CharSequence chars = this.getCharsSequence();
        CharSequence toDelete = chars.subSequence(startOffset, endOffset);
        int perfixLength = StringUtil.commonPrefixLength((CharSequence)s, (CharSequence)toDelete);
        int suffixLength = StringUtil.commonSuffixLength((CharSequence)toDelete.subSequence(perfixLength, toDelete.length()), (CharSequence)s.subSequence(perfixLength, s.length()));
        s = s.subSequence(perfixLength, s.length() - suffixLength);
        this.doReplaceString(startOffset += perfixLength, endOffset -= suffixLength, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReplaceString(int startOffset, int endOffset, CharSequence s) {
        ArrayList<Pair> hostRangesToModify;
        assert (this.intersectWithEditable(new TextRange(startOffset, startOffset)) != null);
        assert (this.intersectWithEditable(new TextRange(endOffset, endOffset)) != null);
        Object object = this.myLock;
        synchronized (object) {
            hostRangesToModify = new ArrayList<Pair>(this.myShreds.size());
            int offset = startOffset;
            int curRangeStart = 0;
            for (int i = 0; i < this.myShreds.size(); ++i) {
                Segment hostRange;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(i);
                if (offset < (curRangeStart += shred.getPrefix().length())) {
                    offset = curRangeStart;
                }
                if ((hostRange = shred.getHostRangeMarker()) == null) continue;
                int hostRangeLength = hostRange.getEndOffset() - hostRange.getStartOffset();
                TextRange range2 = TextRange.from((int)curRangeStart, (int)hostRangeLength);
                if (range2.contains(offset) || range2.getEndOffset() == offset) {
                    TextRange rangeToModify = new TextRange(offset, Math.min(range2.getEndOffset(), endOffset));
                    TextRange hostRangeToModify = rangeToModify.shiftRight(hostRange.getStartOffset() - curRangeStart);
                    CharSequence toReplace = i == this.myShreds.size() - 1 || range2.getEndOffset() + shred.getSuffix().length() >= endOffset ? s : s.subSequence(0, Math.min(hostRangeToModify.getLength(), s.length()));
                    s = toReplace == s ? "" : s.subSequence(toReplace.length(), s.length());
                    hostRangesToModify.add(Pair.create((Object)hostRangeToModify, (Object)toReplace));
                    offset = rangeToModify.getEndOffset();
                }
                curRangeStart += hostRangeLength;
                if ((curRangeStart += shred.getSuffix().length()) > endOffset) break;
            }
        }
        int delta = 0;
        for (Pair pair : hostRangesToModify) {
            TextRange hostRange = (TextRange)pair.getFirst();
            CharSequence replace = (CharSequence)pair.getSecond();
            this.myDelegate.replaceString(hostRange.getStartOffset() + delta, hostRange.getEndOffset() + delta, replace);
            delta -= hostRange.getLength() - replace.length();
        }
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return this.myDelegate.isWritable();
    }

    public long getModificationStamp() {
        return this.isValid() ? this.myDelegate.getModificationStamp() : -1L;
    }

    @Override
    public int getModificationSequence() {
        return this.myDelegate.getModificationSequence();
    }

    public void fireReadOnlyModificationAttempt() {
        this.myDelegate.fireReadOnlyModificationAttempt();
    }

    public void addDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(8);
        }
        this.myDelegate.addDocumentListener(listener2);
    }

    public void addDocumentListener(@NotNull DocumentListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            DocumentWindowImpl.$$$reportNull$$$0(10);
        }
        this.myDelegate.addDocumentListener(listener2, parentDisposable);
    }

    public void removeDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(11);
        }
        this.myDelegate.removeDocumentListener(listener2);
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        ProperTextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeMarker hostMarker = this.myDelegate.createRangeMarker((TextRange)hostRange);
        int startShift = Math.max(0, this.hostToInjected(hostRange.getStartOffset()) - startOffset);
        int endShift = Math.max(0, endOffset - this.hostToInjected(hostRange.getEndOffset()) - startShift);
        RangeMarkerWindow rangeMarkerWindow = new RangeMarkerWindow(this, (RangeMarkerEx)hostMarker, startShift, endShift);
        if (rangeMarkerWindow == null) {
            DocumentWindowImpl.$$$reportNull$$$0(12);
        }
        return rangeMarkerWindow;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (!surviveOnExternalChange) {
            RangeMarker rangeMarker = this.createRangeMarker(startOffset, endOffset);
            if (rangeMarker == null) {
                DocumentWindowImpl.$$$reportNull$$$0(13);
            }
            return rangeMarker;
        }
        ProperTextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeMarker hostMarker = this.myDelegate.createRangeMarker(hostRange.getStartOffset(), hostRange.getEndOffset(), surviveOnExternalChange);
        int startShift = Math.max(0, this.hostToInjected(hostRange.getStartOffset()) - startOffset);
        int endShift = Math.max(0, endOffset - this.hostToInjected(hostRange.getEndOffset()) - startShift);
        RangeMarkerWindow rangeMarkerWindow = new RangeMarkerWindow(this, (RangeMarkerEx)hostMarker, startShift, endShift);
        if (rangeMarkerWindow == null) {
            DocumentWindowImpl.$$$reportNull$$$0(14);
        }
        return rangeMarkerWindow;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(15);
        }
        this.myDelegate.addPropertyChangeListener(listener2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(16);
        }
        this.myDelegate.removePropertyChangeListener(listener2);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.myDelegate.setReadOnly(isReadOnly);
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        ProperTextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeMarker rangeMarker = this.myDelegate.createGuardedBlock(hostRange.getStartOffset(), hostRange.getEndOffset());
        if (rangeMarker == null) {
            DocumentWindowImpl.$$$reportNull$$$0(17);
        }
        return rangeMarker;
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            DocumentWindowImpl.$$$reportNull$$$0(18);
        }
        this.myDelegate.removeGuardedBlock(block);
    }

    public RangeMarker getRangeGuard(int startOffset, int endOffset) {
        ProperTextRange injRange = new ProperTextRange(startOffset, endOffset);
        TextRange editable = (TextRange)ObjectUtils.notNull((Object)this.intersectWithEditable((TextRange)injRange), (Object)TextRange.EMPTY_RANGE);
        if (!injRange.equals((Object)editable)) {
            ProperTextRange guarded = injRange.cutOut(editable.shiftLeft(editable.getStartOffset() - injRange.getStartOffset()));
            return this.createRangeMarker((TextRange)guarded);
        }
        ProperTextRange hostRange = this.injectedToHost((TextRange)injRange);
        return this.myDelegate.getRangeGuard(hostRange.getStartOffset(), hostRange.getEndOffset());
    }

    public void startGuardedBlockChecking() {
        this.myDelegate.startGuardedBlockChecking();
    }

    public void stopGuardedBlockChecking() {
        this.myDelegate.stopGuardedBlockChecking();
    }

    public void setCyclicBufferSize(int bufferSize) {
        this.myDelegate.setCyclicBufferSize(bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            DocumentWindowImpl.$$$reportNull$$$0(19);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.assertTrue(text.toString().startsWith(((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix()));
            LOG.assertTrue(text.toString().endsWith(((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getSuffix()));
            if (this.isOneLine()) {
                text = StringUtil.replace((String)text.toString(), (String)"\n", (String)"");
            }
            String[] changes = this.calculateMinEditSequence(text.toString());
            assert (changes.length == this.myShreds.size());
            for (int i = 0; i < changes.length; ++i) {
                Segment hostRange;
                String change = changes[i];
                if (change == null || (hostRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker()) == null) continue;
                this.myDelegate.replaceString(hostRange.getStartOffset(), hostRange.getEndOffset(), change);
            }
        }
    }

    public boolean isLineModified(int line) {
        return this.myDelegate.isLineModified(this.injectedToHostLine(line));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Segment[] getHostRanges() {
        Object object = this.myLock;
        // MONITORENTER : object
        ArrayList<Segment> markers = new ArrayList<Segment>(this.myShreds.size());
        Iterator iterator = this.myShreds.iterator();
        while (iterator.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
            Segment hostMarker = shred.getHostRangeMarker();
            if (hostMarker == null) continue;
            markers.add(hostMarker);
        }
        Segment[] segmentArray = markers.isEmpty() ? Segment.EMPTY_ARRAY : markers.toArray(new Segment[markers.size()]);
        // MONITOREXIT : object
        if (segmentArray != null) return segmentArray;
        DocumentWindowImpl.$$$reportNull$$$0(20);
        return segmentArray;
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            DocumentWindowImpl.$$$reportNull$$$0(21);
        }
        ProperTextRange properTextRange = new ProperTextRange(textRange);
        RangeMarker rangeMarker = this.createRangeMarker(properTextRange.getStartOffset(), properTextRange.getEndOffset());
        if (rangeMarker == null) {
            DocumentWindowImpl.$$$reportNull$$$0(22);
        }
        return rangeMarker;
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        this.myDelegate.setStripTrailingSpacesEnabled(isEnabled);
    }

    public int getLineSeparatorLength(int line) {
        return this.myDelegate.getLineSeparatorLength(this.injectedToHostLine(line));
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.myDelegate.createLineIterator();
        if (lineIterator == null) {
            DocumentWindowImpl.$$$reportNull$$$0(23);
        }
        return lineIterator;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myDelegate.setModificationStamp(modificationStamp);
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(24);
        }
        this.myDelegate.addEditReadOnlyListener(listener2);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(25);
        }
        this.myDelegate.removeEditReadOnlyListener(listener2);
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            DocumentWindowImpl.$$$reportNull$$$0(26);
        }
        this.setText(chars);
        this.myDelegate.setModificationStamp(newModificationStamp);
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myDelegate.suppressGuardedExceptions();
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myDelegate.unSuppressGuardedExceptions();
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myDelegate.isInEventsHandling();
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            DocumentWindowImpl.$$$reportNull$$$0(27);
        }
        return this.myDelegate.removeRangeMarker(((RangeMarkerWindow)rangeMarker).getDelegate());
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            DocumentWindowImpl.$$$reportNull$$$0(28);
        }
        throw new IllegalStateException();
    }

    @NotNull
    public DocumentEx getDelegate() {
        DocumentEx documentEx = this.myDelegate;
        if (documentEx == null) {
            DocumentWindowImpl.$$$reportNull$$$0(29);
        }
        return documentEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hostToInjected(int hostOffset) {
        Object object = this.myLock;
        synchronized (object) {
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
            if (hostRangeMarker == null || hostOffset < hostRangeMarker.getStartOffset()) {
                return ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix().length();
            }
            int offset = 0;
            for (int i = 0; i < this.myShreds.size(); ++i) {
                Segment nextRange;
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getPrefix().length();
                Segment currentRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker();
                if (currentRange == null) continue;
                Segment segment = nextRange = i == this.myShreds.size() - 1 ? null : ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i + 1)).getHostRangeMarker();
                if (nextRange == null || hostOffset < nextRange.getStartOffset()) {
                    if (hostOffset >= currentRange.getEndOffset()) {
                        hostOffset = currentRange.getEndOffset();
                    }
                    return offset + hostOffset - currentRange.getStartOffset();
                }
                offset += currentRange.getEndOffset() - currentRange.getStartOffset();
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix().length();
            }
            return this.getTextLength() - ((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getSuffix().length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hostToInjectedUnescaped(int hostOffset) {
        Object object = this.myLock;
        synchronized (object) {
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
            if (hostRangeMarker == null || hostOffset < hostRangeMarker.getStartOffset()) {
                return ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix().length();
            }
            int offset = 0;
            for (int i = 0; i < this.myShreds.size(); ++i) {
                Segment nextRange;
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getPrefix().length();
                Segment currentRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker();
                if (currentRange == null) continue;
                Segment segment = nextRange = i == this.myShreds.size() - 1 ? null : ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i + 1)).getHostRangeMarker();
                if (nextRange == null || hostOffset < nextRange.getStartOffset()) {
                    offset = hostOffset >= currentRange.getEndOffset() ? (offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getRange().getLength()) : (offset += hostOffset - currentRange.getStartOffset());
                    return offset;
                }
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getRange().getLength();
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix().length();
            }
            return this.getTextLength() - ((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getSuffix().length();
        }
    }

    public int injectedToHost(int offset) {
        Editor editor;
        int offsetInRightFragment;
        int offsetInLeftFragment = this.injectedToHost(offset, true);
        if (offsetInLeftFragment == (offsetInRightFragment = this.injectedToHost(offset, false))) {
            return offsetInLeftFragment;
        }
        Editor[] editors = EditorFactory.getInstance().getEditors((Document)this.getDelegate());
        Editor editor2 = editor = editors.length == 0 ? null : editors[0];
        if (editor != null) {
            int caret;
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            return Math.abs((caret = editor.getCaretModel().getOffset()) - offsetInLeftFragment) < Math.abs(caret - offsetInRightFragment) ? offsetInLeftFragment : offsetInRightFragment;
        }
        return offsetInLeftFragment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int injectedToHost(int offset, boolean preferLeftFragment) {
        Object object = this.myLock;
        synchronized (object) {
            if (offset < ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix().length()) {
                Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
                int n = hostRangeMarker == null ? 0 : hostRangeMarker.getStartOffset();
                return n;
            }
            int prevEnd = 0;
            for (int i = 0; i < this.myShreds.size(); ++i) {
                Segment currentRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker();
                if (currentRange == null) continue;
                int length = currentRange.getEndOffset() - currentRange.getStartOffset();
                if ((offset -= ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getPrefix().length()) < 0) {
                    return preferLeftFragment ? prevEnd : currentRange.getStartOffset() - 1;
                }
                if (offset == 0) {
                    return preferLeftFragment && i != 0 ? prevEnd : currentRange.getStartOffset();
                }
                if (offset < length || offset == length && preferLeftFragment) {
                    return currentRange.getStartOffset() + offset;
                }
                offset -= length;
                offset -= ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix().length();
                prevEnd = currentRange.getEndOffset();
            }
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getHostRangeMarker();
            int n = hostRangeMarker == null ? 0 : hostRangeMarker.getEndOffset();
            return n;
        }
    }

    @NotNull
    public ProperTextRange injectedToHost(@NotNull TextRange injected) {
        if (injected == null) {
            DocumentWindowImpl.$$$reportNull$$$0(30);
        }
        int start = this.injectedToHost(injected.getStartOffset(), false);
        int end = this.injectedToHost(injected.getEndOffset(), true);
        if (end < start) {
            end = this.injectedToHost(injected.getEndOffset(), false);
        }
        ProperTextRange properTextRange = new ProperTextRange(start, end);
        if (properTextRange == null) {
            DocumentWindowImpl.$$$reportNull$$$0(31);
        }
        return properTextRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int injectedToHostLine(int line) {
        if (line < this.myPrefixLineCount) {
            Object object = this.myLock;
            synchronized (object) {
                Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
                return hostRangeMarker == null ? 0 : this.myDelegate.getLineNumber(hostRangeMarker.getStartOffset());
            }
        }
        int lineCount = this.getLineCount();
        if (line > lineCount - this.mySuffixLineCount) {
            return lineCount;
        }
        int offset = this.getLineStartOffset(line);
        int hostOffset = this.injectedToHost(offset);
        return this.myDelegate.getLineNumber(hostOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsRange(int hostStart, int hostEnd) {
        Object object = this.myLock;
        synchronized (object) {
            ProperTextRange query = new ProperTextRange(hostStart, hostEnd);
            Iterator iterator = this.myShreds.iterator();
            while (iterator.hasNext()) {
                ProperTextRange textRange;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null || !(textRange = ProperTextRange.create((Segment)hostRange)).contains((TextRange)query)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nullable
    public TextRange intersectWithEditable(@NotNull TextRange rangeToEdit) {
        if (rangeToEdit == null) {
            DocumentWindowImpl.$$$reportNull$$$0(32);
        }
        int startOffset = -1;
        int endOffset = -1;
        Object object = this.myLock;
        synchronized (object) {
            int offset = 0;
            Iterator iterator = this.myShreds.iterator();
            while (iterator.hasNext()) {
                int length;
                ProperTextRange intersection;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                if ((intersection = new ProperTextRange(offset += shred.getPrefix().length(), offset + (length = hostRange.getEndOffset() - hostRange.getStartOffset())).intersection(rangeToEdit)) != null) {
                    if (startOffset == -1) {
                        startOffset = intersection.getStartOffset();
                    }
                    endOffset = intersection.getEndOffset();
                }
                offset += length;
                offset += shred.getSuffix().length();
            }
        }
        if (startOffset == -1) {
            return null;
        }
        return new ProperTextRange(startOffset, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String[] calculateMinEditSequence(String newText) {
        Object object = this.myLock;
        // MONITORENTER : object
        String[] result2 = new String[this.myShreds.size()];
        String hostText = this.myDelegate.getText();
        this.calculateMinEditSequence(hostText, newText, result2, 0, result2.length - 1);
        int i = 0;
        while (true) {
            if (i >= result2.length) {
                // MONITOREXIT : object
                if (result2 != null) return result2;
                DocumentWindowImpl.$$$reportNull$$$0(33);
                return result2;
            }
            String change = result2[i];
            if (change != null) {
                String prefix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getPrefix();
                String suffix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix();
                assert (change.startsWith(prefix)) : change + "/" + prefix;
                assert (change.endsWith(suffix)) : change + "/" + suffix;
                result2[i] = StringUtil.trimEnd((String)StringUtil.trimStart((String)change, (String)prefix), (String)suffix);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRangeText(@NotNull String hostText, int hostNum) {
        if (hostText == null) {
            DocumentWindowImpl.$$$reportNull$$$0(34);
        }
        Object object = this.myLock;
        synchronized (object) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(hostNum);
            Segment hostRangeMarker = shred.getHostRangeMarker();
            return shred.getPrefix() + (hostRangeMarker == null ? "" : hostText.substring(hostRangeMarker.getStartOffset(), hostRangeMarker.getEndOffset())) + shred.getSuffix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateMinEditSequence(String hostText, String newText, String[] result2, int i, int j) {
        Object object = this.myLock;
        synchronized (object) {
            String rangeText1 = this.getRangeText(hostText, i);
            if (i == j) {
                result2[i] = rangeText1.equals(newText) ? null : newText;
                return;
            }
            if (StringUtil.startsWith((CharSequence)newText, (CharSequence)rangeText1)) {
                result2[i] = null;
                this.calculateMinEditSequence(hostText, newText.substring(rangeText1.length()), result2, i + 1, j);
                return;
            }
            String rangeText2 = this.getRangeText(hostText, j);
            if (StringUtil.endsWith((CharSequence)newText, (CharSequence)rangeText2)) {
                result2[j] = null;
                this.calculateMinEditSequence(hostText, newText.substring(0, newText.length() - rangeText2.length()), result2, i, j - 1);
                return;
            }
            if (i + 1 == j) {
                String commonPrefix;
                String suffix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix();
                String prefix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(j)).getPrefix();
                String separator = suffix + prefix;
                if (!separator.isEmpty()) {
                    int sep = newText.indexOf(separator);
                    assert (sep != -1);
                    result2[i] = newText.substring(0, sep + suffix.length());
                    result2[j] = newText.substring(sep + suffix.length() + prefix.length(), newText.length());
                    return;
                }
                result2[i] = commonPrefix = StringUtil.commonPrefix((String)rangeText1, (String)newText);
                result2[j] = newText.substring(commonPrefix.length());
                return;
            }
            String middleText = this.getRangeText(hostText, i + 1);
            int m = newText.indexOf(middleText);
            if (m != -1) {
                result2[i] = newText.substring(0, m);
                result2[i + 1] = null;
                this.calculateMinEditSequence(hostText, newText.substring(m + middleText.length(), newText.length()), result2, i + 2, j);
                return;
            }
            middleText = this.getRangeText(hostText, j - 1);
            m = newText.lastIndexOf(middleText);
            if (m != -1) {
                result2[j] = newText.substring(m + middleText.length());
                result2[j - 1] = null;
                this.calculateMinEditSequence(hostText, newText.substring(0, m), result2, i, j - 2);
                return;
            }
            result2[i] = "";
            result2[j] = "";
            this.calculateMinEditSequence(hostText, newText, result2, i + 1, j - 1);
        }
    }

    public boolean areRangesEqual(@NotNull DocumentWindow otherd) {
        if (otherd == null) {
            DocumentWindowImpl.$$$reportNull$$$0(35);
        }
        DocumentWindowImpl window = (DocumentWindowImpl)otherd;
        Place shreds = this.getShreds();
        Place otherShreds = window.getShreds();
        if (shreds.size() != otherShreds.size()) {
            return false;
        }
        for (int i = 0; i < shreds.size(); ++i) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(i);
            PsiLanguageInjectionHost.Shred otherShred = (PsiLanguageInjectionHost.Shred)otherShreds.get(i);
            if (!shred.getPrefix().equals(otherShred.getPrefix())) {
                return false;
            }
            if (!shred.getSuffix().equals(otherShred.getSuffix())) {
                return false;
            }
            Segment hostRange = shred.getHostRangeMarker();
            Segment other = otherShred.getHostRangeMarker();
            if (hostRange != null && other != null && TextRange.areSegmentsEqual((Segment)hostRange, (Segment)other)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        PsiLanguageInjectionHost.Shred[] shredArray = this.myLock;
        synchronized (this.myLock) {
            PsiLanguageInjectionHost.Shred[] shreds = (PsiLanguageInjectionHost.Shred[])this.myShreds.toArray(new PsiLanguageInjectionHost.Shred[this.myShreds.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (PsiLanguageInjectionHost.Shred shred : shreds) {
                if (shred.isValid()) continue;
                return false;
            }
            return true;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DocumentWindowImpl)) {
            return false;
        }
        DocumentWindowImpl window = (DocumentWindowImpl)o;
        return this.myDelegate.equals(window.getDelegate()) && this.areRangesEqual(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.myLock;
        synchronized (object) {
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
            return hostRangeMarker == null ? -1 : hostRangeMarker.getStartOffset();
        }
    }

    public boolean isOneLine() {
        return this.myOneLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myShreds.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShreds(@NotNull Place shreds) {
        if (shreds == null) {
            DocumentWindowImpl.$$$reportNull$$$0(36);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myShreds.dispose();
            this.myShreds = shreds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Place getShreds() {
        Object object = this.myLock;
        // MONITORENTER : object
        Place place = this.myShreds;
        // MONITOREXIT : object
        if (place != null) return place;
        DocumentWindowImpl.$$$reportNull$$$0(37);
        return place;
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor2) {
        if (processor2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(38);
        }
        return this.myDelegate.processRangeMarkers(processor2);
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor2) {
        if (processor2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(39);
        }
        return this.myDelegate.processRangeMarkersOverlappingWith(start, end, processor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shreds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hPos";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/DocumentWindowImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injected";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToEdit";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostText";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherd";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/DocumentWindowImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableCharSequence";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMarker";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuardedBlock";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostRanges";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineIterator";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "injectedToHost";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMinEditSequence";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getShreds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hostToInjectedInVirtualSpace";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 37: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceString";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeGuardedBlock";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createRangeMarker";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addEditReadOnlyListener";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeEditReadOnlyListener";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeRangeMarker";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "registerRangeMarker";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "injectedToHost";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "intersectWithEditable";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRangeText";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "areRangesEqual";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setShreds";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkers";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkersOverlappingWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedText {
        private final String text;
        private final long modificationStamp;

        private CachedText(@NotNull String text, long modificationStamp) {
            if (text == null) {
                CachedText.$$$reportNull$$$0(0);
            }
            this.text = text;
            this.modificationStamp = modificationStamp;
        }

        @NotNull
        private String getText() {
            String string = this.text;
            if (string == null) {
                CachedText.$$$reportNull$$$0(1);
            }
            return string;
        }

        private long getModificationStamp() {
            return this.modificationStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/DocumentWindowImpl$CachedText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/DocumentWindowImpl$CachedText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

