/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.listeners.RefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.RefactoringListenerManagerImpl;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.ui.GuiUtils;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UnknownUsagesInUnloadedModules;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRefactoringProcessor
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.BaseRefactoringProcessor");
    private static boolean PREVIEW_IN_TESTS = true;
    @NotNull
    protected final Project myProject;
    private RefactoringTransaction myTransaction;
    private boolean myIsPreviewUsages;
    protected Runnable myPrepareSuccessfulSwingThreadCallback;

    protected BaseRefactoringProcessor(@NotNull Project project) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    protected BaseRefactoringProcessor(@NotNull Project project, @Nullable Runnable prepareSuccessfulCallback) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(1);
        }
        this.myPrepareSuccessfulSwingThreadCallback = EmptyRunnable.INSTANCE;
        this.myProject = project;
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulCallback;
    }

    @NotNull
    protected abstract UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] var1);

    @NotNull
    protected abstract UsageInfo[] findUsages();

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(2);
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(3);
        }
        this.prepareSuccessful();
        return true;
    }

    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(4);
        }
        return this.myIsPreviewUsages;
    }

    protected boolean isPreviewUsages() {
        return this.myIsPreviewUsages;
    }

    private Set<UnloadedModuleDescription> computeUnloadedModulesFromUseScope(UsageViewDescriptor descriptor) {
        if (ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescriptions().isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<UnloadedModuleDescription> unloadedModulesInUseScope = new LinkedHashSet<UnloadedModuleDescription>();
        for (PsiElement element : descriptor.getElements()) {
            SearchScope useScope = element.getUseScope();
            if (!(useScope instanceof GlobalSearchScope)) continue;
            unloadedModulesInUseScope.addAll(((GlobalSearchScope)useScope).getUnloadedModulesBelongingToScope());
        }
        return unloadedModulesInUseScope;
    }

    public void setPreviewUsages(boolean isPreviewUsages) {
        this.myIsPreviewUsages = isPreviewUsages;
    }

    public void setPrepareSuccessfulSwingThreadCallback(Runnable prepareSuccessfulSwingThreadCallback) {
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulSwingThreadCallback;
    }

    protected RefactoringTransaction getTransaction() {
        return this.myTransaction;
    }

    protected abstract void performRefactoring(@NotNull UsageInfo[] var1);

    @NotNull
    protected abstract String getCommandName();

    protected void doRun() {
        boolean isPreview;
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        Ref refUsages = new Ref();
        Ref refErrorLanguage = new Ref();
        Ref refProcessCanceled = new Ref();
        Ref anyException = new Ref();
        Runnable findUsagesRunnable = () -> {
            try {
                refUsages.set(DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(this::findUsages));
            }
            catch (UnknownReferenceTypeException e) {
                refErrorLanguage.set((Object)e.getElementLanguage());
            }
            catch (ProcessCanceledException e) {
                refProcessCanceled.set((Object)Boolean.TRUE);
            }
            catch (Throwable e) {
                anyException.set((Object)Boolean.TRUE);
                LOG.error(e);
            }
        };
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(findUsagesRunnable, RefactoringBundle.message((String)"progress.text"), true, this.myProject)) {
            return;
        }
        if (!refErrorLanguage.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"unsupported.refs.found", (Object[])new Object[]{((Language)refErrorLanguage.get()).getDisplayName()}), (String)RefactoringBundle.message((String)"error.title"));
            return;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            DumbService.getInstance((Project)this.myProject).showDumbModeNotification("Refactoring is not available until indices are ready");
            return;
        }
        if (!refProcessCanceled.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)"Index corruption detected. Please retry the refactoring - indexes will be rebuilt automatically", (String)RefactoringBundle.message((String)"error.title"));
            return;
        }
        if (!anyException.isNull()) {
            return;
        }
        assert (!refUsages.isNull()) : "Null usages from processor " + this;
        if (!this.preprocessUsages((Ref<UsageInfo[]>)refUsages)) {
            return;
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        assert (usages != null);
        UsageViewDescriptor descriptor = this.createUsageViewDescriptor(usages);
        boolean bl = isPreview = this.isPreviewUsages(usages) || !this.computeUnloadedModulesFromUseScope(descriptor).isEmpty();
        if (!isPreview) {
            boolean bl2 = isPreview = !this.ensureElementsWritable(usages, descriptor) || UsageViewUtil.hasReadOnlyUsages(usages);
            if (isPreview) {
                StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"readonly.occurences.found"));
            }
        }
        if (isPreview) {
            for (UsageInfo usage : usages) {
                LOG.assertTrue(usage != null, this.getClass());
            }
            this.previewRefactoring(usages);
        } else {
            this.execute(usages);
        }
    }

    public static <T extends Throwable> void runWithDisabledPreview(ThrowableRunnable<T> runnable2) throws T {
        PREVIEW_IN_TESTS = false;
        try {
            runnable2.run();
        }
        finally {
            PREVIEW_IN_TESTS = true;
        }
    }

    protected void previewRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!PREVIEW_IN_TESTS) {
                throw new RuntimeException("Unexpected preview in tests: " + StringUtil.join((Object[])usages, UsageInfo::toString, (String)", "));
            }
            this.ensureElementsWritable(usages, this.createUsageViewDescriptor(usages));
            this.execute(usages);
            return;
        }
        UsageViewDescriptor viewDescriptor = this.createUsageViewDescriptor(usages);
        final PsiElement[] elements = viewDescriptor.getElements();
        final PsiElement2UsageTargetAdapter[] targets = PsiElement2UsageTargetAdapter.convert(elements);
        Factory factory = () -> new UsageInfoSearcherAdapter(){

            public void generate(@NotNull Processor<Usage> processor2) {
                if (processor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (int i = 0; i < elements.length; ++i) {
                        elements2[i] = targets[i].getElement();
                    }
                    BaseRefactoringProcessor.this.refreshElements(elements);
                });
                this.processUsages(processor2, BaseRefactoringProcessor.this.myProject);
            }

            @NotNull
            protected UsageInfo[] findUsages() {
                UsageInfo[] usageInfoArray = BaseRefactoringProcessor.this.findUsages();
                if (usageInfoArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return usageInfoArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findUsages";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "generate";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.showUsageView(viewDescriptor, (Factory<UsageSearcher>)factory, usages);
    }

    protected boolean skipNonCodeUsages() {
        return false;
    }

    private boolean ensureElementsWritable(@NotNull UsageInfo[] usages, @NotNull UsageViewDescriptor descriptor) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(7);
        }
        THashSet elements = ContainerUtil.newIdentityTroveSet();
        for (UsageInfo usage : usages) {
            PsiElement element;
            assert (usage != null) : "Found null element in usages array";
            if (this.skipNonCodeUsages() && usage.isNonCodeUsage() || (element = usage.getElement()) == null) continue;
            elements.add(element);
        }
        elements.addAll(this.getElementsToWrite(descriptor));
        return BaseRefactoringProcessor.ensureFilesWritable(this.myProject, (Collection<? extends PsiElement>)elements);
    }

    private static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(8);
        }
        if (elements == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(9);
        }
        PsiElement[] psiElements = PsiUtilCore.toPsiElementArray(elements);
        return CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement[])psiElements);
    }

    protected void execute(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(10);
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (usages == null) {
                BaseRefactoringProcessor.$$$reportNull$$$0(39);
            }
            LinkedHashSet<UsageInfo> usageInfos = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
            this.doRefactoring(usageInfos);
            if (this.isGlobalUndoAction()) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
            }
        }, this.getCommandName(), null, this.getUndoConfirmationPolicy());
    }

    protected boolean isGlobalUndoAction() {
        return CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext()) == null;
    }

    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
        if (undoConfirmationPolicy == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(11);
        }
        return undoConfirmationPolicy;
    }

    @NotNull
    private static UsageViewPresentation createPresentation(@NotNull UsageViewDescriptor descriptor, @NotNull Usage[] usages) {
        if (descriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(12);
        }
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(13);
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText(RefactoringBundle.message((String)"usageView.tabText"));
        presentation.setTargetsNodeText(descriptor.getProcessedElementsHeader());
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        int codeUsageCount = 0;
        int nonCodeUsageCount = 0;
        int dynamicUsagesCount = 0;
        HashSet codeFiles = new HashSet();
        HashSet nonCodeFiles = new HashSet();
        HashSet dynamicUsagesCodeFiles = new HashSet();
        for (Usage usage : usages) {
            UsageInfo usageInfo;
            PsiElementUsage elementUsage;
            PsiElement element;
            if (!(usage instanceof PsiElementUsage) || (element = (elementUsage = (PsiElementUsage)usage).getElement()) == null) continue;
            PsiFile containingFile = element.getContainingFile();
            if (elementUsage.isNonCodeUsage()) {
                ++nonCodeUsageCount;
                nonCodeFiles.add(containingFile);
            } else {
                ++codeUsageCount;
                codeFiles.add(containingFile);
            }
            if (!(usage instanceof UsageInfo2UsageAdapter) || !((usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo()) instanceof MoveRenameUsageInfo) || !usageInfo.isDynamicUsage()) continue;
            ++dynamicUsagesCount;
            dynamicUsagesCodeFiles.add(containingFile);
        }
        codeFiles.remove(null);
        nonCodeFiles.remove(null);
        dynamicUsagesCodeFiles.remove(null);
        String codeReferencesText = descriptor.getCodeReferencesText(codeUsageCount, codeFiles.size());
        presentation.setCodeUsagesString(codeReferencesText);
        String commentReferencesText = descriptor.getCommentReferencesText(nonCodeUsageCount, nonCodeFiles.size());
        if (commentReferencesText != null) {
            presentation.setNonCodeUsagesString(commentReferencesText);
        }
        presentation.setDynamicUsagesString("Dynamic " + StringUtil.decapitalize((String)descriptor.getCodeReferencesText(dynamicUsagesCount, dynamicUsagesCodeFiles.size())));
        String generatedCodeString = codeReferencesText.contains("in code") ? StringUtil.replace((String)codeReferencesText, (String)"in code", (String)"in generated code") : codeReferencesText + " in generated code";
        presentation.setUsagesInGeneratedCodeString(generatedCodeString);
        UsageViewPresentation usageViewPresentation = presentation;
        if (usageViewPresentation == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(14);
        }
        return usageViewPresentation;
    }

    private void showUsageView(@NotNull UsageViewDescriptor viewDescriptor, Factory<UsageSearcher> factory, @NotNull UsageInfo[] usageInfos) {
        if (viewDescriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(15);
        }
        if (usageInfos == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(16);
        }
        UsageViewManager viewManager = UsageViewManager.getInstance((Project)this.myProject);
        PsiElement[] initialElements = viewDescriptor.getElements();
        PsiElement2UsageTargetAdapter[] targets = PsiElement2UsageTargetAdapter.convert(initialElements);
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (usageInfos == null) {
                BaseRefactoringProcessor.$$$reportNull$$$0(37);
            }
            ApplicationManager.getApplication().runReadAction(() -> {
                if (usageInfos == null) {
                    BaseRefactoringProcessor.$$$reportNull$$$0(38);
                }
                convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos));
            });
        }, "Preprocess usages", true, this.myProject)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = BaseRefactoringProcessor.createPresentation(viewDescriptor, usages);
        UsageView usageView = viewManager.showUsages((UsageTarget[])targets, usages, presentation, factory);
        Set<UnloadedModuleDescription> unloadedModules = this.computeUnloadedModulesFromUseScope(viewDescriptor);
        if (!unloadedModules.isEmpty()) {
            usageView.appendUsage((Usage)new UnknownUsagesInUnloadedModules(unloadedModules));
        }
        this.customizeUsagesView(viewDescriptor, usageView);
    }

    protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
        if (viewDescriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(17);
        }
        if (usageView == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(18);
        }
        Runnable refactoringRunnable = () -> {
            if (usageView == null) {
                BaseRefactoringProcessor.$$$reportNull$$$0(34);
            }
            if (viewDescriptor == null) {
                BaseRefactoringProcessor.$$$reportNull$$$0(35);
            }
            Set<UsageInfo> usagesToRefactor = UsageViewUtil.getNotExcludedUsageInfos(usageView);
            UsageInfo[] infos = usagesToRefactor.toArray(new UsageInfo[usagesToRefactor.size()]);
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                if (viewDescriptor == null) {
                    BaseRefactoringProcessor.$$$reportNull$$$0(36);
                }
                if (this.ensureElementsWritable(infos, viewDescriptor)) {
                    this.execute(infos);
                }
            });
        };
        String canNotMakeString = RefactoringBundle.message((String)"usageView.need.reRun");
        this.addDoRefactoringAction(usageView, refactoringRunnable, canNotMakeString);
    }

    private void addDoRefactoringAction(@NotNull UsageView usageView, @NotNull Runnable refactoringRunnable, @NotNull String canNotMakeString) {
        if (usageView == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(19);
        }
        if (refactoringRunnable == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(20);
        }
        if (canNotMakeString == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(21);
        }
        usageView.addPerformOperationAction(refactoringRunnable, this.getCommandName(), canNotMakeString, RefactoringBundle.message((String)"usageView.doAction"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefactoring(@NotNull Collection<UsageInfo> usageInfoSet) {
        if (usageInfoSet == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(22);
        }
        Iterator<UsageInfo> iterator = usageInfoSet.iterator();
        while (iterator.hasNext()) {
            UsageInfo usageInfo = iterator.next();
            PsiElement element = usageInfo.getElement();
            if (element != null && this.isToBeChanged(usageInfo)) continue;
            iterator.remove();
        }
        String commandName = this.getCommandName();
        LocalHistoryAction action = LocalHistory.getInstance().startAction(commandName);
        UsageInfo[] writableUsageInfos = usageInfoSet.toArray(new UsageInfo[usageInfoSet.size()]);
        try {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            RefactoringListenerManagerImpl listenerManager = (RefactoringListenerManagerImpl)RefactoringListenerManager.getInstance((Project)this.myProject);
            this.myTransaction = listenerManager.startTransaction();
            LinkedHashMap preparedData = new LinkedHashMap();
            Runnable prepareHelpersRunnable = () -> {
                for (RefactoringHelper helper : (RefactoringHelper[])Extensions.getExtensions(RefactoringHelper.EP_NAME)) {
                    Object operation = ReadAction.compute(() -> helper.prepareOperation(writableUsageInfos));
                    preparedData.put(helper, operation);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(prepareHelpersRunnable, "Prepare ...", false, this.myProject);
            Runnable performRefactoringRunnable = () -> {
                String refactoringId;
                if (usageInfoSet == null) {
                    BaseRefactoringProcessor.$$$reportNull$$$0(33);
                }
                if ((refactoringId = this.getRefactoringId()) != null) {
                    RefactoringEventData data = this.getBeforeData();
                    if (data != null) {
                        data.addUsages(usageInfoSet);
                    }
                    ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(refactoringId, data);
                }
                try {
                    if (refactoringId != null) {
                        UndoRefactoringAction action1 = new UndoRefactoringAction(this.myProject, refactoringId);
                        UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action1);
                    }
                    this.performRefactoring(writableUsageInfos);
                }
                finally {
                    if (refactoringId != null) {
                        ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, this.getAfterData(writableUsageInfos));
                    }
                }
            };
            ApplicationImpl app = (ApplicationImpl)ApplicationManagerEx.getApplicationEx();
            if (Registry.is((String)"run.refactorings.under.progress")) {
                app.runWriteActionWithNonCancellableProgressInDispatchThread(commandName, this.myProject, null, (Consumer<ProgressIndicator>)((Consumer)indicator -> performRefactoringRunnable.run()));
            } else {
                app.runWriteAction(performRefactoringRunnable);
            }
            DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
            for (Map.Entry e : preparedData.entrySet()) {
                ((RefactoringHelper)e.getKey()).performOperation(this.myProject, e.getValue());
            }
            this.myTransaction.commit();
            if (Registry.is((String)"run.refactorings.under.progress")) {
                app.runWriteActionWithNonCancellableProgressInDispatchThread(commandName, this.myProject, null, (Consumer<ProgressIndicator>)((Consumer)indicator -> this.performPsiSpoilingRefactoring()));
            } else {
                app.runWriteAction(this::performPsiSpoilingRefactoring);
            }
        }
        finally {
            action.finish();
        }
        int count = writableUsageInfos.length;
        if (count > 0) {
            StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"statusBar.refactoring.result", (Object[])new Object[]{count}));
        } else if (!this.isPreviewUsages(writableUsageInfos)) {
            StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"statusBar.noUsages"));
        }
    }

    protected boolean isToBeChanged(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(23);
        }
        return usageInfo.isWritable();
    }

    protected void performPsiSpoilingRefactoring() {
    }

    protected void prepareSuccessful() {
        if (this.myPrepareSuccessfulSwingThreadCallback != null) {
            try {
                GuiUtils.runOrInvokeAndWait((Runnable)this.myPrepareSuccessfulSwingThreadCallback);
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public final void run() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.doRun();
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            LOG.error("Refactorings should not be started inside write action\n because they start progress inside and any read action from the progress task would cause the deadlock", (Throwable)new Exception());
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(this::doRun);
        } else {
            this.doRun();
        }
    }

    @Deprecated
    protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(24);
        }
        return this.showConflicts(conflicts, null);
    }

    protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, @Nullable UsageInfo[] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(25);
        }
        if (!conflicts.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            if (!ConflictsInTestsException.isTestIgnore()) {
                throw new ConflictsInTestsException(conflicts.values());
            }
            return true;
        }
        if (this.myPrepareSuccessfulSwingThreadCallback != null && !conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog;
            String refactoringId = this.getRefactoringId();
            if (refactoringId != null) {
                RefactoringEventData conflictUsages = new RefactoringEventData();
                conflictUsages.putUserData(RefactoringEventData.CONFLICTS_KEY, (Object)conflicts.values());
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).conflictsDetected(refactoringId, conflictUsages);
            }
            if (!(conflictsDialog = this.prepareConflictsDialog(conflicts, usages)).showAndGet()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    @NotNull
    protected ConflictsDialog prepareConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, @Nullable UsageInfo[] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(26);
        }
        ConflictsDialog conflictsDialog = this.createConflictsDialog(conflicts, usages);
        conflictsDialog.setCommandName(this.getCommandName());
        ConflictsDialog conflictsDialog2 = conflictsDialog;
        if (conflictsDialog2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(27);
        }
        return conflictsDialog2;
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        return null;
    }

    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(28);
        }
        return null;
    }

    @Nullable
    protected String getRefactoringId() {
        return null;
    }

    @NotNull
    protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, @Nullable UsageInfo[] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(29);
        }
        ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts, usages == null ? null : () -> this.execute(usages), false, true);
        if (conflictsDialog == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(30);
        }
        return conflictsDialog;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(31);
        }
        List<PsiElement> list2 = Arrays.asList(descriptor.getElements());
        if (list2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(32);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: 
            case 27: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: 
            case 27: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 28: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 7: 
            case 12: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: 
            case 14: 
            case 27: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor";
                break;
            }
            case 15: 
            case 17: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewDescriptor";
                break;
            }
            case 16: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 18: 
            case 19: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringRunnable";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canNotMakeString";
                break;
            }
            case 22: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfoSet";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoConfirmationPolicy";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareConflictsDialog";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createConflictsDialog";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "previewRefactoring";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ensureElementsWritable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 11: 
            case 14: 
            case 27: 
            case 30: 
            case 32: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showUsageView";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "customizeUsagesView";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addDoRefactoringAction";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isToBeChanged";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showConflicts";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "prepareConflictsDialog";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createConflictsDialog";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doRefactoring$9";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$customizeUsagesView$6";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showUsageView$4";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 14: 
            case 27: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UndoRefactoringAction
    extends BasicUndoableAction {
        private final Project myProject;
        private final String myRefactoringId;

        UndoRefactoringAction(@NotNull Project project, @NotNull String refactoringId) {
            if (project == null) {
                UndoRefactoringAction.$$$reportNull$$$0(0);
            }
            if (refactoringId == null) {
                UndoRefactoringAction.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myRefactoringId = refactoringId;
        }

        public void undo() {
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).undoRefactoring(this.myRefactoringId);
        }

        public void redo() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refactoringId";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/BaseRefactoringProcessor$UndoRefactoringAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UnknownReferenceTypeException
    extends RuntimeException {
        private final Language myElementLanguage;

        public UnknownReferenceTypeException(@NotNull Language elementLanguage) {
            if (elementLanguage == null) {
                UnknownReferenceTypeException.$$$reportNull$$$0(0);
            }
            this.myElementLanguage = elementLanguage;
        }

        @NotNull
        Language getElementLanguage() {
            Language language = this.myElementLanguage;
            if (language == null) {
                UnknownReferenceTypeException.$$$reportNull$$$0(1);
            }
            return language;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementLanguage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$UnknownReferenceTypeException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$UnknownReferenceTypeException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ConflictsInTestsException
    extends RuntimeException {
        private final Collection<? extends String> messages;
        private static boolean myTestIgnore;

        public ConflictsInTestsException(@NotNull Collection<? extends String> messages) {
            if (messages == null) {
                ConflictsInTestsException.$$$reportNull$$$0(0);
            }
            this.messages = messages;
        }

        public static void setTestIgnore(boolean myIgnore) {
            myTestIgnore = myIgnore;
        }

        public static boolean isTestIgnore() {
            return myTestIgnore;
        }

        public static <T extends Throwable> void withIgnoredConflicts(ThrowableRunnable<T> r) throws T {
            try {
                myTestIgnore = true;
                r.run();
            }
            finally {
                myTestIgnore = false;
            }
        }

        @NotNull
        public Collection<String> getMessages() {
            ArrayList<String> result2 = new ArrayList<String>(this.messages);
            for (int i = 0; i < this.messages.size(); ++i) {
                result2.set(i, ((String)result2.get(i)).replaceAll("<[^>]+>", ""));
            }
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                ConflictsInTestsException.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        @Override
        public String getMessage() {
            ArrayList<? extends String> result2 = new ArrayList<String>(this.messages);
            Collections.sort(result2);
            return StringUtil.join(result2, (String)"\n");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messages";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$ConflictsInTestsException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$ConflictsInTestsException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

