/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.panel;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.ui.panel.GridBagPanelBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class ComponentPanelBuilderImpl
implements ComponentPanelBuilder,
GridBagPanelBuilder {
    private final JComponent myComponent;
    private String myLabelText;
    private boolean myLabelOnTop;
    private String myComment;
    private boolean myCommentBelow = true;
    private String myHTDescription;
    private String myHTLinkText;
    private Runnable myHTAction;
    private boolean valid = true;

    ComponentPanelBuilderImpl(JComponent component) {
        this.myComponent = component;
    }

    public ComponentPanelBuilder withLabel(@NotNull String labelText) {
        if (labelText == null) {
            ComponentPanelBuilderImpl.$$$reportNull$$$0(0);
        }
        this.myLabelText = labelText;
        return this;
    }

    public ComponentPanelBuilder moveLabelOnTop() {
        this.myLabelOnTop = true;
        return this;
    }

    public ComponentPanelBuilder withComment(@NotNull String comment) {
        if (comment == null) {
            ComponentPanelBuilderImpl.$$$reportNull$$$0(1);
        }
        this.myComment = comment;
        this.valid = StringUtil.isNotEmpty((String)comment) && StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    public ComponentPanelBuilder moveCommentRight() {
        this.myCommentBelow = false;
        return this;
    }

    public ComponentPanelBuilder withTooltip(@NotNull String description) {
        if (description == null) {
            ComponentPanelBuilderImpl.$$$reportNull$$$0(2);
        }
        this.myHTDescription = description;
        this.valid = StringUtil.isNotEmpty((String)description) && StringUtil.isEmpty((String)this.myComment);
        return this;
    }

    public ComponentPanelBuilder withTooltipLink(@NotNull String linkText, @NotNull Runnable action) {
        if (linkText == null) {
            ComponentPanelBuilderImpl.$$$reportNull$$$0(3);
        }
        if (action == null) {
            ComponentPanelBuilderImpl.$$$reportNull$$$0(4);
        }
        this.myHTLinkText = linkText;
        this.myHTAction = action;
        return this;
    }

    @NotNull
    public JPanel createPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, null, 0, 0);
        this.addToPanel(panel2, gc);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ComponentPanelBuilderImpl.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public boolean constrainsValid() {
        return this.valid;
    }

    public int gridWidth() {
        return 2;
    }

    public void addToPanel(JPanel panel2, GridBagConstraints gc) {
        if (!this.constrainsValid()) {
            return;
        }
        gc.gridx = 0;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gc.anchor = 21;
        if (StringUtil.isNotEmpty((String)this.myLabelText)) {
            JLabel lbl = new JLabel();
            LabeledComponent.TextWithMnemonic.fromTextWithMnemonic((String)this.myLabelText).setToLabel(lbl);
            lbl.setLabelFor(this.myComponent);
            if (this.myLabelOnTop) {
                gc.insets = JBUI.insetsBottom((int)4);
                panel2.add((Component)lbl, gc);
                ++gc.gridy;
            } else {
                gc.insets = JBUI.insetsRight((int)8);
                panel2.add((Component)lbl, gc);
            }
        }
        gc.gridx = ++gc.gridx + (this.myLabelOnTop ? 0 : 1);
        gc.weightx = 1.0;
        gc.insets = JBUI.emptyInsets();
        JPanel componentPanel = new JPanel();
        componentPanel.setLayout(new BoxLayout(componentPanel, 0));
        componentPanel.add(this.myComponent);
        JLabel comment = null;
        if (StringUtil.isNotEmpty((String)this.myComment)) {
            comment = new JLabel(this.myComment);
            comment.setForeground((Color)Gray.x78);
            if (SystemInfo.isMac) {
                Font font = comment.getFont();
                float size = font.getSize2D();
                Font smallFont = font.deriveFont(size - 2.0f);
                comment.setFont(smallFont);
            }
        }
        if (StringUtil.isNotEmpty((String)this.myHTDescription)) {
            ContextHelpLabel lbl = StringUtil.isNotEmpty((String)this.myHTLinkText) && this.myHTAction != null ? ContextHelpLabel.createWithLink(null, this.myHTDescription, this.myHTLinkText, this.myHTAction) : ContextHelpLabel.create(this.myHTDescription);
            componentPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)7, (int)0)));
            componentPanel.add((Component)((Object)lbl));
        } else if (comment != null && !this.myCommentBelow) {
            componentPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)14, (int)0)));
            componentPanel.add(comment);
        }
        panel2.add((Component)componentPanel, gc);
        if (comment != null && this.myCommentBelow) {
            gc.gridx = 1;
            ++gc.gridy;
            gc.weightx = 0.0;
            gc.anchor = 18;
            gc.insets = this.getCommentInsets();
            panel2.add((Component)comment, gc);
        }
        ++gc.gridy;
    }

    private Insets getCommentInsets() {
        if (this.myComponent instanceof JRadioButton || this.myComponent instanceof JCheckBox) {
            return JBUI.insets((int)0, (int)24, (int)0, (int)0);
        }
        if (this.myComponent instanceof JTextField || this.myComponent instanceof EditorTextField || this.myComponent instanceof JComboBox || this.myComponent instanceof ComponentWithBrowseButton) {
            return JBUI.insets((int)2, (int)6, (int)0, (int)0);
        }
        if (this.myComponent instanceof JButton) {
            return JBUI.insets((int)0, (int)8, (int)0, (int)0);
        }
        return JBUI.insetsTop((int)9);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/panel/ComponentPanelBuilderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/panel/ComponentPanelBuilderImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withLabel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withComment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withTooltip";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withTooltipLink";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

