/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.SnapshotVisiblePackBuilder;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisiblePackRefresherImpl
implements VisiblePackRefresher,
Disposable {
    private static final Logger LOG = Logger.getInstance(VisiblePackRefresherImpl.class);
    @NotNull
    private final SingleTaskController<Request, State> myTaskController;
    @NotNull
    private final VcsLogFilterer myVisiblePackBuilder;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogIndex.IndexingFinishedListener myIndexingFinishedListener;
    @NotNull
    private final List<VisiblePackChangeListener> myVisiblePackChangeListeners;
    @NotNull
    private volatile State myState;

    public VisiblePackRefresherImpl(final @NotNull Project project, @NotNull VcsLogData logData, @NotNull PermanentGraph.SortType initialSortType, @NotNull VcsLogFilterer builder) {
        if (project == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(1);
        }
        if (initialSortType == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(3);
        }
        this.myVisiblePackChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLogData = logData;
        this.myVisiblePackBuilder = builder;
        this.myState = new State(initialSortType);
        this.myTaskController = new SingleTaskController<Request, State>(project, state -> {
            boolean hasChanges = this.myState.getVisiblePack() != state.getVisiblePack();
            this.myState = state;
            if (hasChanges) {
                for (VisiblePackChangeListener listener2 : this.myVisiblePackChangeListeners) {
                    listener2.onVisiblePackChange(state.getVisiblePack());
                }
            }
        }, true, (Disposable)this){

            @Override
            @NotNull
            protected ProgressIndicator startNewBackgroundTask() {
                ProgressIndicator indicator = VisiblePackRefresherImpl.this.myLogData.getProgress().createProgressIndicator();
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    MyTask task = new MyTask(project, "Applying filters...");
                    ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, indicator);
                });
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return progressIndicator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startNewBackgroundTask";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$startNewBackgroundTask$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myIndexingFinishedListener = root -> this.myTaskController.request(new IndexingFinishedRequest(root));
        this.myLogData.getIndex().addListener(this.myIndexingFinishedListener);
    }

    @Override
    public void addVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        if (listener2 == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(4);
        }
        this.myVisiblePackChangeListeners.add(listener2);
    }

    @Override
    public void removeVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        if (listener2 == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(5);
        }
        this.myVisiblePackChangeListeners.remove(listener2);
    }

    @Override
    public void onRefresh() {
        this.myTaskController.request(new RefreshRequest());
    }

    @Override
    public void setValid(boolean validate) {
        this.myTaskController.request(new ValidateRequest(validate));
    }

    @Override
    public void onFiltersChange(@NotNull VcsLogFilterCollection newFilters) {
        if (newFilters == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(6);
        }
        this.myTaskController.request(new FilterRequest(newFilters));
    }

    @Override
    public void onSortTypeChange(@NotNull PermanentGraph.SortType sortType) {
        if (sortType == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(7);
        }
        this.myTaskController.request(new SortTypeRequest(sortType));
    }

    @Override
    public void moreCommitsNeeded(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(8);
        }
        this.myTaskController.request(new MoreCommitsRequest(onLoaded));
    }

    @Override
    public boolean isValid() {
        return this.myState.isValid();
    }

    public void dispose() {
        this.myLogData.getIndex().removeListener(this.myIndexingFinishedListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSortType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onLoaded";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addVisiblePackChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeVisiblePackChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onFiltersChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onSortTypeChange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "moreCommitsNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class IndexingFinishedRequest
    implements Request {
        @NotNull
        private final VirtualFile root;

        IndexingFinishedRequest(@NotNull VirtualFile root) {
            if (root == null) {
                IndexingFinishedRequest.$$$reportNull$$$0(0);
            }
            this.root = root;
        }

        @NotNull
        public VirtualFile getRoot() {
            VirtualFile virtualFile = this.root;
            if (virtualFile == null) {
                IndexingFinishedRequest.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        public String toString() {
            return "IndexingFinishedRequest for " + this.root;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$IndexingFinishedRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$IndexingFinishedRequest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MoreCommitsRequest
    implements Request {
        @NotNull
        private final Runnable onLoaded;

        MoreCommitsRequest(@NotNull Runnable onLoaded) {
            if (onLoaded == null) {
                MoreCommitsRequest.$$$reportNull$$$0(0);
            }
            this.onLoaded = onLoaded;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoaded", "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$MoreCommitsRequest", "<init>"));
        }
    }

    private static final class SortTypeRequest
    implements Request {
        private final PermanentGraph.SortType sortType;

        SortTypeRequest(PermanentGraph.SortType sortType) {
            this.sortType = sortType;
        }

        public String toString() {
            return "SortTypeRequest " + this.sortType;
        }
    }

    private static final class FilterRequest
    implements Request {
        private final VcsLogFilterCollection filters;

        FilterRequest(VcsLogFilterCollection filters) {
            this.filters = filters;
        }

        public String toString() {
            return "FilterRequest by " + this.filters;
        }
    }

    private static final class ValidateRequest
    implements Request {
        private final boolean validate;

        private ValidateRequest(boolean validate) {
            this.validate = validate;
        }

        public String toString() {
            return "ValidateRequest " + this.validate;
        }
    }

    private static final class RefreshRequest
    implements Request {
        private RefreshRequest() {
        }

        public String toString() {
            return "RefreshRequest";
        }
    }

    private static interface Request {
    }

    private static class State {
        @NotNull
        private final VcsLogFilterCollection myFilters;
        @NotNull
        private final PermanentGraph.SortType mySortType;
        @NotNull
        private final CommitCountStage myCommitCount;
        @NotNull
        private final List<MoreCommitsRequest> myRequestsToRun;
        @NotNull
        private final VisiblePack myVisiblePack;
        private final boolean myIsValid;

        public State(@NotNull PermanentGraph.SortType sortType) {
            if (sortType == null) {
                State.$$$reportNull$$$0(0);
            }
            this(new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder().build(), sortType, CommitCountStage.INITIAL, ContainerUtil.newArrayList(), VisiblePack.EMPTY, true);
        }

        public State(@NotNull VcsLogFilterCollection filters, @NotNull PermanentGraph.SortType sortType, @NotNull CommitCountStage commitCountStage, @NotNull List<MoreCommitsRequest> requests, @NotNull VisiblePack visiblePack, boolean isValid) {
            if (filters == null) {
                State.$$$reportNull$$$0(1);
            }
            if (sortType == null) {
                State.$$$reportNull$$$0(2);
            }
            if (commitCountStage == null) {
                State.$$$reportNull$$$0(3);
            }
            if (requests == null) {
                State.$$$reportNull$$$0(4);
            }
            if (visiblePack == null) {
                State.$$$reportNull$$$0(5);
            }
            this.myFilters = filters;
            this.mySortType = sortType;
            this.myCommitCount = commitCountStage;
            this.myRequestsToRun = Collections.unmodifiableList(requests);
            this.myVisiblePack = visiblePack;
            this.myIsValid = isValid;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        @NotNull
        public VisiblePack getVisiblePack() {
            VisiblePack visiblePack = this.myVisiblePack;
            if (visiblePack == null) {
                State.$$$reportNull$$$0(6);
            }
            return visiblePack;
        }

        @NotNull
        public List<MoreCommitsRequest> getRequestsToRun() {
            List<MoreCommitsRequest> list2 = this.myRequestsToRun;
            if (list2 == null) {
                State.$$$reportNull$$$0(7);
            }
            return list2;
        }

        @NotNull
        public VcsLogFilterCollection getFilters() {
            VcsLogFilterCollection vcsLogFilterCollection = this.myFilters;
            if (vcsLogFilterCollection == null) {
                State.$$$reportNull$$$0(8);
            }
            return vcsLogFilterCollection;
        }

        @NotNull
        public PermanentGraph.SortType getSortType() {
            PermanentGraph.SortType sortType = this.mySortType;
            if (sortType == null) {
                State.$$$reportNull$$$0(9);
            }
            return sortType;
        }

        @NotNull
        public CommitCountStage getCommitCount() {
            CommitCountStage commitCountStage = this.myCommitCount;
            if (commitCountStage == null) {
                State.$$$reportNull$$$0(10);
            }
            return commitCountStage;
        }

        @NotNull
        public State withValid(boolean valid) {
            State state = new State(this.myFilters, this.mySortType, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, valid);
            if (state == null) {
                State.$$$reportNull$$$0(11);
            }
            return state;
        }

        @NotNull
        public State withVisiblePack(@NotNull VisiblePack visiblePack) {
            if (visiblePack == null) {
                State.$$$reportNull$$$0(12);
            }
            State state = new State(this.myFilters, this.mySortType, this.myCommitCount, this.myRequestsToRun, visiblePack, this.myIsValid);
            if (state == null) {
                State.$$$reportNull$$$0(13);
            }
            return state;
        }

        @NotNull
        public State withCommitCount(@NotNull CommitCountStage commitCount) {
            if (commitCount == null) {
                State.$$$reportNull$$$0(14);
            }
            State state = new State(this.myFilters, this.mySortType, commitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
            if (state == null) {
                State.$$$reportNull$$$0(15);
            }
            return state;
        }

        @NotNull
        public State withRequests(@NotNull List<MoreCommitsRequest> requests) {
            if (requests == null) {
                State.$$$reportNull$$$0(16);
            }
            State state = new State(this.myFilters, this.mySortType, this.myCommitCount, requests, this.myVisiblePack, this.myIsValid);
            if (state == null) {
                State.$$$reportNull$$$0(17);
            }
            return state;
        }

        @NotNull
        public State withFilters(@NotNull VcsLogFilterCollection filters) {
            if (filters == null) {
                State.$$$reportNull$$$0(18);
            }
            State state = new State(filters, this.mySortType, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
            if (state == null) {
                State.$$$reportNull$$$0(19);
            }
            return state;
        }

        @NotNull
        public State withSortType(@NotNull PermanentGraph.SortType type) {
            if (type == null) {
                State.$$$reportNull$$$0(20);
            }
            State state = new State(this.myFilters, type, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
            if (state == null) {
                State.$$$reportNull$$$0(21);
            }
            return state;
        }

        public String toString() {
            return "State{myFilters=" + this.myFilters + ", mySortType=" + this.mySortType + ", myCommitCount=" + (Object)((Object)this.myCommitCount) + ", myRequestsToRun=" + this.myRequestsToRun + ", myVisiblePack=" + this.myVisiblePack + ", myIsValid=" + this.myIsValid + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 21: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 21: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortType";
                    break;
                }
                case 1: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitCountStage";
                    break;
                }
                case 4: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
                case 5: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visiblePack";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$State";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitCount";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$State";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVisiblePack";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestsToRun";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilters";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortType";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommitCount";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withValid";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withVisiblePack";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withCommitCount";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRequests";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withFilters";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withSortType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 21: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "withVisiblePack";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "withCommitCount";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "withRequests";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "withFilters";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "withSortType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 21: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyTask
    extends Task.Backgroundable {
        public MyTask(@NotNull Project project, String title) {
            if (title == null) {
                MyTask.$$$reportNull$$$0(0);
            }
            super(project, title, false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyTask.$$$reportNull$$$0(1);
            }
            State state = VisiblePackRefresherImpl.this.myState;
            List<Request> requests = VisiblePackRefresherImpl.this.myTaskController.peekRequests();
            if (!requests.isEmpty()) {
                try {
                    state = this.computeState(state, requests);
                    VisiblePackRefresherImpl.this.myTaskController.removeRequests(requests);
                }
                catch (ProcessCanceledException reThrown) {
                    LOG.debug("Filtering cancelled");
                    VisiblePackRefresherImpl.this.myTaskController.taskCompleted(null);
                    throw reThrown;
                }
                catch (Throwable t) {
                    LOG.error("Error while filtering log by " + requests, t);
                }
            }
            ArrayList requestsToRun = ContainerUtil.newArrayList();
            if (state.getVisiblePack() != VisiblePackRefresherImpl.this.myState.getVisiblePack() && state.isValid()) {
                requestsToRun.addAll(state.getRequestsToRun());
                state = state.withRequests(ContainerUtil.newArrayList());
            }
            VisiblePackRefresherImpl.this.myTaskController.taskCompleted(state);
            if (!requestsToRun.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (MoreCommitsRequest request : requestsToRun) {
                        request.onLoaded.run();
                    }
                });
            }
        }

        @NotNull
        private State computeState(@NotNull State state, @NotNull List<Request> requests) {
            if (state == null) {
                MyTask.$$$reportNull$$$0(2);
            }
            if (requests == null) {
                MyTask.$$$reportNull$$$0(3);
            }
            ValidateRequest validateRequest = (ValidateRequest)ContainerUtil.findLastInstance(requests, ValidateRequest.class);
            FilterRequest filterRequest = (FilterRequest)ContainerUtil.findLastInstance(requests, FilterRequest.class);
            SortTypeRequest sortTypeRequest = (SortTypeRequest)ContainerUtil.findLastInstance(requests, SortTypeRequest.class);
            List moreCommitsRequests = ContainerUtil.findAll(requests, MoreCommitsRequest.class);
            List indexingRequests = ContainerUtil.findAll(requests, IndexingFinishedRequest.class);
            state = state.withRequests(ContainerUtil.concat(state.getRequestsToRun(), (List)moreCommitsRequests));
            if (filterRequest != null) {
                state = state.withFilters(filterRequest.filters);
            }
            if (sortTypeRequest != null) {
                state = state.withSortType(sortTypeRequest.sortType);
            }
            if (!state.isValid()) {
                if (validateRequest != null && validateRequest.validate) {
                    state = state.withValid(true);
                    State state2 = this.refresh(state, filterRequest, moreCommitsRequests);
                    if (state2 == null) {
                        MyTask.$$$reportNull$$$0(4);
                    }
                    return state2;
                }
                State state3 = state;
                if (state3 == null) {
                    MyTask.$$$reportNull$$$0(5);
                }
                return state3;
            }
            if (validateRequest != null && !validateRequest.validate) {
                state = state.withValid(false);
                if (filterRequest != null) {
                    state = this.refresh(state, filterRequest, moreCommitsRequests);
                }
                State state4 = state.withVisiblePack(new SnapshotVisiblePackBuilder(VisiblePackRefresherImpl.this.myLogData.getStorage()).build(state.getVisiblePack()));
                if (state4 == null) {
                    MyTask.$$$reportNull$$$0(6);
                }
                return state4;
            }
            Request nonValidateRequest = (Request)ContainerUtil.find(requests, request -> !(request instanceof ValidateRequest) && !(request instanceof IndexingFinishedRequest));
            if (nonValidateRequest != null) {
                State state5 = this.refresh(state, filterRequest, moreCommitsRequests);
                if (state5 == null) {
                    MyTask.$$$reportNull$$$0(7);
                }
                return state5;
            }
            if (!indexingRequests.isEmpty() && VisiblePackRefresherImpl.this.myVisiblePackBuilder.areFiltersAffectedByIndexing(state.getFilters(), ContainerUtil.map((Collection)indexingRequests, IndexingFinishedRequest::getRoot))) {
                State state6 = this.refresh(state, filterRequest, moreCommitsRequests);
                if (state6 == null) {
                    MyTask.$$$reportNull$$$0(8);
                }
                return state6;
            }
            State state7 = state;
            if (state7 == null) {
                MyTask.$$$reportNull$$$0(9);
            }
            return state7;
        }

        @NotNull
        private State refresh(@NotNull State state, @Nullable FilterRequest filterRequest, @NotNull List<MoreCommitsRequest> moreCommitsRequests) {
            DataPack dataPack;
            if (state == null) {
                MyTask.$$$reportNull$$$0(10);
            }
            if (moreCommitsRequests == null) {
                MyTask.$$$reportNull$$$0(11);
            }
            if ((dataPack = VisiblePackRefresherImpl.this.myLogData.getDataPack()) == DataPack.EMPTY) {
                State state2 = state;
                if (state2 == null) {
                    MyTask.$$$reportNull$$$0(12);
                }
                return state2;
            }
            if (filterRequest != null) {
                state = state.withCommitCount(CommitCountStage.INITIAL);
            } else if (!moreCommitsRequests.isEmpty()) {
                state = state.withCommitCount(state.getCommitCount().next());
            }
            Pair<VisiblePack, CommitCountStage> pair = VisiblePackRefresherImpl.this.myVisiblePackBuilder.filter(dataPack, state.getSortType(), state.getFilters(), state.getCommitCount());
            State state3 = state.withVisiblePack((VisiblePack)pair.first).withCommitCount((CommitCountStage)((Object)pair.second));
            if (state3 == null) {
                MyTask.$$$reportNull$$$0(13);
            }
            return state3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$MyTask";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moreCommitsRequests";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$MyTask";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeState";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "refresh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "computeState";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "refresh";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

