/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.JComponent;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageFileEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.editor.impl.ImageEditorImpl;
import org.intellij.images.editor.impl.ImageFileEditorState;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.jetbrains.annotations.NotNull;

final class ImageFileEditorImpl
extends UserDataHolderBase
implements ImageFileEditor,
PropertyChangeListener {
    private static final String NAME = "ImageFileEditor";
    private final ImageEditor imageEditor;
    private final EventDispatcher<PropertyChangeListener> myDispatcher;

    ImageFileEditorImpl(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(1);
        }
        this.myDispatcher = EventDispatcher.create(PropertyChangeListener.class);
        this.imageEditor = new ImageEditorImpl(project, file2);
        Disposer.register((Disposable)this, (Disposable)this.imageEditor);
        Options options = OptionsManager.getInstance().getOptions();
        EditorOptions editorOptions = options.getEditorOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        TransparencyChessboardOptions transparencyChessboardOptions = editorOptions.getTransparencyChessboardOptions();
        this.imageEditor.setGridVisible(gridOptions.isShowDefault());
        this.imageEditor.setTransparencyChessboardVisible(transparencyChessboardOptions.isShowDefault());
        ((ImageEditorImpl)this.imageEditor).getComponent().getImageComponent().addPropertyChangeListener(this);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.imageEditor.getComponent();
        if (jComponent == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.imageEditor.getContentComponent();
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(3);
        }
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(4);
        }
        ImageZoomModel zoomModel = this.imageEditor.getZoomModel();
        ImageFileEditorState imageFileEditorState = new ImageFileEditorState(this.imageEditor.isTransparencyChessboardVisible(), this.imageEditor.isGridVisible(), zoomModel.getZoomFactor());
        if (imageFileEditorState == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(5);
        }
        return imageFileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(6);
        }
        if (state instanceof ImageFileEditorState) {
            ImageFileEditorState editorState = (ImageFileEditorState)state;
            ImageZoomModel zoomModel = this.imageEditor.getZoomModel();
            this.imageEditor.setTransparencyChessboardVisible(editorState.isBackgroundVisible());
            this.imageEditor.setGridVisible(editorState.isGridVisible());
            zoomModel.setZoomFactor(editorState.getZoomFactor());
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(7);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(8);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(9);
        }
        PropertyChangeEvent editorEvent = new PropertyChangeEvent(this, event.getPropertyName(), event.getOldValue(), event.getNewValue());
        ((PropertyChangeListener)this.myDispatcher.getMulticaster()).propertyChange(editorEvent);
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public ImageEditor getImageEditor() {
        ImageEditor imageEditor = this.imageEditor;
        if (imageEditor == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(10);
        }
        return imageEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/editor/impl/ImageFileEditorImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/editor/impl/ImageFileEditorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "propertyChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

