/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantEscapeInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Redundant character escape" == null) {
            RedundantEscapeInspection.$$$reportNull$$$0(0);
        }
        return "Redundant character escape";
    }

    @NotNull
    public RegExpElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantEscapeInspection.$$$reportNull$$$0(1);
        }
        RedundantEscapeVisitor redundantEscapeVisitor = new RedundantEscapeVisitor(holder);
        if (redundantEscapeVisitor == null) {
            RedundantEscapeInspection.$$$reportNull$$$0(2);
        }
        return redundantEscapeVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/inspection/RedundantEscapeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/inspection/RedundantEscapeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveRedundantEscapeFix
    implements LocalQuickFix {
        private RemoveRedundantEscapeFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Remove redundant escape" == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(0);
            }
            return "Remove redundant escape";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor.getPsiElement()) instanceof RegExpChar)) {
                return;
            }
            RegExpChar aChar = (RegExpChar)element;
            ASTNode node = aChar.getNode().getFirstChildNode();
            ASTNode parent = node.getTreeParent();
            parent.addLeaf(RegExpTT.CHARACTER, (CharSequence)RemoveRedundantEscapeFix.replacement(aChar), node);
            parent.removeChild(node);
        }

        @NotNull
        private static String replacement(RegExpChar aChar) {
            int codePoint = aChar.getValue();
            String s = Character.isSupplementaryCodePoint(codePoint) ? Character.toString(Character.highSurrogate(codePoint)) + Character.toString(Character.lowSurrogate(codePoint)) : Character.toString((char)codePoint);
            String string = RegExpReplacementUtil.escapeForContext(s, aChar);
            if (string == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/RedundantEscapeInspection$RemoveRedundantEscapeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/RedundantEscapeInspection$RemoveRedundantEscapeFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RedundantEscapeVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        public RedundantEscapeVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            String text = ch.getUnescapedText();
            if (!text.startsWith("\\") || !RegExpLanguageHosts.getInstance().isRedundantEscape(ch, text)) {
                return;
            }
            ASTNode astNode = ch.getNode().getFirstChildNode();
            if (astNode == null || astNode.getElementType() != RegExpTT.REDUNDANT_ESCAPE) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, "Redundant character escape <code>" + ch.getText() + "</code> in RegExp", new LocalQuickFix[]{new RemoveRedundantEscapeFix()});
        }
    }
}

