/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.xml.util.XmlStringUtil;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;

public class RegExpReplacementUtil {
    private RegExpReplacementUtil() {
    }

    public static String escapeForContext(String text, RegExpElement element) {
        ElementManipulator manipulator;
        PsiElement context = element.getContainingFile().getContext();
        ElementManipulator elementManipulator = manipulator = context == null ? null : ElementManipulators.getManipulator((PsiElement)context);
        if (manipulator != null) {
            PsiElement copy = context.copy();
            PsiElement newElement = manipulator.handleContentChange(copy, text);
            String newElementText = newElement.getText();
            TextRange newRange = manipulator.getRangeInElement(newElement);
            return newElementText.substring(newRange.getStartOffset(), newRange.getEndOffset());
        }
        if (RegExpElementImpl.isLiteralExpression(context)) {
            return StringUtil.escapeStringCharacters((String)text);
        }
        if (context instanceof XmlElement) {
            return XmlStringUtil.escapeString((String)text);
        }
        return text;
    }
}

