/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpNamedGroupRefImpl
extends RegExpElementImpl
implements RegExpNamedGroupRef {
    private static final TokenSet RUBY_GROUP_REF_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.RUBY_NAMED_GROUP_REF, RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF, RegExpTT.RUBY_NAMED_GROUP_CALL, RegExpTT.RUBY_QUOTED_NAMED_GROUP_CALL});

    public RegExpNamedGroupRefImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpNamedGroupRef(this);
    }

    @Override
    @Nullable
    public RegExpGroup resolve() {
        PsiElementProcessor.FindFilteredElement processor2 = new PsiElementProcessor.FindFilteredElement(element -> {
            if (!(element instanceof RegExpGroup)) {
                return false;
            }
            RegExpGroup group = (RegExpGroup)element;
            return group.isAnyNamedGroup() && Comparing.equal((String)this.getGroupName(), (String)group.getGroupName());
        });
        PsiTreeUtil.processElements((PsiElement)this.getContainingFile(), (PsiElementProcessor)processor2);
        return (RegExpGroup)processor2.getFoundElement();
    }

    @Override
    @Nullable
    public String getGroupName() {
        ASTNode nameNode = this.getNode().findChildByType(RegExpTT.NAME);
        return nameNode != null ? nameNode.getText() : null;
    }

    @Override
    public boolean isPythonNamedGroupRef() {
        return this.getNode().findChildByType(RegExpTT.PYTHON_NAMED_GROUP_REF) != null;
    }

    @Override
    public boolean isRubyNamedGroupRef() {
        ASTNode node = this.getNode();
        return node.findChildByType(RUBY_GROUP_REF_TOKENS) != null;
    }

    @Override
    public boolean isNamedGroupRef() {
        return this.getNode().findChildByType(RegExpTT.RUBY_NAMED_GROUP_REF) != null;
    }

    @Override
    public PsiReference getReference() {
        if (this.getNode().findChildByType(RegExpTT.NAME) == null) {
            return null;
        }
        return new PsiReference(){

            public PsiElement getElement() {
                return RegExpNamedGroupRefImpl.this;
            }

            public TextRange getRangeInElement() {
                ASTNode groupNode = RegExpNamedGroupRefImpl.this.getNode().getFirstChildNode();
                assert (groupNode != null);
                ASTNode nameNode = RegExpNamedGroupRefImpl.this.getNode().findChildByType(RegExpTT.NAME);
                assert (nameNode != null);
                int startOffset = groupNode.getTextLength();
                return new TextRange(startOffset, startOffset + nameNode.getTextLength());
            }

            public PsiElement resolve() {
                return RegExpNamedGroupRefImpl.this.resolve();
            }

            @NotNull
            public String getCanonicalText() {
                String string = this.getRangeInElement().substring(RegExpNamedGroupRefImpl.this.getText());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                throw new UnsupportedOperationException();
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                throw new UnsupportedOperationException();
            }

            public boolean isReferenceTo(PsiElement element) {
                return this.resolve() == element;
            }

            @NotNull
            public Object[] getVariants() {
                PsiElementProcessor.CollectFilteredElements processor2 = new PsiElementProcessor.CollectFilteredElements(e -> e instanceof RegExpGroup && ((RegExpGroup)e).isAnyNamedGroup());
                PsiTreeUtil.processElements((PsiElement)RegExpNamedGroupRefImpl.this.getContainingFile(), (PsiElementProcessor)processor2);
                Object[] objectArray = processor2.toArray();
                if (objectArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return objectArray;
            }

            public boolean isSoft() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/psi/impl/RegExpNamedGroupRefImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCanonicalText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/psi/impl/RegExpNamedGroupRefImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "bindToElement";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }
}

