/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.StaticFileHandlerKt;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"chromeVersionFromUserAgent", "Ljava/util/regex/Pattern;", "getChromeVersionFromUserAgent", "()Ljava/util/regex/Pattern;", "canBeAccessedDirectly", "", "path", "", "checkAccess", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "channel", "Lio/netty/channel/Channel;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "built-in-server"})
public final class DefaultWebServerPathHandlerKt {
    @NotNull
    private static final Pattern chromeVersionFromUserAgent;

    @NotNull
    public static final Pattern getChromeVersionFromUserAgent() {
        return chromeVersionFromUserAgent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkAccess(PathInfo pathInfo, Channel channel, HttpRequest request) {
        block9: {
            Path file2;
            Path path;
            block8: {
                if (pathInfo.getIoFile() != null) break block8;
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                if (!virtualFile.isInLocalFileSystem()) break block9;
            }
            if ((path = pathInfo.getIoFile()) == null) {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                path = file2 = Paths.get(virtualFile.getPath(), new String[0]);
            }
            if (PathKt.isDirectory((Path)file2)) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
                Responses.send$default(Responses.orInSafeMode(HttpResponseStatus.FORBIDDEN, httpResponseStatus), channel, request, null, null, 12, null);
                return false;
            }
            Path path2 = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
            if (StaticFileHandlerKt.hasAccess(path2)) return true;
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
            Responses.send$default(Responses.orInSafeMode(HttpResponseStatus.FORBIDDEN, httpResponseStatus), channel, request, null, null, 12, null);
            return false;
        }
        VirtualFile virtualFile = pathInfo.getFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        if (!virtualFile.is(VFileProperty.HIDDEN)) return true;
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
        Responses.send$default(Responses.orInSafeMode(HttpResponseStatus.FORBIDDEN, httpResponseStatus), channel, request, null, null, 12, null);
        return false;
    }

    private static final boolean canBeAccessedDirectly(String path) {
        for (WebServerFileHandler fileHandler : (WebServerFileHandler[])WebServerFileHandler.Companion.getEP_NAME$built_in_server().getExtensions()) {
            for (String ext : fileHandler.getPageFileExtensions()) {
                if (!FileUtilRt.extensionEquals((String)path, (String)ext)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Pattern pattern = Pattern.compile(" Chrome/([\\d.]+) ");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\" Chrome/([\\\\d.]+) \")");
        chromeVersionFromUserAgent = pattern;
    }

    public static final /* synthetic */ boolean access$canBeAccessedDirectly(@NotNull String path) {
        return DefaultWebServerPathHandlerKt.canBeAccessedDirectly(path);
    }

    public static final /* synthetic */ boolean access$checkAccess(@NotNull PathInfo pathInfo, @NotNull Channel channel, @NotNull HttpRequest request) {
        return DefaultWebServerPathHandlerKt.checkAccess(pathInfo, channel, request);
    }
}

