/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 $2\u00020\u0001:\u0001$B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0010\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ&\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u001d\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u0010J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0007J\u0010\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001dR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "", "rawSources", "", "", "canonicalizedUrls", "", "Lcom/intellij/util/Url;", "sourceContents", "(Ljava/util/List;[Lcom/intellij/util/Url;Ljava/util/List;)V", "canonicalizedUrlToSourceIndex", "Lcom/intellij/util/containers/ObjectIntHashMap;", "getCanonicalizedUrls", "()[Lcom/intellij/util/Url;", "[Lcom/intellij/util/Url;", "findSourceIndex", "", "sourceUrls", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "localFileUrlOnly", "", "resolver", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "findSourceIndex$script_debugger_backend", "findSourceIndexByFile", "findSourceIndexByFile$script_debugger_backend", "getRawSource", "entry", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getSource", "getSourceContent", "sourceIndex", "getSourceIndex", "url", "getUrlIfLocalFile", "Companion", "script-debugger-backend"})
public final class SourceResolver {
    private final ObjectIntHashMap<Url> canonicalizedUrlToSourceIndex;
    private final List<String> rawSources;
    @NotNull
    private final Url[] canonicalizedUrls;
    private final List<String> sourceContents;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Url getSource(@NotNull MappingEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        int index = entry.getSource();
        return index < 0 ? null : this.canonicalizedUrls[index];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getSourceContent(@NotNull MappingEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        if (UtilKt.isNullOrEmpty((Collection)this.sourceContents)) {
            return null;
        }
        int index = entry.getSource();
        if (index < 0) return null;
        List<String> list2 = this.sourceContents;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        if (index >= list2.size()) {
            return null;
        }
        String string = this.sourceContents.get(index);
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getSourceContent(int sourceIndex) {
        if (UtilKt.isNullOrEmpty((Collection)this.sourceContents)) {
            return null;
        }
        if (sourceIndex < 0) return null;
        List<String> list2 = this.sourceContents;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        if (sourceIndex >= list2.size()) {
            return null;
        }
        String string = this.sourceContents.get(sourceIndex);
        return string;
    }

    public final int getSourceIndex(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return ArrayUtil.indexOf((Object[])this.canonicalizedUrls, (Object)url);
    }

    @Nullable
    public final String getRawSource(@NotNull MappingEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        int index = entry.getSource();
        return index < 0 ? null : this.rawSources.get(index);
    }

    public final int findSourceIndex$script_debugger_backend(@NotNull SourceFileResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        int resolveByCanonicalizedUrls = resolver.resolve(this.canonicalizedUrlToSourceIndex);
        return resolveByCanonicalizedUrls != -1 ? resolveByCanonicalizedUrls : resolver.resolve(this.rawSources);
    }

    public final int findSourceIndex(@NotNull List<? extends Url> sourceUrls, @Nullable VirtualFile sourceFile, boolean localFileUrlOnly) {
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        for (Url url : sourceUrls) {
            int index = this.canonicalizedUrlToSourceIndex.get((Object)url);
            if (index == -1) continue;
            return index;
        }
        if (sourceFile != null) {
            return this.findSourceIndexByFile$script_debugger_backend(sourceFile, localFileUrlOnly);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int findSourceIndexByFile$script_debugger_backend(@NotNull VirtualFile sourceFile, boolean localFileUrlOnly) {
        int index;
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        if (!localFileUrlOnly && (index = this.canonicalizedUrlToSourceIndex.get((Object)Urls.newFromVirtualFile(sourceFile).trimParameters())) != -1) {
            return index;
        }
        if (!sourceFile.isInLocalFileSystem()) {
            return -1;
        }
        index = this.canonicalizedUrlToSourceIndex.get((Object)Urls.newLocalFileUrl(sourceFile));
        if (index != -1) {
            return index;
        }
        VirtualFile canonicalFile = sourceFile.getCanonicalFile();
        if (canonicalFile != null && Intrinsics.areEqual((Object)canonicalFile, (Object)sourceFile) ^ true) {
            int n = 0;
            int n2 = this.canonicalizedUrls.length;
            while (n < n2) {
                void i;
                Url url = (Url)((Object[])this.canonicalizedUrls)[i];
                if (Urls.equalsIgnoreParameters(url, canonicalFile)) {
                    return (int)i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Nullable
    public final Url getUrlIfLocalFile(@NotNull MappingEntry entry) {
        Url url;
        Url it;
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        Url url2 = (Url)ArraysKt.getOrNull((Object[])this.canonicalizedUrls, (int)entry.getSource());
        return url2 != null ? ((it = (url = url2)).isInLocalFileSystem() ? it : null) : null;
    }

    @NotNull
    public final Url[] getCanonicalizedUrls() {
        return this.canonicalizedUrls;
    }

    /*
     * WARNING - void declaration
     */
    public SourceResolver(@NotNull List<String> rawSources, @NotNull Url[] canonicalizedUrls, @Nullable List<String> sourceContents) {
        Intrinsics.checkParameterIsNotNull(rawSources, (String)"rawSources");
        Intrinsics.checkParameterIsNotNull((Object)canonicalizedUrls, (String)"canonicalizedUrls");
        this.rawSources = rawSources;
        this.canonicalizedUrls = canonicalizedUrls;
        this.sourceContents = sourceContents;
        this.canonicalizedUrlToSourceIndex = SystemInfo.isFileSystemCaseSensitive ? new ObjectIntHashMap(this.rawSources.size()) : new ObjectIntHashMap(this.rawSources.size(), Urls.getCaseInsensitiveUrlHashingStrategy());
        int n = 0;
        int n2 = ((Collection)this.rawSources).size();
        while (n < n2) {
            void i;
            this.canonicalizedUrlToSourceIndex.put((Object)this.canonicalizedUrls[i], (int)i);
            ++i;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceResolver$Companion;", "", "()V", "isAbsolute", "", "path", "", "script-debugger-backend"})
    public static final class Companion {
        public final boolean isAbsolute(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) || SystemInfo.isWindows && path.length() > 2 && path.charAt(1) == ':';
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

