/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myPanel;
    private JPanel myPreviewPanel;
    private JComboBox myBracePlacementCombo;
    private JComboBox myAlignValueCombo;
    private JCheckBox mySpaceAfterColonCheckBox;
    private JCheckBox mySpaceBeforeOpeningBraceCheckBox;
    private JCheckBox myAlignClosingBraceWithPropertiesCheckBox;
    private JTextField myBlankLinesBetweenBlocksTextField;
    private JCheckBox myKeepSingleLineBlocksCheckBox;
    private JCheckBox myConvertColorCaseCheckBox;
    private JRadioButton myColorLowerCaseRadioButton;
    private JRadioButton myColorUpperCaseRadioButton;
    private JCheckBox myConvertColorFormatCheckBox;
    private JRadioButton myLongFormatRadioButton;
    private JRadioButton myShortFormatRadioButton;

    public CssCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        CssCodeStyleSettings cssSettings = (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class);
        this.myConvertColorCaseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CssCodeStylePanel.this.myConvertColorCaseCheckBox.isSelected()) {
                    CssCodeStylePanel.this.myColorLowerCaseRadioButton.setEnabled(true);
                    CssCodeStylePanel.this.myColorUpperCaseRadioButton.setEnabled(true);
                    if (!CssCodeStylePanel.this.myColorUpperCaseRadioButton.isSelected() && !CssCodeStylePanel.this.myColorLowerCaseRadioButton.isSelected()) {
                        CssCodeStylePanel.this.myColorLowerCaseRadioButton.doClick();
                    }
                } else {
                    CssCodeStylePanel.this.myColorLowerCaseRadioButton.setEnabled(false);
                    CssCodeStylePanel.this.myColorUpperCaseRadioButton.setEnabled(false);
                }
            }
        });
        this.myConvertColorFormatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CssCodeStylePanel.this.myConvertColorFormatCheckBox.isSelected()) {
                    CssCodeStylePanel.this.myLongFormatRadioButton.setEnabled(true);
                    CssCodeStylePanel.this.myShortFormatRadioButton.setEnabled(true);
                    if (!CssCodeStylePanel.this.myLongFormatRadioButton.isSelected() && !CssCodeStylePanel.this.myShortFormatRadioButton.isSelected()) {
                        CssCodeStylePanel.this.myLongFormatRadioButton.doClick();
                    }
                } else {
                    CssCodeStylePanel.this.myLongFormatRadioButton.setEnabled(false);
                    CssCodeStylePanel.this.myShortFormatRadioButton.setEnabled(false);
                }
            }
        });
        this.myBracePlacementCombo.setModel(new DefaultComboBoxModel<String>(new String[]{CssBundle.message((String)"css.code.style.braces.end.of.line", (Object[])new Object[0]), CssBundle.message((String)"css.code.style.braces.next.line", (Object[])new Object[0])}));
        this.myAlignValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{CssBundle.message((String)"css.code.style.value.align.do.not.align", (Object[])new Object[0]), CssBundle.message((String)"css.code.style.value.align.on.colon", (Object[])new Object[0]), CssBundle.message((String)"css.code.style.value.align.on.value", (Object[])new Object[0])}));
        this.setSettings(cssSettings);
        this.addPanelToWatch(this.myPanel);
    }

    private void setSettings(CssCodeStyleSettings cssSettings) {
        CssCodeStylePanel.setValue(this.myBracePlacementCombo, cssSettings.BRACE_PLACEMENT);
        CssCodeStylePanel.setValue(this.myAlignValueCombo, cssSettings.VALUE_ALIGNMENT);
        CssCodeStylePanel.setValue(this.mySpaceAfterColonCheckBox, cssSettings.SPACE_AFTER_COLON);
        CssCodeStylePanel.setValue(this.mySpaceBeforeOpeningBraceCheckBox, cssSettings.SPACE_BEFORE_OPENING_BRACE);
        CssCodeStylePanel.setValue(this.myAlignClosingBraceWithPropertiesCheckBox, cssSettings.ALIGN_CLOSING_BRACE_WITH_PROPERTIES);
        CssCodeStylePanel.setValue(this.myKeepSingleLineBlocksCheckBox, cssSettings.KEEP_SINGLE_LINE_BLOCKS);
        if (cssSettings.HEX_COLOR_UPPER_CASE) {
            this.enableColorCaseButtons(true);
            this.myColorUpperCaseRadioButton.doClick();
        } else if (cssSettings.HEX_COLOR_LOWER_CASE) {
            this.enableColorCaseButtons(true);
            this.myColorLowerCaseRadioButton.doClick();
        } else {
            this.enableColorCaseButtons(false);
        }
        if (cssSettings.HEX_COLOR_LONG_FORMAT) {
            this.enableColorFormatButtons(true);
            this.myLongFormatRadioButton.doClick();
        } else if (cssSettings.HEX_COLOR_SHORT_FORMAT) {
            this.enableColorFormatButtons(true);
            this.myShortFormatRadioButton.doClick();
        } else {
            this.enableColorFormatButtons(false);
        }
        this.myBlankLinesBetweenBlocksTextField.setText(Integer.toString(cssSettings.BLANK_LINES_BETWEEN_BLOCKS));
    }

    private void enableColorFormatButtons(boolean state) {
        this.myConvertColorFormatCheckBox.setSelected(state);
        this.myLongFormatRadioButton.setEnabled(state);
        this.myShortFormatRadioButton.setEnabled(state);
    }

    private void enableColorCaseButtons(boolean state) {
        this.myConvertColorCaseCheckBox.setSelected(state);
        this.myColorUpperCaseRadioButton.setEnabled(state);
        this.myColorLowerCaseRadioButton.setEnabled(state);
    }

    private static void setValue(@NotNull JComboBox box, int value) {
        if (box == null) {
            CssCodeStylePanel.$$$reportNull$$$0(0);
        }
        box.setSelectedIndex(value);
    }

    private static void setValue(@NotNull JCheckBox box, boolean value) {
        if (box == null) {
            CssCodeStylePanel.$$$reportNull$$$0(1);
        }
        box.setSelected(value);
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return new LexerEditorHighlighter((SyntaxHighlighter)new CssHighlighter(), scheme);
    }

    protected int getRightMargin() {
        return 60;
    }

    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = CssFileType.INSTANCE;
        if (languageFileType == null) {
            CssCodeStylePanel.$$$reportNull$$$0(2);
        }
        return languageFileType;
    }

    @NonNls
    protected String getPreviewText() {
        return CssCodeStylePanel.readFromFile(((Object)((Object)this)).getClass(), (String)"preview.css.template");
    }

    public void apply(CodeStyleSettings settings) {
        CssCodeStyleSettings cssSettings = (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class);
        cssSettings.BRACE_PLACEMENT = CssCodeStylePanel.getComboValue(this.myBracePlacementCombo);
        cssSettings.VALUE_ALIGNMENT = CssCodeStylePanel.getComboValue(this.myAlignValueCombo);
        cssSettings.SPACE_AFTER_COLON = this.mySpaceAfterColonCheckBox.isSelected();
        cssSettings.SPACE_BEFORE_OPENING_BRACE = this.mySpaceBeforeOpeningBraceCheckBox.isSelected();
        cssSettings.ALIGN_CLOSING_BRACE_WITH_PROPERTIES = this.myAlignClosingBraceWithPropertiesCheckBox.isSelected();
        cssSettings.BLANK_LINES_BETWEEN_BLOCKS = CssCodeStylePanel.toInt(this.myBlankLinesBetweenBlocksTextField.getText());
        cssSettings.KEEP_SINGLE_LINE_BLOCKS = this.myKeepSingleLineBlocksCheckBox.isSelected();
        cssSettings.HEX_COLOR_UPPER_CASE = this.myConvertColorCaseCheckBox.isSelected() && this.myColorUpperCaseRadioButton.isSelected();
        cssSettings.HEX_COLOR_LOWER_CASE = this.myConvertColorCaseCheckBox.isSelected() && this.myColorLowerCaseRadioButton.isSelected();
        cssSettings.HEX_COLOR_LONG_FORMAT = this.myConvertColorFormatCheckBox.isSelected() && this.myLongFormatRadioButton.isSelected();
        cssSettings.HEX_COLOR_SHORT_FORMAT = this.myConvertColorFormatCheckBox.isSelected() && this.myShortFormatRadioButton.isSelected();
    }

    public boolean isModified(CodeStyleSettings settings) {
        CssCodeStyleSettings cssSettings = (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class);
        if (cssSettings.BRACE_PLACEMENT != CssCodeStylePanel.getComboValue(this.myBracePlacementCombo)) {
            return true;
        }
        if (cssSettings.VALUE_ALIGNMENT != CssCodeStylePanel.getComboValue(this.myAlignValueCombo)) {
            return true;
        }
        if (cssSettings.SPACE_AFTER_COLON != this.mySpaceAfterColonCheckBox.isSelected()) {
            return true;
        }
        if (cssSettings.SPACE_BEFORE_OPENING_BRACE != this.mySpaceBeforeOpeningBraceCheckBox.isSelected()) {
            return true;
        }
        if (cssSettings.ALIGN_CLOSING_BRACE_WITH_PROPERTIES != this.myAlignClosingBraceWithPropertiesCheckBox.isSelected()) {
            return true;
        }
        if (cssSettings.BLANK_LINES_BETWEEN_BLOCKS != CssCodeStylePanel.toInt(this.myBlankLinesBetweenBlocksTextField.getText())) {
            return true;
        }
        if (cssSettings.KEEP_SINGLE_LINE_BLOCKS != this.myKeepSingleLineBlocksCheckBox.isSelected()) {
            return true;
        }
        if (cssSettings.HEX_COLOR_UPPER_CASE != (this.myConvertColorCaseCheckBox.isSelected() && this.myColorUpperCaseRadioButton.isSelected())) {
            return true;
        }
        if (cssSettings.HEX_COLOR_LOWER_CASE != (this.myConvertColorCaseCheckBox.isSelected() && this.myColorLowerCaseRadioButton.isSelected())) {
            return true;
        }
        if (cssSettings.HEX_COLOR_LONG_FORMAT != (this.myConvertColorFormatCheckBox.isSelected() && this.myLongFormatRadioButton.isSelected())) {
            return true;
        }
        return cssSettings.HEX_COLOR_SHORT_FORMAT != (this.myConvertColorFormatCheckBox.isSelected() && this.myShortFormatRadioButton.isSelected());
    }

    private static int toInt(String text) {
        return Math.max(StringUtil.parseInt((String)text, (int)0), 0);
    }

    private static int getComboValue(JComboBox comboBox) {
        ComboBoxModel model = comboBox.getModel();
        String item = (String)model.getSelectedItem();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            if (!item.equals(model.getElementAt(i))) continue;
            return i;
        }
        return 0;
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        CssCodeStyleSettings cssSettings = (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class);
        this.setSettings(cssSettings);
    }

    private void createUIComponents() {
        this.myPreviewPanel = new JPanel();
        this.installPreviewPanel(this.myPreviewPanel);
    }

    protected void prepareForReformat(PsiFile psiFile) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "box";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/codeStyle/CssCodeStylePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/codeStyle/CssCodeStylePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JCheckBox jCheckBox2;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JCheckBox jCheckBox3;
        JTextField jTextField;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.braces.placement"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(113, 26), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.align.value"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.spaces.frame.title"), (int)0, (int)0, null, null));
        this.mySpaceAfterColonCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.space.after.colon"));
        jPanel4.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpaceBeforeOpeningBraceCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.space.before.opening.brace"));
        jPanel4.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.blank.lines.between.blocks"));
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAlignClosingBraceWithPropertiesCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.tab.before.closing.brace"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myBlankLinesBetweenBlocksTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(40, -1), null));
        this.myKeepSingleLineBlocksCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Keep single-line blocks");
        jCheckBox3.setMnemonic('K');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox3, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myBracePlacementCombo = jComboBox2 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel);
        jPanel3.add(jComboBox2, new GridConstraints(0, 1, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myAlignValueCombo = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(1, 1, 1, 2, 0, 1, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel5, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.colors.frame.title"), (int)0, (int)0, null, null));
        this.myConvertColorCaseCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.colors.case.checkbox"));
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myColorLowerCaseRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.colors.case.lower"));
        jPanel6.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myColorUpperCaseRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.colors.case.upper"));
        jPanel6.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConvertColorFormatCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.colors.format.checkbox"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLongFormatRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.colors.format.long"));
        jPanel7.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShortFormatRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/CssBundle").getString("css.code.style.colors.format.short"));
        jPanel7.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 2, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = this.myPreviewPanel;
        jPanel2.add((Component)jPanel8, new GridConstraints(0, 1, 3, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox);
        jBLabel.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

