/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor.value;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssExpression;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssOperation;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.value.CssAnyValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssAngleValue;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssDecibelValue;
import com.intellij.psi.css.impl.descriptor.value.CssExpressionValue;
import com.intellij.psi.css.impl.descriptor.value.CssFlexValue;
import com.intellij.psi.css.impl.descriptor.value.CssFrequencyValue;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssIdValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssIntegerValue;
import com.intellij.psi.css.impl.descriptor.value.CssJavaScriptValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssNumberValue;
import com.intellij.psi.css.impl.descriptor.value.CssPercentageValue;
import com.intellij.psi.css.impl.descriptor.value.CssPositionValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.descriptor.value.CssResolutionValue;
import com.intellij.psi.css.impl.descriptor.value.CssSelectorValue;
import com.intellij.psi.css.impl.descriptor.value.CssSemitonesValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssTextValue;
import com.intellij.psi.css.impl.descriptor.value.CssTimeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrangeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrlValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorVisitorImpl;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueValidatorImpl
implements CssValueValidator {
    @NotNull
    private final CssElementDescriptorProvider myElementDescriptorProvider;

    public CssValueValidatorImpl(@NotNull CssElementDescriptorProvider elementDescriptorProvider) {
        if (elementDescriptorProvider == null) {
            CssValueValidatorImpl.$$$reportNull$$$0(0);
        }
        this.myElementDescriptorProvider = elementDescriptorProvider;
    }

    private static boolean isIntegerType(@NotNull CssTermType termType) {
        if (termType == null) {
            CssValueValidatorImpl.$$$reportNull$$$0(1);
        }
        return termType == CssTermTypes.NEGATIVE_NUMBER || termType == CssTermTypes.NUMBER || termType == CssTermTypes.INTEGER;
    }

    public boolean isValid(@Nullable PsiElement term, @NotNull CssValueDescriptor valueDescriptor) {
        if (valueDescriptor == null) {
            CssValueValidatorImpl.$$$reportNull$$$0(2);
        }
        Ref result = Ref.create((Object)true);
        CssValueValidatingDescriptorVisitor visitor = new CssValueValidatingDescriptorVisitor((Ref<Boolean>)result, term);
        valueDescriptor.accept((CssValueDescriptorVisitor)visitor);
        return (Boolean)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDescriptorProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "termType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isIntegerType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isValid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CssValueValidatingDescriptorVisitor
    extends CssValueDescriptorVisitorImpl {
        private final Ref<Boolean> myResult;
        private final PsiElement myTerm;

        public CssValueValidatingDescriptorVisitor(Ref<Boolean> result, PsiElement term) {
            this.myResult = result;
            this.myTerm = term;
        }

        @Override
        public void visitGroupValue(@NotNull CssGroupValue groupValue) {
            if (groupValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(0);
            }
            this.myResult.set((Object)(this.myTerm != null ? 1 : 0));
            super.visitGroupValue(groupValue);
        }

        @Override
        public void visitAnyValue(@NotNull CssAnyValue anyValue) {
            if (anyValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(1);
            }
            this.myResult.set((Object)(this.myTerm != null && !StringUtil.isEmptyOrSpaces((String)this.myTerm.getText()) ? 1 : 0));
            super.visitAnyValue(anyValue);
        }

        @Override
        public void visitAngleValue(@NotNull CssAngleValue angleValue) {
            if (angleValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(2);
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.ANGLE || this.getTermType() == CssTermTypes.NEGATIVE_ANGLE || this.isZero() ? 1 : 0));
            super.visitAngleValue(angleValue);
        }

        @Override
        public void visitColorValue(@NotNull CssColorValue colorValue) {
            if (colorValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(3);
            }
            this.myResult.set((Object)(this.myTerm != null && (this.getTermType() == CssTermTypes.COLOR || this.myTerm instanceof CssTerm && CssValueValidatorImpl.this.myElementDescriptorProvider.isColorTerm((CssTerm)this.myTerm)) ? 1 : 0));
            super.visitColorValue(colorValue);
        }

        @Override
        public void visitFrequencyValue(@NotNull CssFrequencyValue frequencyValue) {
            if (frequencyValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(4);
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.FREQUENCY ? 1 : 0));
            super.visitFrequencyValue(frequencyValue);
        }

        @Override
        public void visitFunctionValue(@NotNull CssFunctionInvocationValue functionValue) {
            if (functionValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(5);
            }
            PsiElement firstChild = this.myTerm.getFirstChild();
            PsiElement lastChild = this.myTerm.getLastChild();
            String functionName = functionValue.getFunctionName();
            boolean functionMatched = false;
            if (firstChild != null && firstChild == lastChild && firstChild instanceof CssFunction) {
                boolean bl = functionMatched = functionName.equalsIgnoreCase(((CssFunction)firstChild).getName()) || functionName.equalsIgnoreCase(CssPropertyUtil.getElementNameWithoutVendorPrefix(((CssFunction)firstChild).getName()));
            }
            if (!functionMatched && "url".equalsIgnoreCase(functionName)) {
                functionMatched = firstChild != null && firstChild == lastChild && StringUtil.startsWith((CharSequence)firstChild.getText(), (CharSequence)"url(");
            }
            this.myResult.set((Object)functionMatched);
            super.visitFunctionValue(functionValue);
        }

        @Override
        public void visitIdValue(@NotNull CssIdValue idValue) {
            if (idValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(6);
            }
            if (this.myTerm == null) {
                this.myResult.set((Object)false);
            } else {
                PsiElement firstChild = this.myTerm.getFirstChild();
                this.myResult.set((Object)(firstChild != null && firstChild.getNode().getElementType() == CssElementTypes.CSS_HASH ? 1 : 0));
            }
            super.visitIdValue(idValue);
        }

        @Override
        public void visitInlineValue(@NotNull CssInlineValue inlineValue) {
            if (inlineValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(7);
            }
            Collection inlineValues = CssValueValidatorImpl.this.myElementDescriptorProvider.getNamedValueDescriptors(inlineValue.getRefId(), null);
            for (CssValueDescriptor cssValueDescriptor : inlineValues) {
                if (!this.createMapper().mapValue(cssValueDescriptor).isMatched() || !((Boolean)this.myResult.get()).booleanValue()) continue;
                return;
            }
            this.myResult.set((Object)false);
            super.visitInlineValue(inlineValue);
        }

        @Override
        public void visitIntegerValue(@NotNull CssIntegerValue integerValue) {
            if (integerValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(8);
            }
            this.myResult.set((Object)(this.myTerm != null && CssValueValidatorImpl.isIntegerType(this.getTermType()) ? 1 : 0));
            super.visitIntegerValue(integerValue);
        }

        @Override
        public void visitExpressionValue(@NotNull CssExpressionValue expressionValue) {
            if (expressionValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(9);
            }
            if (this.myTerm instanceof CssOperation) {
                this.myResult.set((Object)true);
            } else if (this.isLength() || CssValueValidatorImpl.isIntegerType(this.getTermType())) {
                PsiElement parent = this.myTerm.getParent();
                this.myResult.set((Object)(parent instanceof CssTermList && ((CssTermList)parent).getTerms().length == 1 ? 1 : 0));
            }
            super.visitExpressionValue(expressionValue);
        }

        @Override
        public void visitJavaScriptValue(@NotNull CssJavaScriptValue javaScriptValue) {
            if (javaScriptValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(10);
            }
            this.myResult.set((Object)(this.myTerm instanceof CssExpression));
            super.visitJavaScriptValue(javaScriptValue);
        }

        @Override
        public void visitLengthValue(@NotNull CssLengthValue lengthValue) {
            if (lengthValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(11);
            }
            this.myResult.set((Object)(this.myTerm != null && this.isLength() ? 1 : 0));
            super.visitLengthValue(lengthValue);
        }

        private boolean isLength() {
            return this.getTermType() == CssTermTypes.LENGTH || this.getTermType() == CssTermTypes.NEGATIVE_LENGTH || this.getTermType() == CssTermTypes.FLEX || this.isZero();
        }

        private boolean isZero() {
            return CssValueValidatorImpl.isIntegerType(this.getTermType()) && (this.myTerm.textMatches((CharSequence)"0") || this.myTerm.textMatches((CharSequence)"-0"));
        }

        @Override
        public void visitNameValue(@NotNull CssNameValue nameValue) {
            if (nameValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(12);
            }
            String expectedValue = nameValue.getValue();
            CssTermType termType = this.getTermType();
            this.myResult.set((Object)(this.myTerm != null && this.myTerm.getNode().getElementType() != CssElementTypes.CSS_HASH && (termType == CssTermTypes.IDENT || termType == CssTermTypes.COLOR) && this.termMatches(nameValue, expectedValue, this.myTerm.getText()) ? 1 : 0));
            super.visitNameValue(nameValue);
        }

        private boolean termMatches(@NotNull CssNameValue nameValue, @Nullable String expectedValue, @NotNull String termText) {
            if (nameValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(13);
            }
            if (termText == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(14);
            }
            return expectedValue == null && !StringUtil.startsWithChar((CharSequence)termText, (char)'#') || Comparing.strEqual((String)termText, (String)expectedValue, (boolean)nameValue.isCaseSensitive());
        }

        @Override
        public void visitNumberValue(@NotNull CssNumberValue numberValue) {
            if (numberValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(15);
            }
            this.myResult.set((Object)(this.myTerm != null && (this.getTermType() == CssTermTypes.NUMBER || this.getTermType() == CssTermTypes.NEGATIVE_NUMBER) ? 1 : 0));
            super.visitNumberValue(numberValue);
        }

        @Override
        public void visitPercentageValue(@NotNull CssPercentageValue percentageValue) {
            if (percentageValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(16);
            }
            this.myResult.set((Object)(this.myTerm != null && (this.getTermType() == CssTermTypes.PERCENTAGE || this.getTermType() == CssTermTypes.NEGATIVE_PERCENTAGE) ? 1 : 0));
            super.visitPercentageValue(percentageValue);
        }

        @Override
        public void visitResolutionValue(@NotNull CssResolutionValue resolutionValue) {
            if (resolutionValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(17);
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.RESOLUTION ? 1 : 0));
            super.visitResolutionValue(resolutionValue);
        }

        @Override
        public void visitPositionValue(@NotNull CssPositionValue positionValue) {
            if (positionValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(18);
            }
            this.visitInlineValue(positionValue);
        }

        @Override
        public void visitPropertyReferenceValue(@NotNull CssPropertyReferenceValue propertyReferenceValue) {
            if (propertyReferenceValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(19);
            }
            Collection propertyDescriptors = CssValueValidatorImpl.this.myElementDescriptorProvider.findPropertyDescriptors(propertyReferenceValue.getPropertyName(), this.myTerm);
            for (CssPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                if (!this.createMapper().mapValue(propertyDescriptor.getValueDescriptor()).isMatched() || !((Boolean)this.myResult.get()).booleanValue()) continue;
                return;
            }
            this.myResult.set((Object)false);
            super.visitPropertyReferenceValue(propertyReferenceValue);
        }

        @Override
        public void visitSelectorValue(@NotNull CssSelectorValue selectorValue) {
            if (selectorValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(20);
            }
            super.visitSelectorValue(selectorValue);
        }

        @Override
        public void visitStringValue(@NotNull CssStringValue stringValue) {
            if (stringValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(21);
            }
            String value = stringValue.getValue();
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.STRING && (value == null || this.myTerm.textMatches((CharSequence)("'" + value + "'")) || this.myTerm.textMatches((CharSequence)("\"" + value + "\"")) || this.myTerm.textMatches((CharSequence)"value")) ? 1 : 0));
            super.visitStringValue(stringValue);
        }

        @Override
        public void visitTextValue(@NotNull CssTextValue textValue) {
            if (textValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(22);
            }
            this.myResult.set((Object)(this.myTerm != null && textValue.getValue().equalsIgnoreCase(this.myTerm.getText()) ? 1 : 0));
            super.visitTextValue(textValue);
        }

        @Override
        public void visitTimeValue(@NotNull CssTimeValue timeValue) {
            if (timeValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(23);
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.TIME ? 1 : 0));
            super.visitTimeValue(timeValue);
        }

        @Override
        public void visitUrangeValue(@NotNull CssUrangeValue urangeValue) {
            if (urangeValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(24);
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.UNICODE_RANGE ? 1 : 0));
            super.visitUrangeValue(urangeValue);
        }

        @Override
        public void visitUrlValue(@NotNull CssUrlValue urlValue) {
            if (urlValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(25);
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.URI ? 1 : 0));
            super.visitUrlValue(urlValue);
        }

        @Override
        public void visitDecibelValue(@NotNull CssDecibelValue decibelValue) {
            if (decibelValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(26);
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.DECIBEL ? 1 : 0));
            super.visitDecibelValue(decibelValue);
        }

        @Override
        public void visitSemitonesValue(@NotNull CssSemitonesValue semitoneValue) {
            if (semitoneValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(27);
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.SEMITONES ? 1 : 0));
            super.visitSemitonesValue(semitoneValue);
        }

        @Override
        public void visitFlexValue(@NotNull CssFlexValue flexValue) {
            if (flexValue == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(28);
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.FLEX ? 1 : 0));
            super.visitFlexValue(flexValue);
        }

        @Override
        public void visitValue(@NotNull CssValueDescriptor value) {
            String functionName;
            if (value == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(29);
            }
            ProgressIndicatorProvider.checkCanceled();
            CssValueDescriptor exclusion = value.getExclusion();
            if (exclusion != null && this.createMapper().mapValue(exclusion).isMatched()) {
                this.myResult.set((Object)false);
                return;
            }
            PsiElement firstChild = this.myTerm.getFirstChild();
            PsiElement lastChild = this.myTerm.getLastChild();
            if (firstChild != null && firstChild == lastChild && firstChild instanceof CssFunction && (functionName = ((CssFunction)firstChild).getName()).equalsIgnoreCase("var")) {
                this.myResult.set((Object)true);
            }
        }

        @NotNull
        private CssTermType getTermType() {
            CssTermType cssTermType = this.myTerm instanceof CssTerm ? ((CssTerm)this.myTerm).getTermType() : CssTermType.UNKNOWN;
            if (cssTermType == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(30);
            }
            return cssTermType;
        }

        @NotNull
        private CssValueDescriptorMapper createMapper() {
            CssTermList value = (CssTermList)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myTerm, (Class[])new Class[]{CssTermList.class});
            CssValueDescriptorMapper cssValueDescriptorMapper = new CssValueDescriptorMapper(this.myTerm, CssPsiUtil.getLastDeepestTerm((PsiElement)value));
            if (cssValueDescriptorMapper == null) {
                CssValueValidatingDescriptorVisitor.$$$reportNull$$$0(31);
            }
            return cssValueDescriptorMapper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 30: 
                case 31: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 30: 
                case 31: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anyValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "angleValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorValue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frequencyValue";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionValue";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idValue";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlineValue";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "integerValue";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionValue";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaScriptValue";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lengthValue";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameValue";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "termText";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "numberValue";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "percentageValue";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolutionValue";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "positionValue";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyReferenceValue";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectorValue";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringValue";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textValue";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeValue";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urangeValue";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urlValue";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decibelValue";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "semitoneValue";
                    break;
                }
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flexValue";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 30: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor";
                    break;
                }
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTermType";
                    break;
                }
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitGroupValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAnyValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAngleValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitColorValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitFrequencyValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitFunctionValue";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitIdValue";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitInlineValue";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitIntegerValue";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitExpressionValue";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJavaScriptValue";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLengthValue";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visitNameValue";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "termMatches";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "visitNumberValue";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPercentageValue";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "visitResolutionValue";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPositionValue";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPropertyReferenceValue";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSelectorValue";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "visitStringValue";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTextValue";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTimeValue";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "visitUrangeValue";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "visitUrlValue";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "visitDecibelValue";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSemitonesValue";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "visitFlexValue";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "visitValue";
                    break;
                }
                case 30: 
                case 31: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 30: 
                case 31: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

