/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssKeyframesSelector;
import com.intellij.psi.css.CssMinifiedFileChecker;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.stubs.CssSelectorStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStub;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.resolve.CssInclusionContext;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssUtil {
    @NonNls
    public static final String ANIMATION_NAME_PROPERTY = "animation-name";
    @NonNls
    public static final String ANIMATION_PROPERTY = "animation";

    @Nullable
    public static CssTerm getEnclosingTerm(@Nullable PsiElement element) {
        PsiElement termList;
        if (element == null) {
            return null;
        }
        CssTerm term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)element, CssTerm.class, (boolean)false);
        if (term != null && (termList = term.getParent()) != null) {
            PsiElement termList2;
            if (termList.getParent() instanceof CssDeclaration) {
                return term;
            }
            if ((term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)term, CssTerm.class, (boolean)true)) != null && (termList2 = term.getParent()) != null && termList2.getParent() instanceof CssDeclaration) {
                return term;
            }
        }
        return null;
    }

    @NotNull
    public static CssDeclaration[] getCssDeclarationsDefinedForTag(@NotNull XmlTag tag) {
        if (tag == null) {
            CssUtil.$$$reportNull$$$0(0);
        }
        if (!tag.isValid()) {
            if (CssDeclaration.EMPTY_ARRAY == null) {
                CssUtil.$$$reportNull$$$0(1);
            }
            return CssDeclaration.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList();
        XmlAttribute[] attributes = tag.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            XmlAttributeValue valueElement = attributes[i].getValueElement();
            if (valueElement == null) continue;
            PsiReference[] references = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)valueElement);
            for (int j = 0; j < references.length; ++j) {
                if (!(references[j] instanceof PsiPolyVariantCachingReference)) continue;
                ResolveResult[] results = ((PsiPolyVariantCachingReference)references[j]).multiResolve(false);
                for (int k = 0; k < results.length; ++k) {
                    CssBlock block;
                    PsiElement element = results[k].getElement();
                    CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)element, CssRuleset.class);
                    if (ruleset == null || (block = ruleset.getBlock()) == null) continue;
                    Object[] declarations = block.getDeclarations();
                    ContainerUtil.addAll(result, (Object[])declarations);
                }
            }
        }
        CssDeclaration[] cssDeclarationArray = result.toArray(new CssDeclaration[result.size()]);
        if (cssDeclarationArray == null) {
            CssUtil.$$$reportNull$$$0(2);
        }
        return cssDeclarationArray;
    }

    @Nullable
    public static CssDeclaration getDeclaration(@Nullable PsiElement element) {
        return (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
    }

    public static boolean isIdent(PsiElement element) {
        return element instanceof CssTokenImpl && ((CssTokenImpl)element).getElementType() == CssElementTypes.CSS_IDENT;
    }

    public static boolean isInSelector(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, CssSelector.class) != null;
    }

    public static boolean isCssDeclaration(PsiElement element) {
        PsiElement parent = element != null ? element.getParent() : null;
        return parent instanceof CssDeclaration;
    }

    public static boolean processStylesheetWithImports(CssStylesheet stylesheet, Processor<PsiFile> processor, @Nullable PsiElement context, boolean withImportsFromImportListOnly) {
        Stack<Object> walkStack = new Stack<Object>();
        HashSet<PsiElement> visited = new HashSet<PsiElement>();
        walkStack.push(stylesheet);
        PsiFile file = stylesheet.getContainingFile();
        for (CssInclusionContext inclusionContext : (CssInclusionContext[])Extensions.getExtensions(CssInclusionContext.EXTENSION_POINT_NAME)) {
            for (PsiFile contextFile : inclusionContext.getContextFiles(file)) {
                if (!(contextFile instanceof StylesheetFile)) continue;
                walkStack.push(contextFile);
            }
        }
        while (!walkStack.isEmpty()) {
            PsiElement element2process = (PsiElement)walkStack.pop();
            if (visited.contains(element2process)) continue;
            visited.add(element2process);
            if (!processor.process((Object)element2process.getContainingFile())) {
                return false;
            }
            Object stylesheet2process = element2process instanceof StylesheetFile ? ((StylesheetFile)element2process).getStylesheet() : (element2process instanceof CssStylesheet ? (CssStylesheet)element2process : null);
            if (stylesheet2process == null) continue;
            for (CssImport cssImport : stylesheet2process.getImports(withImportsFromImportListOnly)) {
                PsiFile[] resolvedFiles;
                boolean importVisible = true;
                if (file instanceof StylesheetFile) {
                    importVisible = ((StylesheetFile)file).isImportVisibleInContext(cssImport, context);
                }
                if (!importVisible) continue;
                for (PsiFile psiFile : resolvedFiles = cssImport.resolve()) {
                    if (!(psiFile instanceof StylesheetFile)) continue;
                    walkStack.push(psiFile);
                }
            }
        }
        return true;
    }

    public static Set<VirtualFile> getImportedFiles(PsiFile file, PsiElement context, boolean withImportsFromImportListOnly) {
        CssStylesheet sheet = file instanceof StylesheetFile ? ((StylesheetFile)file).getStylesheet() : (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)context, CssStylesheet.class);
        if (sheet != null) {
            HashSet importedVirtualFiles = Sets.newHashSet();
            CssUtil.processStylesheetWithImports(sheet, (Processor<PsiFile>)((Processor)file1 -> {
                VirtualFile virtualFile = file1.getVirtualFile();
                if (virtualFile != null) {
                    importedVirtualFiles.add(virtualFile);
                }
                return true;
            }), context, withImportsFromImportListOnly);
            return importedVirtualFiles;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null ? Sets.newHashSet((Object[])new VirtualFile[]{virtualFile}) : Collections.emptySet();
    }

    public static boolean containsStrangeCharacter(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != '*' && (c == ':' || c == '-' || Character.isJavaIdentifierPart(c))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSelectorInjected(PsiElement element) {
        PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
        return context != null && !context.textContains('\n') && !(context.getContainingFile() instanceof XmlFile);
    }

    public static boolean isHackComment(@Nullable String commentText) {
        return "\\0".equals(commentText = Strings.nullToEmpty((String)commentText).trim()) || "\\0/".equals(commentText) || "\\9".equals(commentText) || "!ie".equalsIgnoreCase(commentText);
    }

    public static boolean isHackPropertyName(@NotNull String name) {
        if (name == null) {
            CssUtil.$$$reportNull$$$0(3);
        }
        return name.startsWith("*") || name.startsWith("_") || name.startsWith("#");
    }

    private CssUtil() {
    }

    public static void rebindFileReference(@NotNull PsiElement referenceOwner, @NotNull PsiFile referenceTarget) {
        if (referenceOwner == null) {
            CssUtil.$$$reportNull$$$0(4);
        }
        if (referenceTarget == null) {
            CssUtil.$$$reportNull$$$0(5);
        }
        for (PsiReference reference : referenceOwner.getReferences()) {
            PsiFileReference lastReference;
            if (!(reference instanceof FileReferenceOwner) || (lastReference = ((FileReferenceOwner)reference).getLastFileReference()) == null) continue;
            lastReference.bindToElement((PsiElement)referenceTarget);
            break;
        }
    }

    public static boolean isInsideKeyframes(PsiElement context) {
        return PsiTreeUtil.getParentOfType((PsiElement)context, CssKeyframesSelector.class, (boolean)false) != null;
    }

    public static boolean isInsideFontFace(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return false;
        }
        ASTNode node = psiElement.getNode();
        return node != null && TreeUtil.findParent((ASTNode)node, (IElementType)CssElementTypes.CSS_FONTFACE) != null;
    }

    public static boolean isInsidePageRuleset(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return false;
        }
        ASTNode node = psiElement.getNode();
        return node != null && TreeUtil.findParent((ASTNode)node, (IElementType)CssElementTypes.CSS_PAGE) != null;
    }

    public static boolean isInsideComposesDeclaration(@NotNull PsiElement element) {
        if (element == null) {
            CssUtil.$$$reportNull$$$0(6);
        }
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
        return CssPropertyUtil.isComposesProperty(declaration);
    }

    @NotNull
    public static List<String> getClassNames(String text, PsiElement element, @Nullable Consumer<String> fun) {
        XmlAttribute attr;
        String delim = " \t";
        if (element.getParent() instanceof XmlAttribute && (attr = (XmlAttribute)element.getParent()).getName().endsWith("Classes")) {
            delim = " \t,";
        }
        StringTokenizer st = new StringTokenizer(text, delim);
        ArrayList<String> names = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            names.add(token);
            if (fun == null) continue;
            fun.consume((Object)token);
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            CssUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public static MediaType getMediaTypeFromDataUri(@NotNull String dataUrl) {
        Matcher matcher;
        if (dataUrl == null) {
            CssUtil.$$$reportNull$$$0(8);
        }
        if ((matcher = URLUtil.DATA_URI_PATTERN.matcher(StringUtil.unquoteString((String)dataUrl))).matches()) {
            try {
                return MediaType.parse((String)StringUtil.notNullize((String)matcher.group(1)));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isSemicolonMissing(@Nullable CssOneLineStatement oneLineStatement) {
        if (oneLineStatement == null) {
            return false;
        }
        ASTNode deepestLast = PsiTreeUtil.getDeepestLast((PsiElement)oneLineStatement).getNode();
        if (deepestLast != null && deepestLast.getElementType() == CssElementTypes.CSS_SEMICOLON) {
            return false;
        }
        PsiElement nextSibling = PsiTreeUtil.nextVisibleLeaf((PsiElement)oneLineStatement);
        while (nextSibling instanceof PsiComment || nextSibling instanceof OuterLanguageElement) {
            nextSibling = PsiTreeUtil.nextVisibleLeaf((PsiElement)nextSibling);
        }
        return nextSibling == null || CssElementTypes.CSS_SEMICOLON != nextSibling.getNode().getElementType();
    }

    public static CssOneLineStatement findOneLineStatement(@Nullable PsiElement psiElement) {
        IElementType type;
        PsiElement parent;
        CssOneLineStatement oneLineStatement = (CssOneLineStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, CssOneLineStatement.class, (boolean)false);
        if (oneLineStatement != null && (parent = oneLineStatement.getParent()) != null && ((type = parent.getNode().getElementType()) == CssElementTypes.CSS_MEDIA_EXPRESSION || type == CssElementTypes.CSS_SUPPORTS || type == CssElementTypes.CSS_SUPPORTS_CONDITION || type == CssElementTypes.CSS_RULESET)) {
            return null;
        }
        return oneLineStatement;
    }

    public static CssOneLineStatement appendStatementWithSemicolonIfNeeded(@NotNull Project project, @NotNull PsiElement psiElement) {
        CssOneLineStatement oneLineStatement;
        if (project == null) {
            CssUtil.$$$reportNull$$$0(9);
        }
        if (psiElement == null) {
            CssUtil.$$$reportNull$$$0(10);
        }
        if ((oneLineStatement = CssUtil.findOneLineStatement(psiElement)) != null && CssUtil.isSemicolonMissing(oneLineStatement)) {
            CssElementFactory factory = CssElementFactory.getInstance((Project)project);
            Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)psiElement);
            PsiElement semicolon = factory.createToken(";", language);
            if (oneLineStatement instanceof CssDeclaration) {
                CssOneLineStatement addAfter = oneLineStatement;
                PsiElement nextSibling = PsiTreeUtil.nextVisibleLeaf((PsiElement)oneLineStatement);
                while (nextSibling instanceof OuterLanguageElement) {
                    addAfter = nextSibling;
                    nextSibling = PsiTreeUtil.nextVisibleLeaf((PsiElement)nextSibling);
                }
                addAfter.getParent().addAfter(semicolon, (PsiElement)addAfter);
            } else {
                PsiElement element = oneLineStatement.add(semicolon);
                PsiElement prevSibling = element.getPrevSibling();
                if (prevSibling instanceof PsiErrorElement && CssBundle.message((String)"expected", (Object[])new Object[]{"';'"}).equals(((PsiErrorElement)prevSibling).getErrorDescription())) {
                    prevSibling.delete();
                }
            }
        }
        return oneLineStatement;
    }

    @NotNull
    public static GlobalSearchScope getCompletionAndResolvingScopeForElement(@NotNull PsiElement element) {
        PsiFile contextFile;
        Module module;
        if (element == null) {
            CssUtil.$$$reportNull$$$0(11);
        }
        GlobalSearchScope globalSearchScope = (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(contextFile = element.getContainingFile()))) != null ? CssUtil.getCompletionAndResolvingScopeForModule(module, contextFile) : GlobalSearchScope.projectScope((Project)element.getProject());
        if (globalSearchScope == null) {
            CssUtil.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getCompletionAndResolvingScopeForModule(@NotNull Module module, @Nullable PsiFile context) {
        if (module == null) {
            CssUtil.$$$reportNull$$$0(13);
        }
        VirtualFile contextFile = context != null ? context.getOriginalFile().getVirtualFile() : null;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module).uniteWith(module.getModuleContentWithDependenciesScope()).uniteWith(ScriptingLibraryUtil.getJSLibraryScopeForFile((Project)module.getProject(), (VirtualFile)contextFile));
        if (globalSearchScope == null) {
            CssUtil.$$$reportNull$$$0(14);
        }
        return globalSearchScope;
    }

    public static int getLineNumber(@NotNull CssElement element) {
        if (element == null) {
            CssUtil.$$$reportNull$$$0(15);
        }
        if (CssMinifiedFileChecker.isMinifiedFile(element.getContainingFile())) {
            return -1;
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        StubElement stub = element instanceof CssStubElement ? ((CssStubElement)element).getStub() : null;
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
        int textOffset = stub instanceof CssNamedStub ? ((CssNamedStub)stub).getTextOffset() : (stub instanceof CssSelectorStub ? ((CssSelectorStub)stub).getTextOffset() : element.getTextOffset());
        return document != null && textOffset < document.getTextLength() ? document.getLineNumber(textOffset) + 1 : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOwner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataUrl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssDeclarationsDefinedForTag";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionAndResolvingScopeForElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionAndResolvingScopeForModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCssDeclarationsDefinedForTag";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 12: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isHackPropertyName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rebindFileReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInsideComposesDeclaration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMediaTypeFromDataUri";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendStatementWithSemicolonIfNeeded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionAndResolvingScopeForElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionAndResolvingScopeForModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumber";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

