---- ListSchemas ----
select schema_name, default_collation_name
from information_schema.schemata
order by if(schema() = schema_name, 1, 2), schema_name

---- RetrieveCasing ----
select @@GLOBAL.lower_case_table_names

---- RetrieveTablesAndViewsInfo ----
select table_name, table_type, table_comment, engine, table_collation
from information_schema.tables
where table_schema = ?

---- RetrieveIndicesInfo ----
select
  table_name,
  index_name,
  group_concat(column_name order by seq_in_index separator '\n') as column_names,
  non_unique
from information_schema.statistics
where table_schema = ? and
      index_schema = ? and
      index_name collate utf8_general_ci <> 'PRIMARY'
group by
  table_catalog,
  table_schema,
  table_name,
  index_name,
  index_type,
  non_unique

---- RetrieveConstraintsInfo ----
select
  c.constraint_name,
  c.table_name,
  c.constraint_type,
  group_concat(u.column_name order by u.ordinal_position separator '\n' ) as column_names,
  u.referenced_table_schema,
  u.referenced_table_name,
  group_concat(u.referenced_column_name order by u.position_in_unique_constraint separator '\n') as ref_column_names,
  r.match_option,
  r.update_rule,
  r.delete_rule
from information_schema.table_constraints c
  left join information_schema.key_column_usage u on
      u.constraint_schema   = c.constraint_schema
  and u.constraint_name     = c.constraint_name
  and u.table_name = c.table_name
  and u.table_schema = ?
  and ((c.constraint_type collate utf8_general_ci = 'UNIQUE' and u.referenced_table_name is null)
     or c.constraint_type collate utf8_general_ci <> 'UNIQUE')
  left join information_schema.referential_constraints r on
      r.constraint_schema   = c.constraint_schema
  and r.constraint_name     = c.constraint_name
where c.table_schema = ?
  and u.table_schema = ?
group by
    c.constraint_schema
  , c.constraint_name
  , c.table_schema
  , c.table_name
  , c.constraint_type
  , u.referenced_table_schema
  , u.referenced_table_name
  , r.match_option
  , r.update_rule
  , r.delete_rule
order by
    c.table_schema
  , c.table_name
  , c.constraint_schema
  , c.constraint_name

---- RetrieveRoutinesInfo ----
select
  specific_name,
  routine_type,
  routine_definition,
  routine_comment,
  dtd_identifier
from information_schema.routines
where routine_schema = ?

---- RetrieveRoutinesSources ----
select specific_name, routine_definition
from information_schema.routines
where routine_schema = ?

---- RetrieveOneFunctionSource ----
show create function #FQN

---- RetrieveOneProcedureSource ----
show create procedure #FQN

---- RetrieveOneTriggerSource ----
show create trigger #FQN

---- RetrieveOneEventSource ----
show create event #FQN

---- RetrieveOneTableSource ----
show create table #FQN

---- ParametersTableExists ----
select table_name from information_schema.tables
where table_schema collate utf8_general_ci = 'information_schema' and table_name collate utf8_general_ci = 'parameters'

---- RetrieveRoutineParamsInfo ----
select specific_name,
  ordinal_position,
  parameter_name,
  parameter_mode,
  dtd_identifier
from information_schema.parameters
where specific_schema = ? and ordinal_position > 0
order by specific_name, ordinal_position

---- RetrieveTableColumnsInfo ----
select
  ordinal_position,
  column_name,
  column_type,
  column_default,
#GENEXPR: #: null #.
  generation_expression,
  table_name,
  column_comment,
  is_nullable,
  extra,
  collation_name
from information_schema.columns
where table_schema = ?
order by table_name, ordinal_position

---- RetrieveViewsInfo ----
select table_name, view_definition
from information_schema.views
where table_schema = ?

---- RetrieveTriggersInfo ----
select
  trigger_name,
  event_object_table,
  event_manipulation,
  action_timing
from information_schema.triggers
where trigger_schema = ?

---- RetrieveTriggersSources ----
select
  trigger_name,
  event_object_table,
  action_statement
from information_schema.triggers
where trigger_schema = ?

---- RetrieveEventsInfo ----
select
  event_name,
  event_comment,
  definer,
  event_type = 'RECURRING' recurring,
  interval_value,
  interval_field,
  cast(coalesce(starts, execute_at) as char) starts,
  cast(ends as char) ends,
  status,
  on_completion = 'PRESERVE' preserve,
  last_executed
from information_schema.events
where event_schema = ?

---- RetrieveEventsSources ----
select
  event_name,
  event_definition
from information_schema.events
where event_schema = ?

---- RetrieveCollations ----
select
  collation_name,
  character_set_name,
  is_default collate utf8_general_ci = 'Yes' as is_default
from information_schema.collations