/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import gnu.trove.TObjectLongHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.android.util.ResourceFileData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.ValidityState;

public class AndroidAptValidityState
implements ValidityState {
    private static final int SIGNATURE = -559038737;
    private static final byte VERSION = 1;
    private final Map<String, ResourceFileData> myResources;
    private final TObjectLongHashMap<String> myValueResourceFilesTimestamps;
    private final List<ResourceEntry> myManifestElements;
    private final String myPackageName;
    private final Set<Pair<String, String>> myLibRTxtFilesAndPackages;
    private final String myProguardOutputCfgFile;
    private final String myRTxtOutputDir;
    private final boolean myLibrary;

    public AndroidAptValidityState(@NotNull Map<String, ResourceFileData> resources, @NotNull TObjectLongHashMap<String> valueResourceFilesTimestamps, @NotNull List<ResourceEntry> manifestElements, @NotNull Collection<Pair<String, String>> libRTxtFilesAndPackages, @NotNull String packageName, @Nullable String proguardOutputCfgFile, @Nullable String rTxtOutputDir, boolean library) {
        if (resources == null) {
            AndroidAptValidityState.$$$reportNull$$$0(0);
        }
        if (valueResourceFilesTimestamps == null) {
            AndroidAptValidityState.$$$reportNull$$$0(1);
        }
        if (manifestElements == null) {
            AndroidAptValidityState.$$$reportNull$$$0(2);
        }
        if (libRTxtFilesAndPackages == null) {
            AndroidAptValidityState.$$$reportNull$$$0(3);
        }
        if (packageName == null) {
            AndroidAptValidityState.$$$reportNull$$$0(4);
        }
        this.myResources = resources;
        this.myValueResourceFilesTimestamps = valueResourceFilesTimestamps;
        this.myManifestElements = manifestElements;
        this.myLibRTxtFilesAndPackages = new HashSet(libRTxtFilesAndPackages);
        this.myPackageName = packageName;
        this.myProguardOutputCfgFile = proguardOutputCfgFile != null ? proguardOutputCfgFile : "";
        this.myRTxtOutputDir = rTxtOutputDir != null ? rTxtOutputDir : "";
        this.myLibrary = library;
    }

    public AndroidAptValidityState(@NotNull DataInput in) throws IOException {
        if (in == null) {
            AndroidAptValidityState.$$$reportNull$$$0(5);
        }
        int signature = in.readInt();
        if (signature != -559038737) {
            throw new IOException("incorrect signature");
        }
        byte version = in.readByte();
        if (version != 1) {
            throw new IOException("old version");
        }
        this.myPackageName = in.readUTF();
        int filesCount = in.readInt();
        this.myResources = new HashMap(filesCount);
        for (int i = 0; i < filesCount; ++i) {
            String filePath = in.readUTF();
            int entriesCount = in.readInt();
            ArrayList<ResourceEntry> entries = new ArrayList<ResourceEntry>(entriesCount);
            for (int j = 0; j < entriesCount; ++j) {
                String resType = in.readUTF();
                String resName = in.readUTF();
                String resContext = in.readUTF();
                entries.add(new ResourceEntry(resType, resName, resContext));
            }
            long timestamp = in.readLong();
            this.myResources.put(filePath, new ResourceFileData(entries, timestamp));
        }
        int manifestElementCount = in.readInt();
        this.myManifestElements = new ArrayList<ResourceEntry>(manifestElementCount);
        for (int i = 0; i < manifestElementCount; ++i) {
            String elementType = in.readUTF();
            String elementName = in.readUTF();
            String elementContext = in.readUTF();
            this.myManifestElements.add(new ResourceEntry(elementType, elementName, elementContext));
        }
        int libPackageCount = in.readInt();
        this.myLibRTxtFilesAndPackages = new HashSet(libPackageCount);
        for (int i = 0; i < libPackageCount; ++i) {
            String libRTxtFilePath = in.readUTF();
            String libPackage = in.readUTF();
            this.myLibRTxtFilesAndPackages.add((Pair<String, String>)Pair.create((Object)libRTxtFilePath, (Object)libPackage));
        }
        this.myProguardOutputCfgFile = in.readUTF();
        this.myRTxtOutputDir = in.readUTF();
        this.myLibrary = in.readBoolean();
        int valueResourceFilesCount = in.readInt();
        this.myValueResourceFilesTimestamps = new TObjectLongHashMap(valueResourceFilesCount);
        for (int i = 0; i < valueResourceFilesCount; ++i) {
            String filePath = in.readUTF();
            long timestamp = in.readLong();
            this.myValueResourceFilesTimestamps.put((Object)filePath, timestamp);
        }
    }

    public boolean equalsTo(ValidityState otherState) {
        if (!(otherState instanceof AndroidAptValidityState)) {
            return false;
        }
        AndroidAptValidityState otherAndroidState = (AndroidAptValidityState)otherState;
        return otherAndroidState.myPackageName.equals(this.myPackageName) && otherAndroidState.myResources.equals(this.myResources) && otherAndroidState.myManifestElements.equals(this.myManifestElements) && otherAndroidState.myLibRTxtFilesAndPackages.equals(this.myLibRTxtFilesAndPackages) && otherAndroidState.myProguardOutputCfgFile.equals(this.myProguardOutputCfgFile) && otherAndroidState.myRTxtOutputDir.equals(this.myRTxtOutputDir) && otherAndroidState.myLibrary == this.myLibrary;
    }

    public void save(DataOutput out) throws IOException {
        out.writeInt(-559038737);
        out.writeByte(1);
        out.writeUTF(this.myPackageName);
        out.writeInt(this.myResources.size());
        for (Map.Entry<String, ResourceFileData> entry : this.myResources.entrySet()) {
            out.writeUTF(entry.getKey());
            ResourceFileData fileData = entry.getValue();
            List resources = fileData.getValueResources();
            out.writeInt(resources.size());
            for (ResourceEntry resource : resources) {
                out.writeUTF(resource.getType());
                out.writeUTF(resource.getName());
                out.writeUTF(resource.getContext());
            }
            out.writeLong(fileData.getTimestamp());
        }
        out.writeInt(this.myManifestElements.size());
        for (ResourceEntry resourceEntry : this.myManifestElements) {
            out.writeUTF(resourceEntry.getType());
            out.writeUTF(resourceEntry.getName());
            out.writeUTF(resourceEntry.getContext());
        }
        out.writeInt(this.myLibRTxtFilesAndPackages.size());
        for (Pair pair : this.myLibRTxtFilesAndPackages) {
            out.writeUTF((String)pair.getFirst());
            out.writeUTF((String)pair.getSecond());
        }
        out.writeUTF(this.myProguardOutputCfgFile);
        out.writeUTF(this.myRTxtOutputDir);
        out.writeBoolean(this.myLibrary);
        out.writeInt(this.myValueResourceFilesTimestamps.size());
        for (Object key : this.myValueResourceFilesTimestamps.keys()) {
            String strKey = (String)key;
            out.writeUTF(strKey);
            out.writeLong(this.myValueResourceFilesTimestamps.get((Object)strKey));
        }
    }

    public Map<String, ResourceFileData> getResources() {
        return this.myResources;
    }

    public TObjectLongHashMap<String> getValueResourceFilesTimestamps() {
        return this.myValueResourceFilesTimestamps;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "resources";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "valueResourceFilesTimestamps";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "manifestElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "libRTxtFilesAndPackages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "packageName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "in";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/android/AndroidAptValidityState";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

