/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.incremental.CacheVersionKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache$WhenMappings;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.JavaClassProtoMapValueExternalizer;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImplKt;
import org.jetbrains.kotlin.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.incremental.PathCollectionExternalizer;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.incremental.SerializedJavaClass;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.ConstantsMapExternalizer;
import org.jetbrains.kotlin.incremental.storage.DirtyClassesJvmNameMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValueExternalizer;
import org.jetbrains.kotlin.incremental.storage.SourceToJvmNameMap;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.inline.InlineUtilKt;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u0000 V2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\tVWXYZ[\\]^B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0005H\u0002J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050+H\u0007J\b\u0010-\u001a\u00020&H\u0016J\u0010\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020&2\u0006\u00102\u001a\u000203H\u0014J\u0010\u00104\u001a\u0002032\u0006\u00105\u001a\u000203H\u0016J\n\u00106\u001a\u0004\u0018\u000107H\u0016J\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020309H\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020309H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u000203H\u0016J\u0018\u0010@\u001a\n\u0012\u0004\u0012\u000203\u0018\u0001092\u0006\u0010A\u001a\u000203H\u0016J\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020:J\u000e\u0010E\u001a\u00020C2\u0006\u0010D\u001a\u00020:J\u000e\u0010F\u001a\u00020C2\u0006\u0010G\u001a\u00020\u0002J\u000e\u0010H\u001a\u00020C2\u0006\u0010I\u001a\u00020\u0005J\u0018\u0010J\u001a\u00020&2\u0006\u0010K\u001a\u00020L2\u0006\u0010/\u001a\u000200H\u0016J\u001e\u0010M\u001a\u00020&2\u0006\u0010N\u001a\u00020\u00052\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u000200J\u001c\u0010R\u001a\u00020&2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u0005092\u0006\u0010I\u001a\u00020\u0005J\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020\u0005092\u0006\u0010U\u001a\u000203R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u001b\u001a\u00060\u001cR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00060\u001eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u00060 R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "targetDataRoot", "Ljava/io/File;", "targetOutputDir", "(Ljava/io/File;Ljava/io/File;)V", "constantsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ConstantsMap;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesJvmNameMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesJvmNameMap;", "inlineFunctionsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InlineFunctionsMap;", "internalNameToSource", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InternalNameToSourcesMap;", "javaSourcesProtoMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$JavaSourcesProtoMap;", "multifileFacadeToParts", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassFacadeMap;", "outputDir", "getOutputDir", "()Ljava/io/File;", "outputDir$delegate", "Lkotlin/Lazy;", "packagePartMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$PackagePartMap;", "partToMultifileFacade", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassPartMap;", "protoMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ProtoMap;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToJvmNameMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/SourceToJvmNameMap;", "addToClassStorage", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "srcFile", "classesBySources", "", "sources", "clean", "clearCacheForRemovedClasses", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "debugLog", "message", "", "getClassFilePath", "internalClassName", "getModuleMappingData", "", "getObsoleteJavaClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "getObsoleteMultifileClasses", "getObsoletePackageParts", "getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "partInternalName", "getStableMultifileFacadeParts", "facadeInternalName", "isJavaClassAlreadyInCache", "", "classId", "isJavaClassToTrack", "isMultifileFacade", "className", "isTrackedFile", "file", "saveFileToCache", "generatedClass", "Lorg/jetbrains/kotlin/build/GeneratedJvmClass;", "saveJavaClassProto", "source", "serializedJavaClass", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClass;", "collector", "saveModuleMappingToCache", "sourceFiles", "sourcesByInternalName", "internalName", "Companion", "ConstantsMap", "InlineFunctionsMap", "InternalNameToSourcesMap", "JavaSourcesProtoMap", "MultifileClassFacadeMap", "MultifileClassPartMap", "PackagePartMap", "ProtoMap", "kotlin-build-common"})
public class IncrementalJvmCache
extends IncrementalCacheCommon<JvmClassName>
implements IncrementalCache {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final SourceToJvmNameMap sourceToClassesMap;
    @NotNull
    private final DirtyClassesJvmNameMap dirtyOutputClassesMap;
    private final ProtoMap protoMap;
    private final ConstantsMap constantsMap;
    private final PackagePartMap packagePartMap;
    private final MultifileClassFacadeMap multifileFacadeToParts;
    private final MultifileClassPartMap partToMultifileFacade;
    private final InlineFunctionsMap inlineFunctionsMap;
    private final InternalNameToSourcesMap internalNameToSource;
    private final JavaSourcesProtoMap javaSourcesProtoMap;
    private final Lazy outputDir$delegate;
    private final File targetDataRoot;
    private static final String PROTO_MAP = "proto";
    private static final String CONSTANTS_MAP = "constants";
    private static final String PACKAGE_PARTS = "package-parts";
    private static final String MULTIFILE_CLASS_FACADES = "multifile-class-facades";
    private static final String MULTIFILE_CLASS_PARTS = "multifile-class-parts";
    private static final String INLINE_FUNCTIONS = "inline-functions";
    private static final String INTERNAL_NAME_TO_SOURCE = "internal-name-to-source";
    private static final String JAVA_SOURCES_PROTO_MAP = "java-sources-proto-map";
    private static final String MODULE_MAPPING_FILE_NAME = ".kotlin_module";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(IncrementalJvmCache.class), "outputDir", "getOutputDir()Ljava/io/File;"))};
        Companion = new Companion(null);
        PROTO_MAP = PROTO_MAP;
        CONSTANTS_MAP = CONSTANTS_MAP;
        PACKAGE_PARTS = PACKAGE_PARTS;
        MULTIFILE_CLASS_FACADES = MULTIFILE_CLASS_FACADES;
        MULTIFILE_CLASS_PARTS = MULTIFILE_CLASS_PARTS;
        INLINE_FUNCTIONS = INLINE_FUNCTIONS;
        INTERNAL_NAME_TO_SOURCE = INTERNAL_NAME_TO_SOURCE;
        JAVA_SOURCES_PROTO_MAP = JAVA_SOURCES_PROTO_MAP;
        MODULE_MAPPING_FILE_NAME = "." + ModuleMapping.MAPPING_FILE_EXT;
    }

    @NotNull
    public SourceToJvmNameMap getSourceToClassesMap$kotlin_build_common() {
        return this.sourceToClassesMap;
    }

    @NotNull
    public DirtyClassesJvmNameMap getDirtyOutputClassesMap$kotlin_build_common() {
        return this.dirtyOutputClassesMap;
    }

    private final File getOutputDir() {
        Lazy lazy = this.outputDir$delegate;
        IncrementalJvmCache incrementalJvmCache = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (File)lazy.getValue();
    }

    protected void debugLog(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
    }

    public final boolean isTrackedFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getSourceToClassesMap$kotlin_build_common().contains(file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<JvmClassName> classesBySources(@NotNull Iterable<? extends File> sources) {
        void $receiver$iv$iv;
        Iterable<? extends File> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        Iterable<? extends File> iterable = $receiver$iv = sources;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            File it = (File)element$iv$iv;
            Iterable list$iv$iv = this.getSourceToClassesMap$kotlin_build_common().get(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Collection<File> sourcesByInternalName(@NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
        return this.internalNameToSource.get(internalName);
    }

    public final boolean isMultifileFacade(@NotNull JvmClassName className2) {
        Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
        return this.multifileFacadeToParts.contains(className2);
    }

    @Override
    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        String string = FileUtil.toSystemIndependentName((String)new File(this.getOutputDir(), "" + internalClassName + ".class").getCanonicalPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toSystemIndependentName(\u2026me.class\").canonicalPath)");
        return string;
    }

    public final void saveModuleMappingToCache(@NotNull Collection<? extends File> sourceFiles, @NotNull File file) {
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName(IncrementalJvmCache.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        this.protoMap.storeModuleMapping(jvmClassName2, FilesKt.readBytes((File)file));
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(jvmClassName);
        Iterable $receiver$iv = sourceFiles;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            this.getSourceToClassesMap$kotlin_build_common().add(it, jvmClassName);
        }
    }

    public void saveFileToCache(@NotNull GeneratedJvmClass generatedClass, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkParameterIsNotNull((Object)generatedClass, (String)"generatedClass");
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        Collection<File> sourceFiles = generatedClass.getSourceFiles();
        LocalFileKotlinClass kotlinClass = generatedClass.getOutputClass();
        JvmClassName className2 = kotlinClass.getClassName();
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(className2);
        Iterable $receiver$iv = sourceFiles;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            this.getSourceToClassesMap$kotlin_build_common().add(it, className2);
        }
        String string = className2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
        this.internalNameToSource.set(string, (Iterable<? extends File>)sourceFiles);
        ClassId classId = kotlinClass.getClassId();
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"kotlinClass.classId");
        if (classId.isLocal()) {
            return;
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        switch (IncrementalJvmCache$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                String string2;
                boolean bl;
                boolean bl2 = bl = sourceFiles.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    string2 = "Package part from several source files: " + sourceFiles;
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                this.packagePartMap.addPackagePart(className2);
                this.protoMap.process(kotlinClass, changesCollector);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
                break;
            }
            case 2: {
                Object object = kotlinClass.getClassHeader().getData();
                if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Multifile class has no parts: " + kotlinClass.getClassName())));
                }
                Object partNames = object;
                this.multifileFacadeToParts.set(className2, (Collection)partNames);
                if (this.protoMap.contains(className2)) {
                    FqName fqName2 = className2.getFqNameForClassNameWithoutDollars();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"className.fqNameForClassNameWithoutDollars");
                    changesCollector.collectSignature(fqName2, true);
                }
                this.protoMap.remove(className2, changesCollector);
                IncrementalCacheCommon.ClassFqNameToSourceMap classFqNameToSourceMap = this.getClassFqNameToSourceMap();
                FqName fqName3 = className2.getFqNameForClassNameWithoutDollars();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"className.fqNameForClassNameWithoutDollars");
                classFqNameToSourceMap.remove(fqName3);
                String string3 = className2.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"className.internalName");
                this.internalNameToSource.remove(string3);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
                break;
            }
            case 3: {
                boolean bl;
                String string2;
                boolean bl3 = bl = sourceFiles.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    string2 = "Multifile class part from several source files: " + sourceFiles;
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                this.packagePartMap.addPackagePart(className2);
                String string4 = className2.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"className.internalName");
                String string5 = header.getMultifileClassName();
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                this.partToMultifileFacade.set(string4, string5);
                this.protoMap.process(kotlinClass, changesCollector);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
                break;
            }
            case 4: {
                boolean bl;
                String string2;
                boolean bl4 = bl = sourceFiles.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    string2 = "Class is expected to have only one source file: " + sourceFiles;
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                this.addToClassStorage(kotlinClass, (File)CollectionsKt.first((Iterable)sourceFiles));
                this.protoMap.process(kotlinClass, changesCollector);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveJavaClassProto(@NotNull File source, @NotNull SerializedJavaClass serializedJavaClass, @NotNull ChangesCollector collector) {
        void proto;
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)serializedJavaClass, (String)"serializedJavaClass");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byClassId(serializedJavaClass.getClassId());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        this.javaSourcesProtoMap.process(jvmClassName2, serializedJavaClass, collector);
        this.getSourceToClassesMap$kotlin_build_common().add(source, jvmClassName);
        ClassProtoData classProtoData = JavaClassesTrackerImplKt.toProtoData(serializedJavaClass);
        ProtoBuf.Class clazz = classProtoData.component1();
        NameResolver nameResolver = classProtoData.component2();
        this.addToClassStorage((ProtoBuf.Class)proto, nameResolver, source);
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(jvmClassName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ClassId> getObsoleteJavaClasses() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassId classId;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            JvmClassName it = (JvmClassName)element$iv$iv;
            SerializedJavaClass serializedJavaClass = this.javaSourcesProtoMap.get(it);
            ClassId classId2 = serializedJavaClass != null ? serializedJavaClass.getClassId() : null;
            if (classId2 == null) continue;
            ClassId it$iv$iv = classId = classId2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    public final boolean isJavaClassToTrack(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        JvmClassName jvmClassName = JvmClassName.byClassId(classId);
        DirtyClassesJvmNameMap dirtyClassesJvmNameMap = this.getDirtyOutputClassesMap$kotlin_build_common();
        JvmClassName jvmClassName2 = jvmClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        return dirtyClassesJvmNameMap.isDirty(jvmClassName2) || !this.javaSourcesProtoMap.contains(jvmClassName);
    }

    public final boolean isJavaClassAlreadyInCache(@NotNull ClassId classId) {
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byClassId(classId);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        return this.javaSourcesProtoMap.contains(jvmClassName2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        Collection<FqName> collection;
        void $receiver$iv$iv;
        Object removedParts;
        Object value$iv;
        JvmClassName facade;
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        Collection dirtyClasses = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        HashMap facadesWithRemovedParts = new HashMap();
        for (Object dirtyClass : dirtyClasses) {
            Object object;
            JvmClassName key$iv;
            void $receiver$iv;
            if (this.partToMultifileFacade.get((JvmClassName)dirtyClass) == null) {
                continue;
            }
            JvmClassName facadeClassName = JvmClassName.byInternalName((String)((Object)facade));
            Map map2 = facadesWithRemovedParts;
            Intrinsics.checkExpressionValueIsNotNull((Object)facadeClassName, (String)"facadeClassName");
            value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                HashSet answer$iv = new HashSet();
                $receiver$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            removedParts = (Set)object;
            String string = ((JvmClassName)dirtyClass).getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dirtyClass.internalName");
            removedParts.add(string);
        }
        Object object = facadesWithRemovedParts.entrySet().iterator();
        while (object.hasNext()) {
            void $receiver$iv$iv2;
            Collection<String> allParts;
            Object dirtyClass;
            removedParts = dirtyClass = (Map.Entry)object.next();
            facade = (JvmClassName)removedParts.getKey();
            removedParts = dirtyClass;
            Set removedParts2 = (Set)removedParts.getValue();
            Object object2 = facade;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"facade");
            if (this.multifileFacadeToParts.get((JvmClassName)object2) == null) {
                continue;
            }
            Iterable $receiver$iv = allParts;
            value$iv = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                String it = (String)element$iv$iv;
                if (!(!removedParts2.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List notRemovedParts = (List)destination$iv$iv;
            if (notRemovedParts.isEmpty()) {
                this.multifileFacadeToParts.remove(facade);
                continue;
            }
            this.multifileFacadeToParts.set(facade, notRemovedParts);
        }
        Iterable $receiver$iv = dirtyClasses;
        for (Object element$iv : $receiver$iv) {
            JvmClassName it = (JvmClassName)element$iv;
            this.protoMap.remove(it, changesCollector);
            this.packagePartMap.remove(it);
            this.multifileFacadeToParts.remove(it);
            this.partToMultifileFacade.remove(it);
            this.constantsMap.remove(it);
            this.inlineFunctionsMap.remove(it);
            String string = it.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.internalName");
            this.internalNameToSource.remove(string);
            this.javaSourcesProtoMap.remove(it, changesCollector);
        }
        $receiver$iv = dirtyClasses;
        IncrementalJvmCache incrementalJvmCache = this;
        object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JvmClassName $i$f$forEach = (JvmClassName)item$iv$iv;
            collection = destination$iv$iv;
            FqName fqName2 = it.getFqNameForClassNameWithoutDollars();
            collection.add(fqName2);
        }
        collection = (List)destination$iv$iv;
        incrementalJvmCache.removeAllFromClassStorage(collection, changesCollector);
        this.getDirtyOutputClassesMap$kotlin_build_common().clean();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getObsoletePackageParts() {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        Object object = this.packagePartMap;
        void var4_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            JvmClassName p1 = (JvmClassName)element$iv$iv;
            if (!((PackagePartMap)object).isPackagePart(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List obsoletePackageParts = (List)destination$iv$iv;
        this.debugLog("Obsolete package parts: " + obsoletePackageParts);
        $receiver$iv = obsoletePackageParts;
        object = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (JvmClassName)item$iv$iv;
            Collection collection = destination$iv$iv2;
            String string = it.getInternalName();
            collection.add(string);
        }
        return (List)destination$iv$iv2;
    }

    @Override
    @Nullable
    public JvmPackagePartProto getPackagePartData(@NotNull String partInternalName) {
        JvmPackagePartProto jvmPackagePartProto;
        Intrinsics.checkParameterIsNotNull((Object)partInternalName, (String)"partInternalName");
        JvmClassName jvmClassName = JvmClassName.byInternalName(partInternalName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(partInternalName)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        if (protoMapValue != null) {
            ProtoMapValue protoMapValue2;
            ProtoMapValue value = protoMapValue2 = protoMapValue;
            jvmPackagePartProto = new JvmPackagePartProto(value.getBytes(), value.getStrings());
        } else {
            jvmPackagePartProto = null;
        }
        return jvmPackagePartProto;
    }

    @Override
    @NotNull
    public Collection<String> getObsoleteMultifileClasses() {
        LinkedHashSet<String> obsoleteMultifileClasses = new LinkedHashSet<String>();
        for (JvmClassName dirtyClass : this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses()) {
            String dirtyFacade;
            if (this.partToMultifileFacade.get(dirtyClass) == null) {
                continue;
            }
            obsoleteMultifileClasses.add(dirtyFacade);
        }
        this.debugLog("Obsolete multifile class facades: " + obsoleteMultifileClasses);
        return obsoleteMultifileClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Collection<String> getStableMultifileFacadeParts(@NotNull String facadeInternalName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull((Object)facadeInternalName, (String)"facadeInternalName");
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName(facadeInternalName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        Collection<String> collection = this.multifileFacadeToParts.get(jvmClassName2);
        if (collection == null) {
            return null;
        }
        Collection<String> partNames = collection;
        Iterable iterable = $receiver$iv = (Iterable)partNames;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            DirtyClassesJvmNameMap dirtyClassesJvmNameMap = this.getDirtyOutputClassesMap$kotlin_build_common();
            JvmClassName jvmClassName3 = JvmClassName.byInternalName(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"JvmClassName.byInternalName(it)");
            if (!(!dirtyClassesJvmNameMap.isDirty(jvmClassName3))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public byte[] getModuleMappingData() {
        JvmClassName jvmClassName = JvmClassName.byInternalName(IncrementalJvmCache.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026MODULE_MAPPING_FILE_NAME)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        return (byte[])(protoMapValue != null ? protoMapValue.getBytes() : null);
    }

    @Override
    public void clean() {
        super.clean();
        CacheVersionKt.normalCacheVersion$default(this.targetDataRoot, null, 2, null).clean();
    }

    /*
     * WARNING - void declaration
     */
    private final void addToClassStorage(LocalFileKotlinClass kotlinClass, File srcFile) {
        void nameResolver;
        String[] stringArray = kotlinClass.getClassHeader().getData();
        if (stringArray == null) {
            Intrinsics.throwNpe();
        }
        String[] stringArray2 = kotlinClass.getClassHeader().getStrings();
        if (stringArray2 == null) {
            Intrinsics.throwNpe();
        }
        ClassData classData = JvmProtoBufUtil.readClassDataFrom(stringArray, stringArray2);
        NameResolver nameResolver2 = classData.component1();
        ProtoBuf.Class proto = classData.component2();
        this.addToClassStorage(proto, (NameResolver)nameResolver, srcFile);
    }

    public IncrementalJvmCache(@NotNull File targetDataRoot, @Nullable File targetOutputDir) {
        Intrinsics.checkParameterIsNotNull((Object)targetDataRoot, (String)"targetDataRoot");
        super(new File(targetDataRoot, IncrementalJvmCacheKt.getKOTLIN_CACHE_DIRECTORY_NAME()));
        this.targetDataRoot = targetDataRoot;
        this.sourceToClassesMap = (SourceToJvmNameMap)this.registerMap((BasicMap)new SourceToJvmNameMap(this.getStorageFile(IncrementalCacheCommon.Companion.getSOURCE_TO_CLASSES())));
        this.dirtyOutputClassesMap = (DirtyClassesJvmNameMap)this.registerMap((BasicMap)new DirtyClassesJvmNameMap(this.getStorageFile(IncrementalCacheCommon.Companion.getDIRTY_OUTPUT_CLASSES())));
        this.protoMap = (ProtoMap)this.registerMap((BasicMap)new ProtoMap(this.getStorageFile(IncrementalJvmCache.Companion.getPROTO_MAP())));
        this.constantsMap = (ConstantsMap)this.registerMap((BasicMap)new ConstantsMap(this.getStorageFile(IncrementalJvmCache.Companion.getCONSTANTS_MAP())));
        this.packagePartMap = (PackagePartMap)this.registerMap((BasicMap)new PackagePartMap(this.getStorageFile(IncrementalJvmCache.Companion.getPACKAGE_PARTS())));
        this.multifileFacadeToParts = (MultifileClassFacadeMap)this.registerMap((BasicMap)new MultifileClassFacadeMap(this.getStorageFile(IncrementalJvmCache.Companion.getMULTIFILE_CLASS_FACADES())));
        this.partToMultifileFacade = (MultifileClassPartMap)this.registerMap((BasicMap)new MultifileClassPartMap(this.getStorageFile(IncrementalJvmCache.Companion.getMULTIFILE_CLASS_PARTS())));
        this.inlineFunctionsMap = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(IncrementalJvmCache.Companion.getINLINE_FUNCTIONS())));
        this.internalNameToSource = (InternalNameToSourcesMap)this.registerMap((BasicMap)new InternalNameToSourcesMap(this.getStorageFile(IncrementalJvmCache.Companion.getINTERNAL_NAME_TO_SOURCE())));
        this.javaSourcesProtoMap = (JavaSourcesProtoMap)this.registerMap((BasicMap)new JavaSourcesProtoMap(this.getStorageFile(IncrementalJvmCache.Companion.getJAVA_SOURCES_PROTO_MAP())));
        this.outputDir$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(targetOutputDir){
            final /* synthetic */ File $targetOutputDir;

            @NotNull
            public final File invoke() {
                File file = this.$targetOutputDir;
                if (file == null) {
                    String string = "Target is expected to have output directory";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                return file;
            }
            {
                this.$targetOutputDir = file;
                super(0);
            }
        }));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ProtoMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "put", "remove", "storeModuleMapping", "bytes", "", "kotlin-build-common"})
    private final class ProtoMap
    extends BasicStringMap<ProtoMapValue> {
        public final void process(@NotNull LocalFileKotlinClass kotlinClass, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
            this.put(kotlinClass, changesCollector);
        }

        public final void storeModuleMapping(@NotNull JvmClassName className2, @NotNull byte[] bytes) {
            String[] stringArray;
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            LazyStorage<String, ProtoMapValue> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            byte[] byArray = bytes;
            boolean bl = false;
            String string2 = string;
            LazyStorage<String, ProtoMapValue> lazyStorage2 = lazyStorage;
            String[] stringArray2 = stringArray = new String[0];
            byte[] byArray2 = byArray;
            boolean bl2 = bl;
            lazyStorage2.set(string2, new ProtoMapValue(bl2, byArray2, stringArray2));
        }

        private final void put(LocalFileKotlinClass kotlinClass, ChangesCollector changesCollector) {
            ProtoData protoData;
            KotlinClassHeader header = kotlinClass.getClassHeader();
            String key = kotlinClass.getClassName().getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            ProtoMapValue oldData = (ProtoMapValue)lazyStorage.get(string);
            boolean bl = Intrinsics.areEqual((Object)((Object)header.getKind()), (Object)((Object)KotlinClassHeader.Kind.CLASS)) ^ true;
            String[] stringArray = header.getData();
            if (stringArray == null) {
                Intrinsics.throwNpe();
            }
            byte[] byArray = BitEncoding.decodeBytes(stringArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"BitEncoding.decodeBytes(header.data!!)");
            String[] stringArray2 = header.getStrings();
            if (stringArray2 == null) {
                Intrinsics.throwNpe();
            }
            ProtoMapValue newData = new ProtoMapValue(bl, byArray, stringArray2);
            this.getStorage().set(key, newData);
            FqName packageFqName = kotlinClass.getClassName().getPackageFqName();
            ProtoMapValue protoMapValue = oldData;
            if (protoMapValue != null) {
                FqName fqName2 = packageFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
                protoData = ProtoDifferenceUtilsKt.toProtoData(protoMapValue, fqName2);
            } else {
                protoData = null;
            }
            FqName fqName3 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"packageFqName");
            ChangesCollector.collectProtoChanges$default(changesCollector, protoData, ProtoDifferenceUtilsKt.toProtoData(newData, fqName3), false, 4, null);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Nullable
        public final ProtoMapValue get(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return (ProtoMapValue)lazyStorage.get(string);
        }

        public final void remove(@NotNull JvmClassName className2, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            ProtoMapValue protoMapValue = (ProtoMapValue)lazyStorage.get(string);
            if (protoMapValue == null) {
                return;
            }
            ProtoMapValue oldValue = protoMapValue;
            if (Intrinsics.areEqual((Object)key, (Object)Companion.getMODULE_MAPPING_FILE_NAME()) ^ true) {
                FqName fqName2 = className2.getPackageFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"className.packageFqName");
                ChangesCollector.collectProtoChanges$default(changesCollector, ProtoDifferenceUtilsKt.toProtoData(oldValue, fqName2), null, false, 4, null);
            }
            this.getStorage().remove(key);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull ProtoMapValue value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return (value.isPackageFacade() ? "1" : "0") + Long.toHexString(IncrementalJvmCacheKt.md5(value.getBytes()));
        }

        public ProtoMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ProtoMapValueExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$JavaSourcesProtoMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClass;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "", "jvmClassName", "newData", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "kotlin-build-common"})
    private final class JavaSourcesProtoMap
    extends BasicStringMap<SerializedJavaClass> {
        public final void process(@NotNull JvmClassName jvmClassName, @NotNull SerializedJavaClass newData, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkParameterIsNotNull((Object)jvmClassName, (String)"jvmClassName");
            Intrinsics.checkParameterIsNotNull((Object)newData, (String)"newData");
            Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
            String key = jvmClassName.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            SerializedJavaClass oldData = (SerializedJavaClass)lazyStorage.get(string);
            this.getStorage().set(key, newData);
            SerializedJavaClass serializedJavaClass = oldData;
            changesCollector.collectProtoChanges(serializedJavaClass != null ? JavaClassesTrackerImplKt.toProtoData(serializedJavaClass) : null, JavaClassesTrackerImplKt.toProtoData(newData), true);
        }

        public final void remove(@NotNull JvmClassName className2, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            SerializedJavaClass serializedJavaClass = (SerializedJavaClass)lazyStorage.get(string);
            if (serializedJavaClass == null) {
                return;
            }
            SerializedJavaClass oldValue = serializedJavaClass;
            this.getStorage().remove(key);
            ChangesCollector.collectProtoChanges$default(changesCollector, JavaClassesTrackerImplKt.toProtoData(oldValue), null, false, 4, null);
        }

        @Nullable
        public final SerializedJavaClass get(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return (SerializedJavaClass)lazyStorage.get(string);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull SerializedJavaClass value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            byte[] byArray = value.getProto().toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"value.proto.toByteArray()");
            String string = Long.toHexString(IncrementalJvmCacheKt.md5(byArray));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Long.toHexStri\u2026roto.toByteArray().md5())");
            return string;
        }

        public JavaSourcesProtoMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, JavaClassProtoMapValueExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u001c\u0010\f\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ConstantsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "getConstantsMap", "bytes", "", "process", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "kotlin-build-common"})
    private final class ConstantsMap
    extends BasicStringMap<Map<String, ? extends Object>> {
        private final Map<String, Object> getConstantsMap(byte[] bytes) {
            HashMap result = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(result, 327680){
                final /* synthetic */ HashMap $result;

                @Nullable
                public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    int staticFinal = 26;
                    if (value != null && (access & staticFinal) == 24) {
                        Map map2 = this.$result;
                        Object object = value;
                        map2.put(name, object);
                    }
                    return null;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }, 7);
            return result;
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        public final void process(@NotNull LocalFileKotlinClass kotlinClass, @NotNull ChangesCollector changesCollector) {
            Map<String, Object> newMap;
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
            String key = kotlinClass.getClassName().getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            Map map2 = (Map)lazyStorage.get(string);
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map oldMap = map2;
            Map<String, Object> map3 = newMap = this.getConstantsMap(kotlinClass.getFileContents());
            if (!map3.isEmpty()) {
                this.getStorage().set(key, newMap);
            } else {
                this.getStorage().remove(key);
            }
            for (String string2 : SetsKt.plus(oldMap.keySet(), (Iterable)newMap.keySet())) {
                FqName fqName2 = IncrementalJvmCacheKt.access$scopeFqName(kotlinClass);
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"kotlinClass.scopeFqName()");
                changesCollector.collectMemberIfValueWasChanged(fqName2, string2, oldMap.get(string2), newMap.get(string2));
            }
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalJvmCacheKt.dumpMap(value, dumpValue.1.INSTANCE);
        }

        public ConstantsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ConstantsMapExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u000e\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$PackagePartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "addPackagePart", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "isPackagePart", "remove", "kotlin-build-common"})
    private final class PackagePartMap
    extends BasicStringMap<Boolean> {
        public final void addPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage<String, Boolean> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, true);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        public final boolean isPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public PackagePartMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            BooleanDataDescriptor booleanDataDescriptor = BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)booleanDataDescriptor, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, (DataExternalizer)booleanDataDescriptor);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u0016\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0086\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassFacadeMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "get", "remove", "", "set", "partNames", "kotlin-build-common"})
    private final class MultifileClassFacadeMap
    extends BasicStringMap<Collection<? extends String>> {
        public final void set(@NotNull JvmClassName className2, @NotNull Collection<String> partNames) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull(partNames, (String)"partNames");
            LazyStorage<String, Collection<String>> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, partNames);
        }

        @Nullable
        public final Collection<String> get(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return (Collection)lazyStorage.get(string);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalJvmCacheKt.dumpCollection(value);
        }

        public MultifileClassFacadeMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassPartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "get", "partName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "remove", "", "className", "set", "facadeName", "kotlin-build-common"})
    private final class MultifileClassPartMap
    extends BasicStringMap<String> {
        public final void set(@NotNull String partName, @NotNull String facadeName) {
            Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            this.getStorage().set(partName, facadeName);
        }

        @Nullable
        public final String get(@NotNull JvmClassName partName) {
            Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
            LazyStorage lazyStorage = this.getStorage();
            String string = partName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"partName.internalName");
            return (String)lazyStorage.get(string);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return value;
        }

        public MultifileClassPartMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)enumeratorStringDescriptor, (String)"EnumeratorStringDescriptor.INSTANCE");
            super(storageFile, (DataExternalizer)enumeratorStringDescriptor);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0003J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0086\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InternalNameToSourcesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "get", "internalName", "remove", "", "set", "sourceFiles", "", "kotlin-build-common"})
    public final class InternalNameToSourcesMap
    extends BasicStringMap<Collection<? extends String>> {
        /*
         * WARNING - void declaration
         */
        public final void set(@NotNull String internalName, @NotNull Iterable<? extends File> sourceFiles) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
            Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
            Iterable<? extends File> iterable = sourceFiles;
            String string = internalName;
            LazyStorage<String, List> lazyStorage = this.getStorage();
            void var4_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                String string2 = it.getCanonicalPath();
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            lazyStorage.set(string, (List)collection);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<File> get(@NotNull String internalName) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
            Collection collection = (Collection)this.getStorage().get(internalName);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Iterable iterable = $receiver$iv = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                File file = new File((String)p1);
                collection2.add(file);
            }
            return (List)destination$iv$iv;
        }

        public final void remove(@NotNull String internalName) {
            Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
            this.getStorage().remove(internalName);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalJvmCacheKt.dumpCollection(value);
        }

        public InternalNameToSourcesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, (KeyDescriptor<String>)((KeyDescriptor)new EnumeratorStringDescriptor()), (DataExternalizer)PathCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "functionNameBySignature", "signature", "getInlineFunctionsMap", "header", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "bytes", "", "process", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "kotlin-build-common"})
    private final class InlineFunctionsMap
    extends BasicStringMap<Map<String, ? extends Long>> {
        private final Map<String, Long> getInlineFunctionsMap(KotlinClassHeader header, byte[] bytes) {
            Set inlineFunctions = InlineUtilKt.inlineFunctionsJvmNames((KotlinClassHeader)header);
            if (inlineFunctions.isEmpty()) {
                return MapsKt.emptyMap();
            }
            HashMap result = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(inlineFunctions, result, 327680){
                final /* synthetic */ Set $inlineFunctions;
                final /* synthetic */ HashMap $result;

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    ClassWriter dummyClassWriter = new ClassWriter(327680);
                    return new MethodVisitor(this, name, desc, dummyClassWriter, exceptions, 327680, dummyClassWriter.visitMethod(0, name, desc, null, exceptions)){
                        final /* synthetic */ getInlineFunctionsMap.1 this$0;
                        final /* synthetic */ String $name;
                        final /* synthetic */ String $desc;
                        final /* synthetic */ ClassWriter $dummyClassWriter;
                        final /* synthetic */ String[] $exceptions;

                        public void visitEnd() {
                            String jvmName = this.$name + this.$desc;
                            if (!this.this$0.$inlineFunctions.contains(jvmName)) {
                                return;
                            }
                            byte[] byArray = this.$dummyClassWriter.toByteArray();
                            if (byArray == null) {
                                Intrinsics.throwNpe();
                            }
                            byte[] dummyBytes = byArray;
                            long hash = IncrementalJvmCacheKt.md5(dummyBytes);
                            Map map2 = this.this$0.$result;
                            Long l = hash;
                            map2.put(jvmName, l);
                        }
                        {
                            this.this$0 = $outer;
                            this.$name = $captured_local_variable$1;
                            this.$desc = $captured_local_variable$2;
                            this.$dummyClassWriter = $captured_local_variable$3;
                            this.$exceptions = $captured_local_variable$4;
                            super($super_call_param$5, $super_call_param$6);
                        }
                    };
                }
                {
                    this.$inlineFunctions = $captured_local_variable$0;
                    this.$result = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            }, 0);
            return result;
        }

        public final void process(@NotNull LocalFileKotlinClass kotlinClass, @NotNull ChangesCollector changesCollector) {
            Map<String, Long> newMap;
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
            String key = kotlinClass.getClassName().getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            Map map2 = (Map)lazyStorage.get(string);
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map oldMap = map2;
            KotlinClassHeader kotlinClassHeader = kotlinClass.getClassHeader();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinClassHeader, (String)"kotlinClass.classHeader");
            Map<String, Long> map3 = newMap = this.getInlineFunctionsMap(kotlinClassHeader, kotlinClass.getFileContents());
            if (!map3.isEmpty()) {
                this.getStorage().set(key, newMap);
            } else {
                this.getStorage().remove(key);
            }
            for (String fn : SetsKt.plus(oldMap.keySet(), (Iterable)newMap.keySet())) {
                FqName fqName2 = IncrementalJvmCacheKt.access$scopeFqName(kotlinClass);
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"kotlinClass.scopeFqName()");
                changesCollector.collectMemberIfValueWasChanged(fqName2, this.functionNameBySignature(fn), oldMap.get(fn), newMap.get(fn));
            }
        }

        private final String functionNameBySignature(String signature) {
            return StringsKt.substringBefore$default((String)signature, (String)"(", null, (int)2, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, Long> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalJvmCacheKt.dumpMap(value, dumpValue.1.INSTANCE);
        }

        public InlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringToLongMapExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$Companion;", "", "()V", "CONSTANTS_MAP", "", "getCONSTANTS_MAP", "()Ljava/lang/String;", "INLINE_FUNCTIONS", "getINLINE_FUNCTIONS", "INTERNAL_NAME_TO_SOURCE", "getINTERNAL_NAME_TO_SOURCE", "JAVA_SOURCES_PROTO_MAP", "getJAVA_SOURCES_PROTO_MAP", "MODULE_MAPPING_FILE_NAME", "getMODULE_MAPPING_FILE_NAME", "MULTIFILE_CLASS_FACADES", "getMULTIFILE_CLASS_FACADES", "MULTIFILE_CLASS_PARTS", "getMULTIFILE_CLASS_PARTS", "PACKAGE_PARTS", "getPACKAGE_PARTS", "PROTO_MAP", "getPROTO_MAP", "kotlin-build-common"})
    public static final class Companion {
        private final String getPROTO_MAP() {
            return PROTO_MAP;
        }

        private final String getCONSTANTS_MAP() {
            return CONSTANTS_MAP;
        }

        private final String getPACKAGE_PARTS() {
            return PACKAGE_PARTS;
        }

        private final String getMULTIFILE_CLASS_FACADES() {
            return MULTIFILE_CLASS_FACADES;
        }

        private final String getMULTIFILE_CLASS_PARTS() {
            return MULTIFILE_CLASS_PARTS;
        }

        private final String getINLINE_FUNCTIONS() {
            return INLINE_FUNCTIONS;
        }

        private final String getINTERNAL_NAME_TO_SOURCE() {
            return INTERNAL_NAME_TO_SOURCE;
        }

        private final String getJAVA_SOURCES_PROTO_MAP() {
            return JAVA_SOURCES_PROTO_MAP;
        }

        private final String getMODULE_MAPPING_FILE_NAME() {
            return MODULE_MAPPING_FILE_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

