/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.core;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.struts.core.PsiBeanProperty;
import com.intellij.struts.core.PsiBeanPropertyImpl;
import java.util.HashMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBeanPropertyCache {
    @NonNls
    private static final String ACTION_FORM = "org.apache.struts.action.ActionForm";
    @NonNls
    private static final String VALIDATOR_FORM = "org.apache.struts.validator.ValidatorForm";
    private final HashMap<String, PsiClassInfo> cache = new HashMap();

    @NotNull
    public static PsiBeanPropertyCache getInstance(Project project) {
        PsiBeanPropertyCache psiBeanPropertyCache = (PsiBeanPropertyCache)ServiceManager.getService((Project)project, PsiBeanPropertyCache.class);
        if (psiBeanPropertyCache == null) {
            PsiBeanPropertyCache.$$$reportNull$$$0(0);
        }
        return psiBeanPropertyCache;
    }

    @NotNull
    public PsiBeanProperty[] getBeanProperties(@Nullable PsiClass clazz) {
        PsiFile psiFile;
        if (clazz == null) {
            if (PsiBeanProperty.EMPTY_ARRAY == null) {
                PsiBeanPropertyCache.$$$reportNull$$$0(1);
            }
            return PsiBeanProperty.EMPTY_ARRAY;
        }
        String className = clazz.getQualifiedName();
        PsiClassInfo info = this.cache.get(className);
        if (info != null && (psiFile = clazz.getContainingFile()) != null) {
            long l = psiFile.getModificationStamp();
            if (info.clazz == clazz && l == info.modificationStamp) {
                PsiBeanProperty[] psiBeanPropertyArray = info.props;
                if (psiBeanPropertyArray == null) {
                    PsiBeanPropertyCache.$$$reportNull$$$0(2);
                }
                return psiBeanPropertyArray;
            }
        }
        PsiMethod[] methods = clazz.getAllMethods();
        TreeSet<PsiBeanPropertyImpl> props = new TreeSet<PsiBeanPropertyImpl>();
        for (PsiMethod method : methods) {
            String name;
            String containing;
            if (!method.hasModifierProperty("public") || "java.lang.Object".equals(containing = method.getContainingClass().getQualifiedName()) || ACTION_FORM.equals(containing) || VALIDATOR_FORM.equals(containing) || (name = PropertyUtilBase.getPropertyName((PsiMethod)method)) == null) continue;
            PsiField field = PropertyUtilBase.findPropertyField((PsiClass)clazz, (String)name, (boolean)method.hasModifierProperty("static"));
            if (field != null && !field.hasModifierProperty("public")) {
                field = null;
            }
            PsiBeanPropertyImpl prop = new PsiBeanPropertyImpl(clazz, name, field);
            props.add(prop);
        }
        info = new PsiClassInfo();
        info.clazz = clazz;
        PsiFile psiFile2 = clazz.getContainingFile();
        if (psiFile2 != null) {
            info.modificationStamp = psiFile2.getModificationStamp();
        }
        PsiClassInfo.access$202(info, props.toArray(PsiBeanProperty.EMPTY_ARRAY));
        this.cache.put(className, info);
        PsiBeanProperty[] psiBeanPropertyArray = info.props;
        if (psiBeanPropertyArray == null) {
            PsiBeanPropertyCache.$$$reportNull$$$0(3);
        }
        return psiBeanPropertyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/struts/core/PsiBeanPropertyCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanProperties";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PsiClassInfo {
        private PsiClass clazz;
        private PsiBeanProperty[] props;
        private long modificationStamp;

        private PsiClassInfo() {
        }

        static /* synthetic */ PsiBeanProperty[] access$202(PsiClassInfo x0, PsiBeanProperty[] x1) {
            x0.props = x1;
            return x1;
        }
    }
}

