/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting.artifacts;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.javaee.converting.artifacts.AbstractPackagingConverter;
import com.intellij.javaee.converting.artifacts.JavaeeFacetConversionProcessor;
import com.intellij.javaee.converting.artifacts.JavaeeRunConfigurationsConverter;
import com.intellij.javaee.converting.artifacts.PackagingConversionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.util.PathUtil;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;

public class JavaeePackagingConverter
extends AbstractPackagingConverter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.converting.artifacts.JavaeePackagingConverter");
    private Map<String, ArtifactState> myExplodedArtifacts = new HashMap<String, ArtifactState>();
    private Map<String, ArtifactState> myArchiveArtifacts = new HashMap<String, ArtifactState>();
    private Map<String, Element> myRootElements = new HashMap<String, Element>();
    private Map<String, Element> myExternalElements = new HashMap<String, Element>();
    private TObjectIntHashMap<String> myFacet2InclusionsCount = new TObjectIntHashMap();
    private MultiValuesMap<Element, Element> myIncludedElements = new MultiValuesMap(true);
    private Map<String, List<String>> myClasspathMap = new HashMap<String, List<String>>();
    private Set<String> myFacetsWithoutOutput = new HashSet<String>();

    public JavaeePackagingConverter(ConversionContext context) {
        super(context);
    }

    public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
        return new JavaeeFacetConversionProcessor(this);
    }

    public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
        return new JavaeeRunConfigurationsConverter(this);
    }

    public void registerExplodedArtifact(String facetPointer, @Nullable String explodedPath) {
        this.myExplodedArtifacts.put(facetPointer, JavaeePackagingConverter.createArtifactState(facetPointer, true, explodedPath));
    }

    private static ArtifactState createArtifactState(String facetPointer, boolean exploded, @Nullable String outputPath) {
        ArtifactState state = new ArtifactState();
        state.setName(JavaeePackagingConverter.getArtifactName(facetPointer, exploded));
        state.setArtifactType(JavaeePackagingConverter.getArtifactType(FacetPointersManager.getFacetType((String)facetPointer), exploded));
        if (outputPath != null) {
            state.setOutputPath(outputPath);
        }
        return state;
    }

    public static String getArtifactName(String facetPointer, boolean exploded) {
        return FacetPointersManager.getModuleName((String)facetPointer) + ":" + FacetPointersManager.getFacetName((String)facetPointer) + (exploded ? " exploded" : "");
    }

    private static String getArtifactType(String facetType, boolean exploded) {
        if ("web".equals(facetType)) {
            return exploded ? "exploded-war" : "war";
        }
        if ("ejb".equals(facetType)) {
            return exploded ? "exploded-ejb" : "ejb-jar";
        }
        if ("javaeeApplication".equals(facetType)) {
            return exploded ? "exploded-ear" : "ear";
        }
        throw new AssertionError((Object)(facetType + " is not JavaEE facet type"));
    }

    public void registerArchiveArtifact(@NotNull String facetPointer, @NotNull String jarPath) throws CannotConvertException {
        if (facetPointer == null) {
            JavaeePackagingConverter.$$$reportNull$$$0(0);
        }
        if (jarPath == null) {
            JavaeePackagingConverter.$$$reportNull$$$0(1);
        }
        String outputPath = PathUtil.getParentPath((String)jarPath);
        ArtifactState state = JavaeePackagingConverter.createArtifactState(facetPointer, false, outputPath);
        Element root = PackagingConversionUtil.createDirectoryOrArchive(PathUtil.getFileName((String)jarPath), true);
        PackagingConversionUtil.addArtifact(root, JavaeePackagingConverter.getArtifactName(facetPointer, true));
        state.setRootElement(root);
        this.myArchiveArtifacts.put(facetPointer, state);
    }

    @Nullable
    public ArtifactState getExplodedArtifact(String facetPointer) {
        return this.myExplodedArtifacts.get(facetPointer);
    }

    public void registerIncludedFacet(String parentFacetPointer, String includedFacetPointer) {
        if (!this.myFacet2InclusionsCount.contains((Object)includedFacetPointer)) {
            this.myFacet2InclusionsCount.put((Object)includedFacetPointer, 0);
        }
        this.myFacet2InclusionsCount.increment((Object)includedFacetPointer);
        LOG.debug("Facet " + includedFacetPointer + " is included in " + parentFacetPointer);
    }

    public void preProcessingFinished() {
        this.myFacet2InclusionsCount.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String facetPointer, int count) {
                if (count >= 2 && !JavaeePackagingConverter.this.myExplodedArtifacts.containsKey(facetPointer)) {
                    LOG.debug(facetPointer + " facet is included in " + count + " facets so exploded artifact will be created for it");
                    JavaeePackagingConverter.this.registerExplodedArtifact(facetPointer, null);
                }
                return true;
            }
        });
        for (String facetPointer : this.myFacetsWithoutOutput) {
            if (this.myFacet2InclusionsCount.containsKey((Object)facetPointer) || this.myExplodedArtifacts.containsKey(facetPointer)) continue;
            LOG.debug(facetPointer + " is not included into any facet and doesn't have output specified so exploded artifact will be created");
            this.registerExplodedArtifact(facetPointer, null);
        }
    }

    public void postProcessingFinished() throws CannotConvertException {
        Set parentsSet = this.myIncludedElements.keySet();
        Element[] parents = parentsSet.toArray(new Element[0]);
        for (Element parent : parents) {
            Collection included = this.myIncludedElements.get((Object)parent);
            if (included == null) continue;
            for (Element element : included) {
                PackagingConversionUtil.addChildElements(parent, element, this.myIncludedElements);
            }
        }
        for (Map.Entry entry : this.myExplodedArtifacts.entrySet()) {
            ((ArtifactState)entry.getValue()).setRootElement(this.getOrCreateRootElement((String)entry.getKey()));
        }
        this.saveArtifacts(this.myExplodedArtifacts.values());
        this.saveArtifacts(this.myArchiveArtifacts.values());
    }

    public Element getOrCreateRootElement(String facetPointer) {
        Element element = this.myRootElements.get(facetPointer);
        if (element == null) {
            element = PackagingConversionUtil.createArtifactRoot();
            this.myRootElements.put(facetPointer, element);
        }
        return element;
    }

    public Element getOrCreateExternalElement(String facetPointer) {
        Element element = this.myExternalElements.get(facetPointer);
        if (element == null) {
            element = new Element("temp");
            this.myExternalElements.put(facetPointer, element);
        }
        return element;
    }

    public void include(Element parent, Element included) {
        this.myIncludedElements.put((Object)parent, (Object)included);
    }

    public List<String> getClasspath(String facetPointer) {
        return this.myClasspathMap.get(facetPointer);
    }

    public List<String> getOrCreateClasspath(String facetPointer) {
        List<String> classpath = this.myClasspathMap.get(facetPointer);
        if (classpath == null) {
            classpath = new ArrayList<String>();
            this.myClasspathMap.put(facetPointer, classpath);
        }
        return classpath;
    }

    public void registerFacetWithoutOutput(String facetPointer) {
        this.myFacetsWithoutOutput.add(facetPointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "facetPointer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "jarPath";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/converting/artifacts/JavaeePackagingConverter";
        objectArray[2] = "registerArchiveArtifact";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

