/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbClassBasicInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbClassWarningsInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.ejb.class.warnings", new Object[0]);
        if (string == null) {
            EjbClassWarningsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbClassWarningsInspection" == null) {
            EjbClassWarningsInspection.$$$reportNull$$$0(1);
        }
        return "EjbClassWarningsInspection";
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        return EjbClassWarningsInspection.getRoleTypes(OldEjbRolesUtil.getEjbRoles(psiClass)).contains(EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS);
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbClassWarningsInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(aClass);
                if (!EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS, classRoles)) {
                    return;
                }
                EjbClassWarningsInspection.checkClassExtends(holder, aClass, classRoles);
            }

            public void visitMethod(PsiMethod method) {
                EjbClassWarningsInspection.checkMethod(holder, method, OldEjbRolesUtil.getEjbRoles(method.getContainingClass()));
            }

            public void visitField(PsiField field) {
                EjbClassWarningsInspection.checkField(holder, field);
            }
        };
    }

    public static void checkMethod(ProblemsHolder holder, PsiMethod method, EjbClassRole[] classRoles) {
        EjbClassRole role;
        EjbClassRole[] ejbClassRoleArray = classRoles;
        int n = ejbClassRoleArray.length;
        for (int i = 0; !(i >= n || (role = ejbClassRoleArray[i]).getEnterpriseBean() != null && EjbUtil.isEjbVersion1x((JavaeeModelElement)role.getEnterpriseBean()) && EjbClassWarningsInspection.checkThrowsRemoteException(holder, method, role)); ++i) {
        }
    }

    private static boolean checkThrowsRemoteException(ProblemsHolder holder, PsiMethod method, EjbClassRole classRole) {
        return EjbClassBasicInspection.checkThrowsRemoteException(holder, method, classRole);
    }

    private static void checkField(ProblemsHolder holder, PsiField field) {
        if (field.hasModifierProperty("static") && !field.hasModifierProperty("final")) {
            holder.registerProblem((PsiElement)field, EjbHighlightingMessages.message("static.fields.only.recommended", new Object[0]), new LocalQuickFix[]{QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)field, "final", true, false)});
        }
    }

    private static void checkClassExtends(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRole) {
        HashSet<String> shouldNotImplement = new HashSet<String>();
        for (EjbClassRole role : classRole) {
            EnterpriseBean ejb = role.getEnterpriseBean();
            if (ejb == null) continue;
            if (ejb instanceof SessionBean) {
                shouldNotImplement.add("javax.ejb.EntityBean");
                shouldNotImplement.add("javax.ejb.MessageDrivenBean");
            } else if (ejb instanceof EntityBean) {
                shouldNotImplement.add("javax.ejb.SessionBean");
                shouldNotImplement.add("javax.ejb.MessageDrivenBean");
            } else if (ejb instanceof MessageDrivenBean) {
                shouldNotImplement.add("javax.ejb.SessionBean");
                shouldNotImplement.add("javax.ejb.EntityBean");
            }
            if (!(ejb instanceof EjbWithHome)) continue;
            EjbWithHome ejbWithHome = (EjbWithHome)ejb;
            shouldNotImplement.add(ejbWithHome.getHome().getStringValue());
            shouldNotImplement.add(ejbWithHome.getLocalHome().getStringValue());
            shouldNotImplement.add(ejbWithHome.getRemote().getStringValue());
            shouldNotImplement.add(ejbWithHome.getLocal().getStringValue());
        }
        for (String interfaceName : shouldNotImplement) {
            if (StringUtil.isEmptyOrSpaces((String)interfaceName)) continue;
            EjbHighlightUtil.checkClassExtends(holder, aClass, interfaceName, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbClassWarningsInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbClassWarningsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

