/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.migration;

import com.intellij.jam.JamElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbMethod;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.migration.ApplyJavaeeStyleConfiguration;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.annotations.ejb.JavaeeReferenceImpl;
import com.intellij.javaee.model.common.EjbReference;
import com.intellij.javaee.model.common.EnvironmentGroup;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.JavaeeReference;
import com.intellij.javaee.model.common.Resource;
import com.intellij.javaee.model.common.ServiceRef;
import com.intellij.javaee.model.common.ejb.ActivationConfigProperty;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.CmrField;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EnterpriseBeanType;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.model.common.ejb.InterceptorMethodContainer;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.Query;
import com.intellij.javaee.model.common.ejb.SecurityRoleRef;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.enums.MethodIntf;
import com.intellij.javaee.model.enums.Multiplicity;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.javaee.model.enums.ResAuth;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.javaee.model.enums.TransAttribute;
import com.intellij.javaee.model.enums.TransactionType;
import com.intellij.javaee.model.xml.EjbRef;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.JndiEnvironmentRefsGroup;
import com.intellij.javaee.model.xml.compatibility.MessageDrivenDestinationType;
import com.intellij.javaee.model.xml.compatibility.SubscriptionDurabilityType;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.InterceptorBinding;
import com.intellij.javaee.model.xml.ejb.Method;
import com.intellij.javaee.model.xml.persistence.Persistence;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.mapping.AccessType;
import com.intellij.javaee.util.AnnotationTextUtil;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NonNls;

public class JavaeeStyleEngine {
    private static final String TRANSACTION_MANAGEMENT_TYPE_PREFIX = "javax.ejb.TransactionManagementType.";
    private static final String TRANSACTION_TYPE_PREFIX = "javax.ejb.TransactionAttributeType.";
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.javaee.ejb.migration.JavaeeStyleEngine");
    @NonNls
    private static final String CREATE_METHOD_PREFIX = "create";
    @NonNls
    private static final String LOOKUP_METHOD_NAME = "lookup";
    @NonNls
    private static final String THIS_PREFIX = "this.";
    @NonNls
    private static final String NARROW_METHOD_NAME = "narrow";
    @NonNls
    private static final String JAVAX_RMI_PORTABLE_REMOTE_OBJECT = "javax.rmi.PortableRemoteObject";
    @NonNls
    private static final String EJB_VERSION_3_0 = "3.0";
    @NonNls
    private static final String JAVAEE_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    @NonNls
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    @NonNls
    private static final String EJB_SCHEMA_LOCATION_3_0 = "http://java.sun.com/xml/ns/javaee\n\t\t  http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd";
    @NonNls
    private static final String NARROW_METHOD_PATTERN = "Object narrow(Object o, Class c) { return null; }";
    @NonNls
    private static final String LOOKUP_METHOD_PATTERN = "Object lookup(String s) { return null; }";
    private Map<PsiClass, PsiClass> homeReplaceMap = new HashMap<PsiClass, PsiClass>();
    private Map<PsiElement, MyUsageInfo> usageInfos = new HashMap<PsiElement, MyUsageInfo>();
    private Map<PsiClass, Map<String, PsiField>> addedFieldsMap = new HashMap<PsiClass, Map<String, PsiField>>();
    private Map<PsiElement, String> variablePostfixMap = new HashMap<PsiElement, String>();
    private Map<PsiElement, Set<String>> nameNotFoundChecksMap = new HashMap<PsiElement, Set<String>>();
    private Set<PsiFile> fileWithInvalidValues = new HashSet<PsiFile>();
    private Set<PsiElement> initializerElements = new HashSet<PsiElement>();
    private boolean willDropHomeInterfaces;
    private ProgressIndicator myProgress;
    private EjbRootElement myEjbRootElement;
    private ApplyJavaeeStyleConfiguration myConfiguration;

    public static Comparator<MyUsageInfo> createMyUsageComparator() {
        return (o1, o2) -> {
            int p2;
            int p1 = o1.getPriority();
            if (p1 != (p2 = o2.getPriority())) {
                return p2 - p1;
            }
            PsiElement e1 = o1.getTargetElement();
            PsiElement e2 = o2.getTargetElement();
            if (e1 == null || e2 == null) {
                return 0;
            }
            if (e1 == e2) {
                return 0;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)e2, (PsiElement)e1, (boolean)false)) {
                return -1;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)e1, (PsiElement)e2, (boolean)false)) {
                return 1;
            }
            return e2.getTextRange().getStartOffset() - e1.getTextRange().getStartOffset();
        };
    }

    public static Comparator<PsiElement> createTopToBottomPsiComparator() {
        return Comparator.comparingInt(e -> e.getTextRange().getStartOffset());
    }

    public JavaeeStyleEngine(ApplyJavaeeStyleConfiguration configuration) {
        this.myConfiguration = configuration;
    }

    public PsiFile[] getFileWithInvalidValues() {
        return this.fileWithInvalidValues.toArray(PsiFile.EMPTY_ARRAY);
    }

    public void performMigration() throws Exception {
        UsageInfo[] infos;
        for (UsageInfo info : infos = JavaeeStyleEngine.preprocessUsages(this.calculateUsages())) {
            for (PsiElement psiElement : ((MyUsageInfo)info).processUsage()) {
                JavaCodeStyleManager.getInstance((Project)psiElement.getProject()).shortenClassReferences(psiElement);
            }
        }
        JavaeeStyleEngine.processInvalidValues(this.getFileWithInvalidValues());
        this.clear();
    }

    private void clear() {
        this.homeReplaceMap.clear();
        this.usageInfos.clear();
        this.addedFieldsMap.clear();
        this.variablePostfixMap.clear();
        this.nameNotFoundChecksMap.clear();
        this.initializerElements.clear();
        this.myProgress = null;
        this.myEjbRootElement = null;
    }

    public UsageInfo[] calculateUsages() throws Exception {
        this.myProgress = ProgressManager.getInstance().getProgressIndicator();
        if (this.myProgress != null) {
            this.myProgress.setIndeterminate(false);
        }
        this.myEjbRootElement = this.myConfiguration.getEjbFacet().getMergedRoot();
        this.updateDescriptorsVersion(this.myEjbRootElement);
        if (this.myProgress != null) {
            this.myProgress.setText(J2EEBundle.message((String)"apply.javaee.style.processing.ejbs", (Object[])new Object[0]));
        }
        if (this.myProgress != null) {
            this.myProgress.setFraction(0.0);
        }
        EnterpriseBean[] enterpriseBeans = this.myConfiguration.getEnterpriseBeans();
        Interceptor[] interceptors = this.myConfiguration.getInterceptors();
        int totalCount = interceptors.length + enterpriseBeans.length;
        int currentCount = 0;
        this.willDropHomeInterfaces = false;
        for (EnterpriseBean enterpriseBean : enterpriseBeans) {
            if (this.hasHomeInterfacesNow(enterpriseBean) == this.willHaveHomeInterface(enterpriseBean)) continue;
            this.willDropHomeInterfaces = true;
        }
        for (EnterpriseBean enterpriseBean : enterpriseBeans) {
            if (this.myProgress != null) {
                this.myProgress.setText2(J2EEBundle.message((String)"apply.javaee.style.processing.ejb", (Object[])new Object[]{enterpriseBean.getEjbName().getValue()}));
            }
            this.migrateEnterpriseBeanInternal(enterpriseBean);
            if (this.myProgress == null) continue;
            this.myProgress.setFraction((double)(++currentCount) / (double)totalCount);
        }
        for (EnterpriseBean enterpriseBean : interceptors) {
            if (this.myProgress != null) {
                this.myProgress.setText2(J2EEBundle.message((String)"apply.javaee.style.processing.interceptor", (Object[])new Object[]{enterpriseBean.getInterceptorClass().getStringValue()}));
            }
            this.migrateInterceptor((Interceptor)enterpriseBean);
            if (this.myProgress == null) continue;
            this.myProgress.setFraction((double)(++currentCount) / (double)totalCount);
        }
        this.cleanupDescriptors(this.myEjbRootElement);
        this.migrateEjbClients();
        UsageInfo[] infos = this.usageInfos.values().toArray(new UsageInfo[this.usageInfos.size()]);
        CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])infos);
        this.clear();
        return infos;
    }

    private void cleanupDescriptors(EjbRootElement ejbRootElement) {
        EjbJar ejbJar = (EjbJar)ModelMergerUtil.getImplementation((Object)ejbRootElement, EjbJar.class);
        if (ejbJar == null) {
            return;
        }
        EnterpriseBean[] enterpriseBeans = this.myConfiguration.getEnterpriseBeans();
        if (this.myConfiguration.isDeleteCopiedXmlTags()) {
            int totalEjbCount = this.myEjbRootElement.getEnterpriseBeans().getEntities().size() + this.myEjbRootElement.getEnterpriseBeans().getSessions().size() + this.myEjbRootElement.getEnterpriseBeans().getMessageDrivens().size();
            int cmpBeansCount = 0;
            int bmpBeansCount = 0;
            for (EntityBean ejb : this.myEjbRootElement.getEnterpriseBeans().getEntities()) {
                if (ejb.getPersistenceType().getValue() == PersistenceType.CONTAINER) {
                    ++cmpBeansCount;
                    continue;
                }
                ++bmpBeansCount;
            }
            if (enterpriseBeans.length == totalEjbCount && bmpBeansCount == 0 && (cmpBeansCount == 0 || this.myConfiguration.isCreatePersistenceUnit())) {
                this.dropDomElementOrCollection(ejbJar.getEnterpriseBeans());
                this.dropDomElementOrCollection(ejbJar.getAssemblyDescriptor());
            } else {
                for (EnterpriseBean ejb : enterpriseBeans) {
                    if (!(ejb instanceof EntityBean) || this.myConfiguration.isCreatePersistenceUnit() && ((EntityBean)ejb).getPersistenceType().getValue() == PersistenceType.CONTAINER) {
                        this.dropDomElementOrCollection(ejb);
                    }
                    this.dropEjbTags(ejb);
                }
            }
        }
        if (this.myConfiguration.isCreatePersistenceUnit()) {
            this.dropElement((DomElement)ejbJar.getRelationships());
            if (!this.myConfiguration.isDeleteCopiedXmlTags()) {
                for (EnterpriseBean ejb : enterpriseBeans) {
                    if (!(ejb instanceof EntityBean) || ((EntityBean)ejb).getPersistenceType().getValue() != PersistenceType.CONTAINER) continue;
                    this.dropDomElementOrCollection(ejb);
                    this.dropEjbTags(ejb);
                }
            }
        }
    }

    private void addFileToInvalidValueHolders(PsiElement psiElement) {
        this.fileWithInvalidValues.add(psiElement.getContainingFile());
    }

    private void dropDomElementOrCollection(Object object) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            for (Object o : collection) {
                DomElement domElement = (DomElement)ModelMergerUtil.getImplementation(o, DomElement.class);
                this.dropElement(domElement);
            }
        }
        DomElement domElement = (DomElement)ModelMergerUtil.getImplementation((Object)object, DomElement.class);
        this.dropElement(domElement);
    }

    private void dropElement(DomElement domElement) {
        if (domElement == null || domElement.getXmlTag() == null) {
            return;
        }
        this.addUsageInfo(new DeleteDomElementUsageInfo(domElement));
    }

    private void dropElement(PsiElement psiElement) {
        if (psiElement == null) {
            return;
        }
        this.addUsageInfo(new DeleteElementUsageInfo(psiElement));
    }

    private void replaceElement(PsiElement psiElement, PsiElement psiReplaceElement) {
        if (psiElement == null) {
            return;
        }
        this.addUsageInfo(new ReplaceElementUsageInfo(psiElement, psiReplaceElement));
    }

    private void addUsageInfo(MyUsageInfo usageInfo) {
        assert (usageInfo.getElement().isPhysical()) : usageInfo.getElement();
        PsiElement element = usageInfo.getElement();
        MyUsageInfo currentInfo = this.usageInfos.get(element);
        if (currentInfo == null || usageInfo instanceof BaseDeleteUsageInfo || usageInfo instanceof ReplaceElementUsageInfo) {
            if (currentInfo != null && currentInfo.getTargetElement() != element) {
                CompositeUsageInfo compositeUsageInfo = new CompositeUsageInfo(usageInfo.getElement(), currentInfo, usageInfo);
                this.usageInfos.put(element, compositeUsageInfo);
            } else {
                this.usageInfos.put(element, usageInfo);
            }
        } else if (currentInfo instanceof CompositeUsageInfo) {
            CompositeUsageInfo compositeUsageInfo = (CompositeUsageInfo)currentInfo;
            if (usageInfo instanceof AddElementUsageInfo) {
                for (MyUsageInfo info : compositeUsageInfo.getChildren()) {
                    AddElementUsageInfo addElementUsageInfo;
                    if (!(info instanceof AddElementUsageInfo) || !(addElementUsageInfo = (AddElementUsageInfo)info).merge((AddElementUsageInfo)usageInfo)) continue;
                    return;
                }
            }
            compositeUsageInfo.getChildren().add(usageInfo);
        } else if (currentInfo != null) {
            if (currentInfo instanceof AddElementUsageInfo && usageInfo instanceof AddElementUsageInfo && ((AddElementUsageInfo)currentInfo).merge((AddElementUsageInfo)usageInfo)) {
                return;
            }
            CompositeUsageInfo compositeUsageInfo = new CompositeUsageInfo(usageInfo.getElement(), currentInfo, usageInfo);
            this.usageInfos.put(element, compositeUsageInfo);
        }
    }

    private AddElementUsageInfo updateFieldsMap(AddElementUsageInfo addElementUsageInfo) {
        List<PsiElement> newElements = addElementUsageInfo.getNewElements();
        if (newElements.size() == 1 && newElements.get(0) instanceof PsiField) {
            PsiClass psiClass = (PsiClass)addElementUsageInfo.getElement();
            Map<String, PsiField> psiFields = this.addedFieldsMap.get(psiClass);
            if (psiFields == null) {
                psiFields = new HashMap<String, PsiField>();
                this.addedFieldsMap.put(psiClass, psiFields);
            }
            PsiField psiField = (PsiField)newElements.get(0);
            psiFields.put(psiField.getName(), psiField);
        }
        return addElementUsageInfo;
    }

    private Map<String, PsiField> getAddedFields(PsiClass psiClass) {
        Map<String, PsiField> psiFields = this.addedFieldsMap.get(psiClass);
        return psiFields != null ? psiFields : Collections.emptyMap();
    }

    private PsiAnnotation findAddedAnnotation(PsiModifierList modifierList, PsiAnnotation annotation, final String annotationName, final Ref<BaseUpdateUsageInfo> ref) {
        MyUsageInfo info;
        if (annotation != null && (info = this.usageInfos.get(annotation)) instanceof ReplaceElementUsageInfo) {
            ReplaceElementUsageInfo replaceElementUsageInfo = (ReplaceElementUsageInfo)info;
            assert (replaceElementUsageInfo.getNewElement() instanceof PsiAnnotation);
            if (ref != null) {
                ref.set((Object)replaceElementUsageInfo);
            }
            return (PsiAnnotation)replaceElementUsageInfo.getNewElement();
        }
        if (modifierList != null && (info = this.usageInfos.get(modifierList)) != null) {
            final Ref result = new Ref((Object)annotation);
            info.accept(new MyUsageVisitor(){

                @Override
                public void visitMyUsageInfo(MyUsageInfo usageInfo) {
                    if (usageInfo instanceof BaseUpdateUsageInfo) {
                        BaseUpdateUsageInfo baseUpdateUsageInfo = (BaseUpdateUsageInfo)usageInfo;
                        for (PsiElement psiElement : baseUpdateUsageInfo.getNewElements()) {
                            PsiAnnotation psiAnnotation;
                            if (!(psiElement instanceof PsiAnnotation) || !annotationName.equals((psiAnnotation = (PsiAnnotation)psiElement).getQualifiedName())) continue;
                            if (ref != null) {
                                ref.set((Object)baseUpdateUsageInfo);
                            }
                            result.set((Object)psiAnnotation);
                        }
                    }
                }
            });
            return (PsiAnnotation)result.get();
        }
        return annotation;
    }

    private void migrateEnterpriseBeanInternal(EnterpriseBean ejb) throws Exception {
        if (ejb instanceof SessionBean) {
            this.migrateSession((SessionBean)ejb);
        } else if (ejb instanceof EntityBean) {
            this.migrateEntity((EntityBean)ejb);
        } else if (ejb instanceof MessageDrivenBean) {
            this.migrateMessageDriven((MessageDrivenBean)ejb);
        }
    }

    private void updateDescriptorsVersion(EjbRootElement ejbRootElement) {
        String curVersion;
        final EjbJar ejbJar = (EjbJar)ModelMergerUtil.getImplementation((Object)ejbRootElement, EjbJar.class);
        if (ejbJar == null) {
            return;
        }
        this.dropElement((PsiElement)DomUtil.getFile((DomElement)ejbJar).getDocument().getProlog().getDoctype());
        XmlTag xmlTag = ejbJar.getXmlTag();
        if (xmlTag != null && !JAVAEE_NAMESPACE.equals(xmlTag.getNamespace())) {
            this.addUsageInfo(new MyUsageInfo((PsiElement)xmlTag){

                @Override
                public Collection<PsiElement> processUsage() {
                    if (this.getElement() == null || !JavaeeStyleEngine.canModify(this.getElement())) {
                        return Collections.emptyList();
                    }
                    XmlTag tag = ejbJar.getXmlTag();
                    tag.setAttribute("xmlns", JavaeeStyleEngine.JAVAEE_NAMESPACE);
                    tag.setAttribute("xmlns:xsi", JavaeeStyleEngine.XSI_NAMESPACE);
                    tag.setAttribute("xsi:schemaLocation", JavaeeStyleEngine.EJB_SCHEMA_LOCATION_3_0);
                    return Collections.emptyList();
                }

                @Override
                protected String getTooltipTextInternal() {
                    String newLine = J2EEBundle.message((String)"apply.javaee.style.usage.tooltip.newline", (Object[])new Object[0]);
                    return J2EEBundle.message((String)"apply.javaee.style.usage.set.tag.attribute", (Object[])new Object[]{"xmlns", JavaeeStyleEngine.JAVAEE_NAMESPACE}) + newLine + J2EEBundle.message((String)"apply.javaee.style.usage.set.tag.attribute", (Object[])new Object[]{"xmlns:xsi", JavaeeStyleEngine.XSI_NAMESPACE}) + newLine + J2EEBundle.message((String)"apply.javaee.style.usage.set.tag.attribute", (Object[])new Object[]{"xsi:schemaLocation", JavaeeStyleEngine.EJB_SCHEMA_LOCATION_3_0});
                }

                @Override
                public int getPriority() {
                    return 10;
                }
            });
        }
        if ((curVersion = (String)ejbJar.getVersion().getValue()) == null || curVersion.compareTo(EJB_VERSION_3_0) < 0) {
            this.addUsageInfo(new MyUsageInfo((PsiElement)xmlTag){

                @Override
                public Collection<PsiElement> processUsage() {
                    if (this.getElement() == null || !JavaeeStyleEngine.canModify(this.getElement())) {
                        return Collections.emptyList();
                    }
                    ejbJar.getVersion().setValue((Object)JavaeeStyleEngine.EJB_VERSION_3_0);
                    return Collections.emptyList();
                }

                @Override
                protected String getTooltipTextInternal() {
                    return J2EEBundle.message((String)"apply.javaee.style.usage.set.tag.attribute", (Object[])new Object[]{"version", JavaeeStyleEngine.EJB_VERSION_3_0});
                }

                @Override
                public int getPriority() {
                    return -10;
                }
            });
        }
    }

    private boolean ensureClassExists(GenericValue<PsiClass> ejbClass, String name) {
        if (ejbClass.getValue() == null) {
            LOG.warn("Class " + ejbClass.getStringValue() + " does not exist, \"" + name + "\" will be skipped");
            return false;
        }
        return true;
    }

    private void migrateEntity(EntityBean ejb) throws Exception {
        if (!this.ensureClassExists((GenericValue<PsiClass>)ejb.getEjbClass(), (String)ejb.getEjbName().getValue())) {
            return;
        }
        if (this.myConfiguration.isCreatePersistenceUnit() && ejb.getPersistenceType().getValue() == PersistenceType.CONTAINER) {
            this.migrateCMPtoPersistenceEntity(ejb);
        } else {
            this.migrateEnvironmentInternal((PsiClass)ejb.getEjbClass().getValue(), (EnvironmentGroup)ejb);
            this.migrateMethodsMetaData((GenericValue<PsiClass>)ejb.getEjbClass(), EjbUtil.getEjbMethods((EnterpriseBean)ejb));
            this.migrateInterceptorMethodsMetaData((InterceptorMethodContainer)ejb);
            this.migrateClassMetaData(ejb);
        }
    }

    private void migrateInterceptorMethodsMetaData(InterceptorMethodContainer methodContainer) throws Exception {
        Ref exceptionRef = new Ref();
        methodContainer.processInterceptorMethods(null, t -> {
            try {
                this.createAnnotation((PsiModifierListOwner)t.getMethod(), t.getType().getMethodAnnotation(), true, new String[0]);
            }
            catch (Exception e) {
                exceptionRef.set((Object)e);
            }
            return true;
        });
        if (exceptionRef.get() != null) {
            throw (Exception)exceptionRef.get();
        }
    }

    private void dropEjbTags(EnterpriseBean ejb) {
        EjbJar ejbJar;
        String name = (String)ejb.getEjbName().getValue();
        EjbBase ejbBase = (EjbBase)this.getDomElement(ejb);
        EjbJar ejbJar2 = ejbJar = ejbBase == null ? null : (EjbJar)ejbBase.getParentOfType(EjbJar.class, true);
        if (name == null || ejbJar == null) {
            return;
        }
        Processor processor = container -> {
            int count = 0;
            List list = container.getMethods();
            for (Method method : list) {
                if (!name.equals(method.getEnterpriseBean().getStringValue())) continue;
                ++count;
            }
            if (count == list.size()) {
                this.dropElement((DomElement)container);
            } else {
                for (Method method : list) {
                    if (!name.equals(method.getEnterpriseBean().getStringValue())) continue;
                    this.dropElement((DomElement)method);
                }
            }
            return true;
        };
        ContainerUtil.process((List)ejbJar.getAssemblyDescriptor().getContainerTransactions(), (Processor)processor);
        ContainerUtil.process((List)ejbJar.getAssemblyDescriptor().getMethodPermissions(), (Processor)processor);
        for (InterceptorBinding binding : ejbJar.getAssemblyDescriptor().getInterceptorBindings()) {
            if (!name.equals(binding.getEnterpriseBean().getStringValue())) continue;
            this.dropElement((DomElement)binding);
        }
    }

    private void migrateCMPtoPersistenceEntity(EntityBean ejb) {
        this.dropElement((PsiElement)ejb.getLocal().getValue());
        this.dropElement((PsiElement)ejb.getRemote().getValue());
        this.dropElement((PsiElement)ejb.getHome().getValue());
        this.dropElement((PsiElement)ejb.getLocalHome().getValue());
        PsiClass psiTargetClass = (PsiClass)ejb.getEjbClass().getValue();
        this.removeModifierListElement((PsiModifierListOwner)psiTargetClass, "abstract");
        PsiMethod[] entityMethods = this.removeSuperClassAndMethods(psiTargetClass, "javax.ejb.EntityBean");
        this.migrateEjbCreatesAndHomeMethods(psiTargetClass);
        this.migrateCMPMetaData(ejb);
        this.annotateStandardMethods(entityMethods);
    }

    private boolean removeModifierListElement(PsiModifierListOwner obj, String name) {
        boolean dropped = false;
        for (PsiElement psiElement : obj.getModifierList().getChildren()) {
            if (!(psiElement instanceof PsiKeyword) || !name.equals(psiElement.getText())) continue;
            this.dropElement(psiElement);
            dropped = true;
        }
        return dropped;
    }

    private void migrateEjbCreatesAndHomeMethods(PsiClass psiTargetClass) {
        boolean noargConstructorAdded = false;
        boolean noargConstructorShouldBeAdded = true;
        for (PsiMethod psiMethod : psiTargetClass.getMethods()) {
            String methodName = psiMethod.getName();
            if (methodName.startsWith("ejbCreate")) {
                PsiParameter[] psiIdentifier = JavaPsiFacade.getInstance((Project)psiMethod.getProject()).getElementFactory().createIdentifier(psiTargetClass.getName());
                this.addUsageInfo(new ReplaceElementUsageInfo((PsiElement)psiMethod.getNameIdentifier(), (PsiElement)psiIdentifier));
                this.dropElement((PsiElement)psiMethod.getReturnTypeElement());
                this.removeThrowsElement(psiMethod, null);
                psiMethod.getBody().accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitLambdaExpression(PsiLambdaExpression expression) {
                    }

                    public void visitReturnStatement(PsiReturnStatement statement) {
                        JavaeeStyleEngine.this.dropElement((PsiElement)statement.getReturnValue());
                    }
                });
                if (psiMethod.getParameterList().getParametersCount() == 0) {
                    noargConstructorAdded = true;
                    continue;
                }
                noargConstructorShouldBeAdded = true;
                continue;
            }
            if (methodName.startsWith("ejbPostCreate")) {
                if (psiMethod.getBody().getStatements().length == 0) {
                    this.dropElement((PsiElement)psiMethod);
                    continue;
                }
                this.createAnnotation((PsiModifierListOwner)psiMethod, "javax.persistence.PostPersist", true, new String[0]);
                for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                    this.dropElement((PsiElement)psiParameter);
                }
                this.removeThrowsElement(psiMethod, null);
                continue;
            }
            if (!methodName.startsWith("ejbHome")) continue;
            String newName = StringUtil.decapitalize((String)methodName.substring("ejbHome".length()));
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiMethod.getProject()).getElementFactory();
            PsiIdentifier psiIdentifier = psiElementFactory.createIdentifier(newName);
            this.addUsageInfo(new ReplaceElementUsageInfo((PsiElement)psiMethod.getNameIdentifier(), (PsiElement)psiIdentifier));
            this.addUsageInfo(new AddElementUsageInfo((PsiElement)psiMethod, Boolean.FALSE, (PsiElement)psiMethod.getModifierList(), null, false, Collections.singletonList(psiElementFactory.createKeyword("static"))));
        }
        for (PsiMethod psiConstructor : psiTargetClass.getConstructors()) {
            if (psiConstructor.getParameterList().getParametersCount() != 0) continue;
            if (noargConstructorAdded) {
                this.dropElement((PsiElement)psiConstructor);
                continue;
            }
            noargConstructorShouldBeAdded = false;
        }
        if (noargConstructorShouldBeAdded) {
            String constructorText = "public " + psiTargetClass.getName() + "() {}";
            PsiMethod psiConstructor = JavaPsiFacade.getInstance((Project)psiTargetClass.getProject()).getElementFactory().createMethodFromText(constructorText, null);
            this.addUsageInfo(new AddElementUsageInfo((PsiElement)psiTargetClass, null, (PsiElement)psiTargetClass, null, false, Collections.singletonList(psiConstructor)));
        }
    }

    private void annotateStandardMethods(PsiMethod[] entityMethods) {
        for (PsiMethod psiMethod : entityMethods) {
            String methodName = psiMethod.getName();
            if (methodName.equals("setEntityContext")) {
                this.dropElement((PsiElement)psiMethod);
                continue;
            }
            if (methodName.equals("unsetEntityContext")) {
                this.dropElement((PsiElement)psiMethod);
                continue;
            }
            if (methodName.equals("ejbRemove")) {
                this.createAnnotation((PsiModifierListOwner)psiMethod, "javax.persistence.PostRemove", true, new String[0]);
                this.removeThrowsElement(psiMethod, null);
                continue;
            }
            if (methodName.equals("ejbActivate")) {
                this.dropElement((PsiElement)psiMethod);
                continue;
            }
            if (methodName.equals("ejbPassivate")) {
                this.dropElement((PsiElement)psiMethod);
                continue;
            }
            if (methodName.equals("ejbLoad")) {
                this.createAnnotation((PsiModifierListOwner)psiMethod, "javax.persistence.PostLoad", true, new String[0]);
                this.removeThrowsElement(psiMethod, null);
                continue;
            }
            if (!methodName.equals("ejbStore")) continue;
            this.createAnnotation((PsiModifierListOwner)psiMethod, "javax.persistence.PreUpdate", true, new String[0]);
            this.removeThrowsElement(psiMethod, null);
        }
    }

    private void migrateCMPMetaData(EntityBean ejb) {
        String name;
        Set<String> pkFieldNames;
        PsiClass psiTargetClass = (PsiClass)ejb.getEjbClass().getValue();
        AccessType accessType = ejb.getCmpVersion().getValue() == CmpVersion.CmpVersion_2_X ? AccessType.PROPERTY : AccessType.FIELD;
        this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.Entity", true, "name", AnnotationTextUtil.quote((String)ejb.getAbstractSchemaName().getValue()), AnnotationTextUtil.quote(psiTargetClass.getName()));
        HashSet<String> fieldNames = new HashSet<String>();
        if (ejb.getPrimkeyField().getStringValue() != null) {
            pkFieldNames = Collections.singleton(ejb.getPrimkeyField().getStringValue());
        } else if (ejb.getPrimKeyClass().getValue() != null) {
            pkFieldNames = new LinkedHashSet<String>();
            PsiClass pkClass = (PsiClass)ejb.getPrimKeyClass().getValue();
            for (PsiField psiField : pkClass.getAllFields()) {
                if (!psiField.hasModifierProperty("public") || psiField.hasModifierProperty("static") || psiField.hasModifierProperty("private")) continue;
                pkFieldNames.add(psiField.getName());
            }
            if (pkFieldNames.size() > 0) {
                this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.IdClass", true, "value", pkClass.getQualifiedName() + ".class", null);
            }
            if (accessType == AccessType.PROPERTY) {
                for (String name2 : pkFieldNames) {
                    this.ensureFieldAccessorsImplemented(pkClass, name2);
                }
            }
        } else {
            pkFieldNames = Collections.emptySet();
        }
        for (CmpField cmpField : ejb.getCmpFields()) {
            String fieldName = (String)cmpField.getFieldName().getValue();
            fieldNames.add(fieldName);
            PsiMember member = cmpField.getPsiMember();
            if (member == null) continue;
            if (member instanceof PsiMethod) {
                this.ensureFieldAccessorsImplemented(psiTargetClass, fieldName, ((PsiMethod)member).getReturnType());
            }
            if (pkFieldNames.contains(fieldName)) {
                this.createAnnotation((PsiModifierListOwner)member, "javax.persistence.Id", true, new String[0]);
                continue;
            }
            this.createAnnotation((PsiModifierListOwner)member, "javax.persistence.Basic", true, new String[0]);
        }
        for (CmrField cmrField : ejb.getCmrFields()) {
            String cascades;
            Object propertyType;
            PsiField psiMember;
            String fieldName = (String)cmrField.getCmrFieldName().getValue();
            if (fieldName == null) continue;
            fieldNames.add(fieldName);
            EntityBean targetEjb = cmrField.getOppositeEntity();
            if (accessType == AccessType.FIELD) {
                psiMember = psiTargetClass.findFieldByName(fieldName, false);
                if (psiMember == null) continue;
                propertyType = psiMember.getType();
            } else {
                if (accessType != AccessType.PROPERTY || (psiMember = PropertyUtilBase.findPropertyGetter((PsiClass)psiTargetClass, (String)fieldName, (boolean)false, (boolean)false)) == null) continue;
                PsiType returnType = ((PsiMethod)psiMember).getReturnType();
                propertyType = Comparing.equal((String)ejb.getLocal().getStringValue(), (String)returnType.getCanonicalText()) ? JavaPsiFacade.getInstance((Project)psiMember.getProject()).getElementFactory().createType((PsiClass)ejb.getEjbClass().getValue()) : returnType;
                this.ensureFieldAccessorsImplemented(psiTargetClass, fieldName, (PsiType)propertyType);
            }
            CmrField cmrTargetField = cmrField.getOppositeField();
            String targetFieldName = (String)cmrTargetField.getCmrFieldName().getValue();
            Multiplicity multiplicity = (Multiplicity)cmrField.getMultiplicity().getValue();
            Multiplicity targetMultiplicity = (Multiplicity)cmrTargetField.getMultiplicity().getValue();
            String targetEntityName = targetEjb.getEjbClass().getStringValue() == null ? null : targetEjb.getEjbClass().getStringValue() + ".class";
            String targetEntityNameDef = propertyType.getCanonicalText() + ".class";
            String mappedBy = cmrField.isRelationshipSource() ? null : targetFieldName;
            String string = cascades = cmrField.getCascadeDelete().getValue() == Boolean.TRUE ? AnnotationTextUtil.createStringArrayInitializer(Collections.singletonList("REMOVE"), "javax.persistence.CascadeType.", null) : null;
            if (multiplicity == Multiplicity.MANY) {
                if (targetMultiplicity == Multiplicity.MANY) {
                    this.createAnnotation((PsiModifierListOwner)psiMember, "javax.persistence.ManyToMany", true, "cascade", cascades, null, "mappedBy", AnnotationTextUtil.quote(mappedBy), null, "targetEntity", targetEntityName, targetEntityNameDef);
                    continue;
                }
                this.createAnnotation((PsiModifierListOwner)psiMember, "javax.persistence.ManyToOne", true, "cascade", cascades, null, "targetEntity", targetEntityName, targetEntityNameDef);
                continue;
            }
            if (targetMultiplicity == Multiplicity.MANY) {
                this.createAnnotation((PsiModifierListOwner)psiMember, "javax.persistence.OneToMany", true, "cascade", cascades, null, "mappedBy", AnnotationTextUtil.quote(mappedBy), null, "targetEntity", targetEntityName, targetEntityNameDef);
                continue;
            }
            this.createAnnotation((PsiModifierListOwner)psiMember, "javax.persistence.OneToOne", true, "cascade", cascades, null, "mappedBy", AnnotationTextUtil.quote(mappedBy), null, "targetEntity", targetEntityName, targetEntityNameDef);
        }
        if (psiTargetClass != null && accessType == AccessType.FIELD) {
            for (PsiField psiField : psiTargetClass.getFields()) {
                if (psiField.hasModifierProperty("static") || fieldNames.contains(name = psiField.getName())) continue;
                this.createAnnotation((PsiModifierListOwner)psiField, "javax.persistence.Transient", true, new String[0]);
            }
        } else if (psiTargetClass != null && accessType == AccessType.PROPERTY) {
            for (PsiMethod psiMethod : psiTargetClass.getMethods()) {
                if (psiMethod.hasModifierProperty("static") || !PropertyUtilBase.isSimplePropertyGetter((PsiMethod)psiMethod) || fieldNames.contains(name = PropertyUtilBase.getPropertyNameByGetter((PsiMethod)psiMethod))) continue;
                this.createAnnotation((PsiModifierListOwner)psiMethod, "javax.persistence.Transient", true, new String[0]);
            }
        }
        ArrayList<String> queriesList = new ArrayList<String>();
        for (Query query : ejb.getQueries()) {
            String name3 = query.getQueryMethodName().getStringValue();
            String ejbql = (String)query.getEjbQl().getValue();
            String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, "javax.persistence.NamedQuery", true, null, "name", AnnotationTextUtil.quote(name3), null, "query", AnnotationTextUtil.quote(ejbql), null);
            queriesList.add(text);
        }
        if (queriesList.size() > 0) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.NamedQueries", true, "value", AnnotationTextUtil.createStringArrayInitializer(queriesList, new String[0]), null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensurePropertyType(PsiMember psiMember, PsiType newType) {
        PsiTypeElement replace;
        if (psiMember == null) {
            return;
        }
        if (psiMember instanceof PsiField) {
            PsiField psiField = (PsiField)psiMember;
            if (Comparing.equal((String)psiField.getType().getCanonicalText(), (String)newType.getCanonicalText())) return;
            replace = psiField.getTypeElement();
        } else {
            if (!(psiMember instanceof PsiMethod)) return;
            PsiMethod psiMethod = (PsiMethod)psiMember;
            if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)psiMethod)) {
                if (Comparing.equal((String)psiMethod.getReturnType().getCanonicalText(), (String)newType.getCanonicalText())) return;
                replace = psiMethod.getReturnTypeElement();
            } else {
                if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod)) return;
                PsiParameter parameter = psiMethod.getParameterList().getParameters()[0];
                if (Comparing.equal((String)parameter.getType().getCanonicalText(), (String)newType.getCanonicalText())) return;
                replace = parameter.getTypeElement();
            }
        }
        PsiTypeElement element = JavaPsiFacade.getInstance((Project)psiMember.getProject()).getElementFactory().createTypeElement(newType);
        this.addUsageInfo(new ReplaceElementUsageInfo((PsiElement)replace, (PsiElement)element));
    }

    private void ensureFieldAccessorsImplemented(PsiClass psiTargetClass, String fieldName) {
        PsiMethod psiProto;
        PsiField field = psiTargetClass.findFieldByName(fieldName, true);
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)psiTargetClass, (String)fieldName, (boolean)false, (boolean)true);
        PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)psiTargetClass, (String)fieldName, (boolean)false, (boolean)true);
        if (getter == null) {
            psiProto = PropertyUtilBase.generateGetterPrototype((PsiField)field);
            this.addUsageInfo(new AddElementUsageInfo((PsiElement)psiTargetClass, null, (PsiElement)psiTargetClass, null, true, Collections.singletonList(psiProto)));
        }
        if (setter == null) {
            psiProto = PropertyUtilBase.generateSetterPrototype((PsiField)field);
            this.addUsageInfo(new AddElementUsageInfo((PsiElement)psiTargetClass, null, (PsiElement)psiTargetClass, null, true, Collections.singletonList(psiProto)));
        }
    }

    private void ensureFieldAccessorsImplemented(PsiClass psiTargetClass, String fieldName, PsiType propertyType) {
        PsiMethod psiProto;
        PsiField field = psiTargetClass.findFieldByName(fieldName, false);
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)psiTargetClass, (String)fieldName, (boolean)false, (boolean)false);
        PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)psiTargetClass, (String)fieldName, (boolean)false, (boolean)false);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiTargetClass.getProject()).getElementFactory();
        if (field == null) {
            field = factory.createField(fieldName, propertyType);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"private", (boolean)true);
            this.addUsageInfo(new AddElementUsageInfo((PsiElement)psiTargetClass, null, (PsiElement)psiTargetClass, null, true, Collections.singletonList(field)));
        }
        if (getter != null && this.removeModifierListElement((PsiModifierListOwner)getter, "abstract")) {
            psiProto = PropertyUtilBase.generateGetterPrototype((PsiField)field);
            this.addUsageInfo(new AddElementUsageInfo((PsiElement)getter, null, (PsiElement)getter, null, false, Collections.singletonList(psiProto.getBody())));
        }
        if (setter != null && this.removeModifierListElement((PsiModifierListOwner)setter, "abstract")) {
            psiProto = PropertyUtilBase.generateSetterPrototype((PsiField)field);
            PsiParameter[] parameters1 = psiProto.getParameterList().getParameters();
            PsiParameter[] parameters2 = setter.getParameterList().getParameters();
            assert (parameters1.length == 1);
            assert (parameters2.length == 1);
            if (!Comparing.equal((String)parameters1[0].getName(), (String)parameters2[0].getName())) {
                this.addUsageInfo(new ReplaceElementUsageInfo((PsiElement)parameters2[0].getNameIdentifier(), (PsiElement)parameters1[0].getNameIdentifier()));
            }
            this.addUsageInfo(new AddElementUsageInfo((PsiElement)setter, null, (PsiElement)setter, null, false, Collections.singletonList(psiProto.getBody())));
        }
        this.ensurePropertyType((PsiMember)field, propertyType);
        this.ensurePropertyType((PsiMember)getter, propertyType);
        this.ensurePropertyType((PsiMember)setter, propertyType);
    }

    private void migrateSession(SessionBean ejb) throws Exception {
        if (!this.ensureClassExists((GenericValue<PsiClass>)ejb.getEjbClass(), (String)ejb.getEjbName().getValue())) {
            return;
        }
        boolean stateful = ejb.getSessionType().getValue() == SessionType.STATEFUL;
        this.createEjbTypeAnnotation(ejb, stateful ? "javax.ejb.Stateful" : "javax.ejb.Stateless");
        this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)ejb.getEjbClass().getValue(), !stateful ? "javax.ejb.Stateful" : "javax.ejb.Stateless"));
        if (!stateful && ejb.getServiceEndpoint().getStringValue() != null) {
            this.createAnnotation((PsiModifierListOwner)ejb.getEjbClass().getValue(), "javax.jws.WebService", true, "endpointInterface", AnnotationTextUtil.quote(ejb.getServiceEndpoint().getStringValue()), null);
        } else {
            this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)ejb.getEjbClass().getValue(), "javax.jws.WebService"));
        }
        this.migrateInterfaces(ejb);
        this.migrateEnvironmentInternal((PsiClass)ejb.getEjbClass().getValue(), (EnvironmentGroup)ejb);
        this.migrateMethodsMetaData((GenericValue<PsiClass>)ejb.getEjbClass(), EjbUtil.getEjbMethods((EnterpriseBean)ejb));
        this.migrateInterceptorMethodsMetaData((InterceptorMethodContainer)ejb);
        this.migrateClassMetaData(ejb);
        PsiMethod[] sessionMethods = this.removeSuperClassAndMethods((PsiClass)ejb.getEjbClass().getValue(), "javax.ejb.SessionBean");
        this.annotateStandardMethods(ejb, sessionMethods);
    }

    private void migrateMessageDriven(MessageDrivenBean ejb) throws Exception {
        if (!this.ensureClassExists((GenericValue<PsiClass>)ejb.getEjbClass(), (String)ejb.getEjbName().getValue())) {
            return;
        }
        this.createEjbTypeAnnotation(ejb, "javax.ejb.MessageDriven");
        this.migrateEnvironmentInternal((PsiClass)ejb.getEjbClass().getValue(), (EnvironmentGroup)ejb);
        this.migrateMethodsMetaData((GenericValue<PsiClass>)ejb.getEjbClass(), EjbUtil.getEjbMethods((EnterpriseBean)ejb));
        this.migrateInterceptorMethodsMetaData((InterceptorMethodContainer)ejb);
        this.migrateClassMetaData(ejb);
        PsiClass ejbClass = (PsiClass)ejb.getEjbClass().getValue();
        PsiMethod[] mdbMethods = this.removeSuperClassAndMethods(ejbClass, "javax.ejb.MessageDrivenBean");
        this.annotateStandardMethods(ejb, mdbMethods);
    }

    private void migrateInterceptor(Interceptor interceptor) throws Exception {
        if (!this.ensureClassExists((GenericValue<PsiClass>)interceptor.getInterceptorClass(), interceptor.getInterceptorClass().getStringValue())) {
            return;
        }
        this.migrateEnvironmentInternal((PsiClass)interceptor.getInterceptorClass().getValue(), (EnvironmentGroup)interceptor);
        this.migrateInterceptorMethodsMetaData((InterceptorMethodContainer)interceptor);
    }

    private void migrateMethodsMetaData(GenericValue<PsiClass> targetClassValue, Collection<? extends EjbMethod> ejbMethods) {
        if (!this.myConfiguration.isCopyFromXml()) {
            return;
        }
        PsiClass ejbClass = (PsiClass)targetClassValue.getValue();
        for (EjbMethod ejbMethod : ejbMethods) {
            PsiMethod psiMethod;
            if (ejbMethod instanceof JamElement || (psiMethod = ejbMethod.getPsiMethod()) == null || psiMethod.getContainingClass() != ejbClass) continue;
            TransAttribute transactionAttribute = (TransAttribute)ejbMethod.getTransactionAttribute().getValue();
            if (transactionAttribute != null) {
                this.createAnnotation((PsiModifierListOwner)psiMethod, "javax.ejb.TransactionAttribute", true, "value", TRANSACTION_TYPE_PREFIX + transactionAttribute.name(), null);
            } else {
                this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)psiMethod, "javax.ejb.TransactionAttribute"));
            }
            if (Boolean.TRUE.equals(ejbMethod.isRemoveMethod().getValue())) {
                Boolean retainIfException = (Boolean)ejbMethod.isRetainIfException().getValue();
                if (retainIfException != null) {
                    this.createAnnotation((PsiModifierListOwner)psiMethod, "javax.ejb.Remove", true, "retainIfException", retainIfException.toString(), null);
                } else {
                    this.createAnnotation((PsiModifierListOwner)psiMethod, "javax.ejb.Remove", true, new String[0]);
                }
            } else {
                this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)psiMethod, "javax.ejb.Remove"));
            }
            this.setupBooleanAnnotation((GenericValue<Boolean>)ejbMethod.isDenyAll(), (PsiModifierListOwner)psiMethod, "javax.annotation.security.DenyAll");
            this.setupBooleanAnnotation((GenericValue<Boolean>)ejbMethod.isPermitAll(), (PsiModifierListOwner)psiMethod, "javax.annotation.security.PermitAll");
            Collection rolesAllowed = ejbMethod.getRolesAllowed();
            if (rolesAllowed.size() > 0) {
                this.createAnnotation((PsiModifierListOwner)psiMethod, "javax.annotation.security.RolesAllowed", false, "value", AnnotationTextUtil.createGenericValueArrayInitializer(rolesAllowed, "\""), null);
            } else {
                this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)psiMethod, "javax.annotation.security.RolesAllowed"));
            }
            GenericValue init = ejbMethod.getInit();
            if (init.getValue() != null) {
                this.createAnnotation((PsiModifierListOwner)psiMethod, "javax.ejb.Init", true, "value", AnnotationTextUtil.quote((String)init.getValue()), null);
            } else {
                this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)psiMethod, "javax.ejb.Init"));
            }
            this.setupBooleanAnnotation((GenericValue<Boolean>)ejbMethod.isTimeoutMethod(), (PsiModifierListOwner)psiMethod, "javax.ejb.Timeout");
            if (ejbMethod.getMethodInterceptors().size() > 0) {
                this.createAnnotation((PsiModifierListOwner)psiMethod, "javax.interceptor.Interceptors", true, "value", AnnotationTextUtil.createGenericValueArrayInitializer(ejbMethod.getMethodInterceptors(), null, ".class"), null);
            } else {
                this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)psiMethod, "javax.interceptor.Interceptors"));
            }
            this.setupBooleanAnnotation((GenericValue<Boolean>)ejbMethod.isExcludeDefaultInterceptors(), (PsiModifierListOwner)psiMethod, "javax.interceptor.ExcludeDefaultInterceptors");
            this.setupBooleanAnnotation((GenericValue<Boolean>)ejbMethod.isExcludeClassInterceptors(), (PsiModifierListOwner)psiMethod, "javax.interceptor.ExcludeClassInterceptors");
        }
    }

    private void setupBooleanAnnotation(GenericValue<Boolean> genericValue, PsiModifierListOwner psiObject, String annotationName) {
        Boolean aBoolean = (Boolean)genericValue.getValue();
        if (Boolean.TRUE.equals(aBoolean)) {
            this.createAnnotation(psiObject, annotationName, true, new String[0]);
        } else if (Boolean.FALSE.equals(aBoolean)) {
            this.dropElement((PsiElement)this.findAnnotation(psiObject, annotationName));
        }
    }

    private void migrateBaseClassMetaData(EnterpriseBean ejb) {
        if (!this.myConfiguration.isCopyFromXml()) {
            return;
        }
        if (ejb.getClassInterceptors().size() > 0) {
            this.createAnnotation((PsiModifierListOwner)ejb.getEjbClass().getValue(), "javax.interceptor.Interceptors", true, "value", AnnotationTextUtil.createGenericValueArrayInitializer(ejb.getClassInterceptors(), null, ".class"), null);
        } else {
            this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)ejb.getEjbClass().getValue(), "javax.interceptor.Interceptors"));
        }
        this.setupBooleanAnnotation((GenericValue<Boolean>)ejb.isExcludeDefaultInterceptors(), (PsiModifierListOwner)ejb.getEjbClass().getValue(), "javax.interceptor.ExcludeDefaultInterceptors");
    }

    private void migrateClassMetaData(EntityBean ejb) {
        this.migrateBaseClassMetaData((EnterpriseBean)ejb);
        if (!this.myConfiguration.isCopyFromXml()) {
            return;
        }
        this.setSecurityRoleRefs((PsiClass)ejb.getEjbClass().getValue(), ejb.getSecurityRoleRefs());
    }

    private void migrateClassMetaData(SessionBean ejb) {
        this.migrateBaseClassMetaData((EnterpriseBean)ejb);
        if (!this.myConfiguration.isCopyFromXml()) {
            return;
        }
        PsiClass ejbClass = (PsiClass)ejb.getEjbClass().getValue();
        this.setTransactionManagementType(ejbClass, (GenericValue<TransactionType>)ejb.getTransactionManagementType());
        this.setSecurityRoleRefs(ejbClass, ejb.getSecurityRoleRefs());
    }

    private void migrateClassMetaData(MessageDrivenBean ejb) {
        com.intellij.javaee.model.xml.ejb.MessageDrivenBean domEjb;
        this.migrateBaseClassMetaData((EnterpriseBean)ejb);
        if (this.myConfiguration.isCopyFromXml()) {
            this.setTransactionManagementType((PsiClass)ejb.getEjbClass().getValue(), (GenericValue<TransactionType>)ejb.getTransactionManagementType());
        }
        if ((domEjb = (com.intellij.javaee.model.xml.ejb.MessageDrivenBean)ModelMergerUtil.getImplementation((Object)ejb, com.intellij.javaee.model.xml.ejb.MessageDrivenBean.class)) != null) {
            String acknowledgeMode = domEjb.getAcknowledgeMode().getStringValue();
            String messageSelectorMode = (String)domEjb.getMessageSelector().getValue();
            MessageDrivenDestinationType destinationType = (MessageDrivenDestinationType)domEjb.getMessageDrivenDestination().getDestinationType().getValue();
            SubscriptionDurabilityType durability = (SubscriptionDurabilityType)domEjb.getMessageDrivenDestination().getSubscriptionDurability().getValue();
            if (acknowledgeMode != null) {
                this.addActivationConfigProperty(domEjb, "acknowledgeMode", acknowledgeMode);
            }
            if (messageSelectorMode != null) {
                this.addActivationConfigProperty(domEjb, "messageSelector", messageSelectorMode);
            }
            if (destinationType != null) {
                this.addActivationConfigProperty(domEjb, "destinationType", destinationType.getValue());
            }
            if (durability != null) {
                this.addActivationConfigProperty(domEjb, "subscriptionDurability", durability.getValue());
            }
            this.dropElement((DomElement)domEjb.getAcknowledgeMode());
            this.dropElement((DomElement)domEjb.getMessageDrivenDestination());
            this.dropElement((DomElement)domEjb.getMessageSelector());
        }
    }

    private void addActivationConfigProperty(final com.intellij.javaee.model.xml.ejb.MessageDrivenBean domEjb, final String propertyName, final String propertyValue) {
        this.addUsageInfo(new MyUsageInfo((PsiElement)domEjb.getXmlTag()){

            @Override
            public Collection<PsiElement> processUsage() {
                if (this.getElement() == null || !JavaeeStyleEngine.canModify(this.getElement())) {
                    return Collections.emptyList();
                }
                com.intellij.javaee.model.xml.ejb.ActivationConfigProperty configProperty = domEjb.getActivationConfig().addActivationConfigProperty();
                configProperty.getActivationConfigPropertyName().setValue((Object)propertyName);
                configProperty.getActivationConfigPropertyValue().setValue((Object)propertyValue);
                return Collections.emptyList();
            }

            @Override
            protected String getTooltipTextInternal() {
                String text = XmlStringUtil.escapeString((String)("<activation-config-property><activation-config-property-name>" + propertyName + "</activation-config-property-name><activation-config-property-value>" + propertyValue + "</activation-config-property-value></activation-config-property>"));
                return J2EEBundle.message((String)"apply.javaee.style.usage.add", (Object[])new Object[]{text});
            }
        });
    }

    private void setSecurityRoleRefs(PsiClass ejbClass, Collection<? extends SecurityRoleRef> securityRoleRefs) {
        ArrayList<String> list = new ArrayList<String>(securityRoleRefs.size());
        for (SecurityRoleRef securityRoleRef : securityRoleRefs) {
            list.add(securityRoleRef.getRoleName().getStringValue());
        }
        if (list.size() > 0) {
            this.createAnnotation((PsiModifierListOwner)ejbClass, "javax.annotation.security.DeclareRoles", true, "value", AnnotationTextUtil.createStringArrayInitializer(list, "\""), null);
        } else {
            this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)ejbClass, "javax.annotation.security.DeclareRoles"));
        }
    }

    private void setTransactionManagementType(PsiClass ejbClass, GenericValue<TransactionType> transactionManagement) {
        if (transactionManagement.getValue() != null) {
            this.createAnnotation((PsiModifierListOwner)ejbClass, "javax.ejb.TransactionManagement", true, "value", TRANSACTION_MANAGEMENT_TYPE_PREFIX + ((TransactionType)transactionManagement.getValue()).name(), null);
        } else {
            this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)ejbClass, "javax.ejb.TransactionManagement"));
        }
    }

    private void annotateStandardMethods(SessionBean ejb, PsiMethod[] methods) {
        for (PsiMethod method : methods) {
            String methodName = method.getName();
            if ("ejbRemove".equals(methodName)) {
                this.createAnnotation((PsiModifierListOwner)method, "javax.ejb.Remove", true, new String[0]);
                continue;
            }
            if ("ejbActivate".equals(methodName)) {
                this.createAnnotation((PsiModifierListOwner)method, "javax.ejb.PostActivate", true, new String[0]);
                continue;
            }
            if ("ejbPassivate".equals(methodName)) {
                this.createAnnotation((PsiModifierListOwner)method, "javax.ejb.PrePassivate", true, new String[0]);
                continue;
            }
            if (!"setSessionContext".equals(methodName)) continue;
            this.createAnnotation((PsiModifierListOwner)method, "javax.annotation.Resource", true, new String[0]);
        }
    }

    private void annotateStandardMethods(MessageDrivenBean ejb, PsiMethod[] methods) {
        for (PsiMethod method : methods) {
            String methodName = method.getName();
            if ("ejbRemove".equals(methodName)) {
                this.createAnnotation((PsiModifierListOwner)method, "javax.ejb.Remove", true, new String[0]);
                continue;
            }
            if (!"setMessageDrivenContext".equals(methodName)) continue;
            this.createAnnotation((PsiModifierListOwner)method, "javax.annotation.Resource", true, new String[0]);
        }
    }

    private void migrateInterfaces(SessionBean ejb) {
        PsiClass ejbClass = (PsiClass)ejb.getEjbClass().getValue();
        if (this.myConfiguration.isHomeInterfaceEnabled((EnterpriseBean)ejb)) {
            this.addHomeInterface(ejb, (GenericValue<PsiClass>)ejb.getHome(), true);
            this.addHomeInterface(ejb, (GenericValue<PsiClass>)ejb.getLocalHome(), false);
            this.migrateComponentToBusinessInterface(ejb, (GenericValue<PsiClass>)ejb.getRemote(), true);
            this.migrateComponentToBusinessInterface(ejb, (GenericValue<PsiClass>)ejb.getLocal(), false);
        } else {
            this.migrateHomeAndComponentInterface(ejb, (GenericValue<PsiClass>)ejb.getHome(), (GenericValue<PsiClass>)ejb.getRemote(), true);
            this.migrateHomeAndComponentInterface(ejb, (GenericValue<PsiClass>)ejb.getLocalHome(), (GenericValue<PsiClass>)ejb.getLocal(), false);
            this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)ejbClass, "javax.ejb.RemoteHome"));
            this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)ejbClass, "javax.ejb.LocalHome"));
        }
        for (GenericValue value : ejb.getBusinessRemotes()) {
            this.addBusinessInterface(ejb, (GenericValue<PsiClass>)value, true);
        }
        for (GenericValue value : ejb.getBusinessLocals()) {
            this.addBusinessInterface(ejb, (GenericValue<PsiClass>)value, false);
        }
    }

    private void addHomeInterface(SessionBean ejb, GenericValue<PsiClass> homeClass, boolean remoteFlag) {
        PsiClass psiHomeClass = (PsiClass)homeClass.getValue();
        if (psiHomeClass == null) {
            return;
        }
        String annotationName = remoteFlag ? "javax.ejb.RemoteHome" : "javax.ejb.LocalHome";
        this.createAnnotation((PsiModifierListOwner)ejb.getEjbClass().getValue(), annotationName, true, "value", psiHomeClass.getQualifiedName() + ".class", null);
        for (PsiMethod method : psiHomeClass.getAllMethods()) {
            PsiMethod ejbMethod;
            if (!method.getName().startsWith(CREATE_METHOD_PREFIX) || (ejbMethod = this.findClassMethod((PsiClass)ejb.getEjbClass().getValue(), method, true)) == null) continue;
            this.createAnnotation((PsiModifierListOwner)ejbMethod, "javax.ejb.Init", true, "value", AnnotationTextUtil.quote(method.getName()), null);
        }
    }

    private void migrateHomeAndComponentInterface(SessionBean ejb, GenericValue<PsiClass> homeClass, GenericValue<PsiClass> intfClass, boolean remoteFlag) {
        PsiClass psiHomeClass = (PsiClass)homeClass.getValue();
        PsiClass psiIntfClass = (PsiClass)intfClass.getValue();
        if (psiIntfClass == null) {
            return;
        }
        if (psiHomeClass != null) {
            for (PsiMethod method : psiHomeClass.getAllMethods()) {
                if (!method.getName().startsWith(CREATE_METHOD_PREFIX)) continue;
                PsiMethod ejbMethod = this.findClassMethod((PsiClass)ejb.getEjbClass().getValue(), method, true);
                PsiMethod intfMethod = this.findClassMethod(psiIntfClass, method, false);
                if (intfMethod == null) {
                    String methodText = JavaCodeStyleManager.getInstance((Project)method.getProject()).qualifyClassReferences(method.copy()).getText();
                    PsiMethod psiCopy = JavaPsiFacade.getInstance((Project)psiIntfClass.getProject()).getElementFactory().createMethodFromText(methodText, null);
                    psiCopy.getReturnTypeElement().replace((PsiElement)JavaPsiFacade.getInstance((Project)psiIntfClass.getProject()).getElementFactory().createTypeElement((PsiType)PsiType.VOID));
                    PsiUtil.removeException((PsiMethod)psiCopy, (String)"java.rmi.RemoteException");
                    PsiClass element = JavaPsiFacade.getInstance((Project)method.getProject()).findClass("java.rmi.RemoteException", method.getResolveScope());
                    if (element != null) {
                        for (PsiReference reference : ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)psiCopy))) {
                            PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiDocTag.class);
                            if (tag == null) continue;
                            tag.delete();
                        }
                    }
                    this.addUsageInfo(new AddElementUsageInfo((PsiElement)psiIntfClass, null, (PsiElement)psiIntfClass, null, false, Collections.singletonList(psiCopy)));
                }
                if (ejbMethod == null) continue;
                this.replaceElement((PsiElement)ejbMethod.getNameIdentifier(), (PsiElement)JavaPsiFacade.getInstance((Project)ejbMethod.getProject()).getElementFactory().createIdentifier(method.getNameIdentifier().getText()));
            }
            Object element = this.getDomElement(homeClass);
            this.dropElement((DomElement)element);
            this.dropElement((PsiElement)psiHomeClass);
            this.migrateHomeMethodDomReferences(ejb, remoteFlag);
            this.dropJavaDocTagReferences((PsiElement)psiHomeClass, (SearchScope)GlobalSearchScope.moduleScope((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)psiHomeClass)));
            this.homeReplaceMap.put(psiHomeClass, psiIntfClass);
        }
        this.migrateComponentToBusinessInterface(ejb, intfClass, remoteFlag);
    }

    private void migrateHomeMethodDomReferences(SessionBean ejb, boolean remoteFlag) {
        EjbJar ejbJar;
        if (this.myConfiguration.isDeleteCopiedXmlTags()) {
            return;
        }
        String name = (String)ejb.getEjbName().getValue();
        EjbBase ejbBase = (EjbBase)this.getDomElement(ejb);
        EjbJar ejbJar2 = ejbJar = ejbBase == null ? null : (EjbJar)ejbBase.getParentOfType(EjbJar.class, true);
        if (name == null || ejbJar == null) {
            return;
        }
        Processor processor = container -> {
            String methodName;
            int count = 0;
            MethodIntf methodIntf = remoteFlag ? MethodIntf.HOME : MethodIntf.LOCAL_HOME;
            final MethodIntf businessMethodIntf = remoteFlag ? MethodIntf.REMOTE : MethodIntf.LOCAL;
            List list = container.getMethods();
            for (final Method method : list) {
                methodName = method.getMethod().getStringValue();
                if (!name.equals(method.getEnterpriseBean().getStringValue()) || method.getMethodIntf().getValue() != methodIntf || methodName != null && methodName.startsWith(CREATE_METHOD_PREFIX)) continue;
                ++count;
            }
            if (count == list.size()) {
                this.dropElement((DomElement)container);
            } else {
                for (final Method method : list) {
                    methodName = method.getMethod().getStringValue();
                    if (!name.equals(method.getEnterpriseBean().getStringValue()) || method.getMethodIntf().getValue() != methodIntf) continue;
                    if (methodName == null || !methodName.startsWith(CREATE_METHOD_PREFIX)) {
                        this.dropElement((DomElement)method);
                        continue;
                    }
                    this.addUsageInfo(new MyUsageInfo((PsiElement)method.getMethodIntf().getXmlTag()){

                        @Override
                        public Collection<PsiElement> processUsage() {
                            if (this.getElement() == null || !JavaeeStyleEngine.canModify(this.getElement())) {
                                return Collections.emptyList();
                            }
                            method.getMethodIntf().setValue((Object)businessMethodIntf);
                            return Collections.emptyList();
                        }

                        @Override
                        protected String getTooltipTextInternal() {
                            String text = XmlStringUtil.escapeString((String)("<method-intf>" + businessMethodIntf.getValue() + "<method-intf>"));
                            return J2EEBundle.message((String)"apply.javaee.style.usage.replace", (Object[])new Object[]{text});
                        }
                    });
                }
            }
            return true;
        };
        ContainerUtil.process((List)ejbJar.getAssemblyDescriptor().getContainerTransactions(), (Processor)processor);
        ContainerUtil.process((List)ejbJar.getAssemblyDescriptor().getMethodPermissions(), (Processor)processor);
    }

    private void migrateComponentToBusinessInterface(SessionBean ejb, GenericValue<PsiClass> intfClass, final boolean remoteFlag) {
        final PsiClass psiIntfClass = (PsiClass)intfClass.getValue();
        if (psiIntfClass == null) {
            return;
        }
        String superClass = remoteFlag ? "javax.ejb.EJBObject" : "javax.ejb.EJBLocalObject";
        this.removeSuperClassAndMethods(psiIntfClass, superClass);
        this.addBusinessInterface(ejb, intfClass, remoteFlag);
        if (remoteFlag) {
            for (PsiMethod method : psiIntfClass.getMethods()) {
                this.removeThrowsElement(method, "java.rmi.RemoteException");
            }
        }
        Object element = this.getDomElement(intfClass);
        this.dropElement((DomElement)element);
        final com.intellij.javaee.model.xml.ejb.SessionBean domEjb = (com.intellij.javaee.model.xml.ejb.SessionBean)this.getDomElement(ejb);
        if (domEjb != null) {
            this.addUsageInfo(new MyUsageInfo((PsiElement)domEjb.getXmlTag()){

                @Override
                public Collection<PsiElement> processUsage() {
                    GenericDomValue businessClass;
                    GenericDomValue genericDomValue = businessClass = remoteFlag ? domEjb.addBusinessRemote() : domEjb.addBusinessLocal();
                    if (this.getElement() == null || !JavaeeStyleEngine.canModify(this.getElement())) {
                        return Collections.emptyList();
                    }
                    businessClass.setValue((Object)psiIntfClass);
                    return Collections.emptyList();
                }

                @Override
                protected String getTooltipTextInternal() {
                    String tagName = remoteFlag ? "business-remote" : "business-local";
                    String text = XmlStringUtil.escapeString((String)("<" + tagName + ">" + psiIntfClass.getQualifiedName() + "</" + tagName + ">"));
                    return J2EEBundle.message((String)"apply.javaee.style.usage.add", (Object[])new Object[]{text});
                }
            });
        }
    }

    private void dropJavaDocTagReferences(PsiElement element, SearchScope scope) {
        if (element != null) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)element, (SearchScope)scope)) {
                PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiDocTag.class);
                if (tag == null) continue;
                this.dropElement((PsiElement)tag);
            }
        }
    }

    private void addBusinessInterface(SessionBean ejb, GenericValue<PsiClass> intfClass, boolean remoteFlag) {
        PsiClass psiIntfClass = (PsiClass)intfClass.getValue();
        if (psiIntfClass == null) {
            return;
        }
        String annotationName = remoteFlag ? "javax.ejb.Remote" : "javax.ejb.Local";
        this.createAnnotation((PsiModifierListOwner)ejb.getEjbClass().getValue(), annotationName, true, "value", AnnotationTextUtil.createStringArrayInitializer(Collections.singletonList(psiIntfClass.getQualifiedName() + ".class"), new String[0]), null);
        this.addInterfaceToImplementsList((PsiClass)ejb.getEjbClass().getValue(), psiIntfClass);
    }

    private void addInterfaceToImplementsList(PsiClass psiClass, PsiClass psiInterface) {
        PsiReferenceList implementsList = psiClass.getImplementsList();
        assert (implementsList != null);
        for (PsiJavaCodeReferenceElement psiJavaCodeReferenceElement : implementsList.getReferenceElements()) {
            if (!psiInterface.getQualifiedName().equals(psiJavaCodeReferenceElement.getQualifiedName())) continue;
            return;
        }
        PsiClassType type = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiInterface);
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createReferenceElementByType(type);
        this.addUsageInfo(new AddElementUsageInfo((PsiElement)psiClass, Boolean.TRUE, (PsiElement)implementsList, null, false, Collections.singletonList(psiJavaCodeReferenceElement)));
    }

    private PsiClass findClass(String name, PsiElement context) {
        return JavaPsiFacade.getInstance((Project)context.getProject()).findClass(name, context.getResolveScope());
    }

    private PsiMethod findClassMethod(PsiElement context, String className, String methodPattern) throws IncorrectOperationException {
        PsiClass psiClass = this.findClass(className, context);
        if (psiClass == null) {
            return null;
        }
        PsiMethod psiPatternMethod = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createMethodFromText(methodPattern, null);
        return psiClass.findMethodBySignature(psiPatternMethod, false);
    }

    private PsiMethod findClassMethod(PsiClass psiClass, PsiMethod intfMethod, boolean ejbPrefix) {
        String expectedName = intfMethod.getName();
        expectedName = ejbPrefix ? "ejb" + Character.toUpperCase(expectedName.charAt(0)) + expectedName.substring(1) : expectedName;
        PsiParameter[] parameters1 = intfMethod.getParameterList().getParameters();
        block0: for (PsiMethod psiMethod : psiClass.findMethodsByName(expectedName, false)) {
            PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
            if (parameters1.length != parameters2.length) continue;
            for (int i = 0; i < parameters1.length; ++i) {
                String type2;
                String type1 = parameters1[i].getType().getCanonicalText();
                if (!type1.equals(type2 = parameters2[i].getType().getCanonicalText())) continue block0;
            }
            return psiMethod;
        }
        return null;
    }

    private void removeThrowsElement(PsiMethod method, String className) {
        for (PsiJavaCodeReferenceElement psiJavaCodeReferenceElement : method.getThrowsList().getReferenceElements()) {
            if (className != null && !className.equals(psiJavaCodeReferenceElement.getQualifiedName())) continue;
            this.dropElement((PsiElement)psiJavaCodeReferenceElement);
            this.dropJavaDocTagReferences(psiJavaCodeReferenceElement.resolve(), (SearchScope)new LocalSearchScope((PsiElement)method));
        }
    }

    private PsiAnnotation findAnnotation(PsiModifierListOwner object, String annotationName) {
        assert (object != null);
        PsiModifierList modifierList = object.getModifierList();
        assert (modifierList != null);
        return modifierList.findAnnotation(annotationName);
    }

    private void createEjbTypeAnnotation(MessageDrivenBean ejb, String annotationName) {
        String activationConfig;
        String messageListenerValue;
        String defaultListenerInterface;
        PsiClass psiClass = (PsiClass)ejb.getEjbClass().getValue();
        String ejbNameDef = psiClass.getName();
        String ejbName = (String)ejb.getEjbName().getValue();
        PsiClass messageListenerInterface = (PsiClass)ejb.getMessageListenerInterface().getValue();
        if (messageListenerInterface != null) {
            PsiClassType defaultInterface = null;
            block0: for (PsiClass curClass : JamCommonUtil.getSuperClassList((PsiClass)psiClass)) {
                PsiClassType[] implementsTypes;
                for (PsiClassType implementsType : implementsTypes = curClass.getImplementsList().getReferencedTypes()) {
                    if ("javax.ejb.MessageDrivenBean".equals(implementsType.getCanonicalText())) continue;
                    if (defaultInterface == null || defaultInterface.isAssignableFrom((PsiType)implementsType)) {
                        defaultInterface = implementsType;
                        continue;
                    }
                    if (implementsType.isAssignableFrom((PsiType)defaultInterface)) continue;
                    defaultInterface = null;
                    break block0;
                }
            }
            defaultListenerInterface = defaultInterface == null ? null : defaultInterface.getCanonicalText() + ".class";
            messageListenerValue = messageListenerInterface.getQualifiedName() + ".class";
        } else {
            defaultListenerInterface = null;
            messageListenerValue = "java.lang.Object.class";
        }
        List activationConfigProperties = ejb.getActivationConfigProperties();
        if (activationConfigProperties.size() > 0) {
            ArrayList<String> initList = new ArrayList<String>();
            for (ActivationConfigProperty property : activationConfigProperties) {
                initList.add("propertyName=" + AnnotationTextUtil.quote((String)property.getPropertyName().getValue()) + ", " + "propertyValue" + "=" + AnnotationTextUtil.quote((String)property.getPropertyValue().getValue()));
            }
            activationConfig = AnnotationTextUtil.createStringArrayInitializer(initList, "@javax.ejb.ActivationConfigProperty(", ")");
        } else {
            activationConfig = "{}";
        }
        this.createAnnotation((PsiModifierListOwner)psiClass, annotationName, true, "name", AnnotationTextUtil.quote(ejbName), AnnotationTextUtil.quote(ejbNameDef), "messageListenerInterface", messageListenerValue, defaultListenerInterface, "activationConfig", activationConfig, null);
    }

    private void createEjbTypeAnnotation(SessionBean ejb, String annotationName) {
        PsiClass psiClass = (PsiClass)ejb.getEjbClass().getValue();
        String ejbNameDef = psiClass.getName();
        String ejbName = (String)ejb.getEjbName().getValue();
        this.createAnnotation((PsiModifierListOwner)psiClass, annotationName, true, "name", AnnotationTextUtil.quote(ejbName), AnnotationTextUtil.quote(ejbNameDef));
    }

    private PsiAnnotation createReferenceAnnotation(PsiClass psiClass, String fieldName, JavaeeReference reference, PsiAnnotation currentAnnotation, String fieldType) {
        String text = reference instanceof EjbReference ? this.createEjbReferenceAnnotationText(psiClass, (EjbReference)reference, currentAnnotation, fieldName, fieldType) : (reference instanceof Resource ? this.createResourceReferenceAnnotationText(psiClass, (Resource)reference, currentAnnotation, fieldName, fieldType) : (reference instanceof ServiceRef ? this.createServiceReferenceAnnotationText(psiClass, (ServiceRef)reference, currentAnnotation, fieldName, fieldType) : null));
        if (text == null) {
            return currentAnnotation;
        }
        return JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createAnnotationFromText(text, null);
    }

    private void createAnnotation(PsiModifierListOwner object, String annotationName, boolean merge, String ... arguments) {
        PsiModifierList modifierList = object.getModifierList();
        PsiAnnotation psiRealAnnotation = modifierList.findAnnotation(annotationName);
        Ref updateInfoRef = new Ref();
        PsiAnnotation annotation = this.findAddedAnnotation(modifierList, psiRealAnnotation, annotationName, (Ref<BaseUpdateUsageInfo>)updateInfoRef);
        BaseUpdateUsageInfo updateUsageInfo = (BaseUpdateUsageInfo)((Object)updateInfoRef.get());
        String text = AnnotationTextUtil.createAnnotationText((PsiElement)object, annotationName, merge, annotation, arguments);
        if (text == null) {
            return;
        }
        PsiAnnotation psiAnnotation = JavaPsiFacade.getInstance((Project)object.getProject()).getElementFactory().createAnnotationFromText(text, null);
        if (updateUsageInfo == null && psiRealAnnotation == null) {
            this.addUsageInfo(new AddElementUsageInfo((PsiElement)object, Boolean.FALSE, (PsiElement)modifierList, null, true, Collections.singletonList(psiAnnotation)));
        } else if (updateUsageInfo != null) {
            updateUsageInfo.updateElement((PsiElement)psiRealAnnotation, (PsiElement)psiAnnotation);
        } else {
            this.replaceElement((PsiElement)psiRealAnnotation, (PsiElement)psiAnnotation);
        }
    }

    private PsiMethod[] removeSuperClassAndMethods(PsiClass psiClass, String className) {
        boolean implementsFlag;
        PsiClass removedSuperClass = this.findClass(className, (PsiElement)psiClass);
        if (removedSuperClass == null) {
            LOG.warn("Standard class " + className + " should be available");
            return PsiMethod.EMPTY_ARRAY;
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        boolean bl = implementsFlag = removedSuperClass.isInterface() != psiClass.isInterface();
        if (removedSuperClass.getAllMethods().length > 0) {
            block0: for (PsiMethod psiMethod : psiClass.getMethods()) {
                PsiMethod[] superMethods;
                psiMethod.findSuperMethods();
                for (PsiMethod superMethod : superMethods = psiMethod.findDeepestSuperMethods()) {
                    if (!className.equals(superMethod.getContainingClass().getQualifiedName())) continue;
                    result.add(psiMethod);
                    continue block0;
                }
            }
        }
        boolean removed = false;
        PsiReferenceList classList = implementsFlag ? psiClass.getImplementsList() : psiClass.getExtendsList();
        for (PsiJavaCodeReferenceElement psiJavaCodeReferenceElement : classList.getReferenceElements()) {
            if (!Comparing.equal((String)className, (String)psiJavaCodeReferenceElement.getQualifiedName())) continue;
            this.dropElement((PsiElement)psiJavaCodeReferenceElement);
            removed = true;
        }
        if (removed) {
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                PsiMethod psiMethod = (PsiMethod)iterator.next();
                PsiCodeBlock body = psiMethod.getBody();
                if (body != null && body.getStatements().length != 0) continue;
                this.dropElement((PsiElement)psiMethod);
                iterator.remove();
            }
        }
        return removed && result.size() > 0 ? result.toArray(PsiMethod.EMPTY_ARRAY) : PsiMethod.EMPTY_ARRAY;
    }

    private <T extends DomElement> T getDomElement(Object element) {
        return (T)((DomElement)ModelMergerUtil.getImplementation((Object)element, DomElement.class));
    }

    private void migrateEnvironmentInternal(PsiClass psiTargetClass, EnvironmentGroup ejb) {
        HashMap<String, JavaeeReference> referenceMap = new HashMap<String, JavaeeReference>();
        this.rebuildJndiEnvironmentMap(ejb, referenceMap);
        TreeSet<String> jndiNames = new TreeSet<String>(referenceMap.keySet());
        if (this.willDropHomeInterfaces || this.myConfiguration.getPreferredAccess() != ApplyJavaeeStyleConfiguration.EnvironmentAccess.DEFAULT) {
            TreeMap lookupUsagesJndi = new TreeMap(JavaeeStyleEngine.createTopToBottomPsiComparator());
            TreeMap lookupUsagesEjbCtx = new TreeMap(JavaeeStyleEngine.createTopToBottomPsiComparator());
            HashSet<PsiElement> contextObjects = new HashSet<PsiElement>();
            this.rebuildLookupUsagesMap(psiTargetClass, lookupUsagesJndi, contextObjects, "javax.naming.Context");
            this.rebuildLookupUsagesMap(psiTargetClass, lookupUsagesEjbCtx, contextObjects, "javax.ejb.EJBContext");
            jndiNames.removeAll(lookupUsagesJndi.values());
            jndiNames.removeAll(lookupUsagesEjbCtx.values());
            this.replaceLookupsWithInjection(psiTargetClass, ejb, lookupUsagesJndi, referenceMap, contextObjects, jndiNames, true);
            this.replaceJndiLookupsWithEjbContextLookups(psiTargetClass, ejb, lookupUsagesJndi);
            this.replaceLookupsWithInjection(psiTargetClass, ejb, lookupUsagesEjbCtx, referenceMap, contextObjects, jndiNames, false);
            this.replaceInjectionWithLookups(ejb, referenceMap, contextObjects, jndiNames, psiTargetClass);
            jndiNames.addAll(lookupUsagesJndi.values());
            jndiNames.addAll(lookupUsagesEjbCtx.values());
            this.removeUnusedVariables(contextObjects);
            this.removeReferencesHomeTags(ejb);
        }
        this.updateReferenceAnnotations(ejb, referenceMap);
        this.updateClassLevelEnvironmentAnnotations(ejb, psiTargetClass, jndiNames, referenceMap);
    }

    private void updateReferenceAnnotations(EnvironmentGroup ejbEnvironment, Map<String, JavaeeReference> referenceMap) {
        if (!this.myConfiguration.isCopyFromXml() || !this.myConfiguration.isEnlisted(ejbEnvironment)) {
            return;
        }
        for (JavaeeReference javaeeReference : referenceMap.values()) {
            PsiClass containingClass;
            String typeName;
            String varName;
            JavaeeDomModelElement domElement = (JavaeeDomModelElement)ModelMergerUtil.getImplementation((Object)javaeeReference, JavaeeDomModelElement.class);
            JavaeeReferenceImpl annoElement = (JavaeeReferenceImpl)((Object)ModelMergerUtil.getImplementation((Object)javaeeReference, JavaeeReferenceImpl.class));
            if (annoElement == null || domElement == null) continue;
            PsiAnnotation psiCurrentAnnotation = (PsiAnnotation)annoElement.getAnnotationRef().getPsiElement();
            PsiMember member = annoElement.getPsiMember();
            if (psiCurrentAnnotation == null) continue;
            if (member instanceof PsiMethod) {
                varName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)((PsiMethod)member));
                typeName = ((PsiMethod)member).getReturnType().getCanonicalText();
                containingClass = member.getContainingClass();
            } else if (member instanceof PsiField) {
                varName = member.getName();
                typeName = ((PsiField)member).getType().getCanonicalText();
                containingClass = member.getContainingClass();
            } else {
                containingClass = (PsiClass)JavaResolveUtil.findParentContextOfClass((PsiElement)psiCurrentAnnotation, PsiClass.class, (boolean)true);
                varName = null;
                typeName = null;
            }
            assert (containingClass != null);
            PsiAnnotation psiAnnotation = this.createReferenceAnnotation(containingClass, varName, javaeeReference, psiCurrentAnnotation, typeName);
            if (psiCurrentAnnotation == psiAnnotation) continue;
            this.replaceElement((PsiElement)psiCurrentAnnotation, (PsiElement)psiAnnotation);
        }
    }

    private void removeReferencesHomeTags(EnvironmentGroup ejbEnvironment) {
        if (!this.willDropHomeInterfaces) {
            return;
        }
        JndiEnvironmentRefsGroup jndiEnv = (JndiEnvironmentRefsGroup)ModelMergerUtil.getImplementation((Object)ejbEnvironment, JndiEnvironmentRefsGroup.class);
        if (jndiEnv == null) {
            return;
        }
        for (EjbRef ejbRef : jndiEnv.getEjbRefs()) {
            if (this.willHaveHomeInterface((EnterpriseBean)ejbRef.getEjbLink().getValue())) continue;
            this.dropElement((DomElement)ejbRef.getHome());
        }
        for (EjbRef ejbRef : jndiEnv.getEjbLocalRefs()) {
            if (this.willHaveHomeInterface((EnterpriseBean)ejbRef.getEjbLink().getValue())) continue;
            this.dropElement((DomElement)ejbRef.getLocalHome());
        }
    }

    private PsiElement findLValue(PsiExpression psiExpression, boolean resolve) {
        PsiElement psiElement = psiExpression.getParent();
        PsiExpression prevElement = psiExpression;
        while (psiElement != null) {
            PsiMethodCallExpression psiMethodCallExpression;
            PsiElement nextElement = null;
            if (psiElement instanceof PsiVariable) break;
            if (psiElement instanceof PsiReferenceExpression) {
                PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)psiElement;
                if (!resolve) break;
                nextElement = psiReferenceExpression.resolve();
            } else if (psiElement instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression psiAssignmentExpression = (PsiAssignmentExpression)psiElement;
                if (psiAssignmentExpression.getOperationTokenType() == JavaTokenType.EQ && psiAssignmentExpression.getRExpression() == prevElement) {
                    nextElement = psiAssignmentExpression.getLExpression();
                }
            } else if (psiElement instanceof PsiParenthesizedExpression || psiElement instanceof PsiTypeCastExpression) {
                nextElement = psiElement.getParent();
            } else if (psiElement instanceof PsiMethodCallExpression && this.isPortableRemoteObjectNarrowCall(psiMethodCallExpression = (PsiMethodCallExpression)psiElement)) {
                nextElement = psiElement.getParent();
            }
            prevElement = psiElement;
            psiElement = nextElement;
        }
        return psiElement;
    }

    private boolean checkElementType(PsiElement psiElement, PsiClass psiClass) {
        PsiExpression psiExpression;
        if (psiClass == null) {
            return false;
        }
        PsiClass curClass = null;
        if (psiElement instanceof PsiVariable) {
            PsiVariable psiVariable = (PsiVariable)psiElement;
            if (psiVariable.getType() instanceof PsiClassType) {
                curClass = ((PsiClassType)psiVariable.getType()).resolve();
            }
        } else if (psiElement instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)psiElement;
            if (psiMethod.getReturnType() instanceof PsiClassType) {
                curClass = ((PsiClassType)psiMethod.getReturnType()).resolve();
            }
        } else if (psiElement instanceof PsiExpression && (psiExpression = (PsiExpression)psiElement).getType() instanceof PsiClassType) {
            curClass = ((PsiClassType)psiExpression.getType()).resolve();
        }
        return curClass != null && (psiClass.equals(curClass) || psiClass.isInheritor(curClass, true));
    }

    private Set<PsiMethodCallExpression> findHomeCreateInvocationsByHomeUsage(PsiClass psiHomeClass, PsiElement psiStartUsage, Set<PsiMethodCallExpression> homeUsages) {
        ArrayList<PsiElement> variables;
        block7: {
            block6: {
                variables = new ArrayList<PsiElement>();
                if (!(psiStartUsage instanceof PsiVariable) && !(psiStartUsage instanceof PsiMethod)) break block6;
                if (!this.checkElementType(psiStartUsage, psiHomeClass)) break block7;
                variables.add(psiStartUsage);
                break block7;
            }
            for (PsiElement psiElement = psiStartUsage.getParent(); psiElement != null; psiElement = psiElement.getParent()) {
                if (psiElement instanceof PsiVariable || psiElement instanceof PsiMethod) {
                    if (!this.checkElementType(psiElement, psiHomeClass)) break;
                    variables.add(psiElement);
                    break;
                }
                if (psiElement instanceof PsiExpressionStatement) break;
                if (psiElement instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression psiAssignmentExpression = (PsiAssignmentExpression)psiElement;
                    PsiElement psiLeft = psiAssignmentExpression.getLExpression().getReference().resolve();
                    if (!(psiLeft instanceof PsiVariable) || !this.checkElementType(psiLeft, psiHomeClass)) continue;
                    variables.add(psiLeft);
                    continue;
                }
                if (!(psiElement instanceof PsiMethodCallExpression)) continue;
                PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiElement;
                PsiMethod psiMethod = psiMethodCallExpression.resolveMethod();
                if (!psiMethod.getName().startsWith(CREATE_METHOD_PREFIX) || !this.checkElementType((PsiElement)psiMethodCallExpression.getMethodExpression().getQualifierExpression(), psiHomeClass)) break;
                homeUsages.add(psiMethodCallExpression);
                break;
            }
        }
        for (PsiElement variable : variables) {
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)variable)) {
                PsiElement methodName;
                if (!(psiReference.getElement() instanceof PsiExpression)) continue;
                PsiExpression psiElement = (PsiExpression)psiReference.getElement();
                PsiVariable lValue = (PsiVariable)this.findLValue(psiElement, true);
                if (lValue != null) {
                    this.findHomeCreateInvocationsByHomeUsage(psiHomeClass, (PsiElement)lValue, homeUsages);
                    continue;
                }
                PsiMethodCallExpression psiExpression = (PsiMethodCallExpression)JavaResolveUtil.findParentContextOfClass((PsiElement)psiElement, PsiMethodCallExpression.class, (boolean)false);
                if (psiExpression == null || (methodName = psiExpression.getMethodExpression().getLastChild()) == null || !methodName.getText().startsWith(CREATE_METHOD_PREFIX)) continue;
                homeUsages.add(psiExpression);
            }
        }
        return homeUsages;
    }

    private PsiDeclarationStatement createLocalVariable(PsiClass psiClass, String initializer, PsiStatement psiContext) throws IncorrectOperationException {
        PsiExpression initializerExpression;
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiContext.getProject()).getElementFactory();
        PsiClassType psiType = psiElementFactory.createType(psiClass);
        try {
            initializerExpression = this.createNeededCasts((PsiType)psiType, psiElementFactory.createExpressionFromText(initializer, (PsiElement)psiContext), null);
        }
        catch (IncorrectOperationException e) {
            initializerExpression = psiElementFactory.createExpressionFromText("$INVALID$", null);
            this.addFileToInvalidValueHolders((PsiElement)psiContext);
        }
        String name = this.suggestUniqueVariableName(VariableKind.LOCAL_VARIABLE, null, (PsiType)psiType, initializerExpression, (PsiElement)psiContext);
        return psiElementFactory.createVariableDeclarationStatement(name, (PsiType)psiType, initializerExpression);
    }

    private String suggestUniqueVariableName(VariableKind variableKind, String baseName, PsiType psiType, PsiExpression initializerExpression, PsiElement psiContext) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiContext.getProject());
        SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(variableKind, baseName, initializerExpression, psiType);
        String suggestedName = suggestedNameInfo.names[0];
        if (variableKind == VariableKind.LOCAL_VARIABLE) {
            suggestedName = suggestedName + this.getUniqueVariablePostfix(this.variablePostfixMap, psiContext);
            PsiClass psiClass = (PsiClass)JavaResolveUtil.findParentContextOfClass((PsiElement)psiContext, PsiClass.class, (boolean)false);
            if (psiClass != null) {
                Map<String, PsiField> fields = this.getAddedFields(psiClass);
                String tmpName = suggestedName;
                while (fields.containsKey(suggestedName)) {
                    suggestedName = tmpName + this.getUniqueVariablePostfix(this.variablePostfixMap, psiContext);
                }
            }
        }
        String uniqueName = codeStyleManager.suggestUniqueVariableName(suggestedName, psiContext instanceof PsiClass ? ((PsiClass)psiContext).getLBrace() : psiContext, true);
        return uniqueName;
    }

    private void rebuildJndiEnvironmentMap(EnvironmentGroup ejbEnvironment, Map<String, JavaeeReference> referenceMap) {
        for (Resource resource : ejbEnvironment.getResources()) {
            ContainerUtil.putIfNotNull((Object)resource.getName().getValue(), (Object)resource, referenceMap);
        }
        for (EjbReference reference : ejbEnvironment.getEjbReferences()) {
            ContainerUtil.putIfNotNull((Object)reference.getName().getValue(), (Object)reference, referenceMap);
        }
        for (EjbReference reference : ejbEnvironment.getServiceRefs()) {
            ContainerUtil.putIfNotNull((Object)reference.getName().getValue(), (Object)reference, referenceMap);
        }
    }

    private void replaceLookupsWithInjection(PsiClass psiTargetClass, EnvironmentGroup ejbEnvironment, Map<PsiMethodCallExpression, String> lookupUsages, Map<String, JavaeeReference> referenceMap, Set<PsiElement> contextObjects, Set<String> jndiNames, boolean fixNamingExceptions) {
        PsiField psiField;
        String jndiName;
        PsiMethodCallExpression methodCallExpression;
        boolean addFieldDefault;
        boolean bl = addFieldDefault = this.myConfiguration.getPreferredAccess() == ApplyJavaeeStyleConfiguration.EnvironmentAccess.INJECTION && this.myConfiguration.isEnlisted(ejbEnvironment);
        if (!this.willDropHomeInterfaces && !addFieldDefault) {
            return;
        }
        TreeMap<String, PsiClass> injectedFieldsToClasses = new TreeMap<String, PsiClass>();
        TreeMap<String, PsiField> injectedFields = new TreeMap<String, PsiField>();
        Iterator<Map.Entry<Object, String>> it = lookupUsages.entrySet().iterator();
        while (it.hasNext()) {
            PsiClass psiClassPrev;
            boolean addField;
            PsiClass psiClass;
            JavaeeReferenceImpl annoElement;
            Map.Entry<PsiMethodCallExpression, String> entry = it.next();
            methodCallExpression = entry.getKey();
            jndiName = entry.getValue();
            JavaeeReference ref = referenceMap.get(jndiName);
            if (ref == null || (annoElement = (JavaeeReferenceImpl)((Object)ModelMergerUtil.getImplementation((Object)ref, JavaeeReferenceImpl.class))) != null && !(annoElement.getPsiMember() instanceof PsiClass) || (psiClass = this.getContainingClass(psiTargetClass, (PsiElement)methodCallExpression)) == null) continue;
            if (ref instanceof EjbReference) {
                EjbReference ejbReference = (EjbReference)ref;
                if (!(ejbReference.getEjbLink().getValue() instanceof EjbWithHome)) continue;
                EjbWithHome targetEjb = (EjbWithHome)ejbReference.getEjbLink().getValue();
                PsiClass targetInterface = (PsiClass)ejbReference.getBeanInterface().getValue();
                if (!this.willHaveHomeInterface((EnterpriseBean)targetEjb)) {
                    if (targetInterface == targetEjb.getHome().getValue() || targetInterface == targetEjb.getLocalHome().getValue()) {
                        boolean remote = targetInterface == targetEjb.getHome().getValue();
                        PsiClass psiHomeClass = remote ? (PsiClass)targetEjb.getHome().getValue() : (PsiClass)targetEjb.getLocalHome().getValue();
                        PsiClass psiIntfClass = remote ? (PsiClass)targetEjb.getRemote().getValue() : (PsiClass)targetEjb.getLocal().getValue();
                        it.remove();
                        PsiExpression psiLookupExpression = this.removeUnnecessaryCastsAndNarrows((PsiElement)methodCallExpression, methodCallExpression.getType());
                        PsiExpression psiContextAccessExpression = this.createAccessExpression((PsiMember)this.getOrCreateEjbContextField(psiTargetClass, ejbEnvironment, (PsiElement)psiLookupExpression), (PsiElement)psiLookupExpression, false);
                        String initializerString = psiContextAccessExpression.getText() + "." + LOOKUP_METHOD_NAME + "(" + AnnotationTextUtil.quote(jndiName) + ")";
                        for (PsiMethodCallExpression psiCreateMethodCallExpression : this.findHomeCreateInvocationsByHomeUsage(psiHomeClass, (PsiElement)psiLookupExpression, new TreeSet<PsiElement>(JavaeeStyleEngine.createTopToBottomPsiComparator()))) {
                            this.replaceOldHomeCreateMethod(psiCreateMethodCallExpression, psiIntfClass, initializerString, jndiName);
                            contextObjects.add(psiCreateMethodCallExpression.getMethodExpression().getQualifier());
                        }
                        contextObjects.add(this.findLValue(psiLookupExpression, false));
                        jndiNames.add(jndiName);
                    }
                    addField = false;
                } else {
                    addField = addFieldDefault;
                }
            } else {
                addField = addFieldDefault;
            }
            if (!addField || (psiClassPrev = (PsiClass)injectedFieldsToClasses.get(jndiName)) != null && !psiClassPrev.isInheritor(psiClass, true)) continue;
            injectedFieldsToClasses.put(jndiName, psiClass);
        }
        for (Map.Entry<Object, String> entry : injectedFieldsToClasses.entrySet()) {
            PsiClass psiFieldClass;
            String jndiName2 = (String)entry.getKey();
            JavaeeReference ref = referenceMap.get(jndiName2);
            PsiClass psiClass = (PsiClass)entry.getValue();
            if (ref instanceof EjbReference) {
                psiFieldClass = (PsiClass)((EjbReference)ref).getBeanInterface().getValue();
            } else if (ref instanceof ServiceRef) {
                psiFieldClass = (PsiClass)((ServiceRef)ref).getType().getValue();
            } else if (ref instanceof Resource) {
                psiFieldClass = (PsiClass)((Resource)ref).getType().getValue();
            } else {
                psiFieldClass = null;
                assert (false) : ref;
            }
            if (psiFieldClass == null) continue;
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
            PsiClassType psiType = psiElementFactory.createType(psiFieldClass);
            String baseName = this.suggestPropertyNameByJndiName(jndiName2);
            String varName = this.suggestUniqueVariableName(VariableKind.FIELD, baseName, (PsiType)psiType, null, (PsiElement)psiClass);
            psiField = this.getAddedFields(psiClass).get(varName);
            if (psiField == null) {
                boolean protectedFlag = psiClass != psiTargetClass;
                PsiAnnotation psiAnnotation = this.createReferenceAnnotation(psiTargetClass, varName, ref, null, psiFieldClass.getQualifiedName());
                psiField = psiElementFactory.createField(varName, (PsiType)psiType);
                psiField.getModifierList().addAfter((PsiElement)psiAnnotation, null);
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiField, (String)(protectedFlag ? "protected" : "private"), (boolean)true);
                this.addUsageInfo(this.updateFieldsMap(new AddElementUsageInfo((PsiElement)psiClass, null, (PsiElement)psiClass, null, true, Collections.singletonList(psiField))));
            }
            injectedFields.put(jndiName2, psiField);
        }
        if (!addFieldDefault) {
            return;
        }
        it = lookupUsages.entrySet().iterator();
        while (it.hasNext()) {
            PsiExpression newAccessExpression;
            Map.Entry<Object, String> entry = it.next();
            methodCallExpression = (PsiElement)entry.getKey();
            jndiName = entry.getValue();
            PsiField psiAccessor = null;
            PsiType psiType = null;
            if (jndiName.length() == 0) {
                psiAccessor = this.getOrCreateEjbContextField(psiTargetClass, ejbEnvironment, (PsiElement)methodCallExpression);
                psiType = psiAccessor.getType();
            } else {
                JavaeeModelElement ref = (JavaeeModelElement)referenceMap.get(jndiName);
                if (ref == null) continue;
                JavaeeReferenceImpl annoElement = (JavaeeReferenceImpl)((Object)ModelMergerUtil.getImplementation((Object)ref, JavaeeReferenceImpl.class));
                PsiMember psiMember = injectedFields.containsKey(jndiName) ? (PsiMember)injectedFields.get(jndiName) : (annoElement != null && annoElement.getPsiMember() != null ? annoElement.getPsiMember() : null);
                if (psiMember instanceof PsiMethod) {
                    String name = PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)psiMember));
                    if (name != null) {
                        psiField = psiMember.getContainingClass().findFieldByName(name, true);
                        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)psiMember.getContainingClass(), (String)name, (boolean)false, (boolean)true);
                        psiAccessor = getter != null ? getter : psiField;
                        psiType = getter != null ? getter.getReturnType() : psiField.getType();
                    }
                } else if (psiMember instanceof PsiField) {
                    psiAccessor = psiMember;
                    psiType = ((PsiField)psiMember).getType();
                }
            }
            if (psiAccessor == null || (newAccessExpression = this.createAccessExpression((PsiMember)psiAccessor, (PsiElement)methodCallExpression, false)) == null) continue;
            it.remove();
            PsiExpression replaceExpression = this.removeUnnecessaryCastsAndNarrows((PsiElement)methodCallExpression, psiType);
            if (replaceExpression.getParent() instanceof PsiExpressionStatement) {
                this.dropElement(replaceExpression.getParent());
            } else {
                this.replaceElement((PsiElement)replaceExpression, (PsiElement)newAccessExpression);
                this.inlineIfPossible(replaceExpression, newAccessExpression, psiType);
            }
            if (!fixNamingExceptions) continue;
            this.addNameNotFoundExceptionCheck((PsiElement)methodCallExpression, newAccessExpression.getText(), jndiName);
        }
    }

    private String suggestPropertyNameByJndiName(String jndiName) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(jndiName, "/");
        boolean first = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            sb.append(first ? Character.toLowerCase(token.charAt(0)) : Character.toUpperCase(token.charAt(0))).append(token, 1, token.length());
            if (!first) continue;
            first = false;
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void replaceInjectionWithLookups(EnvironmentGroup ejbEnvironment, Map<String, JavaeeReference> referenceMap, Set<PsiElement> contextObjects, Set<String> jndiNames, PsiClass psiTargetClass) {
        boolean replaceWithLookupDefault;
        boolean bl = replaceWithLookupDefault = this.myConfiguration.getPreferredAccess() == ApplyJavaeeStyleConfiguration.EnvironmentAccess.LOOKUP && this.myConfiguration.isEnlisted(ejbEnvironment);
        if (!this.willDropHomeInterfaces && !replaceWithLookupDefault) {
            return;
        }
        Iterator<Map.Entry<String, JavaeeReference>> iterator = referenceMap.entrySet().iterator();
        while (true) {
            boolean replaceWithLookup;
            PsiMethod psiPropertySetter;
            PsiMethod psiPropertyGetter;
            PsiField psiPropertyField;
            String jndiName;
            block13: {
                int n;
                PsiElement[] psiElementArray;
                HashSet<PsiElement> processedUsages;
                PsiClass psiIntfClass;
                PsiClass psiHomeClass;
                block16: {
                    JavaeeReference javaeeReference;
                    block14: {
                        block15: {
                            if (!iterator.hasNext()) {
                                return;
                            }
                            Map.Entry<String, JavaeeReference> entry = iterator.next();
                            jndiName = entry.getKey();
                            javaeeReference = entry.getValue();
                            JavaeeReferenceImpl annoElement = (JavaeeReferenceImpl)((Object)ModelMergerUtil.getImplementation((Object)javaeeReference, JavaeeReferenceImpl.class));
                            if (annoElement == null) continue;
                            PsiMember psiMember = annoElement.getPsiMember();
                            psiPropertyField = null;
                            psiPropertyGetter = null;
                            psiPropertySetter = null;
                            if (psiMember == null || psiMember instanceof PsiClass) continue;
                            if (psiMember instanceof PsiField) {
                                psiPropertyField = (PsiField)psiMember;
                                psiPropertyGetter = PropertyUtilBase.findPropertyGetter((PsiClass)psiMember.getContainingClass(), (String)psiMember.getName(), (boolean)false, (boolean)true);
                                psiPropertySetter = PropertyUtilBase.findPropertyGetter((PsiClass)psiMember.getContainingClass(), (String)psiMember.getName(), (boolean)false, (boolean)true);
                            } else if (psiMember instanceof PsiMethod) {
                                psiPropertySetter = (PsiMethod)psiMember;
                                String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)psiPropertySetter);
                                if (propertyName == null) continue;
                                psiPropertyGetter = PropertyUtilBase.findPropertyGetter((PsiClass)psiMember.getContainingClass(), (String)propertyName, (boolean)false, (boolean)true);
                                psiPropertyField = PropertyUtilBase.findPropertyField((PsiClass)psiMember.getContainingClass(), (String)propertyName, (boolean)false);
                                if (psiPropertyGetter == null && psiPropertyField != null) {
                                    // empty if block
                                }
                            } else assert (false) : "annotated element not a field, method or class";
                            if (psiPropertyField == null && psiPropertyGetter == null) continue;
                            if (!(javaeeReference instanceof EjbReference)) break block14;
                            EjbReference ejbReference = (EjbReference)javaeeReference;
                            if (!(ejbReference.getEjbLink().getValue() instanceof EjbWithHome)) continue;
                            EjbWithHome targetEjb = (EjbWithHome)ejbReference.getEjbLink().getValue();
                            PsiClass targetInterface = (PsiClass)ejbReference.getBeanInterface().getValue();
                            if (this.willHaveHomeInterface((EnterpriseBean)targetEjb) || targetInterface != targetEjb.getHome().getValue() && targetInterface != targetEjb.getLocalHome().getValue()) break block15;
                            boolean remote = targetInterface == targetEjb.getHome().getValue();
                            psiHomeClass = remote ? (PsiClass)targetEjb.getHome().getValue() : (PsiClass)targetEjb.getLocalHome().getValue();
                            psiIntfClass = remote ? (PsiClass)targetEjb.getRemote().getValue() : (PsiClass)targetEjb.getLocal().getValue();
                            processedUsages = new HashSet<PsiElement>();
                            psiElementArray = new PsiElement[]{psiPropertyField, psiPropertyGetter};
                            n = psiElementArray.length;
                            break block16;
                        }
                        replaceWithLookup = replaceWithLookupDefault;
                        break block13;
                    }
                    if (javaeeReference instanceof Resource) {
                        Resource resource = (Resource)javaeeReference;
                        replaceWithLookup = this.getContextClassName(ejbEnvironment).equals(resource.getType().getStringValue()) || "javax.ejb.EJBContext".equals(resource.getType().getStringValue()) ? false : replaceWithLookupDefault;
                        break block13;
                    } else {
                        replaceWithLookup = replaceWithLookupDefault;
                    }
                    break block13;
                }
                for (int i = 0; i < n; ++i) {
                    PsiElement psiElement = psiElementArray[i];
                    if (psiElement == null) continue;
                    for (PsiMethodCallExpression psiCreateMethodCallExpression : this.findHomeCreateInvocationsByHomeUsage(psiHomeClass, psiElement, new TreeSet<PsiElement>(JavaeeStyleEngine.createTopToBottomPsiComparator()))) {
                        PsiExpression psiContextAccessExpression = this.createAccessExpression((PsiMember)this.getOrCreateEjbContextField(psiTargetClass, ejbEnvironment, (PsiElement)psiCreateMethodCallExpression), (PsiElement)psiCreateMethodCallExpression, false);
                        String initializerString = psiContextAccessExpression.getText() + "." + LOOKUP_METHOD_NAME + "(" + AnnotationTextUtil.quote(jndiName) + ")";
                        this.replaceOldHomeCreateMethod(psiCreateMethodCallExpression, psiIntfClass, initializerString, jndiName);
                        contextObjects.add(psiCreateMethodCallExpression.getMethodExpression().getQualifier());
                        processedUsages.add(psiCreateMethodCallExpression.getMethodExpression().getQualifier());
                    }
                }
                this.dropElementUsages(processedUsages, new PsiElement[]{psiPropertyField, psiPropertyGetter, psiPropertySetter});
                jndiNames.add(jndiName);
                replaceWithLookup = false;
            }
            if (!replaceWithLookup) continue;
            this.replacePropertyWithLookup(psiTargetClass, ejbEnvironment, jndiName, psiPropertyField, psiPropertyGetter, psiPropertySetter);
            jndiNames.add(jndiName);
        }
    }

    private void replacePropertyWithLookup(PsiClass psiTargetClass, EnvironmentGroup ejbEnvironment, String jndiName, PsiField psiPropertyField, PsiMethod psiPropertyGetter, PsiMethod psiPropertySetter) {
        HashSet<PsiElement> processedUsages = new HashSet<PsiElement>();
        for (PsiElement psiElement : new PsiElement[]{psiPropertyField, psiPropertyGetter}) {
            if (psiElement == null) continue;
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)psiElement)) {
                if (!(psiReference.getElement() instanceof PsiExpression)) continue;
                PsiExpression psiExpression = (PsiExpression)(psiElement instanceof PsiMethod ? psiReference.getElement().getParent() : psiReference.getElement());
                PsiExpression psiContextAccessExpression = this.createAccessExpression((PsiMember)this.getOrCreateEjbContextField(psiTargetClass, ejbEnvironment, (PsiElement)psiExpression), (PsiElement)psiExpression, false);
                String accessString = psiContextAccessExpression.getText() + "." + LOOKUP_METHOD_NAME + "(" + AnnotationTextUtil.quote(jndiName) + ")";
                PsiExpression newAccessExpression = this.createNeededCasts(psiExpression.getType(), JavaPsiFacade.getInstance((Project)psiExpression.getProject()).getElementFactory().createExpressionFromText(accessString, psiExpression.getContext()), psiExpression);
                this.replaceElement((PsiElement)psiExpression, (PsiElement)newAccessExpression);
                processedUsages.add(psiReference.getElement());
            }
        }
        this.dropElementUsages(processedUsages, new PsiElement[]{psiPropertyField, psiPropertyGetter, psiPropertySetter});
    }

    private void dropElementUsages(Set<PsiElement> processedUsages, PsiElement ... psiElements) {
        for (PsiElement psiPropertyElement : psiElements) {
            if (psiPropertyElement == null) continue;
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)psiPropertyElement)) {
                PsiElement element = psiReference.getElement();
                if (processedUsages.contains(element)) continue;
                PsiElement psiStatement = JavaResolveUtil.findParentContextOfClass((PsiElement)element, PsiStatement.class, (boolean)false);
                this.dropElement(psiStatement != null ? psiStatement : element);
            }
            this.dropElement(psiPropertyElement);
        }
    }

    private PsiClass getContainingClass(PsiClass psiClassInitial, PsiElement psiElement) {
        HashSet ejbClassSupers = new HashSet(JamCommonUtil.getSuperClassList((PsiClass)psiClassInitial));
        PsiClass psiClass = (PsiClass)JavaResolveUtil.findParentContextOfClass((PsiElement)psiElement, PsiClass.class, (boolean)false);
        while (psiClass != null && !ejbClassSupers.contains(psiClass)) {
            if (psiClass instanceof PsiAnonymousClass) {
                psiClass = (PsiClass)JavaResolveUtil.findParentContextOfClass((PsiElement)psiClass, PsiClass.class, (boolean)true);
                continue;
            }
            psiClass = psiClass.getContainingClass();
        }
        return psiClass;
    }

    private PsiExpression createAccessExpression(PsiMember psiMember, PsiElement psiContext, boolean storeContextInExpression) throws IncorrectOperationException {
        String expressionString = psiMember instanceof PsiMethod ? psiMember.getName() + "()" : psiMember.getName();
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiContext.getProject()).getElementFactory();
        PsiClass contextClass = (PsiClass)JavaResolveUtil.findParentContextOfClass((PsiElement)psiContext, PsiClass.class, (boolean)true);
        PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)contextClass);
        String[] accessPrefixes = contextClass.getContainingClass() != null || contextClass.getQualifiedName() == null ? new String[]{"", topLevelClass.getQualifiedName() + "." + THIS_PREFIX} : new String[]{"", THIS_PREFIX};
        String accessString = expressionString;
        for (String accessPrefix : accessPrefixes) {
            String text = accessPrefix + expressionString;
            PsiExpression newAccessExpression = psiElementFactory.createExpressionFromText(text, psiContext);
            assert (newAccessExpression instanceof PsiJavaReference);
            PsiJavaReference psiReferenceExpression = (PsiJavaReference)newAccessExpression;
            JavaResolveResult[] resolveResults = psiReferenceExpression.multiResolve(false);
            if (resolveResults.length != 0 && (resolveResults.length != 1 || resolveResults[0].getElement() != psiMember || !resolveResults[0].isValidResult())) continue;
            if (storeContextInExpression) {
                return newAccessExpression;
            }
            accessString = text;
            break;
        }
        return psiElementFactory.createExpressionFromText(accessString, null);
    }

    private void inlineIfPossible(PsiExpression replaceExpression, PsiExpression newExpression, PsiType psiType) {
        if (!this.myConfiguration.isInlineInjectedFields()) {
            return;
        }
        HashSet<PsiVariable> processedVariables = new HashSet<PsiVariable>();
        PsiElement lValue = this.findLValue(replaceExpression, true);
        if (lValue instanceof PsiVariable) {
            this.inlineIfPossible((PsiVariable)lValue, newExpression, psiType, false, processedVariables);
        }
    }

    private boolean inlineIfPossible(PsiVariable psiVariable, PsiExpression replaceExpression, PsiType defaultExpressionType, boolean localOnly, Set<PsiVariable> processedVariables) {
        if (localOnly && !(psiVariable instanceof PsiLocalVariable)) {
            return false;
        }
        if (processedVariables.contains(psiVariable)) {
            return true;
        }
        processedVariables.add(psiVariable);
        PsiExpression[] nonNullAssignmentExpressions = this.getNonNullAssignmentExpressions(psiVariable);
        if (nonNullAssignmentExpressions.length > 1) {
            return false;
        }
        com.intellij.util.Query query = ReferencesSearch.search((PsiElement)psiVariable);
        for (PsiReference psiReference : query) {
            boolean replace;
            PsiElement psiElement = psiReference.getElement();
            if (psiElement == psiVariable) {
                replace = false;
            } else if (psiElement.getParent() instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression psiAssignmentExpression = (PsiAssignmentExpression)psiElement.getParent();
                if (psiAssignmentExpression.getLExpression() == psiElement) {
                    if (psiAssignmentExpression.getParent() instanceof PsiExpressionStatement) {
                        this.dropElement(psiAssignmentExpression.getParent());
                        replace = false;
                    } else if (psiAssignmentExpression.getRExpression() != null) {
                        this.replaceElement((PsiElement)psiAssignmentExpression, (PsiElement)psiAssignmentExpression.getRExpression());
                        replace = false;
                    } else {
                        replace = true;
                    }
                } else if (psiAssignmentExpression.getRExpression() == psiElement) {
                    PsiElement psiNextVariable = psiAssignmentExpression.getLExpression().getReference().resolve();
                    replace = localOnly && psiNextVariable instanceof PsiLocalVariable || psiNextVariable instanceof PsiVariable ? !this.inlineIfPossible((PsiVariable)psiNextVariable, replaceExpression, defaultExpressionType, localOnly, processedVariables) : true;
                } else {
                    replace = true;
                }
            } else {
                replace = true;
            }
            if (!replace) continue;
            this.replaceElement((PsiElement)this.removeUnnecessaryCastsAndNarrows(psiElement, defaultExpressionType != null ? defaultExpressionType : replaceExpression.getType()), (PsiElement)replaceExpression);
        }
        this.dropElement((PsiElement)psiVariable);
        return true;
    }

    private boolean hasHomeInterfacesNow(EnterpriseBean ejb) {
        if (ejb instanceof EjbWithHome) {
            EjbWithHome ejbWithHome = (EjbWithHome)ejb;
            return ejbWithHome.getHome().getValue() != null || ejbWithHome.getLocalHome().getValue() != null;
        }
        return false;
    }

    private boolean willHaveHomeInterface(EnterpriseBean ejb) {
        boolean hasHomeNow = this.hasHomeInterfacesNow(ejb);
        if (hasHomeNow) {
            Module ejbModule = ejb.getModule();
            boolean homeWillBeProcessed = ejb instanceof SessionBean;
            if (homeWillBeProcessed && this.myConfiguration.getModule() == ejbModule) {
                return this.myConfiguration.isHomeInterfaceEnabled(ejb);
            }
        }
        return hasHomeNow;
    }

    private PsiExpression removeUnnecessaryCastsAndNarrows(PsiElement newAccessExpression, PsiType psiType) {
        PsiClassType psiEjbContextType = JavaPsiFacade.getInstance((Project)newAccessExpression.getProject()).getElementFactory().createType(this.findClass("javax.ejb.EJBContext", newAccessExpression));
        PsiClassType psiJndiContextType = JavaPsiFacade.getInstance((Project)newAccessExpression.getProject()).getElementFactory().createType(this.findClass("javax.naming.Context", newAccessExpression));
        PsiElement lastGood = newAccessExpression;
        for (PsiElement psiElement = newAccessExpression.getParent(); psiElement != null; psiElement = psiElement.getParent()) {
            PsiMethodCallExpression psiMethodCallExpression;
            if (psiElement instanceof PsiParenthesizedExpression) {
                lastGood = psiElement;
                continue;
            }
            if (psiElement instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression psiTypeCastExpression = (PsiTypeCastExpression)psiElement;
                PsiTypeElement psiCastTypeElement = psiTypeCastExpression.getCastType();
                if (!(psiCastTypeElement != null && psiType != null && (psiCastTypeElement.getType().isAssignableFrom(psiType) || psiEjbContextType.isAssignableFrom(psiType) && psiJndiContextType.isAssignableFrom(psiCastTypeElement.getType())))) {
                    lastGood = psiTypeCastExpression.getOperand();
                    break;
                }
                lastGood = psiElement;
                continue;
            }
            if (psiElement instanceof PsiExpressionList) continue;
            if (!(psiElement instanceof PsiMethodCallExpression) || !this.isPortableRemoteObjectNarrowCall(psiMethodCallExpression = (PsiMethodCallExpression)psiElement)) break;
            lastGood = psiElement;
        }
        return (PsiExpression)lastGood;
    }

    private boolean isPortableRemoteObjectNarrowCall(PsiMethodCallExpression psiMethodCallExpression) {
        PsiMethod psiMethod = psiMethodCallExpression.resolveMethod();
        return psiMethod != null && NARROW_METHOD_NAME.equals(psiMethod.getName()) && JAVAX_RMI_PORTABLE_REMOTE_OBJECT.equals(psiMethod.getContainingClass().getQualifiedName());
    }

    /*
     * WARNING - void declaration
     */
    private void removeUnusedVariables(Set<PsiElement> contextObjects) {
        void var7_12;
        if (contextObjects.size() == 0) {
            return;
        }
        HashSet<PsiVariable> variables = new HashSet<PsiVariable>();
        for (PsiElement contextObject : contextObjects) {
            PsiReferenceExpression psiReferenceExpression;
            Object psiElement;
            if (contextObject instanceof PsiVariable) {
                variables.add((PsiVariable)contextObject);
                continue;
            }
            if (!(contextObject instanceof PsiReferenceExpression) || !((psiElement = (psiReferenceExpression = (PsiReferenceExpression)contextObject).resolve()) instanceof PsiVariable)) continue;
            variables.add((PsiVariable)psiElement);
        }
        HashSet<PsiElement> goodElementsSet = new HashSet<PsiElement>();
        HashSet<Object> badVariablesSet = new HashSet<Object>();
        HashMap<PsiVariable, ArrayList<PsiVariable>> dependencyMap = new HashMap<PsiVariable, ArrayList<PsiVariable>>();
        block1: for (PsiVariable psiVariable : variables) {
            com.intellij.util.Query query = ReferencesSearch.search((PsiElement)psiVariable);
            for (PsiReference psiReference : query) {
                PsiAssignmentExpression psiAssignmentExpression;
                boolean good = false;
                PsiElement element = psiReference.getElement();
                PsiElement psiExpression = element.getParent();
                for (PsiElement initializerElement : this.initializerElements) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)initializerElement, (PsiElement)element, (boolean)false)) continue;
                    badVariablesSet.add(psiVariable);
                    continue block1;
                }
                PsiVariable depVariable = null;
                if (psiExpression instanceof PsiAssignmentExpression && (psiAssignmentExpression = (PsiAssignmentExpression)psiExpression).getLExpression() == element) {
                    good = true;
                }
                if (!good && element instanceof PsiExpression) {
                    PsiElement psiElement;
                    depVariable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiVariable.class);
                    if (depVariable == null && (psiAssignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAssignmentExpression.class)) != null && psiAssignmentExpression.getOperationTokenType() == JavaTokenType.EQ && PsiTreeUtil.isAncestor((PsiElement)psiAssignmentExpression.getRExpression(), (PsiElement)element, (boolean)false) && (psiElement = psiAssignmentExpression.getLExpression().getReference().resolve()) instanceof PsiVariable) {
                        depVariable = (PsiVariable)psiElement;
                    }
                    good = depVariable != null && variables.contains(depVariable);
                }
                boolean replacedOrDeleted = false;
                for (PsiElement e = element; e != null && !(e instanceof PsiCodeBlock) && !(replacedOrDeleted = this.isElementReplacedOrDeleted(e)); e = e.getParent()) {
                }
                if (replacedOrDeleted) {
                    good = true;
                    goodElementsSet.add(element);
                }
                if (!good) {
                    badVariablesSet.add(psiVariable);
                    continue block1;
                }
                if (depVariable == null) continue;
                ArrayList<PsiVariable> list = (ArrayList<PsiVariable>)dependencyMap.get(psiVariable);
                if (list == null) {
                    list = new ArrayList<PsiVariable>();
                    dependencyMap.put(psiVariable, list);
                }
                list.add(depVariable);
            }
        }
        for (Map.Entry entry : dependencyMap.entrySet()) {
            boolean bl;
            if (badVariablesSet.contains(entry.getKey())) continue;
            boolean bl2 = false;
            for (Map.Entry entry2 : dependencyMap.entrySet()) {
                if (badVariablesSet.contains(entry2.getKey())) continue;
                for (PsiVariable variable : (List)entry2.getValue()) {
                    if (!badVariablesSet.contains(variable)) continue;
                    badVariablesSet.add(entry2.getKey());
                    bl = true;
                }
            }
            if (bl) continue;
            break;
        }
        dependencyMap.clear();
        HashSet<Object> removedElements = new HashSet<Object>();
        for (PsiVariable psiVariable : variables) {
            if (badVariablesSet.contains(psiVariable)) continue;
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)psiVariable)) {
                PsiElement element = psiReference.getElement();
                if (goodElementsSet.contains(element)) continue;
                PsiStatement psiStatement = (PsiStatement)JavaResolveUtil.findParentContextOfClass((PsiElement)element, PsiStatement.class, (boolean)false);
                removedElements.add(psiStatement);
            }
            boolean declarationRemoved = false;
            if (psiVariable.getParent() instanceof PsiDeclarationStatement) {
                declarationRemoved = true;
                for (PsiElement psiElement : ((PsiDeclarationStatement)psiVariable.getParent()).getDeclaredElements()) {
                    if (psiElement == psiVariable || variables.contains(psiElement) && !badVariablesSet.contains(psiElement)) continue;
                    declarationRemoved = false;
                    break;
                }
            }
            if (declarationRemoved) {
                removedElements.add(psiVariable.getParent());
                continue;
            }
            this.dropElement((PsiElement)psiVariable);
        }
        int n = removedElements.size() - 1;
        while (var7_12 > 0) {
            boolean bl;
            boolean bl3 = false;
            Iterator iterator = new ArrayList(removedElements).iterator();
            while (iterator.hasNext()) {
                PsiElement removedElement;
                PsiElement alsoGood = removedElement = (PsiElement)iterator.next();
                PsiElement e = removedElement.getParent();
                block13: while (e instanceof PsiCodeBlock) {
                    PsiCodeBlock psiCodeBlock = (PsiCodeBlock)e;
                    for (PsiStatement psiStatement : psiCodeBlock.getStatements()) {
                        if (removedElement != psiStatement && !removedElements.contains(psiStatement)) break block13;
                    }
                    PsiElement parent = e.getParent();
                    if (parent instanceof PsiCodeBlock) {
                        alsoGood = e;
                    } else {
                        PsiTryStatement psiTryStatement;
                        if (!(parent instanceof PsiStatement) || parent instanceof PsiTryStatement && (psiTryStatement = (PsiTryStatement)parent).getTryBlock() != e) break;
                        alsoGood = parent;
                    }
                    e = e.getParent();
                }
                if (alsoGood == removedElement) continue;
                removedElements.add(alsoGood);
                bl = true;
            }
            if (!bl) break;
            --var7_12;
        }
        for (PsiElement psiElement : removedElements) {
            this.dropElement(psiElement);
        }
    }

    private boolean isElementReplacedOrDeleted(PsiElement e) {
        MyUsageInfo info = this.usageInfos.get(e);
        if (info instanceof CompositeUsageInfo) {
            CompositeUsageInfo compositeUsageInfo = (CompositeUsageInfo)info;
            for (MyUsageInfo usageInfo : compositeUsageInfo.getChildren()) {
                if (!(usageInfo instanceof ReplaceElementUsageInfo) && !(usageInfo instanceof BaseDeleteUsageInfo)) continue;
                return true;
            }
        }
        return info instanceof ReplaceElementUsageInfo || info instanceof BaseDeleteUsageInfo;
    }

    private void replaceJndiLookupsWithEjbContextLookups(PsiClass psiTargetClass, EnvironmentGroup ejbEnvironment, Map<PsiMethodCallExpression, String> lookupUsages) {
        if (!this.myConfiguration.isReplaceJndiLookups() || !this.myConfiguration.isEnlisted(ejbEnvironment)) {
            return;
        }
        for (Map.Entry<PsiMethodCallExpression, String> entry : lookupUsages.entrySet()) {
            String jndiName = entry.getValue();
            PsiElement methodCallExpression = (PsiElement)entry.getKey();
            PsiField psiField = this.getOrCreateEjbContextField(psiTargetClass, ejbEnvironment, methodCallExpression);
            PsiExpression accessExpression = this.createAccessExpression((PsiMember)psiField, methodCallExpression, false);
            String template = accessExpression.getText() + "." + LOOKUP_METHOD_NAME;
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)methodCallExpression.getProject()).getElementFactory();
            String expressionString = template + "(\"" + StringUtil.escapeStringCharacters((String)jndiName) + "\")";
            PsiExpression newCallExpression = psiElementFactory.createExpressionFromText(expressionString, null);
            PsiClassType psiObjectType = psiElementFactory.createTypeByFQClassName("java.lang.Object", methodCallExpression.getResolveScope());
            this.replaceElement((PsiElement)this.removeUnnecessaryCastsAndNarrows(methodCallExpression, (PsiType)psiObjectType), (PsiElement)newCallExpression);
            this.addNameNotFoundExceptionCheck(methodCallExpression, expressionString, jndiName);
        }
    }

    private void addNameNotFoundExceptionCheck(PsiElement methodCallExpression, String expressionString, String jndiName) throws IncorrectOperationException {
        PsiStatement psiAnchor = null;
        PsiStatement methodCallStatement = (PsiStatement)JavaResolveUtil.findParentContextOfClass((PsiElement)methodCallExpression, PsiStatement.class, (boolean)true);
        if (methodCallStatement == null) {
            return;
        }
        PsiStatement psiPrevElement = methodCallStatement;
        for (PsiElement psiCurElement = methodCallStatement.getParent(); psiCurElement != null; psiCurElement = psiCurElement.getParent()) {
            if (psiCurElement instanceof PsiCodeBlock) {
                PsiStatement[] statements = ((PsiCodeBlock)psiCurElement).getStatements();
                psiAnchor = statements.length > 0 ? statements[0] : null;
                break;
            }
            if (psiCurElement instanceof PsiIfStatement || psiCurElement instanceof PsiForStatement || psiCurElement instanceof PsiWhileStatement || psiCurElement instanceof PsiDoWhileStatement) {
                psiAnchor = psiPrevElement;
                break;
            }
            psiPrevElement = psiCurElement;
        }
        if (psiAnchor == null) {
            return;
        }
        PsiStatement checkStatement = this.createThrowNamingExceptionStatement((PsiElement)psiAnchor, expressionString, jndiName);
        if (checkStatement != null) {
            this.addUsageInfo(new AddElementUsageInfo((PsiElement)psiAnchor, Boolean.FALSE, psiAnchor.getParent(), (PsiElement)psiAnchor, false, Collections.singletonList(checkStatement)));
        }
    }

    private PsiStatement createThrowNamingExceptionStatement(PsiElement psiContext, String accessExpression, String jndiName) throws IncorrectOperationException {
        if (jndiName != null && jndiName.length() == 0) {
            return null;
        }
        Set<String> strings = this.nameNotFoundChecksMap.get(psiContext);
        if (strings == null) {
            strings = new HashSet<String>();
            this.nameNotFoundChecksMap.put(psiContext, strings);
        } else if (strings.contains(accessExpression)) {
            return null;
        }
        strings.add(accessExpression);
        PsiStatement psiCheckStatement = JavaPsiFacade.getInstance((Project)psiContext.getProject()).getElementFactory().createStatementFromText("if (" + accessExpression + "==null) throw new javax.naming.NameNotFoundException(" + (jndiName != null ? AnnotationTextUtil.quote(jndiName) : "") + ");", null);
        return psiCheckStatement;
    }

    private PsiField getOrCreateEjbContextField(PsiClass psiTargetClass, EnvironmentGroup ejbEnvironment, PsiElement context) {
        String ejbContextType = this.getContextClassName(ejbEnvironment);
        String standardName = StringUtil.decapitalize((String)ejbContextType.substring(ejbContextType.lastIndexOf(46) + 1));
        assert (ejbContextType != null);
        PsiClass psiClass = this.getContainingClass(psiTargetClass, context);
        assert (psiClass != null);
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
        for (PsiField psiField : this.getAddedFields(psiClass).values()) {
            if (!ejbContextType.equals(psiField.getType().getCanonicalText())) continue;
            return psiField;
        }
        for (PsiField psiField : psiClass.getAllFields()) {
            PsiReferenceExpression referenceExpression;
            JavaResolveResult[] resolveResults;
            if (!ejbContextType.equals(psiField.getType().getCanonicalText()) || (resolveResults = (referenceExpression = (PsiReferenceExpression)this.createAccessExpression((PsiMember)psiField, context, true)).multiResolve(false)).length != 1 || resolveResults[0].getElement() != psiField || !resolveResults[0].isValidResult()) continue;
            PsiMethod setter = EjbUtil.findSetter(psiClass, psiField.getName(), psiField.getType(), true);
            if (setter == null) {
                setter = EjbUtil.findSetter(psiClass, standardName, psiField.getType(), true);
            }
            if (setter == null) {
                this.createAnnotation((PsiModifierListOwner)psiField, "javax.annotation.Resource", true, new String[0]);
            }
            return psiField;
        }
        PsiField psiField = psiElementFactory.createFieldFromText("private " + ejbContextType + " " + standardName + ";", null);
        psiField.getModifierList().addAfter((PsiElement)psiElementFactory.createAnnotationFromText("@javax.annotation.Resource", null), null);
        this.addUsageInfo(this.updateFieldsMap(new AddElementUsageInfo((PsiElement)psiClass, null, (PsiElement)psiClass, null, true, Collections.singletonList(psiField))));
        return psiField;
    }

    private String getContextClassName(EnvironmentGroup ejbEnvironment) {
        if (ejbEnvironment instanceof EnterpriseBean) {
            return EnterpriseBeanType.getEnterpriseBeanType((EnterpriseBean)ejbEnvironment).getContextClassName();
        }
        return "javax.ejb.EJBContext";
    }

    private void rebuildLookupUsagesMap(PsiClass psiClass, Map<PsiMethodCallExpression, String> lookupUsages, Set<PsiElement> contextObjects, String lookupClassName) {
        boolean javaxNaming = "javax.naming.Context".equals(lookupClassName);
        PsiMethod lookupMethod = this.findClassMethod((PsiElement)psiClass, lookupClassName, LOOKUP_METHOD_PATTERN);
        if (lookupMethod == null) {
            return;
        }
        for (PsiClass curClass : JamCommonUtil.getSuperClassList((PsiClass)psiClass)) {
            PsiReference[] references;
            for (PsiReference psiReference : references = (PsiReference[])MethodReferencesSearch.search((PsiMethod)lookupMethod, (SearchScope)new LocalSearchScope((PsiElement)curClass), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                PsiReferenceExpression psiReferenceExpression;
                PsiElement psiElement = psiReference.getElement();
                if (!(psiElement instanceof PsiReferenceExpression) || !((psiReferenceExpression = (PsiReferenceExpression)psiElement).getParent() instanceof PsiMethodCallExpression)) continue;
                ArrayList<PsiElement> currentContextObjects = new ArrayList<PsiElement>();
                PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiElement.getParent();
                String jndiName = this.calculateSubContextPrefix((PsiExpression)psiMethodCallExpression, currentContextObjects);
                if (jndiName == null) continue;
                if (jndiName.startsWith("java:comp/env/")) {
                    jndiName = jndiName.substring("java:comp/env/".length());
                } else if (javaxNaming) continue;
                if (contextObjects != null) {
                    contextObjects.addAll(currentContextObjects);
                }
                lookupUsages.put(psiMethodCallExpression, jndiName);
            }
        }
    }

    private String calculateSubContextPrefix(PsiExpression psiExpression, Collection<PsiElement> contextObjects) {
        String currentPrefix = "";
        PsiExpression psiCurrentExpression = psiExpression;
        while (psiCurrentExpression != null) {
            PsiExpression psiNextExpression = null;
            if (psiCurrentExpression instanceof PsiParenthesizedExpression) {
                psiNextExpression = ((PsiParenthesizedExpression)psiCurrentExpression).getExpression();
            } else if (psiCurrentExpression instanceof PsiTypeCastExpression) {
                psiNextExpression = ((PsiTypeCastExpression)psiCurrentExpression).getOperand();
            } else if (!(psiCurrentExpression instanceof PsiThisExpression) && !(psiCurrentExpression instanceof PsiNewExpression)) {
                if (psiCurrentExpression instanceof PsiReferenceExpression) {
                    PsiVariable psiVariable;
                    PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)psiCurrentExpression;
                    PsiElement psiElement = psiReferenceExpression.resolve();
                    if (psiElement instanceof PsiVariable && !(psiVariable = (PsiVariable)psiElement).getType().getCanonicalText().startsWith("javax.ejb.")) {
                        PsiExpression[] assignmentExpressions;
                        if (contextObjects != null) {
                            contextObjects.add((PsiElement)psiReferenceExpression);
                        }
                        if ((assignmentExpressions = this.getNonNullAssignmentExpressions(psiVariable)).length == 1) {
                            psiNextExpression = assignmentExpressions[0];
                        }
                    }
                } else if (psiCurrentExpression instanceof PsiMethodCallExpression) {
                    String nextPrefix = null;
                    PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiCurrentExpression;
                    PsiMethod psiMethod = psiMethodCallExpression.resolveMethod();
                    if (psiMethod != null) {
                        Object obj;
                        PsiExpression[] psiExpressions;
                        String methodClassQName = psiMethod.getContainingClass().getQualifiedName();
                        if (LOOKUP_METHOD_NAME.equals(psiMethod.getName()) && methodClassQName != null && methodClassQName.startsWith("javax.") && (psiExpressions = psiMethodCallExpression.getArgumentList().getExpressions()).length == 1 && (obj = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)psiExpressions[0], null, (boolean)false)) instanceof String) {
                            String prefix = (String)obj;
                            if (methodClassQName.equals("javax.ejb.EJBContext")) {
                                prefix = "java:comp/env/" + prefix;
                            }
                            if (currentPrefix.length() > 0 && !prefix.endsWith("/")) {
                                prefix = prefix + "/";
                            }
                            nextPrefix = prefix + currentPrefix;
                            psiNextExpression = psiMethodCallExpression.getMethodExpression().getQualifierExpression();
                        }
                    }
                    currentPrefix = nextPrefix;
                }
            }
            psiCurrentExpression = psiNextExpression;
        }
        return currentPrefix;
    }

    private void updateClassLevelEnvironmentAnnotations(EnvironmentGroup ejbEnvironment, PsiClass psiClass, Set<String> jndiNames, Map<String, JavaeeReference> referenceMap) {
        boolean external = !this.myConfiguration.isCopyFromXml() || !this.myConfiguration.isEnlisted(ejbEnvironment);
        ArrayList<String> resources = new ArrayList<String>();
        ArrayList<String> ejbs = new ArrayList<String>();
        ArrayList<String> services = new ArrayList<String>();
        for (String jndiName : jndiNames) {
            JavaeeReferenceImpl annoElement;
            JavaeeModelElement ref = (JavaeeModelElement)referenceMap.get(jndiName);
            if (ref == null || (annoElement = (JavaeeReferenceImpl)((Object)ModelMergerUtil.getImplementation((Object)ref, JavaeeReferenceImpl.class))) != null && annoElement.getAnnotationRef().getPsiElement() != null && annoElement.getPsiMember() != null && this.myConfiguration.getPreferredAccess() != ApplyJavaeeStyleConfiguration.EnvironmentAccess.LOOKUP && !(annoElement.getPsiMember() instanceof PsiClass)) continue;
            if (ref instanceof EjbReference) {
                EjbReference ejbReference = (EjbReference)ref;
                EnterpriseBean targetEjb = (EnterpriseBean)ejbReference.getEjbLink().getValue();
                if (external && this.hasHomeInterfacesNow(targetEjb) == this.willHaveHomeInterface(targetEjb)) continue;
                ejbs.add(this.createEjbReferenceAnnotationText(psiClass, (EjbReference)ref, null, null, null));
                continue;
            }
            if (ref instanceof Resource) {
                if (external) continue;
                resources.add(this.createResourceReferenceAnnotationText(psiClass, (Resource)ref, null, null, null));
                continue;
            }
            if (ref instanceof ServiceRef) {
                if (external) continue;
                services.add(this.createServiceReferenceAnnotationText(psiClass, (ServiceRef)ref, null, null, null));
                continue;
            }
            assert (false) : ref;
        }
        this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)psiClass, "javax.ejb.EJB"));
        if (ejbs.size() > 0) {
            this.createAnnotation((PsiModifierListOwner)psiClass, "javax.ejb.EJBs", true, "value", AnnotationTextUtil.createStringArrayInitializer(ejbs, new String[0]), null);
        } else {
            this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)psiClass, "javax.ejb.EJBs"));
        }
        this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)psiClass, "javax.annotation.Resource"));
        if (resources.size() > 0) {
            this.createAnnotation((PsiModifierListOwner)psiClass, "javax.annotation.Resources", true, "value", AnnotationTextUtil.createStringArrayInitializer(resources, new String[0]), null);
        } else {
            this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)psiClass, "javax.annotation.Resources"));
        }
        if (services.size() > 0) {
            this.createAnnotation((PsiModifierListOwner)psiClass, "javax.xml.ws.WebServiceRef", true, "value", AnnotationTextUtil.createStringArrayInitializer(services, new String[0]), null);
        } else {
            this.dropElement((PsiElement)this.findAnnotation((PsiModifierListOwner)psiClass, "javax.xml.ws.WebServiceRefs"));
        }
    }

    private String createResourceReferenceAnnotationText(PsiClass psiClass, Resource resource, PsiAnnotation psiAnnotation, String fieldName, String fieldType) {
        String jndiName = (String)resource.getName().getValue();
        String jndiNameDef = fieldName == null ? null : psiClass.getQualifiedName() + "/" + fieldName;
        String typeDef = fieldType == null ? null : fieldType + ".class";
        PsiClass psiTypeClass = (PsiClass)resource.getType().getValue();
        ResAuth resAuth = (ResAuth)resource.getAuthenticationType().getValue();
        Boolean shareable = (Boolean)resource.isShareable().getValue();
        String description = (String)resource.getDescription().getValue();
        String mappedName = (String)resource.getMappedName().getValue();
        String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiClass, "javax.annotation.Resource", true, psiAnnotation, "name", AnnotationTextUtil.quote(jndiName), AnnotationTextUtil.quote(jndiNameDef), "type", psiTypeClass == null ? null : psiTypeClass.getQualifiedName() + ".class", typeDef, "authenticationType", resAuth == null ? null : "javax.annotation.Resource.AuthenticationType" + resAuth.name(), null, "shareable", shareable == null ? null : shareable.toString(), null, "mappedName", AnnotationTextUtil.quote(mappedName), null, "description", AnnotationTextUtil.quote(description), null);
        return text;
    }

    private String createEjbReferenceAnnotationText(PsiClass psiClass, EjbReference ejbReference, PsiAnnotation psiAnnotation, String fieldName, String fieldType) {
        EjbWithHome ejb;
        String jndiName = (String)ejbReference.getName().getValue();
        String jndiNameDef = fieldName == null ? null : psiClass.getQualifiedName() + "/" + fieldName;
        String typeDef = fieldType == null ? null : fieldType + ".class";
        PsiClass ejbInterface = (PsiClass)ejbReference.getBeanInterface().getValue();
        String beanName = ejbReference.getEjbLink().getStringValue();
        if (ejbInterface != null && (ejb = (EjbWithHome)ejbReference.getEjbLink().getValue()) != null && !this.willHaveHomeInterface((EnterpriseBean)ejb)) {
            if (ejbInterface == ejb.getHome().getValue()) {
                ejbInterface = (PsiClass)ejb.getRemote().getValue();
            } else if (ejbInterface == ejb.getLocalHome().getValue()) {
                ejbInterface = (PsiClass)ejb.getLocal().getValue();
            }
        }
        String mappedName = (String)ejbReference.getMappedName().getValue();
        String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiClass, "javax.ejb.EJB", true, psiAnnotation, "name", AnnotationTextUtil.quote(jndiName), AnnotationTextUtil.quote(jndiNameDef), "beanName", AnnotationTextUtil.quote(beanName), null, "beanInterface", ejbInterface == null ? null : ejbInterface.getQualifiedName() + ".class", typeDef, "mappedName", AnnotationTextUtil.quote(mappedName), null);
        return text;
    }

    private String createServiceReferenceAnnotationText(PsiClass psiClass, ServiceRef serviceRef, PsiAnnotation psiAnnotation, String fieldName, String fieldType) {
        String jndiName = (String)serviceRef.getName().getValue();
        String jndiNameDef = fieldName == null ? null : psiClass.getQualifiedName() + "/" + fieldName;
        String typeDef = fieldType == null ? null : fieldType + ".class";
        PsiClass psiValueClass = (PsiClass)serviceRef.getValue().getValue();
        PsiClass psiTypeClass = (PsiClass)serviceRef.getType().getValue();
        String mappedName = (String)serviceRef.getMappedName().getValue();
        String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiClass, "javax.xml.ws.WebServiceRef", true, psiAnnotation, "name", AnnotationTextUtil.quote(jndiName), AnnotationTextUtil.quote(jndiNameDef), "type", psiTypeClass == null ? null : psiTypeClass.getQualifiedName() + ".class", typeDef, "value", psiValueClass == null ? null : psiValueClass.getQualifiedName() + ".class", typeDef, "wsdlLocation", (String)serviceRef.getWsdlLocation().getValue(), null, "mappedName", AnnotationTextUtil.quote(mappedName), null);
        return text;
    }

    private PsiExpression[] getNonNullAssignmentExpressions(PsiVariable psiVariable) {
        ArrayList<PsiExpression> list = new ArrayList<PsiExpression>();
        list.add(psiVariable.getInitializer());
        for (PsiReference psiReference : ReferencesSearch.search((PsiElement)psiVariable)) {
            PsiAssignmentExpression assignmentExpression;
            PsiElement element = psiReference.getElement();
            if (element == null || !(element.getParent() instanceof PsiAssignmentExpression) || (assignmentExpression = (PsiAssignmentExpression)element.getParent()).getLExpression() != element) continue;
            list.add(assignmentExpression.getRExpression());
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            PsiExpression psiExpression = (PsiExpression)it.next();
            if (psiExpression instanceof PsiLiteralExpression) {
                PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)psiExpression;
                if (psiLiteralExpression.getValue() != null) continue;
                it.remove();
                continue;
            }
            if (psiExpression != null) continue;
            it.remove();
        }
        return list.toArray(PsiExpression.EMPTY_ARRAY);
    }

    private void migrateEjbClients() {
        if (this.myProgress != null) {
            this.myProgress.setText(J2EEBundle.message((String)"apply.javaee.style.processing.clients", (Object[])new Object[0]));
        }
        for (Map.Entry<PsiClass, PsiClass> entry : this.homeReplaceMap.entrySet()) {
            PsiClass homeClass = entry.getKey();
            PsiClass intfClass = entry.getValue();
            if (this.myProgress != null) {
                this.myProgress.setText2(J2EEBundle.message((String)"apply.javaee.style.processing.home", (Object[])new Object[]{homeClass.getName()}));
            }
            this.migrateEjbClientsRemovedHomesUsages(homeClass, intfClass);
        }
        this.homeReplaceMap.clear();
    }

    private void migrateEjbClientsRemovedHomesUsages(PsiClass psiHomeClass, PsiClass psiIntfClass) {
        HashSet<Object> processedEjbs = new HashSet<Object>();
        HashSet<PsiClass> processedClasses = new HashSet<PsiClass>();
        HashSet<PsiElement> contextObjects = new HashSet<PsiElement>();
        PsiMethod narrowMethod = this.findClassMethod((PsiElement)psiHomeClass, JAVAX_RMI_PORTABLE_REMOTE_OBJECT, NARROW_METHOD_PATTERN);
        PsiMethod lookupMethod = this.findClassMethod((PsiElement)psiHomeClass, "javax.naming.Context", LOOKUP_METHOD_PATTERN);
        PsiMethod ejbLookupMethod = this.findClassMethod((PsiElement)psiHomeClass, "javax.ejb.EJBContext", LOOKUP_METHOD_PATTERN);
        Collection queryResult = ReferencesSearch.search((PsiElement)psiHomeClass, (SearchScope)GlobalSearchScope.projectScope((Project)this.myConfiguration.getModule().getProject())).findAll();
        int count = 0;
        if (this.myProgress != null) {
            this.myProgress.setFraction(0.0);
        }
        for (PsiReference psiReference : queryResult) {
            PsiElement psiElement = psiReference.getElement();
            PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)psiElement);
            if (topLevelClass == null) {
                EjbBase ejb;
                PsiElement parent = psiElement.getParent();
                if (parent instanceof PsiImportStatement) {
                    this.dropElement(parent);
                    continue;
                }
                if (!(parent instanceof XmlText)) continue;
                XmlText xmlText = (XmlText)parent;
                DomElement domElement = DomManager.getDomManager((Project)parent.getProject()).getDomElement(xmlText.getParentTag());
                if (domElement == null || (ejb = (EjbBase)domElement.getParentOfType(EjbBase.class, true)) == null || processedEjbs.contains(ejb) || this.myConfiguration.isEnlisted((EnvironmentGroup)ejb)) continue;
                processedEjbs.add(ejb);
                this.migrateEnvironmentInternal((PsiClass)ejb.getEjbClass().getValue(), (EnvironmentGroup)ejb);
                continue;
            }
            if (!processedClasses.add(topLevelClass)) continue;
            EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(topLevelClass);
            if (classRoles.length > 0) {
                for (EjbClassRole ejbClassRole : classRoles) {
                    EnterpriseBean ejb = ejbClassRole.getEnterpriseBean();
                    if (ejb == null || this.myConfiguration.isEnlisted((EnvironmentGroup)ejb) || !processedEjbs.add(ejb)) continue;
                    this.migrateEnvironmentInternal((PsiClass)ejb.getEjbClass().getValue(), (EnvironmentGroup)ejb);
                }
            } else {
                this.migrateEjbClientUsagesForMethod(topLevelClass, narrowMethod, psiHomeClass, psiIntfClass, 0, contextObjects);
                this.migrateEjbClientUsagesForMethod(topLevelClass, lookupMethod, psiHomeClass, psiIntfClass, -1, contextObjects);
                this.migrateEjbClientUsagesForMethod(topLevelClass, ejbLookupMethod, psiHomeClass, psiIntfClass, -1, contextObjects);
            }
            if (this.myProgress == null) continue;
            this.myProgress.setFraction((double)(++count) / (double)queryResult.size());
        }
        this.removeUnusedVariables(contextObjects);
    }

    private void migrateEjbClientUsagesForMethod(PsiClass topLevelClass, PsiMethod psiMethod, PsiClass psiHomeClass, PsiClass psiIntfClass, int parameterIndex, Set<PsiElement> contextObjects) {
        if (psiMethod == null) {
            return;
        }
        ArrayList<PsiMethodCallExpression> elementsList = new ArrayList<PsiMethodCallExpression>();
        for (PsiReference reference : MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)new LocalSearchScope((PsiElement)topLevelClass), (boolean)false)) {
            PsiElement element = reference.getElement().getParent();
            if (!(element instanceof PsiMethodCallExpression)) continue;
            elementsList.add((PsiMethodCallExpression)element);
        }
        Collections.sort(elementsList, JavaeeStyleEngine.createTopToBottomPsiComparator());
        for (PsiMethodCallExpression psiMethodCallExpression : elementsList) {
            String initializerString;
            PsiElement lValue = this.findLValue((PsiExpression)psiMethodCallExpression, false);
            if (!contextObjects.add(lValue)) continue;
            if (parameterIndex == -1) {
                initializerString = psiMethodCallExpression.getText();
                this.initializerElements.add((PsiElement)psiMethodCallExpression);
            } else {
                PsiExpression[] psiExpressions = psiMethodCallExpression.getArgumentList().getExpressions();
                if (psiExpressions.length > parameterIndex) {
                    initializerString = psiExpressions[parameterIndex].getText();
                    this.initializerElements.add((PsiElement)psiExpressions[parameterIndex]);
                } else {
                    initializerString = "$INVALID$";
                }
            }
            for (PsiMethodCallExpression psiCreateMethodCallExpression : this.findHomeCreateInvocationsByHomeUsage(psiHomeClass, (PsiElement)psiMethodCallExpression, new TreeSet<PsiElement>(JavaeeStyleEngine.createTopToBottomPsiComparator()))) {
                this.replaceOldHomeCreateMethod(psiCreateMethodCallExpression, psiIntfClass, initializerString, null);
                contextObjects.add(psiCreateMethodCallExpression.getMethodExpression().getQualifier());
                if (!initializerString.equals("$INVALID$")) continue;
                this.addFileToInvalidValueHolders((PsiElement)psiCreateMethodCallExpression);
            }
        }
    }

    private String getUniqueVariablePostfix(Map<PsiElement, String> variablePostfixMap, PsiElement psiElement) {
        String variablePostfix;
        PsiMethod mapKey;
        PsiMethod psiMethod = (PsiMethod)JavaResolveUtil.findParentContextOfClass((PsiElement)psiElement, PsiMethod.class, (boolean)false);
        Object object = mapKey = psiMethod != null ? psiMethod : JavaResolveUtil.findParentContextOfClass((PsiElement)psiElement, PsiClass.class, (boolean)false);
        if (mapKey != null) {
            String postfix = variablePostfixMap.get(mapKey);
            variablePostfix = postfix == null ? "" : postfix;
            variablePostfixMap.put((PsiElement)mapKey, this.getNextVariableNamePostfix(variablePostfix));
        } else {
            variablePostfix = "";
        }
        return variablePostfix;
    }

    private String getNextVariableNamePostfix(String variablePostfix) {
        int lastCharIdx;
        char startChar = 'A';
        char stopChar = 'Z';
        String nextPostfix = variablePostfix.length() == 0 ? Character.toString(startChar) : (variablePostfix.charAt(lastCharIdx = variablePostfix.length() - 1) == stopChar ? variablePostfix + startChar : variablePostfix.substring(0, lastCharIdx) + (char)(variablePostfix.charAt(lastCharIdx) + '\u0001'));
        return nextPostfix;
    }

    private void replaceOldHomeCreateMethod(PsiMethodCallExpression psiCreateMethodCallExpression, PsiClass psiIntfClass, String initializerString, String jndiName) {
        PsiExpression newAccessExpression;
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiCreateMethodCallExpression.getProject()).getElementFactory();
        PsiStatement psiCurrentStatement = (PsiStatement)JavaResolveUtil.findParentContextOfClass((PsiElement)psiCreateMethodCallExpression, PsiStatement.class, (boolean)false);
        PsiExpression replaceExpression = this.removeUnnecessaryCastsAndNarrows((PsiElement)psiCreateMethodCallExpression, psiCreateMethodCallExpression.getType());
        String createMethodCallString = psiCreateMethodCallExpression.getMethodExpression().getLastChild().getText() + psiCreateMethodCallExpression.getArgumentList().getText();
        PsiVariable psiLocalVariable = (PsiVariable)this.findLValue((PsiExpression)psiCreateMethodCallExpression, true);
        if (psiLocalVariable == null) {
            PsiDeclarationStatement declarationStatement = this.createLocalVariable(psiIntfClass, initializerString, psiCurrentStatement);
            psiLocalVariable = (PsiVariable)declarationStatement.getDeclaredElements()[0];
            String createCallStatementString = psiLocalVariable.getName() + "." + createMethodCallString + ";";
            PsiStatement throwNamingExceptionStatement = this.createThrowNamingExceptionStatement((PsiElement)psiCurrentStatement, psiLocalVariable.getName(), jndiName);
            PsiStatement createCallStatement = psiElementFactory.createStatementFromText(createCallStatementString, null);
            this.addUsageInfo(new AddElementUsageInfo((PsiElement)psiCurrentStatement, Boolean.FALSE, psiCurrentStatement.getParent(), (PsiElement)psiCurrentStatement, false, throwNamingExceptionStatement == null ? Arrays.asList(declarationStatement, createCallStatement) : Arrays.asList(declarationStatement, throwNamingExceptionStatement, createCallStatement)));
            newAccessExpression = psiElementFactory.createExpressionFromText(psiLocalVariable.getName(), null);
        } else {
            String createCallStatementString = psiLocalVariable.getName() + "." + createMethodCallString + ";";
            PsiStatement createCallStatement = psiElementFactory.createStatementFromText(createCallStatementString, null);
            newAccessExpression = this.createNeededCasts(replaceExpression.getType(), psiElementFactory.createExpressionFromText(initializerString, (PsiElement)psiCurrentStatement), replaceExpression);
            PsiStatement throwNamingExceptionStatement = this.createThrowNamingExceptionStatement((PsiElement)psiCurrentStatement, psiLocalVariable.getName(), jndiName);
            this.addUsageInfo(new AddElementUsageInfo((PsiElement)psiCurrentStatement, Boolean.TRUE, psiCurrentStatement.getParent(), (PsiElement)psiCurrentStatement, true, throwNamingExceptionStatement == null ? Collections.singletonList(createCallStatement) : Arrays.asList(throwNamingExceptionStatement, createCallStatement)));
        }
        this.replaceElement((PsiElement)replaceExpression, (PsiElement)newAccessExpression);
    }

    private PsiExpression createNeededCasts(PsiType psiType, PsiExpression psiExpression, PsiExpression context) throws IncorrectOperationException {
        PsiType psiCurType = psiExpression.getType();
        boolean needParenthesizing = false;
        boolean needCasting = true;
        if (context != null) {
            needParenthesizing = true;
            for (PsiElement curElement = context.getParent(); curElement != null; curElement = curElement.getParent()) {
                if (curElement instanceof PsiParenthesizedExpression) {
                    needParenthesizing = false;
                    continue;
                }
                if (curElement instanceof PsiAssignmentExpression) {
                    needParenthesizing = false;
                    continue;
                }
                if (curElement instanceof PsiTypeCastExpression) {
                    needCasting = false;
                    continue;
                }
                if (curElement instanceof PsiExpression) {
                    PsiPolyadicExpression psiBinaryExpression;
                    IElementType sign;
                    if (!(curElement instanceof PsiPolyadicExpression) || (sign = (psiBinaryExpression = (PsiPolyadicExpression)curElement).getOperationTokenType()) != JavaTokenType.EQEQ && sign != JavaTokenType.NE) break;
                    needCasting = false;
                    break;
                }
                needParenthesizing = false;
                break;
            }
        }
        if (needCasting && (psiCurType == null || !psiType.isAssignableFrom(psiCurType))) {
            String newType;
            String string = newType = TypeConversionUtil.isPrimitiveAndNotNull((PsiType)psiType) ? ((PsiPrimitiveType)psiType).getBoxedTypeName() : psiType.getCanonicalText();
            assert (newType != null) : psiType;
            PsiTypeCastExpression newExpression = (PsiTypeCastExpression)JavaPsiFacade.getInstance((Project)psiExpression.getProject()).getElementFactory().createExpressionFromText("(" + newType + ")a", null);
            newExpression.getOperand().replace((PsiElement)psiExpression);
            if (needParenthesizing) {
                PsiParenthesizedExpression psiParenthesizedExpression = (PsiParenthesizedExpression)JavaPsiFacade.getInstance((Project)psiExpression.getProject()).getElementFactory().createExpressionFromText("(a)", null);
                psiParenthesizedExpression.getExpression().replace((PsiElement)newExpression);
                return psiParenthesizedExpression;
            }
            return newExpression;
        }
        return JavaPsiFacade.getInstance((Project)psiExpression.getProject()).getElementFactory().createExpressionFromText(psiExpression.getText(), null);
    }

    public static boolean canModify(PsiElement psiElement) {
        return psiElement != null && CommonRefactoringUtil.checkReadOnlyStatus((Project)psiElement.getProject(), (PsiElement)psiElement);
    }

    public static UsageInfo[] preprocessUsages(UsageInfo[] usages) {
        final ArrayList result = new ArrayList();
        MyUsageVisitor visitor = new MyUsageVisitor(){

            @Override
            public void visitMyUsageInfo(MyUsageInfo usageInfo) {
                result.add(usageInfo);
            }
        };
        for (UsageInfo info : usages) {
            assert (info instanceof MyUsageInfo);
            ((MyUsageInfo)info).accept(visitor);
        }
        UsageInfo[] resultArray = result.toArray(new MyUsageInfo[0]);
        Arrays.sort(resultArray, JavaeeStyleEngine.createMyUsageComparator());
        return resultArray;
    }

    public static void postProcess(ApplyJavaeeStyleConfiguration configuration) throws Exception {
        Persistence persistence;
        if (configuration.isCreatePersistenceUnit() && (persistence = JpaUtil.getOrCreatePersitence(configuration.getModule())).getPersistenceUnits().size() == 0) {
            PersistenceUnit unit = persistence.addPersistenceUnit();
            unit.getName().setValue((Object)configuration.getModule().getName());
        }
    }

    public static void processInvalidValues(PsiFile[] psiFiles) {
        String newText = "...";
        for (PsiFile psiFile : psiFiles) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
            Document document = documentManager.getDocument(psiFile);
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            final IntArrayList offsetList = new IntArrayList();
            psiFile.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    PsiElement psiElement = expression.getElement();
                    String text = psiElement.getText();
                    if (text.equals("$INVALID$")) {
                        offsetList.add(psiElement.getTextOffset());
                    }
                }
            });
            int[] offsets = offsetList.toArray();
            Arrays.sort(offsets);
            for (int i = offsets.length - 1; i > -1; --i) {
                document.replaceString(offsets[i], offsets[i] + "$INVALID$".length(), (CharSequence)"...");
            }
            documentManager.commitDocument(document);
        }
    }

    static class AddElementUsageInfo
    extends BaseUpdateUsageInfo {
        private final Boolean presentationAppend;
        private final boolean after;
        private final List<PsiElement> elements;
        private final PsiElement anchor;
        private final PsiElement target;

        public AddElementUsageInfo(PsiElement presentationElement, Boolean presentationAppend, PsiElement target, PsiElement anchor, boolean after, List<? extends PsiElement> elements) {
            super(presentationElement);
            this.presentationAppend = presentationAppend;
            this.after = after;
            this.elements = new ArrayList<PsiElement>(elements);
            this.anchor = anchor;
            this.target = target;
        }

        @Override
        public PsiElement getTargetElement() {
            return this.target;
        }

        @Override
        public Collection<PsiElement> processUsage() {
            if (this.target == null || !JavaeeStyleEngine.canModify(this.target)) {
                return Collections.emptyList();
            }
            assert (this.anchor == null || this.anchor.isValid()) : this.anchor;
            for (PsiElement element : this.elements) {
                assert (element.isValid()) : element;
            }
            PsiElement realTarget = this.target;
            PsiElement realAnchor = this.anchor;
            if (this.target instanceof PsiIfStatement || this.target instanceof PsiForStatement || this.target instanceof PsiWhileStatement || this.target instanceof PsiDoWhileStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)JavaPsiFacade.getInstance((Project)this.target.getProject()).getElementFactory().createStatementFromText("{ }", this.target);
                if (this.anchor != null) {
                    blockStatement.getCodeBlock().add(this.anchor);
                    blockStatement = (PsiBlockStatement)this.anchor.replace((PsiElement)blockStatement);
                    realAnchor = blockStatement.getCodeBlock().getStatements()[0];
                    realTarget = blockStatement.getCodeBlock();
                }
            }
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            if (!this.after) {
                ListIterator<PsiElement> it = this.elements.listIterator(this.elements.size());
                while (it.hasPrevious()) {
                    PsiElement element = it.previous();
                    realAnchor = realTarget.addBefore(element, realAnchor);
                    result.add(realAnchor);
                }
            } else {
                for (PsiElement element : this.elements) {
                    realAnchor = realTarget.addAfter(element, realAnchor);
                    result.add(realAnchor);
                }
            }
            return result;
        }

        @Override
        protected String getTooltipTextInternal() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (PsiElement element : this.elements) {
                if (first) {
                    first = false;
                } else {
                    sb.append(J2EEBundle.message((String)"apply.javaee.style.usage.tooltip.newline", (Object[])new Object[0]));
                }
                String elementText = XmlStringUtil.escapeString((String)element.getText());
                String text = this.presentationAppend != null ? (this.presentationAppend.booleanValue() ? J2EEBundle.message((String)"apply.javaee.style.usage.add.after", (Object[])new Object[]{elementText}) : J2EEBundle.message((String)"apply.javaee.style.usage.add.before", (Object[])new Object[]{elementText})) : J2EEBundle.message((String)"apply.javaee.style.usage.add", (Object[])new Object[]{elementText});
                sb.append(text);
            }
            return sb.toString();
        }

        @Override
        public void updateElement(PsiElement psiElement, PsiElement psiNewElement) {
            int index = 0;
            for (PsiElement element : this.elements) {
                if (element == psiElement) {
                    this.elements.set(index, psiNewElement);
                }
                ++index;
            }
        }

        @Override
        public List<PsiElement> getNewElements() {
            return this.elements;
        }

        public boolean merge(AddElementUsageInfo other) {
            if (this.target == other.target && this.anchor == other.anchor && this.after == other.after) {
                this.elements.addAll(other.elements);
                return true;
            }
            return false;
        }
    }

    static class DeleteDomElementUsageInfo
    extends BaseDeleteUsageInfo {
        private final DomElement element;

        public DeleteDomElementUsageInfo(DomElement element) {
            super((PsiElement)element.getXmlTag());
            this.element = element;
        }

        @Override
        public Collection<PsiElement> processUsage() {
            if (this.getElement() == null || !JavaeeStyleEngine.canModify(this.getElement())) {
                return Collections.emptyList();
            }
            this.element.undefine();
            return Collections.emptyList();
        }

        @Override
        protected String getTooltipTextInternal() {
            return J2EEBundle.message((String)"apply.javaee.style.usage.delete", (Object[])new Object[0]);
        }
    }

    static class DeleteElementUsageInfo
    extends BaseDeleteUsageInfo {
        public DeleteElementUsageInfo(PsiElement element) {
            super(element);
        }

        @Override
        public Collection<PsiElement> processUsage() {
            if (this.getElement() == null || !JavaeeStyleEngine.canModify(this.getElement())) {
                return Collections.emptyList();
            }
            this.getElement().delete();
            return Collections.emptyList();
        }

        @Override
        protected String getTooltipTextInternal() {
            return J2EEBundle.message((String)"apply.javaee.style.usage.delete", (Object[])new Object[0]);
        }

        @Override
        public int getPriority() {
            return -1;
        }
    }

    static class ReplaceElementUsageInfo
    extends BaseUpdateUsageInfo {
        private PsiElement myNewElement;

        public ReplaceElementUsageInfo(PsiElement element, PsiElement newElement) {
            super(element);
            this.myNewElement = newElement;
        }

        @Override
        public Collection<PsiElement> processUsage() {
            if (this.getElement() == null || !JavaeeStyleEngine.canModify(this.getElement())) {
                return Collections.emptyList();
            }
            assert (this.myNewElement != null && this.myNewElement.isValid()) : this.myNewElement;
            return Collections.singletonList(this.getElement().replace(this.myNewElement));
        }

        @Override
        protected String getTooltipTextInternal() {
            return J2EEBundle.message((String)"apply.javaee.style.usage.replace", (Object[])new Object[]{XmlStringUtil.escapeString((String)this.myNewElement.getText())});
        }

        public PsiElement getNewElement() {
            return this.myNewElement;
        }

        @Override
        public void updateElement(PsiElement psiElement, PsiElement psiNewElement) {
            this.myNewElement = psiNewElement;
        }

        @Override
        public List<PsiElement> getNewElements() {
            return Collections.singletonList(this.myNewElement);
        }
    }

    static abstract class BaseDeleteUsageInfo
    extends MyUsageInfo {
        public BaseDeleteUsageInfo(PsiElement element) {
            super(element);
        }
    }

    static abstract class BaseUpdateUsageInfo
    extends MyUsageInfo {
        public BaseUpdateUsageInfo(PsiElement element) {
            super(element);
        }

        public abstract void updateElement(PsiElement var1, PsiElement var2);

        public abstract List<PsiElement> getNewElements();
    }

    static class CompositeUsageInfo
    extends MyUsageInfo {
        ArrayList<MyUsageInfo> myChildren = new ArrayList();

        public CompositeUsageInfo(PsiElement element, MyUsageInfo ... children) {
            super(element);
            Collections.addAll(this.myChildren, children);
        }

        @Override
        public Collection<PsiElement> processUsage() throws Exception {
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            for (MyUsageInfo child : this.myChildren) {
                result.addAll(child.processUsage());
            }
            return result;
        }

        @Override
        public void accept(MyUsageVisitor visitor) {
            for (MyUsageInfo child : this.myChildren) {
                child.accept(visitor);
            }
        }

        public List<MyUsageInfo> getChildren() {
            return this.myChildren;
        }

        @Override
        protected String getTooltipTextInternal() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (MyUsageInfo child : this.myChildren) {
                if (first) {
                    first = false;
                } else {
                    sb.append(J2EEBundle.message((String)"apply.javaee.style.usage.tooltip.newline", (Object[])new Object[0]));
                }
                sb.append(child.getTooltipTextInternal());
            }
            return sb.toString();
        }

        @Override
        public int getPriority() {
            int maxPriority = Integer.MIN_VALUE;
            for (MyUsageInfo child : this.myChildren) {
                maxPriority = Math.max(maxPriority, child.getPriority());
            }
            return maxPriority;
        }
    }

    static abstract class MyUsageInfo
    extends UsageInfo {
        public MyUsageInfo(PsiElement element) {
            super(element);
        }

        public PsiElement getTargetElement() {
            return this.getElement();
        }

        public abstract Collection<PsiElement> processUsage() throws Exception;

        protected abstract String getTooltipTextInternal();

        public void accept(MyUsageVisitor visitor) {
            visitor.visitMyUsageInfo(this);
        }

        public String getTooltipText() {
            String text = this.getTooltipTextInternal();
            return text == null ? null : J2EEBundle.message((String)"apply.javaee.style.usage.tooltip", (Object[])new Object[]{text});
        }

        public int getPriority() {
            return 0;
        }

        public String toString() {
            try {
                String text = this.getTooltipTextInternal();
                return text;
            }
            catch (Exception exception) {
                return super.toString();
            }
        }
    }

    static interface MyUsageVisitor {
        public void visitMyUsageInfo(MyUsageInfo var1);
    }
}

