/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.role;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbDeclMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRoleImpl;
import com.intellij.javaee.model.common.ejb.EjbPsiMethodUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Map;

public class EjbDeclMethodRoleImpl
extends EjbMethodRoleImpl
implements EjbDeclMethodRole {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.ejb.role.EjbDeclMethodRole");
    private MethodSignature[] myImplementations;

    public EjbDeclMethodRoleImpl(PsiMethod method, EjbClassRole classRole, EjbMethodRoleEnum type) {
        super(method, classRole, type);
    }

    public boolean isCompletelyImplemented() {
        boolean result;
        PsiClass ejbClass = (PsiClass)this.getEnterpriseBean().getEjbClass().getValue();
        Map<PsiClass, PsiMethod[]> map = EjbUtil.findEjbImplementationsMap(this.getMethod());
        PsiMethod[] implementations = map.containsKey(ejbClass) ? map.get(ejbClass) : PsiMethod.EMPTY_ARRAY;
        int count = implementations.length;
        boolean bl = result = count != 0;
        if (result && this.getType() == EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_DECL && this.getEnterpriseBean() instanceof EntityBean) {
            result = count == 2;
        }
        return result;
    }

    public final PsiMethod[] findAllImplementations() {
        return EjbUtil.findEjbImplementations(this.getMethod());
    }

    public final PsiMethod[] findImplementationsInEjbClass() {
        PsiClass implClass = (PsiClass)this.getEnterpriseBean().getEjbClass().getValue();
        if (implClass == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        MethodSignature[] implMethods = this.suggestImplementationPrototypes();
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (MethodSignature suggestedMethod : implMethods) {
            PsiMethod implMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)implClass, (MethodSignature)suggestedMethod, (boolean)true);
            if (implMethod == null) continue;
            result.add(implMethod);
        }
        return result.size() == 0 ? PsiMethod.EMPTY_ARRAY : result.toArray(PsiMethod.EMPTY_ARRAY);
    }

    public PsiMethod[] suggestImplementations() {
        return EjbDeclMethodRoleImpl.suggestImplementations(this.getMethod(), this.getEnterpriseBean(), this.getType());
    }

    private MethodSignature[] suggestImplementationPrototypes() {
        if (this.myImplementations == null) {
            this.myImplementations = EjbDeclMethodRoleImpl.suggestImplementationPrototypes(this.getMethod(), this.getEnterpriseBean(), this.getType());
        }
        return this.myImplementations;
    }

    private static PsiMethod[] suggestImplementations(PsiMethod method, EnterpriseBean ejb, EjbMethodRoleEnum type) {
        PsiMethod[] result = PsiMethod.EMPTY_ARRAY;
        try {
            String methodName = method.getName();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
            PsiMethod copy = (PsiMethod)factory.createClass("Dummy").add((PsiElement)GenerateMembersUtil.substituteGenericMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            PsiUtil.setModifierProperty((PsiModifierListOwner)copy, (String)"abstract", (boolean)false);
            switch (type) {
                case EJB_METHOD_ROLE_FINDER_DECL: {
                    if (((EntityBean)ejb).getPersistenceType().getValue() != PersistenceType.BEAN) break;
                    String implName = "ejb" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
                    copy.getNameIdentifier().replace((PsiElement)factory.createIdentifier(implName));
                    PsiUtil.addException((PsiMethod)copy, (String)"javax.ejb.FinderException");
                    result = new PsiMethod[]{copy};
                    break;
                }
                case EJB_METHOD_ROLE_CREATE_DECL: {
                    if (ejb instanceof SessionBean || ejb instanceof MessageDrivenBean) {
                        String implName = "ejbCreate" + methodName.substring("create".length());
                        copy.getNameIdentifier().replace((PsiElement)factory.createIdentifier(implName));
                        PsiUtil.addException((PsiMethod)copy, (String)"javax.ejb.CreateException");
                        result = new PsiMethod[]{copy};
                        break;
                    }
                    if (!(ejb instanceof EntityBean)) break;
                    String implName = "ejbCreate" + methodName.substring("create".length());
                    copy.getNameIdentifier().replace((PsiElement)factory.createIdentifier(implName));
                    PsiMethod copy2 = (PsiMethod)factory.createClass("Dummy2").add(copy.copy());
                    implName = "ejbPostCreate" + methodName.substring("create".length());
                    copy2.getNameIdentifier().replace((PsiElement)factory.createIdentifier(implName));
                    PsiUtil.addException((PsiMethod)copy2, (String)"javax.ejb.CreateException");
                    result = new PsiMethod[]{copy, copy2};
                    break;
                }
                case EJB_METHOD_ROLE_CMP_GETTER_DECL: 
                case EJB_METHOD_ROLE_CMP_SETTER_DECL: {
                    boolean isAbstract = EjbUtil.isCMP(ejb, CmpVersion.CmpVersion_2_X);
                    PsiUtil.setModifierProperty((PsiModifierListOwner)copy, (String)"abstract", (boolean)isAbstract);
                    if (isAbstract) {
                        copy.getBody().delete();
                    }
                    result = new PsiMethod[]{copy};
                    break;
                }
                case EJB_METHOD_ROLE_CMR_GETTER_DECL: 
                case EJB_METHOD_ROLE_CMR_SETTER_DECL: {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)copy, (String)"abstract", (boolean)true);
                    copy.getBody().delete();
                    result = new PsiMethod[]{copy};
                    break;
                }
                case EJB_METHOD_ROLE_BUSINESS_METHOD_DECL: {
                    result = new PsiMethod[]{EjbDeclMethodRoleImpl.replaceFutureWithT(copy)};
                    break;
                }
                case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_DECL: {
                    String implName = "ejbHome" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
                    copy.getNameIdentifier().replace((PsiElement)factory.createIdentifier(implName));
                    result = new PsiMethod[]{copy};
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    private static PsiMethod replaceFutureWithT(PsiMethod method) {
        PsiTypeParameter[] typeParameters;
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass psiClass;
        PsiType type;
        PsiTypeElement typeElement = method.getReturnTypeElement();
        if (typeElement != null && (type = typeElement.getType()) instanceof PsiClassType && (psiClass = (resolveResult = ((PsiClassType)type).resolveGenerics()).getElement()) != null && "java.util.concurrent.Future".equals(psiClass.getQualifiedName()) && (typeParameters = psiClass.getTypeParameters()).length == 1) {
            PsiType psiType = (PsiType)resolveResult.getSubstitutor().getSubstitutionMap().get(typeParameters[0]);
            typeElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)typeElement.getProject()).createTypeElement(psiType));
        }
        return method;
    }

    private static MethodSignature[] suggestImplementationPrototypes(PsiMethod method, EnterpriseBean ejb, EjbMethodRoleEnum type) {
        String[] implName = EjbPsiMethodUtil.suggestImplNames((String)method.getName(), (EjbMethodRoleEnum)type, (EnterpriseBean)ejb);
        if (implName[0] == null) {
            return MethodSignature.EMPTY_ARRAY;
        }
        if (implName[1] == null) {
            return new MethodSignature[]{MethodSignatureUtil.createMethodSignature((String)implName[0], (PsiParameterList)method.getParameterList(), null, (PsiSubstitutor)PsiSubstitutor.EMPTY)};
        }
        return new MethodSignature[]{MethodSignatureUtil.createMethodSignature((String)implName[0], (PsiParameterList)method.getParameterList(), null, (PsiSubstitutor)PsiSubstitutor.EMPTY), MethodSignatureUtil.createMethodSignature((String)implName[1], (PsiParameterList)method.getParameterList(), null, (PsiSubstitutor)PsiSubstitutor.EMPTY)};
    }

    @Override
    public String getTitle() {
        String desc;
        switch (this.getType()) {
            case EJB_METHOD_ROLE_FINDER_DECL: {
                desc = J2EEBundle.message((String)"method.role.finder.method.declaration", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_CREATE_DECL: {
                desc = J2EEBundle.message((String)"method.role.create.method.declaration", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_BUSINESS_METHOD_DECL: {
                desc = J2EEBundle.message((String)"method.role.business.method.declaration", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_CMP_GETTER_DECL: {
                desc = J2EEBundle.message((String)"method.role.cmp.field.getter.declaration", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_CMP_SETTER_DECL: {
                desc = J2EEBundle.message((String)"method.role.cmp.field.setter.declaration", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_CMR_GETTER_DECL: {
                desc = J2EEBundle.message((String)"method.role.cmr.field.getter.declaration", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_CMR_SETTER_DECL: {
                desc = J2EEBundle.message((String)"method.role.cmr.field.setter.declaration", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_DECL: {
                desc = J2EEBundle.message((String)"method.role.home.business.method.declaration", (Object[])new Object[0]);
                break;
            }
            default: {
                desc = J2EEBundle.message((String)"method.role.unknown.method.declaration", (Object[])new Object[0]);
            }
        }
        return desc;
    }
}

