/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.converters.QuotedValueConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationModelUtil {
    private AnnotationModelUtil() {
    }

    @NotNull
    public static List<PsiAnnotation> getAnnotationsValue(PsiAnnotation annotation, String parameterName, String childAnnotationName) {
        if (annotation != null) {
            PsiAnnotation childAnnotation;
            PsiAnnotationMemberValue annotationMemberValue = annotation.findAttributeValue(parameterName);
            if (annotationMemberValue instanceof PsiArrayInitializerMemberValue) {
                PsiArrayInitializerMemberValue psiArrayInitializerMemberValue = (PsiArrayInitializerMemberValue)annotationMemberValue;
                ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
                for (PsiAnnotationMemberValue value : psiArrayInitializerMemberValue.getInitializers()) {
                    PsiAnnotation childAnnotation2;
                    if (!(value instanceof PsiAnnotation) || !childAnnotationName.equals((childAnnotation2 = (PsiAnnotation)value).getQualifiedName())) continue;
                    result.add(childAnnotation2);
                }
                ArrayList<PsiAnnotation> arrayList = result;
                if (arrayList == null) {
                    AnnotationModelUtil.$$$reportNull$$$0(0);
                }
                return arrayList;
            }
            if (annotationMemberValue instanceof PsiAnnotation && childAnnotationName.equals((childAnnotation = (PsiAnnotation)annotationMemberValue).getQualifiedName())) {
                List<PsiAnnotation> list = Collections.singletonList(childAnnotation);
                if (list == null) {
                    AnnotationModelUtil.$$$reportNull$$$0(1);
                }
                return list;
            }
        }
        List<PsiAnnotation> list = Collections.emptyList();
        if (list == null) {
            AnnotationModelUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<AnnotationGenericValue<String>> getStringArrayValue(PsiAnnotation annotation, @NonNls String attributeName) {
        List<AnnotationGenericValue<String>> list = AnnotationModelUtil.getObjectArrayValue(annotation, attributeName, FunctionUtil.id());
        if (list == null) {
            AnnotationModelUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static <T extends Enum> List<AnnotationGenericValue<T>> getEnumArrayValue(PsiAnnotation annotation, @NonNls String attributeName, Class<T> clazz) {
        List<AnnotationGenericValue<T>> list = AnnotationModelUtil.getObjectArrayValue(annotation, attributeName, clazz, FunctionUtil.id());
        if (list == null) {
            AnnotationModelUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static <T> List<AnnotationGenericValue<T>> getObjectArrayValue(PsiAnnotation annotation, String attributeName, Function<String, T> function) {
        List<AnnotationGenericValue<T>> list = AnnotationModelUtil.getObjectArrayValue(annotation, attributeName, String.class, function);
        if (list == null) {
            AnnotationModelUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static <T, V> List<AnnotationGenericValue<T>> getObjectArrayValue(PsiAnnotation annotation, String attributeName, Class<V> clazz, Function<V, T> mapper) {
        ArrayList result = ContainerUtil.newArrayList();
        JamCommonUtil.processObjectArrayValue((PsiAnnotation)annotation, (String)attributeName, value -> {
            Object obj = JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)value, (Class)clazz);
            if (obj != null) {
                result.add(AnnotationGenericValue.getInstance(mapper.fun(obj), annotation, (PsiElement)value));
            }
            return true;
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            AnnotationModelUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static AnnotationGenericValue<Boolean> getBooleanValue(PsiAnnotation annotation) {
        AnnotationGenericValue<Boolean> annotationGenericValue = AnnotationGenericValue.getInstance(annotation != null ? Boolean.TRUE : Boolean.FALSE, annotation, null);
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(7);
        }
        return annotationGenericValue;
    }

    @NotNull
    public static AnnotationGenericValue<Boolean> getBooleanValue(PsiAnnotation annotation, @NonNls String attributeName, boolean def) {
        PsiAnnotationMemberValue memberValue = annotation.findAttributeValue(attributeName);
        Boolean value = AnnotationModelUtil.getBooleanValue(memberValue, def);
        AnnotationGenericValue<Boolean> annotationGenericValue = AnnotationGenericValue.getInstance(value, annotation, (PsiElement)memberValue);
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(8);
        }
        return annotationGenericValue;
    }

    private static boolean getBooleanValue(@Nullable PsiAnnotationMemberValue memberValue, boolean defValue) {
        boolean result;
        if (memberValue != null) {
            String s = memberValue.getText();
            result = Boolean.valueOf(s);
        } else {
            result = defValue;
        }
        return result;
    }

    @NotNull
    public static <T extends Enum> AnnotationGenericValue<T> getEnumValue(PsiAnnotation annotation, String attributeName, Class<T> clazz) {
        PsiAnnotationMemberValue memberValue;
        Enum value;
        if (annotation != null && (value = JamCommonUtil.getEnumValue((PsiAnnotationMemberValue)(memberValue = annotation.findAttributeValue(attributeName)), clazz)) != null) {
            AnnotationGenericValue<Enum> annotationGenericValue = AnnotationGenericValue.getInstance(value, annotation, (PsiElement)memberValue);
            if (annotationGenericValue == null) {
                AnnotationModelUtil.$$$reportNull$$$0(9);
            }
            return annotationGenericValue;
        }
        AnnotationGenericValue annotationGenericValue = AnnotationGenericValue.NULL;
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(10);
        }
        return annotationGenericValue;
    }

    @NotNull
    public static AnnotationGenericValue<String> getStringValue(PsiAnnotation annotation, @NonNls String attributeName, @Nullable String defaultValue) {
        if (annotation != null) {
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue(attributeName);
            String obj = (String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)value, String.class);
            String result = obj == null ? defaultValue : obj;
            AnnotationGenericValue<String> annotationGenericValue = AnnotationGenericValue.getInstance(QuotedValueConverter.unquote((String)result), annotation, (PsiElement)value);
            if (annotationGenericValue == null) {
                AnnotationModelUtil.$$$reportNull$$$0(11);
            }
            return annotationGenericValue;
        }
        if (defaultValue != null) {
            AnnotationGenericValue<String> annotationGenericValue = AnnotationGenericValue.getInstance(QuotedValueConverter.unquote((String)defaultValue), null, null);
            if (annotationGenericValue == null) {
                AnnotationModelUtil.$$$reportNull$$$0(12);
            }
            return annotationGenericValue;
        }
        AnnotationGenericValue annotationGenericValue = AnnotationGenericValue.NULL;
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(13);
        }
        return annotationGenericValue;
    }

    @NotNull
    public static <T> AnnotationGenericValue<T> getObjectValue(PsiAnnotation annotation, @NonNls String attributeName, Class<T> clazz) {
        if (annotation != null) {
            PsiAnnotationMemberValue value = annotation.findAttributeValue(attributeName);
            Object obj = JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)value, clazz);
            AnnotationGenericValue<Object> annotationGenericValue = AnnotationGenericValue.getInstance(obj, annotation, (PsiElement)value);
            if (annotationGenericValue == null) {
                AnnotationModelUtil.$$$reportNull$$$0(14);
            }
            return annotationGenericValue;
        }
        AnnotationGenericValue annotationGenericValue = AnnotationGenericValue.NULL;
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(15);
        }
        return annotationGenericValue;
    }

    @NotNull
    public static AnnotationGenericValue<PsiClass> getPsiClassValue(PsiAnnotation annotation, String attributeName, PsiClass defaultValue) {
        if (annotation != null) {
            PsiAnnotationMemberValue memberValue = annotation.findAttributeValue(attributeName);
            PsiClass psiClass = JamCommonUtil.getPsiClass((PsiAnnotationMemberValue)memberValue);
            if (psiClass == null) {
                psiClass = defaultValue;
            }
            if (psiClass != null || memberValue != null) {
                AnnotationGenericValue<PsiClass> annotationGenericValue = AnnotationGenericValue.getInstance(psiClass, annotation, (PsiElement)memberValue);
                if (annotationGenericValue == null) {
                    AnnotationModelUtil.$$$reportNull$$$0(16);
                }
                return annotationGenericValue;
            }
        }
        AnnotationGenericValue annotationGenericValue = AnnotationGenericValue.NULL;
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(17);
        }
        return annotationGenericValue;
    }

    @NotNull
    public static List<AnnotationGenericValue<PsiClass>> getPsiClassArrayValue(PsiAnnotation annotation, String attributeName) {
        if (annotation != null) {
            PsiClass psiClass;
            PsiAnnotationMemberValue memberValue = annotation.findAttributeValue(attributeName);
            if (memberValue instanceof PsiArrayInitializerMemberValue) {
                ArrayList<AnnotationGenericValue<PsiClass>> result = new ArrayList<AnnotationGenericValue<PsiClass>>();
                PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)memberValue;
                for (PsiAnnotationMemberValue value : arrayValue.getInitializers()) {
                    PsiClass psiClass2 = JamCommonUtil.getPsiClass((PsiAnnotationMemberValue)value);
                    if (psiClass2 == null) continue;
                    result.add(AnnotationGenericValue.getInstance(psiClass2, annotation, (PsiElement)value));
                }
                ArrayList<AnnotationGenericValue<PsiClass>> arrayList = result;
                if (arrayList == null) {
                    AnnotationModelUtil.$$$reportNull$$$0(18);
                }
                return arrayList;
            }
            if (memberValue != null && (psiClass = JamCommonUtil.getPsiClass((PsiAnnotationMemberValue)memberValue)) != null) {
                List<AnnotationGenericValue<PsiClass>> list = Collections.singletonList(AnnotationGenericValue.getInstance(psiClass, annotation, (PsiElement)memberValue));
                if (list == null) {
                    AnnotationModelUtil.$$$reportNull$$$0(19);
                }
                return list;
            }
        }
        List<AnnotationGenericValue<PsiClass>> list = Collections.emptyList();
        if (list == null) {
            AnnotationModelUtil.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Nullable
    public static String getPsiMemberName(PsiMember member) {
        String attributeName = PropertyUtilBase.getPropertyName((PsiMember)member);
        return attributeName == null ? null : member.getContainingClass().getQualifiedName() + "/" + attributeName;
    }

    @Nullable
    public static PsiClass getPsiMemberType(PsiMember member) {
        PsiMethod method;
        Object psiType = member instanceof PsiField ? ((PsiField)member).getType() : (member instanceof PsiMethod ? (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)(method = (PsiMethod)member)) ? method.getReturnType() : (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) ? method.getParameterList().getParameters()[0].getType() : null)) : null);
        if (psiType == null) {
            return null;
        }
        if (psiType instanceof PsiClassType) {
            return ((PsiClassType)psiType).resolve();
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)psiType) && StringUtil.isNotEmpty((String)((PsiPrimitiveType)psiType).getBoxedTypeName())) {
            return JavaPsiFacade.getInstance((Project)member.getProject()).findClass(((PsiPrimitiveType)psiType).getBoxedTypeName(), member.getResolveScope());
        }
        return null;
    }

    public static List<PsiAnnotation> getAnnotationsValueIncludingSingle(PsiModifierListOwner modifierListOwner, String annotationName, String contentAnnotation) {
        if (modifierListOwner == null) {
            return Collections.emptyList();
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        PsiAnnotation psiSingleAnnotation = modifierList.findAnnotation(contentAnnotation);
        if (psiSingleAnnotation != null) {
            result.add(psiSingleAnnotation);
        }
        PsiAnnotation annotation = modifierList.findAnnotation(annotationName);
        for (PsiAnnotation psiAnnotation : AnnotationModelUtil.getAnnotationsValue(annotation, "value", contentAnnotation)) {
            result.add(psiAnnotation);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/model/annotations/AnnotationModelUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationsValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringArrayValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumArrayValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectArrayValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBooleanValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumValue";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectValue";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClassValue";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClassArrayValue";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

