/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.xml.impl;

import com.intellij.javaee.ejb.EjbMethod;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.InterceptorMethod;
import com.intellij.javaee.model.common.ejb.InterceptorMethodType;
import com.intellij.javaee.model.enums.TransAttribute;
import com.intellij.javaee.model.xml.SecurityRole;
import com.intellij.javaee.model.xml.ejb.AssemblyDescriptor;
import com.intellij.javaee.model.xml.ejb.ContainerTransaction;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.javaee.model.xml.ejb.EntityBean;
import com.intellij.javaee.model.xml.ejb.InterceptorBinding;
import com.intellij.javaee.model.xml.ejb.MessageDrivenBean;
import com.intellij.javaee.model.xml.ejb.Method;
import com.intellij.javaee.model.xml.ejb.MethodPermission;
import com.intellij.javaee.model.xml.ejb.SessionBean;
import com.intellij.javaee.model.xml.impl.EjbXmlImplUtil;
import com.intellij.javaee.model.xml.impl.EnvironmentGroupImpl;
import com.intellij.javaee.model.xml.impl.GenericValueImpl;
import com.intellij.javaee.model.xml.impl.InterceptorImpl;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Processor;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class EnterpriseBeanImpl
extends EnvironmentGroupImpl
implements EjbBase {
    @NotNull
    public EjbDescriptorVersion getEjbVersion() {
        EjbDescriptorVersion ejbDescriptorVersion = EjbUtil.getVersion((JavaeeModelElement)this);
        if (ejbDescriptorVersion == null) {
            EnterpriseBeanImpl.$$$reportNull$$$0(0);
        }
        return ejbDescriptorVersion;
    }

    public GenericValue<SecurityRole> getRunAs() {
        return this.getSecurityIdentity().getRunAs().getRoleName();
    }

    public List<GenericDomValue<SecurityRole>> getDeclaredRoles() {
        return Collections.emptyList();
    }

    public GenericValue<TransAttribute> getTransactionAttribute() {
        String ejbName = (String)this.getEjbName().getValue();
        AssemblyDescriptor assemblyDescriptor = EjbXmlImplUtil.getAssemblyDescriptor((JavaeeModelElement)this);
        if (ejbName != null && assemblyDescriptor != null) {
            for (ContainerTransaction transaction : assemblyDescriptor.getContainerTransactions()) {
                TransAttribute attrName;
                if (!this.describesTheWholeBean(transaction.getMethods(), ejbName) || (attrName = (TransAttribute)transaction.getTransAttribute().getValue()) == null) continue;
                return new GenericValueImpl<TransAttribute>(Enum.valueOf(TransAttribute.class, attrName.name()));
            }
        }
        return new GenericValueImpl<TransAttribute>(TransAttribute.REQUIRED);
    }

    public GenericValue<Boolean> isPermitAll() {
        String ejbName = (String)this.getEjbName().getValue();
        if (ejbName != null) {
            AssemblyDescriptor assemblyDescriptor = EjbXmlImplUtil.getAssemblyDescriptor((JavaeeModelElement)this);
            for (MethodPermission methodPermission : assemblyDescriptor.getMethodPermissions()) {
                if (!this.describesTheWholeBean(methodPermission.getMethods(), ejbName)) continue;
                return methodPermission.getUnchecked();
            }
        }
        return new GenericValueImpl<Boolean>(Boolean.FALSE);
    }

    public GenericValue<Boolean> isDenyAll() {
        String ejbName = (String)this.getEjbName().getValue();
        AssemblyDescriptor assemblyDescriptor = EjbXmlImplUtil.getAssemblyDescriptor((JavaeeModelElement)this);
        if (ejbName != null && assemblyDescriptor != null) {
            if (this.describesTheWholeBean(assemblyDescriptor.getExcludeList().getMethods(), ejbName)) {
                return new GenericValueImpl<Boolean>(Boolean.TRUE);
            }
            for (MethodPermission methodPermission : assemblyDescriptor.getMethodPermissions()) {
                if (!this.describesTheWholeBean(methodPermission.getMethods(), ejbName)) continue;
                return new GenericValueImpl<Boolean>(methodPermission.getRoleNames().size() == 0 ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        return new GenericValueImpl<Boolean>(Boolean.FALSE);
    }

    public Collection<? extends GenericValue<SecurityRole>> getRolesAllowed() {
        String ejbName = (String)this.getEjbName().getValue();
        AssemblyDescriptor assemblyDescriptor = EjbXmlImplUtil.getAssemblyDescriptor((JavaeeModelElement)this);
        if (ejbName != null && assemblyDescriptor != null) {
            for (MethodPermission methodPermission : assemblyDescriptor.getMethodPermissions()) {
                if (!this.describesTheWholeBean(methodPermission.getMethods(), ejbName)) continue;
                return methodPermission.getRoleNames();
            }
        }
        return Collections.emptyList();
    }

    public GenericValue<Boolean> isExcludeDefaultInterceptors() {
        String thisEjbName = (String)this.getEjbName().getValue();
        AssemblyDescriptor assemblyDescriptor = EjbXmlImplUtil.getAssemblyDescriptor((JavaeeModelElement)this);
        GenericDomValue result = null;
        if (thisEjbName != null && assemblyDescriptor != null) {
            for (InterceptorBinding binding : assemblyDescriptor.getInterceptorBindings()) {
                String ejbName = binding.getEnterpriseBean().getStringValue();
                if (!thisEjbName.equals(ejbName) || binding.getMethod().getXmlTag() != null || !Boolean.TRUE.equals((result = binding.getExcludeDefaultInterceptors()).getValue())) continue;
                return result;
            }
        }
        return result == null ? GenericValueImpl.NULL : result;
    }

    public List<GenericDomValue<PsiClass>> getClassInterceptors() {
        String thisEjbName = (String)this.getEjbName().getValue();
        AssemblyDescriptor assemblyDescriptor = EjbXmlImplUtil.getAssemblyDescriptor((JavaeeModelElement)this);
        if (assemblyDescriptor == null || thisEjbName == null) {
            return Collections.emptyList();
        }
        ArrayList<GenericDomValue<PsiClass>> result = new ArrayList<GenericDomValue<PsiClass>>();
        for (InterceptorBinding binding : assemblyDescriptor.getInterceptorBindings()) {
            String ejbName = binding.getEnterpriseBean().getStringValue();
            if (!thisEjbName.equals(ejbName) || binding.getMethod().getXmlTag() != null) continue;
            result.addAll(binding.getInterceptorClasses());
        }
        return result;
    }

    public void processInterceptorMethods(PsiClass currentClass, Processor<InterceptorMethod> processor) {
        if (!InterceptorImpl.processLifecycleCallbackList((PsiClass)this.getEjbClass().getValue(), this.getPostConstructs(), InterceptorMethodType.POST_CONSTRUCT, currentClass, processor)) {
            return;
        }
        if (!InterceptorImpl.processLifecycleCallbackList((PsiClass)this.getEjbClass().getValue(), this.getPreDestroys(), InterceptorMethodType.PRE_DESTROY, currentClass, processor)) {
            return;
        }
    }

    protected boolean describesTheWholeBean(List<Method> methods, String ejbName) {
        for (Method method : methods) {
            if (!ejbName.equals(method.getEnterpriseBean().getStringValue()) || !"*".equals(method.getMethod().getStringValue()) || method.getMethodIntf().getValue() != null) continue;
            return true;
        }
        return false;
    }

    public GenericValue<PsiMethod> getTimeoutMethodValue() {
        PsiMethod ejbTimeoutMethod;
        PsiMethod[] methods;
        PsiClass timedObjectClass;
        PsiClass ejbClass = (PsiClass)this.getEjbClass().getValue();
        if (ejbClass != null && (timedObjectClass = this.findPsiClass("javax.ejb.TimedObject")) != null && ejbClass.isInheritor(timedObjectClass, true) && (methods = timedObjectClass.findMethodsByName("ejbTimeout", false)).length == 1 && (ejbTimeoutMethod = ejbClass.findMethodBySignature(methods[0], true)) != null) {
            return GenericValueImpl.getInstance(ejbTimeoutMethod);
        }
        return GenericValueImpl.nullInstance();
    }

    public List<? extends EjbMethod> getEjbMethods() {
        return EjbXmlImplUtil.getXmlEjbMethods((EnterpriseBean)this);
    }

    public List<? extends GenericValue<PsiClass>> getBusinessInterfaces() {
        if (this instanceof SessionBean) {
            SessionBean ejb = (SessionBean)this;
            ArrayList<GenericDomValue> result = new ArrayList<GenericDomValue>();
            result.add(ejb.getLocal());
            result.add(ejb.getRemote());
            result.add(ejb.getServiceEndpoint());
            result.addAll(ejb.getBusinessLocals());
            result.addAll(ejb.getBusinessRemotes());
            return result;
        }
        if (this instanceof EntityBean) {
            EntityBean ejb = (EntityBean)this;
            return Arrays.asList(ejb.getLocal(), ejb.getRemote());
        }
        if (this instanceof MessageDrivenBean) {
            return Collections.singletonList(((MessageDrivenBean)this).getMessageDestinationType());
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/xml/impl/EnterpriseBeanImpl", "getEjbVersion"));
    }
}

