/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.module.view.ejb.nodes.InterceptorMethodsNodeDescriptor;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.xml.GenericValue;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class InterceptorNodeDescriptor
extends InterceptorMethodsNodeDescriptor<Interceptor> {
    @NonNls
    public static final String INTERCEPTOR_SELECTED_OR_PARENT = "InterceptorImpl";

    public InterceptorNodeDescriptor(Interceptor interceptor, NodeDescriptor parentDescriptor, Object parameters) {
        super(interceptor, parentDescriptor, parameters);
    }

    public InterceptorNodeDescriptor(Interceptor interceptor, Object parameters) {
        super(interceptor, parameters);
    }

    @Override
    public JavaeeNodeDescriptor[] getChildren() {
        J2EEModuleParameters parameters = (J2EEModuleParameters)((Object)this.getParameters());
        if (!parameters.showMembers()) {
            return EMPTY_ARRAY;
        }
        return super.getChildren();
    }

    public Object getData(String dataId) {
        if (INTERCEPTOR_SELECTED_OR_PARENT.equals(dataId)) {
            return this.getElement();
        }
        if (DataConstants.VIRTUAL_FILE.equals(dataId)) {
            return this.findFile();
        }
        if ("psi.Element".equals(dataId)) {
            return ((Interceptor)this.getElement()).getInterceptorClass().getValue();
        }
        return super.getData(dataId);
    }

    @Nullable
    private VirtualFile findFile() {
        PsiClass aClass = (PsiClass)((Interceptor)this.getElement()).getInterceptorClass().getValue();
        PsiFile psiFile = aClass == null ? null : aClass.getContainingFile();
        return psiFile == null ? null : psiFile.getVirtualFile();
    }

    protected Navigatable getNavigatable() {
        VirtualFile file = this.findFile();
        return file == null ? null : new OpenFileDescriptor(((Interceptor)this.getElement()).getModule().getProject(), file);
    }

    @Override
    public String getNewNodeText() {
        if (!((Interceptor)this.getElement()).isValid()) {
            return null;
        }
        return JavaeeUtil.getClassPresentableText((GenericValue<PsiClass>)((Interceptor)this.getElement()).getInterceptorClass(), false, true);
    }

    protected String getNewNodeTextExt() {
        if (!((Interceptor)this.getElement()).isValid()) {
            return null;
        }
        return JavaeeUtil.getClassPresentableText((GenericValue<PsiClass>)((Interceptor)this.getElement()).getInterceptorClass(), true, false);
    }

    @Override
    public Icon getNewIcon() {
        return JavaeeIcons.EJB_INTERCEPTOR_CLASS_ICON;
    }
}

