/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.transactions;

import com.intellij.ide.DeleteProvider;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.module.view.ejb.nodes.EjbClassNodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.module.view.nodes.MethodNodeDescriptor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class EjbTransactionClassNodeDescriptor
extends EjbClassNodeDescriptor {
    @NonNls
    protected static final String JAVAX_EJB_PREFIX = "javax.ejb";
    @NonNls
    protected static final String ON_MESSAGE = "onMessage";
    @NonNls
    private static final List<String> nonTransactableEntityMethods = Arrays.asList("getEJBHome", "getEJBLocalHome", "getHandle", "getPrimaryKey", "isIdentical", "getEJBMetaData", "getHomeHandle");

    public EjbTransactionClassNodeDescriptor(EjbClassRoleEnum ejbClassRoleEnum, PsiClass aClass, JavaeeNodeDescriptor parentDescriptor, Object parameters) {
        super(ejbClassRoleEnum, aClass, parentDescriptor, parameters);
    }

    @Override
    public JavaeeNodeDescriptor[] getChildren() {
        ArrayList<MethodNodeDescriptor> result = new ArrayList<MethodNodeDescriptor>();
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        this.addMethods((PsiClass)this.getElement(), methods);
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            PsiMethod method;
            EjbMethodRole[] roles = OldEjbRolesUtil.getEjbRoles(method = (PsiMethod)iterator.next());
            result.add(this.createMethodChildDescriptor(method, roles.length > 0 ? roles[0].getType() : null, true));
        }
        return result.toArray(JavaeeNodeDescriptor.EMPTY_ARRAY);
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        return null;
    }

    protected void addMethods(PsiClass aClass, List<PsiMethod> list) {
        if (!(this.getParent().getElement() instanceof EnterpriseBean)) {
            return;
        }
        EnterpriseBean ejb = (EnterpriseBean)this.getParent().getElement();
        if (ejb instanceof EntityBean) {
            this.addEntityMethods(ejb, aClass, list);
        } else if (ejb instanceof SessionBean) {
            this.addSessionMethods(ejb, aClass, list);
        } else if (ejb instanceof MessageDrivenBean) {
            this.addMessageDrivenMethods(ejb, aClass, list);
        }
    }

    protected void addMessageDrivenMethods(EnterpriseBean ejb, PsiClass aClass, List<PsiMethod> list) {
        this.addSessionMethods(ejb, aClass, list);
    }

    protected void addEntityMethods(EnterpriseBean ejb, PsiClass anInterface, List<PsiMethod> list) {
        if (anInterface == null) {
            return;
        }
        if (this.myClassRoleEnum == EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) {
            ContainerUtil.addIfNotNull(list, (Object)ejb.getTimeoutMethodValue().getValue());
        } else {
            for (PsiMethod method : anInterface.getAllMethods()) {
                PsiClass aClass = method.getContainingClass();
                String qualifiedName = aClass.getQualifiedName();
                if (qualifiedName == null || !aClass.isInterface()) continue;
                String methodName = method.getName();
                if (qualifiedName.startsWith(JAVAX_EJB_PREFIX) && nonTransactableEntityMethods.contains(methodName)) continue;
                list.add(method);
            }
        }
    }

    protected void addSessionMethods(EnterpriseBean ejb, PsiClass anInterface, List<PsiMethod> list) {
        if (anInterface == null) {
            return;
        }
        if (this.myClassRoleEnum == EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) {
            ContainerUtil.addIfNotNull(list, (Object)ejb.getTimeoutMethodValue().getValue());
        } else {
            for (PsiMethod method : anInterface.getAllMethods()) {
                PsiClass aClass = method.getContainingClass();
                String qualifiedName = aClass.getQualifiedName();
                if (qualifiedName == null || !aClass.isInterface() || qualifiedName.startsWith(JAVAX_EJB_PREFIX)) continue;
                list.add(method);
            }
        }
    }
}

