/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.artifacts.JarArtifactType;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeExtensionsBase
implements PersistentStateComponent<Element> {
    @NonNls
    protected static final String EAR_ID = "app";
    @NonNls
    protected static final String EJB_ID = "ejb";
    @NonNls
    protected static final String WAR_ID = "web";
    @NonNls
    protected static final String JAR_ID = "jar";
    private final Map<ArtifactType, String> types = new HashMap<ArtifactType, String>();
    private final Map<String, Set<String>> extensions = new HashMap<String, Set<String>>();
    private final String myElementName;

    protected JavaeeExtensionsBase(@NonNls String elementName) {
        this.myElementName = elementName;
        JavaeeArtifactUtil artifactUtil = JavaeeArtifactUtil.getInstance();
        this.initialize(EAR_ID, artifactUtil.getEarArtifactType(), artifactUtil.getExplodedEarArtifactType(), "ear");
        this.initialize(EJB_ID, artifactUtil.getEjbJarArtifactType(), artifactUtil.getExplodedEjbArtifactType(), JAR_ID, "beans", "spring", "ejb3", "par", "rar", "aop", "deployer", "esb");
        WebArtifactUtil webArtifactUtil = WebArtifactUtil.getInstance();
        this.initialize(WAR_ID, webArtifactUtil.getWarArtifactType(), webArtifactUtil.getExplodedWarArtifactType(), "war");
        this.initialize(JAR_ID, (ArtifactType)JarArtifactType.getInstance(), null, JAR_ID, "beans", "spring", "par", "rar", "aop", "deployer", "esb");
    }

    public Element getState() {
        Element element = new Element(this.myElementName);
        for (Map.Entry<String, Set<String>> entry : this.extensions.entrySet()) {
            for (String extension : entry.getValue()) {
                Element child = new Element("entry");
                child.setAttribute("type", entry.getKey());
                child.setAttribute("extension", extension);
                element.addContent(child);
            }
        }
        return element;
    }

    public void loadState(@NotNull @NonNls Element element) {
        if (element == null) {
            JavaeeExtensionsBase.$$$reportNull$$$0(0);
        }
        for (Element child : element.getChildren("entry")) {
            String id = child.getAttributeValue("type");
            if (!this.extensions.containsKey(id)) {
                this.extensions.put(id, (Set<String>)new THashSet(FileUtil.PATH_HASHING_STRATEGY));
            }
            this.extensions.get(id).add(child.getAttributeValue("extension"));
        }
    }

    public boolean isValidExtension(ArtifactType artifactType, String extension) {
        Set<String> set = this.extensions.get(this.types.get(artifactType));
        return set != null && set.contains(extension);
    }

    public String getDefaultExtension(ArtifactType artifactType) {
        return (String)ContainerUtil.getFirstItem((Collection)this.extensions.get(this.types.get(artifactType)), null);
    }

    private void initialize(@NonNls String id, ArtifactType type1, @Nullable ArtifactType type2, String ... extension) {
        this.types.put(type1, id);
        if (type2 != null) {
            this.types.put(type2, id);
        }
        if (!this.extensions.containsKey(id)) {
            this.extensions.put(id, (Set<String>)new THashSet(Arrays.asList(extension), FileUtil.PATH_HASHING_STRATEGY));
        }
    }

    protected final void addExtensions(@NonNls String id, String ... extension) {
        this.extensions.get(id).addAll(Arrays.asList(extension));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/oss/server/JavaeeExtensionsBase", "loadState"));
    }
}

