/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.javaee.appServerIntegrations.ApplicationServerHelper;
import com.intellij.javaee.appServerIntegrations.ApplicationServerInfo;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.appServerIntegrations.CantFindApplicationServerJarsException;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeePersistentDataEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaeeServerHelper
implements ApplicationServerHelper {
    @NonNls
    private static final String[] CLASSES = new String[]{"javax.servlet.Servlet", "javax.servlet.jsp.JspPage", "javax.ejb.EntityBean"};
    private final JavaeeIntegration myIntegration;

    public JavaeeServerHelper(JavaeeIntegration integration) {
        this.myIntegration = integration;
    }

    private JavaeeIntegration getIntegration() {
        return this.myIntegration;
    }

    public ApplicationServerPersistentDataEditor createConfigurable() {
        return new JavaeePersistentDataEditor(this.getIntegration());
    }

    public ApplicationServerPersistentData createPersistentDataEmptyInstance() {
        return new JavaeePersistentData();
    }

    public ApplicationServerInfo getApplicationServerInfo(final ApplicationServerPersistentData data) throws CantFindApplicationServerJarsException {
        final ArrayList libraries = new ArrayList();
        Function mapper = type -> type.replace('.', '/') + ".class";
        final List classes = ContainerUtil.map2List((Object[])CLASSES, (Function)mapper);
        new Task.Modal(null, JavaeeBundle.getText("ServerHelper.libraries.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                JavaeeServerHelper.this.getLibraries(libraries, classes, (JavaeePersistentData)data, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javaee/oss/server/JavaeeServerHelper$1", "run"));
            }
        }.queue();
        if (!this.getIntegration().allLibrariesFound(classes, (Function<String, String>)mapper)) {
            throw new CantFindApplicationServerJarsException(JavaeeBundle.getText("ServerHelper.libraries.error", new Object[0]));
        }
        JavaeeIntegration integration = this.getIntegration();
        String serverVersion = integration.getServerVersionSilently((JavaeePersistentData)data);
        String name = StringUtil.join(Arrays.asList(integration.getName(), serverVersion), (String)" ");
        return new ApplicationServerInfo(libraries.toArray(new File[0]), name);
    }

    private void getLibraries(List<File> libraries, Collection<String> classes, JavaeePersistentData persistentData, ProgressIndicator indicator) {
        if (StringUtil.isEmpty((String)persistentData.HOME)) {
            return;
        }
        indicator.setIndeterminate(true);
        List<File> candidates = this.getCandidates(persistentData, indicator);
        indicator.setIndeterminate(false);
        for (File file : candidates) {
            if (indicator.isCanceled()) continue;
            indicator.setText(file.getAbsolutePath());
            indicator.setFraction((double)candidates.indexOf(file) / (double)candidates.size());
            try {
                ZipFile zip = new ZipFile(file);
                Iterator<String> iter = classes.iterator();
                while (iter.hasNext()) {
                    String name = iter.next();
                    if (zip.getEntry(name) == null) continue;
                    libraries.add(file);
                    iter.remove();
                }
            }
            catch (IOException iOException) {
            }
        }
        if (indicator.isCanceled()) {
            libraries.clear();
        }
    }

    private List<File> getCandidates(JavaeePersistentData persistentData, ProgressIndicator indicator) {
        ArrayList<File> locations = new ArrayList<File>();
        ArrayList<File> candidates = new ArrayList<File>();
        HashSet<File> visited = new HashSet<File>();
        this.getIntegration().addLibraryLocations(persistentData, locations);
        for (File file : locations) {
            this.getCandidates(file, candidates, visited, indicator);
        }
        return candidates;
    }

    private void getCandidates(File base, List<File> candidates, Set<File> visited, ProgressIndicator indicator) {
        if (base.isDirectory() && visited.add(base) && !indicator.isCanceled()) {
            File[] children = base.listFiles();
            if (children == null) {
                return;
            }
            for (File file : children) {
                if (file.isDirectory()) {
                    this.getCandidates(file, candidates, visited, indicator);
                    continue;
                }
                if (!file.getName().endsWith(".jar")) continue;
                candidates.add(file);
            }
        }
    }
}

