/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.configuration;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.J2EEConfigurationFactory;
import com.intellij.javaee.run.configuration.J2EEConfigurationType;
import com.intellij.javaee.run.configuration.JavaCommandLineStartupPolicy;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.configuration.ServerModelEx;
import com.intellij.javaee.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class J2EEConfigurationFactoryImpl
extends J2EEConfigurationFactory {
    public RunConfiguration createJ2EERunConfiguration(ConfigurationFactory factory, Project project, ServerModel serverSpecific, AppServerIntegration integration, boolean isLocal, JavaCommandLineStartupPolicy startupPolicy) {
        return integration.isDebugAllowed(isLocal) ? new CommonStrategy("", integration, project, factory, serverSpecific, isLocal, startupPolicy) : new CommonStrategyWithoutDefaultDebug("", integration, project, factory, serverSpecific, isLocal, startupPolicy);
    }

    public RunConfiguration createJ2EERunConfiguration(ConfigurationFactory factory, Project project, ServerModel serverSpecific, AppServerIntegration integration, boolean isLocal, ExecutableObjectStartupPolicy startupPolicy) {
        return integration.isDebugAllowed(isLocal) ? new CommonStrategy("", integration, project, factory, serverSpecific, isLocal, startupPolicy) : new CommonStrategyWithoutDefaultDebug("", integration, project, factory, serverSpecific, isLocal, startupPolicy);
    }

    public RunnerAndConfigurationSettings addAppServerConfiguration(@NotNull Project project, @NotNull ConfigurationFactory type, @NotNull ApplicationServer appServer) {
        if (project == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(1);
        }
        if (appServer == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(2);
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings runSettings = runManager.createRunConfiguration(appServer.getName(), type);
        CommonStrategy configuration = (CommonStrategy)runSettings.getConfiguration();
        configuration.setApplicationServer(appServer);
        runManager.addConfiguration(runSettings);
        runManager.setSelectedConfiguration(runSettings);
        return runSettings;
    }

    public RunnerAndConfigurationSettings createSettingsByFile(@NotNull PsiFile psiFile, @NotNull J2EEConfigurationType configurationType) {
        AppServerIntegration integration;
        if (psiFile == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(3);
        }
        if (configurationType == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(4);
        }
        if ((integration = configurationType.getIntegration()) == null) {
            return null;
        }
        List servers = ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{integration});
        if (servers.isEmpty()) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        FileType fileType = file.getFileType();
        if (fileType != StdFileTypes.HTML && fileType != StdFileTypes.XHTML && fileType != StdFileTypes.JSP && fileType != StdFileTypes.JSPX) {
            return null;
        }
        Project project = psiFile.getProject();
        ApplicationServer server = (ApplicationServer)servers.get(0);
        String url = configurationType.getUrlToOpenInBrowser(server, psiFile);
        if (url == null) {
            return null;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(psiFile.getName(), configurationType.getLocalFactory());
        CommonStrategy configuration = (CommonStrategy)settings.getConfiguration();
        configuration.setApplicationServer(server);
        configuration.setUrlToOpenInBrowser(url);
        Collection artifacts = ArtifactBySourceFileFinder.getInstance((Project)project).findArtifacts(file);
        DeploymentProvider deploymentProvider = DeploymentManagerEx.getProvider(configuration);
        if (deploymentProvider != null) {
            Artifact toDeploy = null;
            for (Artifact artifact : artifacts) {
                if (!deploymentProvider.getSupportedArtifactTypes().contains(artifact.getArtifactType())) continue;
                toDeploy = artifact;
                break;
            }
            if (toDeploy == null) {
                return null;
            }
            configuration.getDeploymentSettings().getOrCreateModel(toDeploy);
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun((Project)project, (RunConfiguration)configuration, toDeploy);
        }
        return settings;
    }

    public ConfigurationFactory createFactory(J2EEConfigurationType type, boolean isLocal, String name) {
        return new MyConfigurationFactory(type, isLocal, name);
    }

    public boolean isConfigurationApplicable(@NotNull J2EEConfigurationType type, @NotNull Project project) {
        AppServerIntegration integration;
        if (type == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(5);
        }
        if (project == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(6);
        }
        return (integration = type.getIntegration()) == null || !ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{integration}).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appServer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addAppServerConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createSettingsByFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationApplicable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommonStrategyWithoutDefaultDebug
    extends CommonStrategy
    implements RunConfigurationWithSuppressedDefaultDebugAction {
        public CommonStrategyWithoutDefaultDebug(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, ExecutableObjectStartupPolicy executablePolicy) {
            super(name, integration, project, factory, serverModel, isLocal, executablePolicy);
        }

        public CommonStrategyWithoutDefaultDebug(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, JavaCommandLineStartupPolicy javaPolicy) {
            super(name, integration, project, factory, serverModel, isLocal, javaPolicy);
        }
    }

    private static class MyConfigurationFactory
    extends ConfigurationFactoryEx {
        private final boolean myIsLocal;
        private final String myName;
        private J2EEConfigurationType myType;

        public MyConfigurationFactory(J2EEConfigurationType type, boolean isLocal, String name) {
            super((ConfigurationType)type);
            this.myIsLocal = isLocal;
            this.myName = name;
            this.myType = type;
        }

        public RunConfiguration createConfiguration(String name, RunConfiguration template) {
            RunConfiguration configuration = super.createConfiguration(name, template);
            ((CommonModel)configuration).initialize();
            return configuration;
        }

        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                MyConfigurationFactory.$$$reportNull$$$0(0);
            }
            return J2EEConfigurationFactory.getInstance().isConfigurationApplicable(this.myType, project);
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(Project project) {
            RunConfiguration runConfiguration = this.myType.createJ2EEConfigurationTemplate((ConfigurationFactory)this, project, this.myIsLocal);
            if (runConfiguration == null) {
                MyConfigurationFactory.$$$reportNull$$$0(1);
            }
            return runConfiguration;
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            ServerModel serverModel;
            CommonStrategy model;
            if (configuration == null) {
                MyConfigurationFactory.$$$reportNull$$$0(2);
            }
            if ((model = (CommonStrategy)configuration).getApplicationServer() == null) {
                List servers = ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{model.getIntegration()});
                model.setApplicationServer((ApplicationServer)ContainerUtil.getFirstItem((Collection)servers, null));
            }
            if ((serverModel = model.getServerModel()) instanceof ServerModelEx) {
                ((ServerModelEx)serverModel).onNewConfigurationCreated();
            }
        }

        public void onConfigurationCopied(@NotNull RunConfiguration configuration) {
            ServerModel model;
            if (configuration == null) {
                MyConfigurationFactory.$$$reportNull$$$0(3);
            }
            if ((model = ((CommonModel)configuration).getServerModel()) instanceof ServerModelEx) {
                ((ServerModelEx)model).onConfigurationCopied();
            }
        }

        public Icon getIcon() {
            return this.myIsLocal ? this.myType.getLocalIcon() : this.myType.getRemoteIcon();
        }

        public String getName() {
            return this.myName;
        }

        public boolean canConfigurationBeSingleton() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl$MyConfigurationFactory";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl$MyConfigurationFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "onNewConfigurationCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onConfigurationCopied";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

