/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.ide.util.projectWizard.j2ee.DeploymentDescriptorUtil;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ui.DeleteDeploymentDescriptorDialog;
import com.intellij.javaee.ui.DeploymentDescriptorEditDialog;
import com.intellij.javaee.ui.DeploymentDescriptorsOwner;
import com.intellij.javaee.ui.DescriptorInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileVersion;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFilesEditor {
    private final Comparator<DescriptorInfo> COMPARATOR = new Comparator<DescriptorInfo>(){

        @Override
        public int compare(DescriptorInfo item1, DescriptorInfo item2) {
            return ConfigFilesEditor.this.myDescriptorInfos.indexOf(item1) - ConfigFilesEditor.this.myDescriptorInfos.indexOf(item2);
        }
    };
    private final ColumnInfo TITLE = new ColumnInfo<DescriptorInfo, String>(J2EEBundle.message((String)"column.name.edit.deployment.descriptors.type", (Object[])new Object[0])){

        public String valueOf(DescriptorInfo descriptorInfo) {
            return descriptorInfo.getTitle();
        }

        public Comparator<DescriptorInfo> getComparator() {
            return ConfigFilesEditor.this.COMPARATOR;
        }
    };
    private final PathCellRenderer myPathCellRenderer = new PathCellRenderer();
    private final ColumnInfo PATH = new ColumnInfo<DescriptorInfo, String>(J2EEBundle.message((String)"column.name.edit.deployment.descriptors.path", (Object[])new Object[0])){

        public String valueOf(DescriptorInfo descriptorInfo) {
            return FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)descriptorInfo.getUrl()));
        }

        public Comparator<DescriptorInfo> getComparator() {
            return ConfigFilesEditor.this.COMPARATOR;
        }

        public TableCellRenderer getRenderer(DescriptorInfo descriptorInfo) {
            return ConfigFilesEditor.this.myPathCellRenderer;
        }
    };
    private JPanel myMainPanel;
    private final List<DescriptorInfo> myDescriptorInfos = new ArrayList<DescriptorInfo>();
    private TableView<DescriptorInfo> myTableView;
    private final File myDefaultParentDirectory;
    private final DeploymentDescriptorsOwner myDDOwner;
    private final ConfigFileInfoSet myDescriptorsConfiguration;
    private final ConfigFileMetaData[] myMetaData;
    private final boolean myNew;

    public ConfigFilesEditor(ConfigFileMetaData[] metaData, ConfigFileInfoSet descriptorsConfiguration, File defaultParent, boolean isNew, DeploymentDescriptorsOwner ddOwner, boolean addDefaultDescriptors) {
        this.myNew = isNew;
        this.myMetaData = metaData;
        this.myDescriptorsConfiguration = descriptorsConfiguration;
        this.myDefaultParentDirectory = defaultParent;
        this.myDDOwner = ddOwner;
        if (addDefaultDescriptors) {
            this.addDefaultDescriptors();
        }
        for (ConfigFileInfo configuration : descriptorsConfiguration.getConfigFileInfos()) {
            this.myDescriptorInfos.add(DescriptorInfo.create(configuration));
        }
        this.onChange();
    }

    private void addDefaultDescriptors() {
        for (ConfigFileMetaData metaData : this.myMetaData) {
            if (metaData.isOptional()) continue;
            String url = this.myDDOwner.suggestDescriptorUrl(this.myDefaultParentDirectory, metaData, this.myDescriptorsConfiguration);
            this.myDescriptorInfos.add(DescriptorInfo.create(new ConfigFileInfo(metaData, url), metaData.getDefaultVersion()));
        }
    }

    public boolean isModified() {
        ArrayList<ConfigFileInfo> descriptors = new ArrayList<ConfigFileInfo>();
        for (DescriptorInfo descriptorInfo : this.myDescriptorInfos) {
            descriptorInfo.addToCollection(descriptors);
        }
        return !Arrays.asList(this.myDescriptorsConfiguration.getConfigFileInfos()).equals(descriptors);
    }

    public void applyChanges() {
        this.onChange();
        ArrayList<ConfigFileInfo> descriptors = new ArrayList<ConfigFileInfo>();
        for (DescriptorInfo descriptorInfo : this.myDescriptorInfos) {
            descriptorInfo.addToCollection(descriptors);
        }
        this.myDescriptorsConfiguration.setConfigFileInfos(descriptors);
    }

    private void onChange() {
        for (DescriptorInfo info : this.myDescriptorInfos) {
            if (info.getVersion() == null) continue;
            this.myDDOwner.addDescriptorFile(info.getUrl(), info.getMetaData(), info.getVersion());
        }
    }

    protected void refreshTableView() {
        this.myTableView.revalidate();
        this.myTableView.repaint();
    }

    public JComponent createComponent() {
        ColumnInfo[] columnInfos = new ColumnInfo[]{this.TITLE, this.PATH};
        ListTableModel listModel = new ListTableModel(columnInfos);
        listModel.setSortable(false);
        listModel.setItems(this.myDescriptorInfos);
        this.myTableView = new TableView(listModel);
        this.myTableView.setSelectionMode(0);
        this.myMainPanel = ToolbarDecorator.createDecorator(this.myTableView).setAddAction((AnActionButtonRunnable)new AddAnActionButtonRunnable((ListTableModel<DescriptorInfo>)listModel)).setRemoveAction((AnActionButtonRunnable)new RemoveAnActionButtonRunnable((ListTableModel<DescriptorInfo>)listModel)).setEditAction((AnActionButtonRunnable)new EditAnActionButtonRunnable((ListTableModel<DescriptorInfo>)listModel)).disableUpDownActions().createPanel();
        if (this.myDescriptorInfos.size() > 0) {
            TableUtil.selectRows(this.myTableView, (int[])new int[]{0});
        }
        return this.myMainPanel;
    }

    public ListTableModel<DescriptorInfo> getTableModel() {
        return (ListTableModel)this.myTableView.getModel();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTableView;
    }

    private Collection<String> getDefinedDescriptorPaths() {
        HashSet<String> result = new HashSet<String>();
        for (DescriptorInfo descriptorInfo : this.myDescriptorInfos) {
            result.add(VfsUtilCore.urlToPath((String)descriptorInfo.getUrl()));
            ConfigFileMetaData metaData = descriptorInfo.getMetaData();
            if (metaData == null) continue;
            result.add(ConfigFilesEditor.getDefaultPath(metaData));
        }
        return result;
    }

    private static String getDefaultPath(ConfigFileMetaData metaData) {
        return metaData.getDirectoryPath() + "/" + metaData.getFileName();
    }

    private List<String> getExistingFilePaths(String fileName) {
        ArrayList<String> result = new ArrayList<String>();
        for (File f : DeploymentDescriptorUtil.findFileRecursively(this.myDefaultParentDirectory, fileName, 10, 3000L).findAll()) {
            VirtualFile virtualDir = LocalFileSystem.getInstance().findFileByIoFile(f.getParentFile());
            if (virtualDir == null || !this.myDDOwner.canBeParentForDescriptors(virtualDir)) continue;
            result.add(FileUtil.toSystemIndependentName((String)f.getAbsolutePath()));
        }
        return result;
    }

    @Nullable
    private DescriptorInfo getSelectedItem() {
        int index = this.myTableView.getSelectionModel().getMinSelectionIndex();
        if (index < 0 || index >= this.myDescriptorInfos.size()) {
            return null;
        }
        return this.myDescriptorInfos.get(index);
    }

    protected void addDeploymentDescriptorInfo(@NotNull ConfigFileMetaData metaData, ListTableModel<DescriptorInfo> listModel, String path, ConfigFileVersion version) {
        if (metaData == null) {
            ConfigFilesEditor.$$$reportNull$$$0(0);
        }
        String url = VfsUtilCore.pathToUrl((String)path);
        DescriptorInfo newInfo = DescriptorInfo.create(new ConfigFileInfo(metaData, url), version);
        this.myDescriptorInfos.add(newInfo);
        listModel.setItems(this.myDescriptorInfos);
        this.refreshTableView();
        int lastElement = this.myDescriptorInfos.size() - 1;
        this.myTableView.getSelectionModel().addSelectionInterval(lastElement, lastElement);
        this.onChange();
    }

    protected boolean containsDescriptor(ConfigFileMetaData metaData) {
        for (DescriptorInfo info : this.myDescriptorInfos) {
            if (!metaData.equals(info.getMetaData())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/javaee/ui/ConfigFilesEditor", "addDeploymentDescriptorInfo"));
    }

    private class PathCellRenderer
    extends ColoredTableCellRenderer {
        private PathCellRenderer() {
        }

        protected SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes) {
            return attributes;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            String path = (String)value;
            SimpleTextAttributes attributes = !ConfigFilesEditor.this.myNew && !ConfigFilesEditor.this.myDDOwner.willCreateFile(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)path))) && !new File(path).exists() ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            this.append(path, attributes);
            this.setToolTipText(path);
        }
    }

    private class RemoveAnActionButtonRunnable
    implements AnActionButtonRunnable {
        private final ListTableModel<DescriptorInfo> myListModel;

        public RemoveAnActionButtonRunnable(ListTableModel<DescriptorInfo> listModel) {
            this.myListModel = listModel;
        }

        public void run(AnActionButton button) {
            DescriptorInfo selectedItem = ConfigFilesEditor.this.getSelectedItem();
            if (selectedItem != null) {
                boolean deleteFromDisk = false;
                ConfigFileMetaData metaData = selectedItem.getMetaData();
                if (!ConfigFilesEditor.this.myNew) {
                    DeleteDeploymentDescriptorDialog dialog = new DeleteDeploymentDescriptorDialog(ConfigFilesEditor.this.myMainPanel, metaData != null);
                    dialog.show();
                    if (dialog.getExitCode() != 0) {
                        return;
                    }
                    deleteFromDisk = dialog.isDeleteFromDiskSelected();
                }
                int index = ConfigFilesEditor.this.myDescriptorInfos.indexOf(selectedItem);
                ConfigFilesEditor.this.myDescriptorInfos.remove(selectedItem);
                int updated = this.myListModel.indexOf((Object)selectedItem);
                this.myListModel.fireTableRowsUpdated(updated, updated);
                this.myListModel.setItems(ConfigFilesEditor.this.myDescriptorInfos);
                ConfigFilesEditor.this.refreshTableView();
                if (metaData != null) {
                    ConfigFilesEditor.this.myDDOwner.clear(metaData);
                }
                if (deleteFromDisk) {
                    ConfigFilesEditor.this.myDDOwner.deleteDescriptorFile(selectedItem.getUrl());
                }
                if (index >= ConfigFilesEditor.this.myDescriptorInfos.size()) {
                    index = ConfigFilesEditor.this.myDescriptorInfos.size() - 1;
                }
                ConfigFilesEditor.this.myTableView.getSelectionModel().addSelectionInterval(index, index);
                ConfigFilesEditor.this.onChange();
            }
        }
    }

    private class EditAnActionButtonRunnable
    implements AnActionButtonRunnable {
        private final ListTableModel<DescriptorInfo> myListModel;

        public EditAnActionButtonRunnable(ListTableModel<DescriptorInfo> listModel) {
            this.myListModel = listModel;
        }

        public void run(AnActionButton button) {
            DescriptorInfo selectedItem = ConfigFilesEditor.this.getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            ConfigFileMetaData metaData = selectedItem.getMetaData();
            String path = VfsUtilCore.urlToPath((String)selectedItem.getUrl());
            Collection existingPaths = ConfigFilesEditor.this.getDefinedDescriptorPaths();
            existingPaths.remove(path);
            List<String> deploymentDescriptors = new ArrayList();
            if (metaData != null) {
                deploymentDescriptors = ConfigFilesEditor.this.getExistingFilePaths(metaData.getFileName());
                deploymentDescriptors.remove(path);
                deploymentDescriptors.add(0, path);
                existingPaths.remove(ConfigFilesEditor.getDefaultPath(selectedItem.getMetaData()));
            }
            DeploymentDescriptorEditDialog dialog = new DeploymentDescriptorEditDialog(ConfigFilesEditor.this.myMainPanel, ConfigFilesEditor.this.myDDOwner.getModule(), metaData, selectedItem.getVersion(), deploymentDescriptors, existingPaths, path);
            if (metaData == null) {
                dialog.setOutputDirectory(selectedItem.getOutputDirectory());
            }
            if (dialog.showAndGet()) {
                selectedItem.setUrlAndDirectory(VfsUtilCore.pathToUrl((String)dialog.getPath()), dialog.getOutputDirectory());
                selectedItem.setVersion(dialog.getVersion());
                this.myListModel.setItems(ConfigFilesEditor.this.myDescriptorInfos);
                int updated = this.myListModel.indexOf((Object)selectedItem);
                this.myListModel.fireTableRowsUpdated(updated, updated);
                ConfigFilesEditor.this.refreshTableView();
            }
            int index = ConfigFilesEditor.this.myDescriptorInfos.indexOf(selectedItem);
            ConfigFilesEditor.this.myTableView.getSelectionModel().setSelectionInterval(index, index);
            ConfigFilesEditor.this.onChange();
        }
    }

    private class AddAnActionButtonRunnable
    implements AnActionButtonRunnable {
        private final ListTableModel<DescriptorInfo> myListModel;
        private PopupAction[] myPopupActions;
        private Icon[] myIcons;

        public AddAnActionButtonRunnable(ListTableModel<DescriptorInfo> listModel) {
            this.myListModel = listModel;
        }

        private void initPopupActions() {
            if (this.myPopupActions == null) {
                ArrayList<PopupAction> popupActions = new ArrayList<PopupAction>();
                for (int i = 0; i < ConfigFilesEditor.this.myMetaData.length; ++i) {
                    popupActions.add(this.createPopupAction(ConfigFilesEditor.this.myMetaData[i], i));
                }
                this.myPopupActions = popupActions.toArray(new PopupAction[0]);
                this.myIcons = new Icon[this.myPopupActions.length];
                for (int idx = 0; idx < this.myPopupActions.length; ++idx) {
                    this.myIcons[idx] = this.myPopupActions[idx].getIcon();
                }
            }
        }

        private PopupAction createPopupAction(final @NotNull ConfigFileMetaData metaData, int index) {
            if (metaData == null) {
                AddAnActionButtonRunnable.$$$reportNull$$$0(0);
            }
            String title = metaData.getFileName();
            String extension = title.substring(title.lastIndexOf(46) + 1);
            FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(extension);
            return new PopupAction(title, fileType.getIcon(), index + 1){

                @Override
                public void executeImpl() {
                    DeploymentDescriptorEditDialog dialog;
                    Collection existingPaths = ConfigFilesEditor.this.getDefinedDescriptorPaths();
                    List deploymentDescriptors = ConfigFilesEditor.this.getExistingFilePaths(metaData.getFileName());
                    if (deploymentDescriptors.isEmpty()) {
                        File defaultFile = new File(new File(ConfigFilesEditor.this.myDefaultParentDirectory, metaData.getDirectoryPath()), metaData.getFileName());
                        deploymentDescriptors.add(FileUtil.toSystemIndependentName((String)defaultFile.getAbsolutePath()));
                    }
                    if ((dialog = new DeploymentDescriptorEditDialog(ConfigFilesEditor.this.myMainPanel, ConfigFilesEditor.this.myDDOwner.getModule(), metaData, metaData.getDefaultVersion(), deploymentDescriptors, existingPaths, null)).showAndGet()) {
                        ConfigFilesEditor.this.addDeploymentDescriptorInfo(metaData, (ListTableModel<DescriptorInfo>)AddAnActionButtonRunnable.this.myListModel, dialog.getPath(), dialog.getVersion());
                    }
                }

                @Override
                public boolean isSelectable() {
                    return !ConfigFilesEditor.this.containsDescriptor(metaData) || !metaData.isUnique();
                }
            };
        }

        public void run(AnActionButton button) {
            this.initPopupActions();
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PopupAction>(null, this.myPopupActions, this.myIcons){

                public boolean isMnemonicsNavigationEnabled() {
                    return true;
                }

                public boolean isSelectable(PopupAction value) {
                    return value.isSelectable();
                }

                public PopupStep onChosen(PopupAction selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> selectedValue.execute());
                }

                @NotNull
                public String getTextFor(PopupAction value) {
                    String string = "&" + value.getIndex() + "  " + value.getTitle();
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ui/ConfigFilesEditor$AddAnActionButtonRunnable$2", "getTextFor"));
                }
            });
            popup.show(button.getPreferredPopupPoint());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/javaee/ui/ConfigFilesEditor$AddAnActionButtonRunnable", "createPopupAction"));
        }
    }

    private static abstract class PopupAction
    implements ActionListener {
        private final String myTitle;
        private final Icon myIcon;
        private final int myIndex;

        protected PopupAction(String title, Icon icon, int index) {
            this.myTitle = title;
            this.myIcon = icon;
            this.myIndex = index;
        }

        public String getTitle() {
            return this.myTitle;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public boolean isSelectable() {
            return true;
        }

        protected void executeImpl() {
        }

        public void execute() {
            this.executeImpl();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.executeImpl();
        }
    }
}

