/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class JpaImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final List<String> INJECTION_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"javax.persistence.PersistenceContext", "javax.persistence.PersistenceUnit", "javax.persistence.GeneratedValue"});
    private static final List<String> LISTENER_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"javax.persistence.PostLoad", "javax.persistence.PostPersist", "javax.persistence.PostRemove", "javax.persistence.PostUpdate", "javax.persistence.PrePersist", "javax.persistence.PreRemove", "javax.persistence.PreUpdate"});

    public boolean isImplicitUsage(PsiElement element) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) && JpaImplicitUsageProvider.isAnnotated(element, INJECTION_ANNOTATIONS)) {
                return true;
            }
            if (JpaImplicitUsageProvider.isAnnotated((PsiElement)method, LISTENER_ANNOTATIONS)) {
                return true;
            }
            if (method.isConstructor()) {
                if (method.getParameterList().getParametersCount() == 0 && JpaUtil.hasRoles(method.getContainingClass())) {
                    return true;
                }
            } else if (PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method)) {
                PsiMethod getter = PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) ? PropertyUtilBase.findPropertyGetter((PsiClass)method.getContainingClass(), (String)PropertyUtilBase.getPropertyName((PsiMethod)method), (boolean)false, (boolean)true) : method;
                return !PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes((PsiMember)getter).isEmpty();
            }
        } else if (element instanceof PsiParameter) {
            PsiElement scope = ((PsiParameter)element).getDeclarationScope();
            return scope instanceof PsiMethod && JpaImplicitUsageProvider.isAnnotated(scope, LISTENER_ANNOTATIONS);
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return JpaImplicitUsageProvider.isAnnotated(element, INJECTION_ANNOTATIONS);
    }

    private static boolean isAnnotated(PsiElement owner, List<String> annos) {
        return owner instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)owner), annos, (int)0);
    }
}

