/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.model.annotations.mapping.AttributeReferenceSet;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.jpa.model.annotations.mapping.JamAttributeConverter;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaAttributeReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider,
LocalQuickFixProvider {
    protected static final Logger LOG = Logger.getInstance(JpaAttributeReference.class);
    private final AttributeReferenceSet myReferenceSet;
    private final int myIndex;

    public JpaAttributeReference(AttributeReferenceSet referenceSet, int index, TextRange range) {
        super(referenceSet.getElement(), range, referenceSet.isSoft());
        this.myReferenceSet = referenceSet;
        this.myIndex = index;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = JpaMessages.message((String)"cannot.resolve.attribute.0", (Object[])new Object[0]);
        if (string == null) {
            JpaAttributeReference.$$$reportNull$$$0(0);
        }
        return string;
    }

    public AttributeReferenceSet getReferenceSet() {
        return this.myReferenceSet;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public JamAttributeConverter getConverter() {
        return this.myReferenceSet.getConverter();
    }

    public LocalQuickFix[] getQuickFixes() {
        return LocalQuickFix.EMPTY_ARRAY;
    }

    public PsiElement resolve() {
        PersistentAttribute attribute = this.resolveAttribute();
        return attribute == null ? null : attribute.getIdentifyingPsiElement();
    }

    @NotNull
    public Object[] getVariants() {
        final ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        this.processTargetAttributes(new AttrProcessor(){

            @Override
            public boolean process(PersistentAttribute attribute, PersistentAttributeType.AttributeComponent component, PsiType psiType) {
                result.add(JpaAttributeReference.createLookupElementFor(attribute, component, psiType));
                return true;
            }
        }, false);
        this.addCustomVariants(result);
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            JpaAttributeReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    protected void addCustomVariants(List<LookupElement> result) {
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JpaAttributeReference.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiMember) {
            String newName = PropertyUtilBase.getPropertyName((PsiMember)((PsiMember)element));
            if (newName == null) {
                LOG.error("new name is null for: " + element.getClass() + "/" + ((PsiMember)element).getName());
                return this.getElement();
            }
            TextRange range = new TextRange(((JpaAttributeReference)this.getReferenceSet().getReference(0)).getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset());
            ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.getElement());
            return manipulator.handleContentChange(this.getElement(), range, newName);
        }
        throw new IncorrectOperationException("cannot bind to element: " + element.getClass().getName());
    }

    @Nullable
    public PersistentAttribute resolveAttribute() {
        PersistentAttribute attribute;
        Pair<PersistentAttribute, PersistentAttributeType.AttributeComponent> pair = this.resolveAttributeInner();
        PersistentAttribute persistentAttribute = attribute = pair == null ? null : (PersistentAttribute)pair.first;
        if (!(attribute == null || this.getReferenceSet().getLastReference() != this || pair.second == null && this.getConverter().acceptsAttribute(attribute, this.getThisAttr(), true))) {
            return null;
        }
        return attribute;
    }

    private Pair<PersistentAttribute, PersistentAttributeType.AttributeComponent> resolveAttributeInner() {
        final String s = this.getValue();
        final Ref resultRef = Ref.create(null);
        this.processTargetAttributes(new AttrProcessor(){

            @Override
            public boolean process(PersistentAttribute attribute, PersistentAttributeType.AttributeComponent component, PsiType psiType) {
                String attrName;
                String string = attrName = component != null ? JpaAttributeReference.getComponentName(component) : (String)attribute.getName().getValue();
                if (JpaAttributeReference.this.areAttributeNamesEqual(attrName, s)) {
                    resultRef.set((Object)Pair.create((Object)attribute, (Object)component));
                    return false;
                }
                return true;
            }
        }, true);
        return (Pair)resultRef.get();
    }

    protected boolean areAttributeNamesEqual(String attrName, String refName) {
        return Comparing.equal((String)attrName, (String)refName);
    }

    @Nullable
    private PersistentAttribute getThisAttr() {
        return JpaAttributeReference.getAttribute(ORMReferencesUtil.getTargetMember(this.getElement(), false));
    }

    protected PersistenceModelBrowser createBrowser() {
        return PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)ORMReferencesUtil.getTargetMember(this.getElement(), true));
    }

    private void processTargetAttributes(AttrProcessor processor, boolean resolve) {
        if (this.myIndex == 0) {
            this.processEmptyContext(this.createBrowser(), processor, resolve);
        } else {
            Pair<PersistentAttribute, PersistentAttributeType.AttributeComponent> pair = ((JpaAttributeReference)this.getReferenceSet().getReference(this.myIndex - 1)).resolveAttributeInner();
            if (pair != null) {
                JpaAttributeReference.processTargetAttributes((PersistentAttribute)pair.first, (PersistentAttributeType.AttributeComponent)pair.second, this.createBrowser(), processor, false, this.getConverter().traverseCollection());
            }
        }
    }

    protected void processEmptyContext(PersistenceModelBrowser browser, AttrProcessor processor, boolean resolve) {
        PersistentAttribute thisAttr = this.getThisAttr();
        if (thisAttr != null) {
            JpaAttributeReference.processTargetAttributes(thisAttr, null, browser, processor, true, this.getConverter().traverseCollection());
        } else {
            JpaAttributeReference.processClassAttributes(ORMReferencesUtil.getTargetClass(this.getElement()), browser, processor);
        }
    }

    protected static void processClassAttributes(PsiClass psiClass, PersistenceModelBrowser browser, AttrProcessor processor) {
        if (psiClass == null) {
            return;
        }
        for (PersistentObject object : browser.queryPersistentObjects(psiClass)) {
            for (PersistentAttribute attribute : browser.queryAttributes(object)) {
                if (attribute instanceof PersistentTransientAttribute || processor.process(attribute, null, null)) continue;
                return;
            }
        }
    }

    private static void processTargetAttributes(PersistentAttribute thisAttr, PersistentAttributeType.AttributeComponent component, PersistenceModelBrowser browser, AttrProcessor processor, boolean emptyContext, boolean traverseCollection) {
        JavaTypeInfo typeInfo = JpaUtil.getSubstitutedTypeInfo(thisAttr, browser, component == PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY);
        if (typeInfo == null) {
            return;
        }
        if (JavaContainerType.isCollectionOrMap((JavaContainerType)typeInfo.containerType)) {
            if (traverseCollection) {
                if (typeInfo.containerType == JavaContainerType.MAP && component == null) {
                    if (!processor.process(thisAttr, PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, typeInfo.getValueType())) {
                        return;
                    }
                    if (!processor.process(thisAttr, PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY, typeInfo.getKeyType())) {
                        return;
                    }
                }
            } else if (!emptyContext) {
                return;
            }
        }
        PsiType type = component == PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY ? typeInfo.getKeyType() : typeInfo.getValueType();
        Query query = browser.queryPersistentObjects(PsiTypesUtil.getPsiClass((PsiType)type));
        for (PersistentObject persistentObject : query.findAll()) {
            for (PersistentAttribute attribute : browser.queryAttributes(persistentObject)) {
                if (attribute instanceof PersistentTransientAttribute || processor.process(attribute, null, null)) continue;
                return;
            }
        }
    }

    @Nullable
    public static PersistentAttribute getAttribute(PsiMember member) {
        if (member == null) {
            return null;
        }
        for (JamMemberMeta meta : AttributeType.getAllJamMetas()) {
            JamAttributeBase attr = (JamAttributeBase)meta.getJamElement((PsiModifierListOwner)member);
            if (!(attr instanceof PersistentRelationshipAttribute) && !(attr instanceof PersistentEmbeddedAttribute)) continue;
            return attr;
        }
        return null;
    }

    private static LookupElement createLookupElementFor(@NotNull PersistentAttribute target, PersistentAttributeType.AttributeComponent component, PsiType componentType) {
        if (target == null) {
            JpaAttributeReference.$$$reportNull$$$0(3);
        }
        String name = component != null ? JpaAttributeReference.getComponentName(component) : (String)target.getName().getValue();
        LookupElementBuilder builder = LookupElementBuilder.create((String)StringUtil.notNullize((String)name));
        if (component != null) {
            builder = builder.bold();
            if (componentType != null) {
                builder = builder.withTypeText(componentType.getPresentableText());
            }
        } else {
            builder = builder.withIcon(ElementPresentationManager.getIcon((Object)target));
            PsiType psiType = target.getPsiType();
            if (psiType != null) {
                builder = builder.withTypeText(psiType.getPresentableText());
            }
        }
        return builder;
    }

    private static String getComponentName(PersistentAttributeType.AttributeComponent component) {
        switch (component) {
            case COLLECTION_VALUE: {
                return "value";
            }
            case COLLECTION_VALUE_KEY: {
                return "key";
            }
        }
        throw new AssertionError(component);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/model/annotations/mapping/JpaAttributeReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/model/annotations/mapping/JpaAttributeReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElementFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MappedByIdReference
    extends JpaAttributeReference {
        public MappedByIdReference(AttributeReferenceSet referenceSet, int index, TextRange range) {
            super(referenceSet, index, range);
        }

        @Override
        protected void processEmptyContext(PersistenceModelBrowser browser, AttrProcessor processor, boolean resolve) {
            PsiMember psiMember = ORMReferencesUtil.getTargetMember(this.getElement(), false);
            if (psiMember == null) {
                return;
            }
            PsiClass psiClass = psiMember.getContainingClass();
            for (PersistentObject object : browser.queryPersistentObjects(psiClass)) {
                for (PersistentAttribute attribute : browser.queryAttributes(object)) {
                    if (attribute instanceof PersistentRelationshipAttribute || !attribute.getAttributeModelHelper().isIdAttribute()) continue;
                    if (attribute instanceof PersistentEmbeddedAttribute) {
                        PsiClass embeddableClass = (PsiClass)((PersistentEmbeddedAttribute)attribute).getTargetEmbeddableClass().getValue();
                        for (PersistentObject embeddable : browser.queryPersistentObjects(embeddableClass, PersistenceClassRoleEnum.EMBEDDABLE)) {
                            for (PersistentAttribute attr : browser.queryAttributes(embeddable).findAll()) {
                                if (processor.process(attr, null, null)) continue;
                                return;
                            }
                        }
                        continue;
                    }
                    if (processor.process(attribute, null, null)) continue;
                    return;
                }
            }
        }
    }

    protected static interface AttrProcessor {
        public boolean process(PersistentAttribute var1, PersistentAttributeType.AttributeComponent var2, PsiType var3);
    }
}

