/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.AsyncCompletion;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionPreselectionBehaviourProvider;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionThreadingBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.DefaultCompletionContributor;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.StatisticsUpdate;
import com.intellij.codeInsight.completion.SyncCompletion;
import com.intellij.codeInsight.completion.WeighingDelegate;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class CompletionProgressIndicator
extends ProgressIndicatorBase
implements CompletionProcess,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CompletionProgressIndicator");
    private final Editor myEditor;
    @NotNull
    private final Caret myCaret;
    @Nullable
    private CompletionParameters myParameters;
    private final CodeCompletionHandlerBase myHandler;
    private final CompletionLookupArranger myArranger;
    private final CompletionType myCompletionType;
    private final int myInvocationCount;
    private OffsetsInFile myHostOffsets;
    private final LookupImpl myLookup;
    private final Alarm mySuppressTimeoutAlarm;
    private final MergingUpdateQueue myQueue;
    private final Update myUpdate;
    private final Semaphore myFreezeSemaphore;
    private final Semaphore myFinishSemaphore;
    private final OffsetMap myOffsetMap;
    private final Set<Pair<Integer, ElementPattern<String>>> myRestartingPrefixConditions;
    private final LookupAdapter myLookupListener;
    private volatile boolean myIsUpdateSuppressed;
    private static int ourInsertSingleItemTimeSpan = 300;
    private static int ourShowPopupGroupingTime = 300;
    private static int ourShowPopupAfterFirstItemGroupingTime = 100;
    private volatile int myCount;
    private volatile boolean myHasPsiElements;
    private boolean myLookupUpdated;
    private final PropertyChangeListener myLookupManagerListener;
    private final Queue<Runnable> myAdvertiserChanges;
    private final List<CompletionResult> myDelayedMiddleMatches;
    private final int myStartCaret;
    private final CompletionThreadingBase myThreading;

    CompletionProgressIndicator(Editor editor, @NotNull Caret caret, int invocationCount, CodeCompletionHandlerBase handler2, OffsetMap offsetMap, OffsetsInFile hostOffsets, boolean hasModifiers, LookupImpl lookup) {
        if (caret == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(0);
        }
        this.mySuppressTimeoutAlarm = new Alarm((Disposable)this);
        this.myUpdate = new Update("update"){

            public void run() {
                CompletionProgressIndicator.this.updateLookup(CompletionProgressIndicator.this.myIsUpdateSuppressed);
                CompletionProgressIndicator.this.myQueue.setMergingTimeSpan(ourShowPopupGroupingTime);
            }
        };
        this.myFreezeSemaphore = new Semaphore(1);
        this.myFinishSemaphore = new Semaphore(1);
        this.myRestartingPrefixConditions = ContainerUtil.newConcurrentSet();
        this.myLookupListener = new LookupAdapter(){

            @Override
            public void lookupCanceled(LookupEvent event) {
                CompletionProgressIndicator.this.finishCompletionProcess(true);
            }
        };
        this.myIsUpdateSuppressed = false;
        this.myAdvertiserChanges = new ConcurrentLinkedQueue<Runnable>();
        this.myDelayedMiddleMatches = ContainerUtil.newArrayList();
        this.myEditor = editor;
        this.myCaret = caret;
        this.myHandler = handler2;
        this.myCompletionType = handler2.completionType;
        this.myInvocationCount = invocationCount;
        this.myOffsetMap = offsetMap;
        this.myHostOffsets = hostOffsets;
        this.myLookup = lookup;
        this.myStartCaret = this.myEditor.getCaretModel().getOffset();
        this.myThreading = ApplicationManager.getApplication().isWriteAccessAllowed() ? new SyncCompletion() : new AsyncCompletion();
        this.myAdvertiserChanges.offer(() -> this.myLookup.getAdvertiser().clearAdvertisements());
        this.myArranger = new CompletionLookupArranger(this);
        this.myLookup.setArranger(this.myArranger);
        this.myLookup.addLookupListener(this.myLookupListener);
        this.myLookup.setCalculating(true);
        this.myLookupManagerListener = evt -> {
            if (evt.getNewValue() != null) {
                LOG.error("An attempt to change the lookup during completion, phase = " + CompletionServiceImpl.getCompletionPhase());
            }
        };
        LookupManager.getInstance(this.getProject()).addPropertyChangeListener(this.myLookupManagerListener);
        this.myQueue = new MergingUpdateQueue("completion lookup progress", ourShowPopupAfterFirstItemGroupingTime, true, this.myEditor.getContentComponent());
        this.myQueue.setPassThrough(false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (hasModifiers && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.trackModifiers();
        }
    }

    private CompletionParameters createCompletionParameters(OffsetsInFile offsets) {
        int offset = offsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        PsiFile fileCopy = offsets.getFile();
        PsiFile originalFile = fileCopy.getOriginalFile();
        PsiElement insertedElement = CompletionProgressIndicator.findCompletionPositionLeaf(offsets, offset, originalFile);
        insertedElement.putUserData(CompletionContext.COMPLETION_CONTEXT_KEY, (Object)new CompletionContext(fileCopy, offsets.getOffsets()));
        return new CompletionParameters(insertedElement, originalFile, this.myCompletionType, offset, this.myInvocationCount, this.myEditor, (CompletionProcess)this);
    }

    @NotNull
    private static PsiElement findCompletionPositionLeaf(OffsetsInFile offsets, int offset, PsiFile originalFile) {
        PsiElement insertedElement = offsets.getFile().findElementAt(offset);
        CompletionAssertions.assertCompletionPositionPsiConsistent(offsets, offset, originalFile, insertedElement);
        PsiElement psiElement = insertedElement;
        if (psiElement == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
        boolean dispose2 = lookupItem == null;
        this.finishCompletionProcess(dispose2);
        if (dispose2) {
            return;
        }
        this.setMergeCommand();
        this.myHandler.lookupItemSelected(this, lookupItem, completionChar, this.myLookup.getItems());
    }

    OffsetMap getOffsetMap() {
        return this.myOffsetMap;
    }

    OffsetsInFile getHostOffsets() {
        return this.myHostOffsets;
    }

    void duringCompletion(CompletionInitializationContext initContext, CompletionParameters parameters) {
        if (this.isAutopopupCompletion() && CompletionProgressIndicator.shouldPreselectFirstSuggestion(parameters)) {
            this.myLookup.setFocusDegree(CodeInsightSettings.getInstance().SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS ? LookupImpl.FocusDegree.FOCUSED : LookupImpl.FocusDegree.SEMI_FOCUSED);
        }
        this.addDefaultAdvertisements(parameters);
        ProgressManager.checkCanceled();
        Document document = initContext.getEditor().getDocument();
        if (!initContext.getOffsetMap().wasModified(CompletionInitializationContext.IDENTIFIER_END_OFFSET)) {
            try {
                int selectionEndOffset = initContext.getSelectionEndOffset();
                PsiReference reference = TargetElementUtil.findReference(this.myEditor, selectionEndOffset);
                if (reference != null) {
                    int replacementOffset = CompletionProgressIndicator.findReplacementOffset(selectionEndOffset, reference);
                    if (replacementOffset > document.getTextLength()) {
                        LOG.error("Invalid replacementOffset: " + replacementOffset + " returned by reference " + reference + " of " + reference.getClass() + "; doc=" + document + "; doc actual=" + (document == initContext.getFile().getViewProvider().getDocument()) + "; doc committed=" + PsiDocumentManager.getInstance((Project)this.getProject()).isCommitted(document));
                    } else {
                        initContext.setReplacementOffset(replacementOffset);
                    }
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        for (CompletionContributor contributor : CompletionContributor.forLanguageHonorDumbness((Language)initContext.getPositionLanguage(), (Project)initContext.getProject())) {
            ProgressManager.checkCanceled();
            contributor.duringCompletion(initContext);
        }
        if (document instanceof DocumentWindow) {
            this.myHostOffsets = new OffsetsInFile(initContext.getFile(), initContext.getOffsetMap()).toTopLevelFile();
        }
    }

    private void addDefaultAdvertisements(CompletionParameters parameters) {
        if (DumbService.isDumb((Project)this.getProject())) {
            this.addAdvertisement("The results might be incomplete while indexing is in progress", MessageType.WARNING.getPopupBackground());
            return;
        }
        this.advertiseTabReplacement(parameters);
        if (this.isAutopopupCompletion()) {
            if (CompletionProgressIndicator.shouldPreselectFirstSuggestion(parameters) && !CodeInsightSettings.getInstance().SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS) {
                this.advertiseCtrlDot();
            }
            this.advertiseCtrlArrows();
        }
    }

    private void advertiseTabReplacement(CompletionParameters parameters) {
        String shortcut;
        if (CompletionUtil.shouldShowFeature(parameters, "editing.completion.replace") && this.myOffsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != this.myOffsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET) && StringUtil.isNotEmpty((String)(shortcut = CompletionContributor.getActionShortcut((String)"EditorChooseLookupItemReplace")))) {
            this.addAdvertisement("Use " + shortcut + " to overwrite the current identifier with the chosen variant", null);
        }
    }

    private void advertiseCtrlDot() {
        String dotShortcut;
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.finishByCtrlDot", this.getProject()) && StringUtil.isNotEmpty((String)(dotShortcut = CompletionContributor.getActionShortcut((String)"EditorChooseLookupItemDot")))) {
            this.addAdvertisement("Press " + dotShortcut + " to choose the selected (or first) suggestion and insert a dot afterwards", null);
        }
    }

    private void advertiseCtrlArrows() {
        if (!this.myEditor.isOneLineMode() && FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.cancelByControlArrows", this.getProject())) {
            String downShortcut = CompletionContributor.getActionShortcut((String)"EditorLookupDown");
            String upShortcut = CompletionContributor.getActionShortcut((String)"EditorLookupUp");
            if (StringUtil.isNotEmpty((String)downShortcut) && StringUtil.isNotEmpty((String)upShortcut)) {
                this.addAdvertisement(downShortcut + " and " + upShortcut + " will move caret down and up in the editor", null);
            }
        }
    }

    public void dispose() {
    }

    private static int findReplacementOffset(int selectionEndOffset, PsiReference reference) {
        List ranges = ReferenceRange.getAbsoluteRanges((PsiReference)reference);
        for (TextRange range2 : ranges) {
            if (!range2.contains(selectionEndOffset)) continue;
            return range2.getEndOffset();
        }
        return selectionEndOffset;
    }

    void scheduleAdvertising(CompletionParameters parameters) {
        if (this.myLookup.isAvailableToUser()) {
            return;
        }
        for (CompletionContributor contributor : CompletionContributor.forParameters((CompletionParameters)parameters)) {
            if (!this.myLookup.isCalculating() && !this.myLookup.isVisible()) {
                return;
            }
            String s = contributor.advertise(parameters);
            if (s == null) continue;
            this.addAdvertisement(s, null);
        }
    }

    private boolean isOutdated() {
        return CompletionServiceImpl.getCompletionPhase().indicator != this;
    }

    private void trackModifiers() {
        assert (!this.isAutopopupCompletion());
        JComponent contentComponent = this.myEditor.getContentComponent();
        contentComponent.addKeyListener(new ModifierTracker(contentComponent));
    }

    void setMergeCommand() {
        CommandProcessor.getInstance().setCurrentCommandGroupId((Object)this.getCompletionCommandName());
    }

    private String getCompletionCommandName() {
        return "Completion" + this.hashCode();
    }

    void showLookup() {
        this.updateLookup(this.myIsUpdateSuppressed);
    }

    @Nullable
    public CompletionParameters getParameters() {
        return this.myParameters;
    }

    public LookupImpl getLookup() {
        return this.myLookup;
    }

    void withSingleUpdate(Runnable action) {
        try {
            this.myIsUpdateSuppressed = true;
            action.run();
        }
        finally {
            this.myIsUpdateSuppressed = false;
            this.myQueue.queue(this.myUpdate);
        }
    }

    private void updateLookup(boolean isUpdateSuppressed) {
        Runnable action;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isOutdated() || !this.shouldShowLookup() || isUpdateSuppressed) {
            return;
        }
        while ((action = this.myAdvertiserChanges.poll()) != null) {
            action.run();
        }
        if (!this.myLookupUpdated) {
            if (this.myLookup.getAdvertisements().isEmpty() && !this.isAutopopupCompletion() && !DumbService.isDumb((Project)this.getProject())) {
                DefaultCompletionContributor.addDefaultAdvertisements(this.myLookup, this.myHasPsiElements);
            }
            this.myLookup.getAdvertiser().showRandomText();
        }
        boolean justShown = false;
        if (!this.myLookup.isShown()) {
            if (this.hideAutopopupIfMeaningless()) {
                return;
            }
            if (Registry.is((String)"dump.threads.on.empty.lookup") && this.myLookup.isCalculating() && this.myLookup.getItems().isEmpty()) {
                PerformanceWatcher.getInstance().dumpThreads("emptyLookup/", true);
            }
            if (!this.myLookup.showLookup()) {
                return;
            }
            justShown = true;
        }
        this.myLookupUpdated = true;
        this.myLookup.refreshUi(true, justShown);
        this.hideAutopopupIfMeaningless();
        if (justShown) {
            this.myLookup.ensureSelectionVisible(true);
        }
    }

    private boolean shouldShowLookup() {
        if (this.isAutopopupCompletion()) {
            if (this.myCount == 0) {
                return false;
            }
            if (this.myLookup.isCalculating() && Registry.is((String)"ide.completion.delay.autopopup.until.completed")) {
                return false;
            }
        }
        return true;
    }

    int getIdentifierEndOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addItem(CompletionResult item) {
        boolean allowMiddleMatches;
        if (!this.isRunning()) {
            return;
        }
        ProgressManager.checkCanceled();
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!unitTestMode) {
            LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        }
        LookupElement lookupElement = item.getLookupElement();
        if (!this.myHasPsiElements && lookupElement.getPsiElement() != null) {
            this.myHasPsiElements = true;
        }
        boolean bl = allowMiddleMatches = this.myCount > 10;
        if (allowMiddleMatches) {
            this.addDelayedMiddleMatches();
        }
        this.myArranger.associateSorter(lookupElement, (CompletionSorterImpl)item.getSorter());
        if (item.isStartMatch() || allowMiddleMatches) {
            this.addItemToLookup(item);
        } else {
            List<CompletionResult> list2 = this.myDelayedMiddleMatches;
            synchronized (list2) {
                this.myDelayedMiddleMatches.add(item);
            }
        }
    }

    private void addItemToLookup(CompletionResult item) {
        if (!this.myLookup.addItem(item.getLookupElement(), item.getPrefixMatcher())) {
            return;
        }
        ++this.myCount;
        if (this.myCount == 1) {
            JobScheduler.getScheduler().schedule(() -> ((Semaphore)this.myFreezeSemaphore).up(), (long)ourInsertSingleItemTimeSpan, TimeUnit.MILLISECONDS);
        }
        this.myQueue.queue(this.myUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDelayedMiddleMatches() {
        ArrayList delayed;
        List<CompletionResult> list2 = this.myDelayedMiddleMatches;
        synchronized (list2) {
            if (this.myDelayedMiddleMatches.isEmpty()) {
                return;
            }
            delayed = ContainerUtil.newArrayList(this.myDelayedMiddleMatches);
            this.myDelayedMiddleMatches.clear();
        }
        for (CompletionResult item : delayed) {
            ProgressManager.checkCanceled();
            this.addItemToLookup(item);
        }
    }

    public void closeAndFinish(boolean hideLookup) {
        if (!this.myLookup.isLookupDisposed()) {
            LookupEx lookup = LookupManager.getActiveLookup(this.myEditor);
            LOG.assertTrue(lookup == this.myLookup, (Object)("lookup changed: " + lookup + "; " + this));
        }
        this.myLookup.removeLookupListener(this.myLookupListener);
        this.finishCompletionProcess(true);
        CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        if (hideLookup) {
            this.myLookup.hideLookup(true);
        }
    }

    private void finishCompletionProcess(boolean disposeOffsetMap) {
        this.cancel();
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.dispose((Disposable)this.myQueue);
        LookupManager.getInstance(this.getProject()).removePropertyChangeListener(this.myLookupManagerListener);
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        LOG.assertTrue(currentCompletion == this, (Object)(currentCompletion + "!=" + this));
        CompletionServiceImpl.assertPhase(CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class, CompletionPhase.Synchronous.class, CompletionPhase.CommittingDocuments.class);
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments) {
            LOG.assertTrue(((CompletionPhase.CommittingDocuments)oldPhase).isRestartingCompletion(), (Object)oldPhase);
            ((CompletionPhase.CommittingDocuments)oldPhase).replaced = true;
        }
        CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        if (disposeOffsetMap) {
            this.disposeIndicator();
        }
    }

    void disposeIndicator() {
        Disposer.dispose((Disposable)this);
    }

    public static void cleanupForNextTest() {
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (currentCompletion != null) {
            currentCompletion.finishCompletionProcess(true);
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        } else {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        }
        StatisticsUpdate.cancelLastCompletionStatisticsUpdate();
    }

    boolean blockingWaitForFinish(int timeoutMs) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !CompletionAutoPopupHandler.ourTestingAutopopup) {
            if (!this.myFinishSemaphore.waitFor(100000L)) {
                throw new AssertionError((Object)"Too long completion");
            }
            return true;
        }
        if (this.myFreezeSemaphore.waitFor((long)timeoutMs)) {
            return !this.isRunning() && !this.isCanceled();
        }
        return false;
    }

    @Override
    public void stop() {
        super.stop();
        this.myQueue.cancelAllUpdates();
        this.myFreezeSemaphore.up();
        this.myFinishSemaphore.up();
        GuiUtils.invokeLaterIfNeeded(() -> {
            PsiFile file2;
            CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
            if (!(phase instanceof CompletionPhase.BgCalculation) || phase.indicator != this) {
                return;
            }
            LOG.assertTrue(!this.getProject().isDisposed(), (Object)"project disposed");
            if (this.myEditor.isDisposed()) {
                this.myLookup.hideLookup(false);
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                return;
            }
            if (this.myEditor instanceof EditorWindow) {
                LOG.assertTrue(((EditorWindow)this.myEditor).getInjectedFile().isValid(), (Object)"injected file !valid");
                LOG.assertTrue(((DocumentWindow)this.myEditor.getDocument()).isValid(), (Object)"docWindow !valid");
            }
            LOG.assertTrue((file2 = this.myLookup.getPsiFile()) == null || file2.isValid(), (Object)"file !valid");
            this.myLookup.setCalculating(false);
            if (this.myCount == 0) {
                this.myLookup.hideLookup(false);
                if (!this.isAutopopupCompletion()) {
                    CompletionProgressIndicator current = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
                    LOG.assertTrue(current == null, (Object)(current + "!=" + this));
                    this.handleEmptyLookup(!((CompletionPhase.BgCalculation)phase).modifiersChanged);
                }
            } else {
                CompletionServiceImpl.setCompletionPhase(new CompletionPhase.ItemsCalculated(this));
                this.updateLookup(this.myIsUpdateSuppressed);
            }
        }, (ModalityState)this.myQueue.getModalityState());
    }

    private boolean hideAutopopupIfMeaningless() {
        if (!this.myLookup.isLookupDisposed() && this.isAutopopupCompletion() && !this.myLookup.isSelectionTouched() && !this.myLookup.isCalculating()) {
            this.myLookup.refreshUi(true, false);
            List<LookupElement> items = this.myLookup.getItems();
            for (LookupElement item : items) {
                if (!this.myLookup.itemPattern(item).equals(item.getLookupString())) {
                    return false;
                }
                if (!item.isValid() || !item.isWorthShowingInAutoPopup()) continue;
                return false;
            }
            this.myLookup.hideLookup(false);
            LOG.assertTrue(CompletionServiceImpl.getCompletionService().getCurrentCompletion() == null);
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            return true;
        }
        return false;
    }

    void restorePrefix(@NotNull Runnable customRestore) {
        if (customRestore == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(2);
        }
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            if (customRestore == null) {
                CompletionProgressIndicator.$$$reportNull$$$0(8);
            }
            this.setMergeCommand();
            customRestore.run();
        });
    }

    int nextInvocationCount(int invocation, boolean reused) {
        return reused ? Math.max(this.myInvocationCount + 1, 2) : invocation;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    Caret getCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(3);
        }
        return caret;
    }

    boolean isRepeatedInvocation(CompletionType completionType, Editor editor) {
        if (completionType != this.myCompletionType || editor != this.myEditor) {
            return false;
        }
        return !this.isAutopopupCompletion() || this.myLookup.mayBeNoticed();
    }

    public boolean isAutopopupCompletion() {
        return this.myInvocationCount == 0;
    }

    @NotNull
    public Project getProject() {
        Project project = (Project)ObjectUtils.assertNotNull((Object)this.myEditor.getProject());
        if (project == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(4);
        }
        return project;
    }

    public void addWatchedPrefix(int startOffset, ElementPattern<String> restartCondition) {
        this.myRestartingPrefixConditions.add((Pair<Integer, ElementPattern<String>>)Pair.create((Object)startOffset, restartCondition));
    }

    public void prefixUpdated() {
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        if (caretOffset < this.myStartCaret) {
            this.scheduleRestart();
            this.myRestartingPrefixConditions.clear();
            return;
        }
        CharSequence text = this.myEditor.getDocument().getCharsSequence();
        for (Pair<Integer, ElementPattern<String>> pair : this.myRestartingPrefixConditions) {
            String newPrefix;
            int start = (Integer)pair.first;
            if (caretOffset < start || start < 0 || !((ElementPattern)pair.second).accepts((Object)(newPrefix = text.subSequence(start, caretOffset).toString()))) continue;
            this.scheduleRestart();
            this.myRestartingPrefixConditions.clear();
            return;
        }
        this.hideAutopopupIfMeaningless();
    }

    public void scheduleRestart() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ApplicationManager.getApplication().isUnitTestMode() && !CompletionAutoPopupHandler.ourTestingAutopopup) {
            this.closeAndFinish(false);
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            new CodeCompletionHandlerBase(this.myCompletionType, false, false, true).invokeCompletion(this.getProject(), this.myEditor, this.myInvocationCount);
            return;
        }
        this.cancel();
        CompletionProgressIndicator current = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (this != current) {
            LOG.error(current + "!=" + this);
        }
        this.hideAutopopupIfMeaningless();
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments) {
            ((CompletionPhase.CommittingDocuments)oldPhase).replaced = true;
        }
        CompletionPhase.CommittingDocuments phase = new CompletionPhase.CommittingDocuments(this, this.myEditor);
        CompletionServiceImpl.setCompletionPhase(phase);
        phase.ignoreCurrentDocumentChange();
        Project project = this.getProject();
        AutoPopupController.runTransactionWithEverythingCommitted(project, () -> {
            if (phase.checkExpired()) {
                return;
            }
            CompletionAutoPopupHandler.invokeCompletion(this.myCompletionType, this.isAutopopupCompletion(), project, this.myEditor, this.myInvocationCount, true);
        });
    }

    @Override
    public String toString() {
        return "CompletionProgressIndicator[count=" + this.myCount + ",phase=" + CompletionServiceImpl.getCompletionPhase() + "]@" + System.identityHashCode(this);
    }

    void handleEmptyLookup(boolean awaitSecondInvocation) {
        if (this.isAutopopupCompletion() && ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LOG.assertTrue(!this.isAutopopupCompletion());
        if (ApplicationManager.getApplication().isUnitTestMode() || !this.myHandler.invokedExplicitly) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            return;
        }
        CompletionParameters parameters = this.getParameters();
        if (parameters != null && this.runContributorsOnEmptyLookup(awaitSecondInvocation, parameters)) {
            return;
        }
        CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
    }

    private boolean runContributorsOnEmptyLookup(boolean awaitSecondInvocation, CompletionParameters parameters) {
        for (CompletionContributor contributor : CompletionContributor.forParameters((CompletionParameters)parameters)) {
            String text = contributor.handleEmptyLookup(parameters, this.getEditor());
            if (!StringUtil.isNotEmpty((String)text)) continue;
            LightweightHint hint = CompletionProgressIndicator.showErrorHint(this.getProject(), this.getEditor(), text);
            CompletionServiceImpl.setCompletionPhase(awaitSecondInvocation ? new CompletionPhase.NoSuggestionsHint(hint, this) : CompletionPhase.NoCompletion);
            return true;
        }
        return false;
    }

    private static LightweightHint showErrorHint(Project project, Editor editor, String text) {
        LightweightHint[] result2 = new LightweightHint[]{null};
        EditorHintListener listener2 = (project1, hint, flags) -> {
            result2[0] = hint;
        };
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(EditorHintListener.TOPIC, (Object)listener2);
        assert (text != null);
        HintManager.getInstance().showErrorHint(editor, StringUtil.escapeXml((String)text), (short)2);
        connection.disconnect();
        return result2[0];
    }

    private static boolean shouldPreselectFirstSuggestion(CompletionParameters parameters) {
        if (Registry.is((String)"ide.completion.lookup.element.preselect.depends.on.context")) {
            for (CompletionPreselectionBehaviourProvider provider : (CompletionPreselectionBehaviourProvider[])Extensions.getExtensions(CompletionPreselectionBehaviourProvider.EP_NAME)) {
                if (provider.shouldPreselectFirstSuggestion(parameters)) continue;
                return false;
            }
        }
        return true;
    }

    void runContributors(CompletionInitializationContext initContext, OffsetsInFile offsets) {
        CompletionParameters parameters;
        this.myParameters = parameters = this.createCompletionParameters(offsets);
        this.myThreading.startThread(ProgressWrapper.wrap(this), () -> AsyncCompletion.tryReadOrCancel(this, () -> this.scheduleAdvertising(parameters)));
        WeighingDelegate weigher = this.myThreading.delegateWeighing(this);
        try {
            this.calculateItems(initContext, weigher, parameters);
        }
        catch (ProcessCanceledException ignore) {
            this.cancel();
        }
        catch (Throwable t) {
            this.cancel();
            LOG.error(t);
        }
    }

    private void calculateItems(CompletionInitializationContext initContext, WeighingDelegate weigher, CompletionParameters parameters) {
        this.duringCompletion(initContext, parameters);
        ProgressManager.checkCanceled();
        CompletionService.getCompletionService().performCompletion(parameters, (Consumer)weigher);
        ProgressManager.checkCanceled();
        weigher.waitFor();
        ProgressManager.checkCanceled();
    }

    @NotNull
    CompletionThreadingBase getCompletionThreading() {
        CompletionThreadingBase completionThreadingBase = this.myThreading;
        if (completionThreadingBase == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(5);
        }
        return completionThreadingBase;
    }

    public void addAdvertisement(@NotNull String text, @Nullable Color bgColor) {
        if (text == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(6);
        }
        this.myAdvertiserChanges.offer(() -> {
            if (text == null) {
                CompletionProgressIndicator.$$$reportNull$$$0(7);
            }
            this.myLookup.addAdvertisement(text, bgColor);
        });
        this.myQueue.queue(this.myUpdate);
    }

    public static void setGroupingTimeSpan(int timeSpan) {
        ourInsertSingleItemTimeSpan = timeSpan;
    }

    @Deprecated
    public static void setAutopopupTriggerTime(int timeSpan) {
        ourShowPopupGroupingTime = timeSpan;
        ourShowPopupAfterFirstItemGroupingTime = timeSpan;
    }

    void makeSureLookupIsShown(int timeout) {
        this.mySuppressTimeoutAlarm.addRequest(this::showIfSuppressed, timeout);
    }

    private void showIfSuppressed() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myLookup.isShown()) {
            return;
        }
        this.updateLookup(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionProgressIndicator";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customRestore";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionProgressIndicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findCompletionPositionLeaf";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionThreading";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restorePrefix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAdvertisement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addAdvertisement$8";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$restorePrefix$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModifierTracker
    extends KeyAdapter {
        private final JComponent myContentComponent;

        public ModifierTracker(JComponent contentComponent) {
            this.myContentComponent = contentComponent;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.processModifier(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.processModifier(e);
        }

        private void processModifier(KeyEvent e) {
            int code2 = e.getKeyCode();
            if (code2 == 17 || code2 == 157 || code2 == 18 || code2 == 16) {
                this.myContentComponent.removeKeyListener(this);
                CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
                if (phase instanceof CompletionPhase.BgCalculation) {
                    ((CompletionPhase.BgCalculation)phase).modifiersChanged = true;
                } else if (phase instanceof CompletionPhase.InsertedSingleItem) {
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                }
            }
        }
    }
}

