/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.containers.WeakInterner;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.LocalInspectionsPass");
    public static final TextRange EMPTY_PRIORITY_RANGE = TextRange.EMPTY_RANGE;
    private static final Condition<PsiFile> SHOULD_INSPECT_FILTER = file2 -> HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)file2);
    private final TextRange myPriorityRange;
    private final boolean myIgnoreSuppressed;
    private final ConcurrentMap<PsiFile, List<InspectionResult>> result;
    private static final String PRESENTABLE_NAME = DaemonBundle.message((String)"pass.inspection", (Object[])new Object[0]);
    private volatile List<HighlightInfo> myInfos;
    private final String myShortcutText;
    private final SeverityRegistrar mySeverityRegistrar;
    private final InspectionProfileWrapper myProfileWrapper;
    private boolean myFailFastOnAcquireReadAction;
    private static Set<String> ourToolsWithInformationProblems = new HashSet<String>();
    private static final TextAttributes NONEMPTY_TEXT_ATTRIBUTES = new TextAttributes(){

        public boolean isEmpty() {
            return false;
        }
    };
    private final Map<TextRange, RangeMarker> ranges2markersCache;
    private final TransferToEDTQueue<Trinity<ProblemDescriptor, LocalInspectionToolWrapper, ProgressIndicator>> myTransferToEDTQueue;
    private final Set<Pair<TextRange, String>> emptyActionRegistered;
    private static final WeakInterner<String> tooltips = new WeakInterner();

    public LocalInspectionsPass(@NotNull PsiFile file2, @Nullable Document document, int startOffset, int endOffset, @NotNull TextRange priorityRange, boolean ignoreSuppressed, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        Keymap keymap;
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(0);
        }
        if (priorityRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(1);
        }
        if (highlightInfoProcessor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(2);
        }
        super(file2.getProject(), document, PRESENTABLE_NAME, file2, null, new TextRange(startOffset, endOffset), true, highlightInfoProcessor);
        this.result = ContainerUtil.newConcurrentMap();
        this.myInfos = Collections.emptyList();
        this.ranges2markersCache = new THashMap();
        this.myTransferToEDTQueue = new TransferToEDTQueue("Apply inspection results", (Processor)new Processor<Trinity<ProblemDescriptor, LocalInspectionToolWrapper, ProgressIndicator>>(){
            private final InjectedLanguageManager ilManager;
            private final List<HighlightInfo> infos;
            private final PsiDocumentManager documentManager;
            {
                this.ilManager = InjectedLanguageManager.getInstance((Project)LocalInspectionsPass.this.myProject);
                this.infos = new ArrayList<HighlightInfo>(2);
                this.documentManager = PsiDocumentManager.getInstance((Project)LocalInspectionsPass.this.myProject);
            }

            public boolean process(Trinity<ProblemDescriptor, LocalInspectionToolWrapper, ProgressIndicator> trinity) {
                ProgressIndicator indicator = (ProgressIndicator)trinity.getThird();
                if (indicator.isCanceled()) {
                    return false;
                }
                ProblemDescriptor descriptor = (ProblemDescriptor)trinity.first;
                LocalInspectionToolWrapper tool = (LocalInspectionToolWrapper)((Object)trinity.second);
                PsiElement psiElement = descriptor.getPsiElement();
                if (psiElement == null) {
                    return true;
                }
                PsiFile file2 = psiElement.getContainingFile();
                Document thisDocument = this.documentManager.getDocument(file2);
                HighlightSeverity severity = LocalInspectionsPass.this.myProfileWrapper.getErrorLevel(HighlightDisplayKey.find((String)tool.getShortName()), (PsiElement)file2).getSeverity();
                this.infos.clear();
                LocalInspectionsPass.this.createHighlightsForDescriptor(this.infos, LocalInspectionsPass.this.emptyActionRegistered, this.ilManager, file2, thisDocument, tool, severity, descriptor, psiElement);
                for (HighlightInfo info : this.infos) {
                    EditorColorsScheme colorsScheme = LocalInspectionsPass.this.getColorsScheme();
                    UpdateHighlightersUtil.addHighlighterToEditorIncrementally(LocalInspectionsPass.this.myProject, LocalInspectionsPass.this.myDocument, LocalInspectionsPass.this.getFile(), LocalInspectionsPass.this.myRestrictRange.getStartOffset(), LocalInspectionsPass.this.myRestrictRange.getEndOffset(), info, colorsScheme, LocalInspectionsPass.this.getId(), LocalInspectionsPass.this.ranges2markersCache);
                }
                return true;
            }
        }, this.myProject.getDisposed());
        this.emptyActionRegistered = Collections.synchronizedSet(new THashSet());
        assert (file2.isPhysical()) : "can't inspect non-physical file: " + file2 + "; " + file2.getVirtualFile();
        this.myPriorityRange = priorityRange;
        this.myIgnoreSuppressed = ignoreSuppressed;
        this.setId(7);
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        this.myShortcutText = keymapManager2 != null ? ((keymap = keymapManager2.getActiveKeymap()) == null ? "" : "(" + KeymapUtil.getShortcutsText((Shortcut[])keymap.getShortcuts("ShowErrorDescription")) + ")") : "";
        InspectionProfileImpl profileToUse = ProjectInspectionProfileManager.getInstance(this.myProject).getCurrentProfile();
        Function custom = (Function)file2.getUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY);
        InspectionProfileWrapper inspectionProfileWrapper = this.myProfileWrapper = custom == null ? new InspectionProfileWrapper(profileToUse) : (InspectionProfileWrapper)custom.apply(profileToUse);
        assert (this.myProfileWrapper != null);
        this.mySeverityRegistrar = this.myProfileWrapper.getInspectionProfile().getProfileManager().getSeverityRegistrar();
        this.setProgressLimit(600L);
    }

    @NotNull
    private PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            LocalInspectionsPass.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            LocalInspectionsPass.$$$reportNull$$$0(4);
        }
        try {
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)this.getFile())) {
                return;
            }
            this.inspect(this.getInspectionTools(this.myProfileWrapper), InspectionManager.getInstance((Project)this.myProject), true, true, progress);
        }
        finally {
            this.disposeDescriptors();
        }
    }

    private void disposeDescriptors() {
        this.result.clear();
    }

    public void doInspectInBatch(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionManager iManager, @NotNull List<LocalInspectionToolWrapper> toolWrappers) {
        if (context == null) {
            LocalInspectionsPass.$$$reportNull$$$0(5);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(6);
        }
        if (toolWrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(7);
        }
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        this.inspect(new ArrayList<LocalInspectionToolWrapper>(toolWrappers), iManager, false, false, progress);
        this.addDescriptorsFromInjectedResults(iManager, context);
        List resultList = (List)this.result.get(this.getFile());
        if (resultList == null) {
            return;
        }
        for (InspectionResult inspectionResult : resultList) {
            LocalInspectionToolWrapper toolWrapper = inspectionResult.tool;
            String shortName = toolWrapper.getShortName();
            for (ProblemDescriptor descriptor : inspectionResult.foundProblems) {
                if (descriptor.getHighlightType() == ProblemHighlightType.INFORMATION) {
                    if (!ourToolsWithInformationProblems.add(shortName)) continue;
                    LOG.error("Tool '" + shortName + "' registers INFORMATION level problem in batch mode on " + this.getFile() + ". INFORMATION level fixes could change semantics and should not be used in batch transformations");
                    continue;
                }
                this.addDescriptors(toolWrapper, descriptor, context);
            }
        }
    }

    private void addDescriptors(@NotNull LocalInspectionToolWrapper toolWrapper, @NotNull ProblemDescriptor descriptor, @NotNull GlobalInspectionContextImpl context) {
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(8);
        }
        if (descriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(9);
        }
        if (context == null) {
            LocalInspectionsPass.$$$reportNull$$$0(10);
        }
        InspectionToolPresentation toolPresentation = context.getPresentation(toolWrapper);
        BatchModeDescriptorsUtil.addProblemDescriptors(Collections.singletonList(descriptor), toolPresentation, this.myIgnoreSuppressed, context, (LocalInspectionTool)toolWrapper.getTool());
    }

    private void addDescriptorsFromInjectedResults(@NotNull InspectionManager iManager, @NotNull GlobalInspectionContextImpl context) {
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(11);
        }
        if (context == null) {
            LocalInspectionsPass.$$$reportNull$$$0(12);
        }
        InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        for (Map.Entry entry : this.result.entrySet()) {
            PsiFile file2 = (PsiFile)entry.getKey();
            if (file2 == this.getFile()) continue;
            DocumentWindow documentRange = (DocumentWindow)documentManager.getDocument(file2);
            List resultList = (List)entry.getValue();
            for (InspectionResult inspectionResult : resultList) {
                LocalInspectionToolWrapper toolWrapper = inspectionResult.tool;
                for (ProblemDescriptor descriptor : inspectionResult.foundProblems) {
                    PsiElement psiElement = descriptor.getPsiElement();
                    if (psiElement == null || SuppressionUtil.inspectionResultSuppressed(psiElement, (LocalInspectionTool)toolWrapper.getTool())) continue;
                    List editables = ilManager.intersectWithAllEditableFragments(file2, ((ProblemDescriptorBase)descriptor).getTextRange());
                    for (TextRange editable : editables) {
                        TextRange hostRange = documentRange.injectedToHost(editable);
                        QuickFix[] fixes = descriptor.getFixes();
                        LocalQuickFix[] localFixes = null;
                        if (fixes != null) {
                            localFixes = new LocalQuickFix[fixes.length];
                            for (int k = 0; k < fixes.length; ++k) {
                                QuickFix fix = fixes[k];
                                localFixes[k] = (LocalQuickFix)fix;
                            }
                        }
                        ProblemDescriptor patchedDescriptor = iManager.createProblemDescriptor((PsiElement)this.getFile(), hostRange, descriptor.getDescriptionTemplate(), descriptor.getHighlightType(), true, localFixes);
                        this.addDescriptors(toolWrapper, patchedDescriptor, context);
                    }
                }
            }
        }
    }

    private void inspect(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull InspectionManager iManager, boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator progress) {
        if (toolWrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(13);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(14);
        }
        if (progress == null) {
            LocalInspectionsPass.$$$reportNull$$$0(15);
        }
        this.myFailFastOnAcquireReadAction = failFastOnAcquireReadAction;
        if (toolWrappers.isEmpty()) {
            return;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(this.myFile, this.myRestrictRange, this.myPriorityRange, SHOULD_INSPECT_FILTER, (Processor<Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List inside = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> d.inside));
        List outside = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> ContainerUtil.concat(d.outside, d.parents)));
        Set<String> elementDialectIds = InspectionEngine.calcElementDialectIds(inside, outside);
        Map<LocalInspectionToolWrapper, Set<String>> toolToSpecifiedLanguageIds = InspectionEngine.getToolsToSpecifiedLanguages(toolWrappers);
        this.setProgressLimit((long)toolToSpecifiedLanguageIds.size() * 2L);
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(this.getFile(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset());
        List<InspectionContext> init = this.visitPriorityElementsAndInit(toolToSpecifiedLanguageIds, iManager, isOnTheFly, progress, inside, session2, elementDialectIds);
        this.inspectInjectedPsi(inside, isOnTheFly, progress, iManager, true, toolWrappers);
        this.visitRestElementsAndCleanup(progress, outside, session2, init, elementDialectIds);
        this.inspectInjectedPsi(outside, isOnTheFly, progress, iManager, false, toolWrappers);
        ProgressManager.checkCanceled();
        this.myInfos = new ArrayList<HighlightInfo>();
        this.addHighlightsFromResults(this.myInfos);
    }

    @NotNull
    private List<InspectionContext> visitPriorityElementsAndInit(@NotNull Map<LocalInspectionToolWrapper, Set<String>> toolToSpecifiedLanguageIds, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull List<PsiElement> elements, @NotNull LocalInspectionToolSession session2, @NotNull Set<String> elementDialectIds) {
        if (toolToSpecifiedLanguageIds == null) {
            LocalInspectionsPass.$$$reportNull$$$0(16);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(18);
        }
        if (elements == null) {
            LocalInspectionsPass.$$$reportNull$$$0(19);
        }
        if (session2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(20);
        }
        if (elementDialectIds == null) {
            LocalInspectionsPass.$$$reportNull$$$0(21);
        }
        ArrayList<InspectionContext> init = new ArrayList<InspectionContext>();
        ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>> entries = new ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>>(toolToSpecifiedLanguageIds.entrySet());
        Processor processor2 = pair -> {
            if (iManager == null) {
                LocalInspectionsPass.$$$reportNull$$$0(93);
            }
            if (indicator == null) {
                LocalInspectionsPass.$$$reportNull$$$0(94);
            }
            if (elements == null) {
                LocalInspectionsPass.$$$reportNull$$$0(95);
            }
            if (session2 == null) {
                LocalInspectionsPass.$$$reportNull$$$0(96);
            }
            if (elementDialectIds == null) {
                LocalInspectionsPass.$$$reportNull$$$0(97);
            }
            LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)((Object)((Object)pair.getKey()));
            Set dialectIdsSpecifiedForTool = (Set)pair.getValue();
            this.runToolOnElements(toolWrapper, dialectIdsSpecifiedForTool, iManager, isOnTheFly, indicator, elements, session2, init, elementDialectIds);
            return true;
        };
        boolean result2 = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(entries, indicator, this.myFailFastOnAcquireReadAction, processor2);
        if (!result2) {
            throw new ProcessCanceledException();
        }
        ArrayList<InspectionContext> arrayList = init;
        if (arrayList == null) {
            LocalInspectionsPass.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runToolOnElements(final @NotNull LocalInspectionToolWrapper toolWrapper, Set<String> dialectIdsSpecifiedForTool, @NotNull InspectionManager iManager, boolean isOnTheFly, final @NotNull ProgressIndicator indicator, @NotNull List<PsiElement> elements, @NotNull LocalInspectionToolSession session2, @NotNull List<InspectionContext> init, @NotNull Set<String> elementDialectIds) {
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(23);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(25);
        }
        if (elements == null) {
            LocalInspectionsPass.$$$reportNull$$$0(26);
        }
        if (session2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(27);
        }
        if (init == null) {
            LocalInspectionsPass.$$$reportNull$$$0(28);
        }
        if (elementDialectIds == null) {
            LocalInspectionsPass.$$$reportNull$$$0(29);
        }
        ProgressManager.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
        final boolean[] applyIncrementally = new boolean[]{isOnTheFly};
        ProblemsHolder holder = new ProblemsHolder(iManager, this.getFile(), isOnTheFly){

            public void registerProblem(@NotNull ProblemDescriptor descriptor) {
                if (descriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.registerProblem(descriptor);
                if (applyIncrementally[0]) {
                    LocalInspectionsPass.this.addDescriptorIncrementally(descriptor, toolWrapper, indicator);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$1", "registerProblem"));
            }
        };
        PsiElementVisitor visitor = InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session2, elements, elementDialectIds, dialectIdsSpecifiedForTool);
        List<InspectionContext> list2 = init;
        synchronized (list2) {
            init.add(new InspectionContext(toolWrapper, holder, holder.getResultCount(), visitor, dialectIdsSpecifiedForTool));
        }
        this.advanceProgress(1L);
        if (holder.hasResults()) {
            this.appendDescriptors(this.getFile(), holder.getResults(), toolWrapper);
        }
        applyIncrementally[0] = false;
    }

    private void visitRestElementsAndCleanup(@NotNull ProgressIndicator indicator, @NotNull List<PsiElement> elements, @NotNull LocalInspectionToolSession session2, @NotNull List<InspectionContext> init, @NotNull Set<String> elementDialectIds) {
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(30);
        }
        if (elements == null) {
            LocalInspectionsPass.$$$reportNull$$$0(31);
        }
        if (session2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(32);
        }
        if (init == null) {
            LocalInspectionsPass.$$$reportNull$$$0(33);
        }
        if (elementDialectIds == null) {
            LocalInspectionsPass.$$$reportNull$$$0(34);
        }
        Processor processor2 = context -> {
            if (elements == null) {
                LocalInspectionsPass.$$$reportNull$$$0(90);
            }
            if (elementDialectIds == null) {
                LocalInspectionsPass.$$$reportNull$$$0(91);
            }
            if (session2 == null) {
                LocalInspectionsPass.$$$reportNull$$$0(92);
            }
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            InspectionEngine.acceptElements(elements, ((InspectionContext)context).visitor, elementDialectIds, ((InspectionContext)context).dialectIdsSpecifiedForTool);
            this.advanceProgress(1L);
            ((LocalInspectionTool)((InspectionContext)context).tool.getTool()).inspectionFinished(session2, ((InspectionContext)context).holder);
            if (((InspectionContext)context).holder.hasResults()) {
                List allProblems = ((InspectionContext)context).holder.getResults();
                List<ProblemDescriptor> restProblems = allProblems.subList(((InspectionContext)context).problemsSize, allProblems.size());
                this.appendDescriptors(this.getFile(), restProblems, ((InspectionContext)context).tool);
            }
            return true;
        };
        boolean result2 = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(init, indicator, this.myFailFastOnAcquireReadAction, processor2);
        if (!result2) {
            throw new ProcessCanceledException();
        }
    }

    void inspectInjectedPsi(@NotNull List<PsiElement> elements, boolean onTheFly, @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, boolean inVisibleRange, @NotNull List<LocalInspectionToolWrapper> wrappers) {
        if (elements == null) {
            LocalInspectionsPass.$$$reportNull$$$0(35);
        }
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(36);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(37);
        }
        if (wrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(38);
        }
        THashSet injected = new THashSet();
        for (PsiElement element : elements) {
            PsiFile containingFile = this.getFile();
            InjectedLanguageManager.getInstance((Project)containingFile.getProject()).enumerateEx(element, containingFile, false, (arg_0, arg_1) -> LocalInspectionsPass.lambda$inspectInjectedPsi$5((Set)injected, arg_0, arg_1));
        }
        if (injected.isEmpty()) {
            return;
        }
        Processor processor2 = injectedPsi -> {
            if (indicator == null) {
                LocalInspectionsPass.$$$reportNull$$$0(87);
            }
            if (iManager == null) {
                LocalInspectionsPass.$$$reportNull$$$0(88);
            }
            if (wrappers == null) {
                LocalInspectionsPass.$$$reportNull$$$0(89);
            }
            this.doInspectInjectedPsi((PsiFile)injectedPsi, onTheFly, indicator, iManager, inVisibleRange, wrappers);
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(injected), indicator, this.myFailFastOnAcquireReadAction, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @Nullable
    private HighlightInfo highlightInfoFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightInfoType highlightInfoType, @NotNull String message, String toolTip, PsiElement psiElement, @NotNull List<IntentionAction> quickFixes) {
        TextRange textRange;
        if (problemDescriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(39);
        }
        if (highlightInfoType == null) {
            LocalInspectionsPass.$$$reportNull$$$0(40);
        }
        if (message == null) {
            LocalInspectionsPass.$$$reportNull$$$0(41);
        }
        if (quickFixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(42);
        }
        if ((textRange = ((ProblemDescriptorBase)problemDescriptor).getTextRange()) == null || psiElement == null) {
            return null;
        }
        boolean isFileLevel = psiElement instanceof PsiFile && textRange.equals((Object)psiElement.getTextRange());
        HighlightSeverity severity = highlightInfoType.getSeverity(psiElement);
        TextAttributes attributes = this.mySeverityRegistrar.getTextAttributesBySeverity(severity);
        HighlightInfo.Builder b = HighlightInfo.newHighlightInfo(highlightInfoType).range(psiElement, textRange.getStartOffset(), textRange.getEndOffset()).description(message).severity(severity);
        if (toolTip != null) {
            b.escapedToolTip(toolTip);
        }
        if (HighlightSeverity.INFORMATION.equals((Object)severity) && attributes == null && toolTip == null && !quickFixes.isEmpty()) {
            attributes = NONEMPTY_TEXT_ATTRIBUTES;
        }
        if (attributes != null) {
            b.textAttributes(attributes);
        }
        if (problemDescriptor.isAfterEndOfLine()) {
            b.endOfLine();
        }
        if (isFileLevel) {
            b.fileLevelAnnotation();
        }
        if (problemDescriptor.getProblemGroup() != null) {
            b.problemGroup(problemDescriptor.getProblemGroup());
        }
        return b.create();
    }

    private void addDescriptorIncrementally(@NotNull ProblemDescriptor descriptor, @NotNull LocalInspectionToolWrapper tool, @NotNull ProgressIndicator indicator) {
        if (descriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(43);
        }
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(44);
        }
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(45);
        }
        if (this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed(descriptor.getPsiElement(), (LocalInspectionTool)tool.getTool())) {
            return;
        }
        this.myTransferToEDTQueue.offer((Object)Trinity.create((Object)descriptor, (Object)((Object)tool), (Object)indicator));
    }

    private void appendDescriptors(@NotNull PsiFile file2, @NotNull List<ProblemDescriptor> descriptors, @NotNull LocalInspectionToolWrapper tool) {
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(46);
        }
        if (descriptors == null) {
            LocalInspectionsPass.$$$reportNull$$$0(47);
        }
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(48);
        }
        for (ProblemDescriptor descriptor : descriptors) {
            if (descriptor != null) continue;
            LOG.error("null descriptor. all descriptors(" + descriptors.size() + "): " + descriptors + "; file: " + file2 + " (" + file2.getVirtualFile() + "); tool: " + (Object)((Object)tool));
        }
        InspectionResult result2 = new InspectionResult(tool, descriptors);
        this.appendResult(file2, result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendResult(@NotNull PsiFile file2, @NotNull InspectionResult result2) {
        List resultList;
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(49);
        }
        if (result2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(50);
        }
        if ((resultList = (List)this.result.get(file2)) == null) {
            resultList = (List)ConcurrencyUtil.cacheOrGet(this.result, (Object)file2, new ArrayList());
        }
        List list2 = resultList;
        synchronized (list2) {
            resultList.add(result2);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), this.myInfos, this.getColorsScheme(), this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHighlightsFromResults(@NotNull List<HighlightInfo> outInfos) {
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(51);
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        THashSet emptyActionRegistered = new THashSet();
        for (Map.Entry entry : this.result.entrySet()) {
            List resultList;
            ProgressManager.checkCanceled();
            PsiFile file2 = (PsiFile)entry.getKey();
            Document documentRange = documentManager.getDocument(file2);
            if (documentRange == null) continue;
            List list2 = resultList = (List)entry.getValue();
            synchronized (list2) {
                for (InspectionResult inspectionResult : resultList) {
                    ProgressManager.checkCanceled();
                    LocalInspectionToolWrapper tool = inspectionResult.tool;
                    HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(HighlightDisplayKey.find((String)tool.getShortName()), (PsiElement)file2).getSeverity();
                    for (ProblemDescriptor descriptor : inspectionResult.foundProblems) {
                        ProgressManager.checkCanceled();
                        PsiElement element = descriptor.getPsiElement();
                        if (element == null) continue;
                        this.createHighlightsForDescriptor(outInfos, (Set<Pair<TextRange, String>>)emptyActionRegistered, ilManager, file2, documentRange, tool, severity, descriptor, element);
                    }
                }
            }
        }
    }

    private void createHighlightsForDescriptor(@NotNull List<HighlightInfo> outInfos, @NotNull Set<Pair<TextRange, String>> emptyActionRegistered, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull HighlightSeverity severity, @NotNull ProblemDescriptor descriptor, @NotNull PsiElement element) {
        boolean isInjected;
        List<IntentionAction> fixes;
        HighlightInfo info;
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(52);
        }
        if (emptyActionRegistered == null) {
            LocalInspectionsPass.$$$reportNull$$$0(53);
        }
        if (ilManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(54);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(55);
        }
        if (documentRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(56);
        }
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(57);
        }
        if (severity == null) {
            LocalInspectionsPass.$$$reportNull$$$0(58);
        }
        if (descriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(59);
        }
        if (element == null) {
            LocalInspectionsPass.$$$reportNull$$$0(60);
        }
        LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
        if (this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed(element, tool)) {
            return;
        }
        HighlightInfoType level = ProblemDescriptorUtil.highlightTypeFromDescriptor(descriptor, severity, this.mySeverityRegistrar);
        String message = ProblemDescriptorUtil.renderDescriptionMessage((CommonProblemDescriptor)descriptor, element);
        HighlightDisplayKey key = HighlightDisplayKey.find((String)tool.getShortName());
        InspectionProfileImpl inspectionProfile = this.myProfileWrapper.getInspectionProfile();
        if (!inspectionProfile.isToolEnabled(key, (PsiElement)this.getFile())) {
            return;
        }
        HighlightInfoType.HighlightInfoTypeImpl type = new HighlightInfoType.HighlightInfoTypeImpl(level.getSeverity(element), level.getAttributesKey());
        String plainMessage = message.startsWith("<html>") ? StringUtil.unescapeXml((String)XmlStringUtil.stripHtml((String)message).replaceAll("<[^>]*>", "")) : message;
        String link = "";
        if (LocalInspectionsPass.showToolDescription(toolWrapper)) {
            link = " <a href=\"#inspection/" + tool.getShortName() + "\"" + (UIUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]) + "</a> " + this.myShortcutText;
        }
        String tooltip = null;
        if (descriptor.showTooltip()) {
            tooltip = (String)tooltips.intern((Object)XmlStringUtil.wrapInHtml((CharSequence)((message.startsWith("<html>") ? XmlStringUtil.stripHtml((String)message) : XmlStringUtil.escapeString((String)message)) + link)));
        }
        if ((info = this.highlightInfoFromDescriptor(descriptor, type, plainMessage, tooltip, element, fixes = LocalInspectionsPass.getQuickFixes(toolWrapper, descriptor, emptyActionRegistered))) == null) {
            return;
        }
        LocalInspectionsPass.registerQuickFixes(toolWrapper, info, fixes);
        PsiFile context = this.getTopLevelFileInBaseLanguage(element);
        PsiFile myContext = this.getTopLevelFileInBaseLanguage((PsiElement)this.getFile());
        if (context != this.getFile()) {
            ClassLoader toolClassLoader = tool.getClass().getClassLoader();
            PluginId pluginId = null;
            if (toolClassLoader instanceof PluginClassLoader) {
                pluginId = ((PluginClassLoader)((Object)toolClassLoader)).getPluginId();
            }
            String errorMessage = "Reported element " + element + " is not from the file '" + file2 + "' the inspection '" + (Object)((Object)toolWrapper) + "' (" + tool.getClass() + ") was invoked for. Message: '" + descriptor + "'.\nElement' containing file: " + context + "\nInspection invoked for file: " + myContext + "\n";
            if (pluginId == null) {
                LOG.error(errorMessage);
            } else {
                LOG.error((Throwable)new PluginException(errorMessage, pluginId));
            }
        }
        boolean bl = isInjected = file2 != this.getFile();
        if (!isInjected) {
            outInfos.add(info);
            return;
        }
        LocalInspectionsPass.injectToHost(outInfos, ilManager, file2, documentRange, toolWrapper, element, fixes, info);
    }

    private static void injectToHost(@NotNull List<HighlightInfo> outInfos, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull PsiElement element, @NotNull List<IntentionAction> fixes, @NotNull HighlightInfo info) {
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(61);
        }
        if (ilManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(62);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(63);
        }
        if (documentRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(64);
        }
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(65);
        }
        if (element == null) {
            LocalInspectionsPass.$$$reportNull$$$0(66);
        }
        if (fixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(67);
        }
        if (info == null) {
            LocalInspectionsPass.$$$reportNull$$$0(68);
        }
        List editables = ilManager.intersectWithAllEditableFragments(file2, new TextRange(info.startOffset, info.endOffset));
        for (TextRange editable : editables) {
            String toolTip;
            TextRange hostRange = ((DocumentWindow)documentRange).injectedToHost(editable);
            int start = hostRange.getStartOffset();
            int end = hostRange.getEndOffset();
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(info.type).range(element, start, end);
            String description = info.getDescription();
            if (description != null) {
                builder.description(description);
            }
            if ((toolTip = info.getToolTip()) != null) {
                builder.escapedToolTip(toolTip);
            }
            HighlightInfo patched = builder.createUnconditionally();
            if (patched.startOffset == patched.endOffset && info.startOffset != info.endOffset) continue;
            patched.setFromInjection(true);
            LocalInspectionsPass.registerQuickFixes(toolWrapper, patched, fixes);
            outInfos.add(patched);
        }
    }

    private PsiFile getTopLevelFileInBaseLanguage(@NotNull PsiElement element) {
        if (element == null) {
            LocalInspectionsPass.$$$reportNull$$$0(69);
        }
        PsiFile file2 = InjectedLanguageManager.getInstance((Project)this.myProject).getTopLevelFile(element);
        FileViewProvider viewProvider = file2.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    private static boolean showToolDescription(@NotNull LocalInspectionToolWrapper tool) {
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(70);
        }
        return tool.getStaticDescription() == null || !tool.getStaticDescription().isEmpty();
    }

    private static void registerQuickFixes(@NotNull LocalInspectionToolWrapper tool, @NotNull HighlightInfo highlightInfo, @NotNull List<IntentionAction> quickFixes) {
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(71);
        }
        if (highlightInfo == null) {
            LocalInspectionsPass.$$$reportNull$$$0(72);
        }
        if (quickFixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(73);
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)tool.getShortName());
        for (IntentionAction quickFix : quickFixes) {
            QuickFixAction.registerQuickFixAction(highlightInfo, quickFix, key);
        }
    }

    private static List<IntentionAction> getQuickFixes(@NotNull LocalInspectionToolWrapper tool, @NotNull ProblemDescriptor descriptor, @NotNull Set<Pair<TextRange, String>> emptyActionRegistered) {
        HintAction hintAction;
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(74);
        }
        if (descriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(75);
        }
        if (emptyActionRegistered == null) {
            LocalInspectionsPass.$$$reportNull$$$0(76);
        }
        SmartList result2 = new SmartList();
        boolean needEmptyAction = true;
        Object[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length != 0) {
            for (int k = 0; k < fixes.length; ++k) {
                QuickFix fix = fixes[k];
                if (fix == null) {
                    throw new IllegalStateException("Inspection " + (Object)((Object)tool) + " returns null quick fix in its descriptor: " + descriptor + "; array: " + Arrays.toString(fixes));
                }
                result2.add(QuickFixWrapper.wrap(descriptor, k));
                needEmptyAction = false;
            }
        }
        HintAction hintAction2 = hintAction = descriptor instanceof ProblemDescriptorImpl ? ((ProblemDescriptorImpl)descriptor).getHintAction() : null;
        if (hintAction != null) {
            result2.add(hintAction);
            needEmptyAction = false;
        }
        if (((ProblemDescriptorBase)descriptor).getEnforcedTextAttributes() != null) {
            needEmptyAction = false;
        }
        if (needEmptyAction && emptyActionRegistered.add((Pair<TextRange, String>)Pair.create((Object)((ProblemDescriptorBase)descriptor).getTextRange(), (Object)tool.getShortName()))) {
            EmptyIntentionAction emptyIntentionAction = new EmptyIntentionAction(tool.getDisplayName());
            result2.add(emptyIntentionAction);
        }
        return result2;
    }

    private static void getElementsAndDialectsFrom(@NotNull PsiFile file2, @NotNull List<PsiElement> outElements, @NotNull Set<String> outDialects) {
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(77);
        }
        if (outElements == null) {
            LocalInspectionsPass.$$$reportNull$$$0(78);
        }
        if (outDialects == null) {
            LocalInspectionsPass.$$$reportNull$$$0(79);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        final LinkedHashSet<PsiFile> result2 = new LinkedHashSet<PsiFile>();
        SmartHashSet processedLanguages = new SmartHashSet();
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor((Set)processedLanguages, outDialects){
            final /* synthetic */ Set val$processedLanguages;
            final /* synthetic */ Set val$outDialects;
            {
                this.val$processedLanguages = set3;
                this.val$outDialects = set4;
            }

            public void visitElement(PsiElement element) {
                PsiElement child;
                ProgressManager.checkCanceled();
                if (child != null) {
                    for (child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                        child.accept((PsiElementVisitor)this);
                        result2.add(child);
                        LocalInspectionsPass.appendDialects(child, this.val$processedLanguages, this.val$outDialects);
                    }
                }
            }
        };
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (psiRoot == null || !HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            psiRoot.accept((PsiElementVisitor)visitor);
            result2.add(psiRoot);
            LocalInspectionsPass.appendDialects((PsiElement)psiRoot, (Set<Language>)processedLanguages, outDialects);
        }
        outElements.addAll(result2);
    }

    private static void appendDialects(PsiElement element, Set<Language> outProcessedLanguages, Set<String> outDialectIds) {
        Language language = element.getLanguage();
        outDialectIds.add(language.getID());
        if (outProcessedLanguages.add(language)) {
            for (Language dialect : language.getDialects()) {
                outDialectIds.add(dialect.getID());
            }
        }
    }

    @NotNull
    List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile2) {
        if (profile2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(80);
        }
        InspectionToolWrapper[] toolWrappers = profile2.getInspectionProfile().getInspectionTools((PsiElement)this.getFile());
        InspectionProfileWrapper.checkInspectionsDuplicates(toolWrappers);
        ArrayList<LocalInspectionToolWrapper> enabled = new ArrayList<LocalInspectionToolWrapper>();
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            String language;
            ProgressManager.checkCanceled();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)toolWrapper.getShortName());
            if (!profile2.isToolEnabled(key, (PsiElement)this.getFile()) || HighlightDisplayLevel.DO_NOT_SHOW.equals(profile2.getErrorLevel(key, (PsiElement)this.getFile()))) continue;
            LocalInspectionToolWrapper wrapper = null;
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                wrapper = (LocalInspectionToolWrapper)toolWrapper;
            } else if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionToolWrapper globalInspectionToolWrapper = (GlobalInspectionToolWrapper)toolWrapper;
                wrapper = globalInspectionToolWrapper.getSharedLocalInspectionToolWrapper();
            }
            if (wrapper == null || (language = wrapper.getLanguage()) != null && Language.findLanguageByID((String)language) == null || this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed((PsiElement)this.getFile(), (LocalInspectionTool)wrapper.getTool())) continue;
            enabled.add(wrapper);
        }
        ArrayList<LocalInspectionToolWrapper> arrayList = enabled;
        if (arrayList == null) {
            LocalInspectionsPass.$$$reportNull$$$0(81);
        }
        return arrayList;
    }

    private void doInspectInjectedPsi(@NotNull PsiFile injectedPsi, final boolean isOnTheFly, final @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, final boolean inVisibleRange, @NotNull List<LocalInspectionToolWrapper> wrappers) {
        if (injectedPsi == null) {
            LocalInspectionsPass.$$$reportNull$$$0(82);
        }
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(83);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(84);
        }
        if (wrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(85);
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)injectedPsi.getProject()).getInjectionHost((PsiElement)injectedPsi);
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        SmartHashSet elementDialectIds = new SmartHashSet();
        LocalInspectionsPass.getElementsAndDialectsFrom(injectedPsi, elements, (Set<String>)elementDialectIds);
        if (elements.isEmpty()) {
            return;
        }
        Map<LocalInspectionToolWrapper, Set<String>> toolToSpecifiedLanguageIds = InspectionEngine.getToolsToSpecifiedLanguages(wrappers);
        for (Map.Entry<LocalInspectionToolWrapper, Set<String>> pair : toolToSpecifiedLanguageIds.entrySet()) {
            ProgressManager.checkCanceled();
            final LocalInspectionToolWrapper wrapper = pair.getKey();
            LocalInspectionTool tool = (LocalInspectionTool)wrapper.getTool();
            if (host != null && this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed((PsiElement)host, tool)) continue;
            ProblemsHolder holder = new ProblemsHolder(iManager, injectedPsi, isOnTheFly){

                public void registerProblem(@NotNull ProblemDescriptor descriptor) {
                    if (descriptor == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    super.registerProblem(descriptor);
                    if (isOnTheFly && inVisibleRange) {
                        LocalInspectionsPass.this.addDescriptorIncrementally(descriptor, wrapper, indicator);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$5", "registerProblem"));
                }
            };
            LocalInspectionToolSession injSession = new LocalInspectionToolSession(injectedPsi, 0, injectedPsi.getTextLength());
            Set<String> dialectIdsSpecifiedForTool = pair.getValue();
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, injSession, elements, (Set<String>)elementDialectIds, dialectIdsSpecifiedForTool);
            tool.inspectionFinished(injSession, holder);
            List problems = holder.getResults();
            if (problems.isEmpty()) continue;
            this.appendDescriptors(injectedPsi, problems, wrapper);
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list2 = this.myInfos;
        if (list2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(86);
        }
        return list2;
    }

    private static /* synthetic */ void lambda$inspectInjectedPsi$5(Set injected, PsiFile injectedPsi, List places) {
        injected.add(injectedPsi);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 22: 
            case 81: 
            case 86: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 22: 
            case 81: 
            case 86: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 3: 
            case 22: 
            case 81: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 17: 
            case 24: 
            case 37: 
            case 84: 
            case 88: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iManager";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 8: 
            case 23: 
            case 57: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 9: 
            case 43: 
            case 59: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolToSpecifiedLanguageIds";
                break;
            }
            case 18: 
            case 25: 
            case 30: 
            case 36: 
            case 45: 
            case 83: 
            case 87: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 19: 
            case 26: 
            case 31: 
            case 35: 
            case 90: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 20: 
            case 27: 
            case 32: 
            case 92: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 21: 
            case 29: 
            case 34: 
            case 91: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDialectIds";
                break;
            }
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "init";
                break;
            }
            case 38: 
            case 85: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 42: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 44: 
            case 48: 
            case 70: 
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 51: 
            case 52: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outInfos";
                break;
            }
            case 53: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyActionRegistered";
                break;
            }
            case 54: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ilManager";
                break;
            }
            case 56: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentRange";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 60: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outElements";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialects";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPriorityElementsAndInit";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionTools";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 22: 
            case 81: 
            case 86: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doInspectInBatch";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptorsFromInjectedResults";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitPriorityElementsAndInit";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "runToolOnElements";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitRestElementsAndCleanup";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "inspectInjectedPsi";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "highlightInfoFromDescriptor";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptorIncrementally";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "appendDescriptors";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "appendResult";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addHighlightsFromResults";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightsForDescriptor";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "injectToHost";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFileInBaseLanguage";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "showToolDescription";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "registerQuickFixes";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getElementsAndDialectsFrom";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionTools";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "doInspectInjectedPsi";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$inspectInjectedPsi$6";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visitRestElementsAndCleanup$4";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visitPriorityElementsAndInit$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 22: 
            case 81: 
            case 86: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InspectionContext {
        @NotNull
        private final LocalInspectionToolWrapper tool;
        @NotNull
        private final ProblemsHolder holder;
        private final int problemsSize;
        @NotNull
        private final PsiElementVisitor visitor;
        @Nullable
        private final Set<String> dialectIdsSpecifiedForTool;

        private InspectionContext(@NotNull LocalInspectionToolWrapper tool, @NotNull ProblemsHolder holder, int problemsSize, @NotNull PsiElementVisitor visitor, @Nullable Set<String> dialectIdsSpecifiedForTool) {
            if (tool == null) {
                InspectionContext.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                InspectionContext.$$$reportNull$$$0(1);
            }
            if (visitor == null) {
                InspectionContext.$$$reportNull$$$0(2);
            }
            this.tool = tool;
            this.holder = holder;
            this.problemsSize = problemsSize;
            this.visitor = visitor;
            this.dialectIdsSpecifiedForTool = dialectIdsSpecifiedForTool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "visitor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InspectionResult {
        @NotNull
        private final LocalInspectionToolWrapper tool;
        @NotNull
        private final List<ProblemDescriptor> foundProblems;

        private InspectionResult(@NotNull LocalInspectionToolWrapper tool, @NotNull List<ProblemDescriptor> foundProblems) {
            if (tool == null) {
                InspectionResult.$$$reportNull$$$0(0);
            }
            if (foundProblems == null) {
                InspectionResult.$$$reportNull$$$0(1);
            }
            this.tool = tool;
            this.foundProblems = new ArrayList<ProblemDescriptor>(foundProblems);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "foundProblems";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

