/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SmartEnterAction
extends EditorAction {
    public SmartEnterAction() {
        super((EditorActionHandler)new Handler());
        this.setInjectedContext(true);
    }

    public static void plainEnter(Editor editor, Caret caret, DataContext dataContext) {
        SmartEnterAction.getEnterHandler().execute(editor, caret, dataContext);
    }

    private static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            return SmartEnterAction.getEnterHandler().isEnabled(editor, caret, dataContext);
        }

        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            List processors;
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null || editor.isOneLineMode()) {
                SmartEnterAction.plainEnter(editor, caret, dataContext);
                return;
            }
            LookupManager.getInstance(project).hideActiveLookup();
            TemplateState state = TemplateManagerImpl.getTemplateState(editor);
            if (state != null) {
                state.gotoEnd();
            }
            int caretOffset = editor.getCaretModel().getOffset();
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            if (psiFile == null) {
                SmartEnterAction.plainEnter(editor, caret, dataContext);
                return;
            }
            if (EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace(editor, caretOffset, psiFile.getFileType())) {
                EditorActionHandler enterHandler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
                enterHandler.execute(editor, caret, dataContext);
                return;
            }
            Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project);
            boolean processed2 = false;
            if (language != null && !(processors = SmartEnterProcessors.INSTANCE.allForLanguage(language)).isEmpty()) {
                for (SmartEnterProcessor processor2 : processors) {
                    if (!processor2.process(project, editor, psiFile)) continue;
                    processed2 = true;
                    break;
                }
            }
            if (!processed2) {
                SmartEnterAction.plainEnter(editor, caret, dataContext);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/editorActions/smartEnter/SmartEnterAction$Handler";
            objectArray[2] = "isEnabledForCaret";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

