/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.PopupActionsKt;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsConfigurable;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/hints/ShowSettingsWithAddedPattern;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.lang.impl"})
public final class ShowSettingsWithAddedPattern
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        String string;
        HintInfo info;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (psiFile == null) {
            return;
        }
        PsiFile file2 = psiFile;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        int offset = editor2.getCaretModel().getOffset();
        PsiFile psiFile2 = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"file");
        Editor editor3 = editor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor");
        HintInfo hintInfo = PopupActionsKt.access$getHintInfoFromProvider(offset, psiFile2, editor3);
        if (hintInfo == null) {
            return;
        }
        HintInfo hintInfo2 = info = hintInfo;
        if (hintInfo2 instanceof HintInfo.OptionInfo) {
            string = "Show Hints Settings...";
        } else if (hintInfo2 instanceof HintInfo.MethodInfo) {
            string = CodeInsightBundle.message((String)"inlay.hints.show.settings", (Object[])new Object[]{((HintInfo.MethodInfo)info).getMethodName()});
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String text = string;
        e.getPresentation().setText(text, false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        HintInfo.MethodInfo methodInfo;
        String string;
        HintInfo info;
        Language fileLanguage;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (psiFile == null) {
            return;
        }
        PsiFile file2 = psiFile;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Language language = file2.getLanguage().getBaseLanguage();
        if (language == null) {
            language = fileLanguage = file2.getLanguage();
        }
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(fileLanguage) == null) {
            return;
        }
        int offset = editor2.getCaretModel().getOffset();
        PsiFile psiFile2 = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"file");
        Editor editor3 = editor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor");
        HintInfo hintInfo = PopupActionsKt.access$getHintInfoFromProvider(offset, psiFile2, editor3);
        if (hintInfo == null) {
            return;
        }
        HintInfo hintInfo2 = info = hintInfo;
        if (hintInfo2 instanceof HintInfo.OptionInfo) {
            string = null;
        } else if (hintInfo2 instanceof HintInfo.MethodInfo) {
            string = PopupActionsKt.toPattern((HintInfo.MethodInfo)info);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String newPreselectedPattern = string;
        HintInfo hintInfo3 = info;
        if (!(hintInfo3 instanceof HintInfo.MethodInfo)) {
            hintInfo3 = null;
        }
        if ((methodInfo = (HintInfo.MethodInfo)hintInfo3) == null || (methodInfo = methodInfo.getLanguage()) == null) {
            Language language2 = fileLanguage;
            methodInfo = language2;
            Intrinsics.checkExpressionValueIsNotNull((Object)language2, (String)"fileLanguage");
        }
        HintInfo.MethodInfo selectedLanguage = methodInfo;
        ParameterNameHintsConfigurable dialog2 = new ParameterNameHintsConfigurable((Language)selectedLanguage, newPreselectedPattern);
        dialog2.show();
    }

    public ShowSettingsWithAddedPattern() {
        this.getTemplatePresentation().setDescription(CodeInsightBundle.message((String)"inlay.hints.show.settings.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setText(CodeInsightBundle.message((String)"inlay.hints.show.settings", (Object[])new Object[]{"_"}));
    }
}

