/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorComposer;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultInspectionToolPresentation
implements InspectionToolPresentation {
    protected static final Logger LOG = Logger.getInstance(DefaultInspectionToolPresentation.class);
    @NotNull
    private final InspectionToolWrapper myToolWrapper;
    @NotNull
    private final GlobalInspectionContextImpl myContext;
    protected InspectionNode myToolNode;
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myProblemElements;
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> mySuppressedElements;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myResolvedElements;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myExcludedElements;
    protected final Map<String, Set<RefEntity>> myContents;
    private DescriptorComposer myComposer;
    private volatile boolean isDisposed;

    public DefaultInspectionToolPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        if (toolWrapper == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(1);
        }
        this.myProblemElements = DefaultInspectionToolPresentation.createBidiMap();
        this.mySuppressedElements = DefaultInspectionToolPresentation.createBidiMap();
        this.myResolvedElements = DefaultInspectionToolPresentation.createBidiMap();
        this.myExcludedElements = DefaultInspectionToolPresentation.createBidiMap();
        this.myContents = Collections.synchronizedMap(new HashMap(1));
        this.myToolWrapper = toolWrapper;
        this.myContext = context;
    }

    public void resolveProblem(@NotNull CommonProblemDescriptor descriptor) {
        RefEntity entity;
        if (descriptor == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(2);
        }
        if ((entity = this.myProblemElements.removeValue(descriptor)) != null) {
            this.myResolvedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor});
        }
    }

    @Override
    public boolean isProblemResolved(@Nullable CommonProblemDescriptor descriptor) {
        return this.myResolvedElements.containsValue(descriptor);
    }

    @Override
    public boolean isProblemResolved(@Nullable RefEntity entity) {
        return this.myResolvedElements.containsKey(entity);
    }

    @Override
    @NotNull
    public Collection<RefEntity> getResolvedElements() {
        Collection<RefEntity> collection = this.myResolvedElements.keys();
        if (collection == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public CommonProblemDescriptor[] getResolvedProblems(@NotNull RefEntity entity) {
        if (entity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(4);
        }
        CommonProblemDescriptor[] commonProblemDescriptorArray = this.myResolvedElements.getOrDefault(entity, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY);
        if (commonProblemDescriptorArray == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(5);
        }
        return commonProblemDescriptorArray;
    }

    @Override
    public void suppressProblem(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(6);
        }
        this.mySuppressedElements.put(this.myProblemElements.removeValue(descriptor), (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor});
    }

    @Override
    public void suppressProblem(@NotNull RefEntity entity) {
        CommonProblemDescriptor[] removed;
        if (entity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(7);
        }
        if ((removed = this.myProblemElements.remove(entity)) != null) {
            this.mySuppressedElements.put(entity, (CommonProblemDescriptor[])removed);
        }
    }

    @Override
    public boolean isSuppressed(RefEntity element) {
        return this.mySuppressedElements.containsKey(element);
    }

    @Override
    public boolean isSuppressed(CommonProblemDescriptor descriptor) {
        return this.mySuppressedElements.containsValue(descriptor);
    }

    @Override
    @NotNull
    public CommonProblemDescriptor[] getSuppressedProblems(@NotNull RefEntity entity) {
        if (entity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(8);
        }
        CommonProblemDescriptor[] commonProblemDescriptorArray = this.mySuppressedElements.getOrDefault(entity, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY);
        if (commonProblemDescriptorArray == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(9);
        }
        return commonProblemDescriptorArray;
    }

    @Override
    @Nullable
    public HighlightSeverity getSeverity(@NotNull RefElement element) {
        PsiFile psiElement;
        if (element == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(10);
        }
        if ((psiElement = ((RefElement)element.getRefManager().getRefinedElement((RefEntity)element)).getPointer().getContainingFile()) != null) {
            GlobalInspectionContextImpl context = this.getContext();
            String shortName = this.getSeverityDelegateName();
            Tools tools = context.getTools().get(shortName);
            if (tools != null) {
                for (ScopeToolState state : tools.getTools()) {
                    InspectionToolWrapper toolWrapper = state.getTool();
                    if (toolWrapper != this.getToolWrapper()) continue;
                    return context.getCurrentProfile().getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement).getSeverity();
                }
            }
            InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(context.getProject()).getCurrentProfile();
            HighlightDisplayLevel level = profile2.getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement);
            return level.getSeverity();
        }
        return null;
    }

    @Override
    public boolean isExcluded(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(11);
        }
        return this.myExcludedElements.containsValue(descriptor);
    }

    @Override
    public boolean isExcluded(@NotNull RefEntity entity) {
        if (entity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(12);
        }
        return Comparing.equal((Object[])this.myExcludedElements.get(entity), (Object[])this.myProblemElements.get(entity));
    }

    @Override
    public void amnesty(@NotNull RefEntity element) {
        if (element == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(13);
        }
        this.myExcludedElements.remove(element);
    }

    @Override
    public void exclude(@NotNull RefEntity element) {
        if (element == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(14);
        }
        this.myExcludedElements.put(element, (CommonProblemDescriptor[])this.myProblemElements.getOrDefault(element, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY));
    }

    @Override
    public void amnesty(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(15);
        }
        this.myExcludedElements.removeValue(descriptor);
    }

    @Override
    public void exclude(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(16);
        }
        RefEntity entity = (RefEntity)ObjectUtils.notNull((Object)this.myProblemElements.getKeyFor(descriptor), () -> {
            if (descriptor == null) {
                DefaultInspectionToolPresentation.$$$reportNull$$$0(52);
            }
            return this.myResolvedElements.getKeyFor(descriptor);
        });
        this.myExcludedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor});
    }

    protected String getSeverityDelegateName() {
        return this.getToolWrapper().getShortName();
    }

    protected static String getTextAttributeKey(@NotNull Project project, @NotNull HighlightSeverity severity, @NotNull ProblemHighlightType highlightType) {
        if (project == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(17);
        }
        if (severity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(18);
        }
        if (highlightType == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(19);
        }
        if (highlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            return HighlightInfoType.DEPRECATED.getAttributesKey().getExternalName();
        }
        if (highlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL && severity == HighlightSeverity.ERROR) {
            return HighlightInfoType.WRONG_REF.getAttributesKey().getExternalName();
        }
        if (highlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            return HighlightInfoType.UNUSED_SYMBOL.getAttributesKey().getExternalName();
        }
        SeverityRegistrar registrar = ProjectInspectionProfileManager.getInstance(project).getSeverityRegistrar();
        return registrar.getHighlightInfoTypeBySeverity(severity).getAttributesKey().getExternalName();
    }

    @Override
    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        InspectionToolWrapper inspectionToolWrapper = this.myToolWrapper;
        if (inspectionToolWrapper == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(20);
        }
        return inspectionToolWrapper;
    }

    @NotNull
    public RefManager getRefManager() {
        RefManager refManager = this.getContext().getRefManager();
        if (refManager == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(21);
        }
        return refManager;
    }

    @Override
    @NotNull
    public GlobalInspectionContextImpl getContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myContext;
        if (globalInspectionContextImpl == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(22);
        }
        return globalInspectionContextImpl;
    }

    @Override
    public void exportResults(final @NotNull Element parentNode, final @NotNull Predicate<RefEntity> excludedEntities, final @NotNull Predicate<CommonProblemDescriptor> excludedDescriptors) {
        if (parentNode == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(23);
        }
        if (excludedEntities == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(24);
        }
        if (excludedDescriptors == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(25);
        }
        this.getRefManager().iterate(new RefVisitor(){

            public void visitElement(@NotNull RefEntity elem) {
                if (elem == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!excludedEntities.test(elem)) {
                    DefaultInspectionToolPresentation.this.exportResults(parentNode, elem, (Predicate<CommonProblemDescriptor>)excludedDescriptors);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation$1", "visitElement"));
            }
        });
    }

    public void addProblemElement(@Nullable RefEntity refElement, CommonProblemDescriptor ... descriptions) {
        if (descriptions == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(26);
        }
        this.addProblemElement(refElement, true, descriptions);
    }

    @Override
    public void addProblemElement(@Nullable RefEntity refElement, boolean filterSuppressed, CommonProblemDescriptor ... descriptors) {
        if (descriptors == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(27);
        }
        if (refElement == null) {
            return;
        }
        if (descriptors.length == 0) {
            return;
        }
        if (filterSuppressed) {
            if (this.myContext.getOutputPath() == null || !(this.myToolWrapper instanceof LocalInspectionToolWrapper)) {
                this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors);
            } else {
                this.writeOutput(descriptors, refElement);
            }
        } else {
            this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors);
        }
        GlobalInspectionContextImpl context = this.getContext();
        if (context.isViewClosed() || !(refElement instanceof RefElement)) {
            return;
        }
        if (this.myToolWrapper instanceof LocalInspectionToolWrapper && (!ApplicationManager.getApplication().isUnitTestMode() || GlobalInspectionContextImpl.CREATE_VIEW_FORCE)) {
            context.initializeViewIfNeed().doWhenDone(() -> {
                if (descriptors == null) {
                    DefaultInspectionToolPresentation.$$$reportNull$$$0(51);
                }
                context.getView().addProblemDescriptors(this.myToolWrapper, refElement, descriptors);
            });
        }
    }

    @Override
    public InspectionNode getToolNode() {
        return this.myToolNode;
    }

    protected boolean isDisposed() {
        return this.isDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeOutput(@NotNull CommonProblemDescriptor[] descriptions, @NotNull RefEntity refElement) {
        if (descriptions == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(28);
        }
        if (refElement == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(29);
        }
        Element parentNode = new Element(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]));
        this.exportResults(descriptions, refElement, parentNode, d -> false);
        List list2 = parentNode.getChildren();
        String ext = ".xml";
        String fileName = this.myContext.getOutputPath() + File.separator + this.myToolWrapper.getShortName() + ".xml";
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)this.getContext().getProject());
        try (PrintWriter printWriter = null;){
            FileUtil.createDirectory((File)new File(this.myContext.getOutputPath()));
            File file2 = new File(fileName);
            StringWriter writer = new StringWriter();
            if (!file2.exists()) {
                writer.append("<").append(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0])).append(" is_local_tool=\"").append(Boolean.toString(this.myToolWrapper instanceof LocalInspectionToolWrapper)).append("\">\n");
            }
            for (Element element : list2) {
                pathMacroManager.collapsePaths(element);
                JDOMUtil.writeElement((Element)element, (Writer)writer, (String)"\n");
            }
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, true), CharsetToolkit.UTF8_CHARSET)));
            printWriter.append("\n");
            printWriter.append(writer.toString());
        }
    }

    @Override
    @NotNull
    public Collection<CommonProblemDescriptor> getProblemDescriptors() {
        Collection<CommonProblemDescriptor> collection = this.myProblemElements.getValues();
        if (collection == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(30);
        }
        return collection;
    }

    public void ignoreElement(@NotNull RefEntity refEntity) {
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(31);
        }
        this.myProblemElements.remove(refEntity);
    }

    @Override
    public void cleanup() {
        this.isDisposed = true;
    }

    @Nullable
    public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] problems;
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(32);
        }
        if ((problems = this.getProblemElements().getOrDefault(refEntity, null)) == null) {
            return null;
        }
        if (!refEntity.isValid()) {
            this.ignoreElement(refEntity);
            return null;
        }
        return problems;
    }

    @Override
    @NotNull
    public HTMLComposerImpl getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DescriptorComposer(this);
        }
        DescriptorComposer descriptorComposer = this.myComposer;
        if (descriptorComposer == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(33);
        }
        return descriptorComposer;
    }

    @Override
    public void exportResults(@NotNull Element parentNode, @NotNull RefEntity refEntity, @NotNull Predicate<CommonProblemDescriptor> isDescriptorExcluded) {
        CommonProblemDescriptor[] descriptions;
        if (parentNode == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(34);
        }
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(35);
        }
        if (isDescriptorExcluded == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(36);
        }
        if ((descriptions = this.getProblemElements().get(refEntity)) != null) {
            this.exportResults(descriptions, refEntity, parentNode, isDescriptorExcluded);
        }
    }

    private void exportResults(@NotNull CommonProblemDescriptor[] descriptors, @NotNull RefEntity refEntity, @NotNull Element parentNode, @NotNull Predicate<CommonProblemDescriptor> isDescriptorExcluded) {
        if (descriptors == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(37);
        }
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(38);
        }
        if (parentNode == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(39);
        }
        if (isDescriptorExcluded == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(40);
        }
        for (CommonProblemDescriptor descriptor : descriptors) {
            if (isDescriptorExcluded.test(descriptor)) continue;
            String template = descriptor.getDescriptionTemplate();
            int line = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getLineNumber() : -1;
            PsiElement psiElement = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
            String problemText = StringUtil.replace((String)StringUtil.replace((String)template, (String)"#ref", (String)(psiElement != null ? ProblemDescriptorUtil.extractHighlightedText(descriptor, psiElement) : "")), (String)" #loc ", (String)" ");
            Element element = refEntity.getRefManager().export(refEntity, parentNode, line);
            if (element == null) {
                return;
            }
            Element problemClassElement = new Element(InspectionsBundle.message((String)"inspection.export.results.problem.element.tag", (Object[])new Object[0]));
            problemClassElement.addContent(this.myToolWrapper.getDisplayName());
            HighlightSeverity severity = InspectionToolPresentation.getSeverity(refEntity, psiElement, this);
            if (severity != null) {
                ProblemHighlightType problemHighlightType = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getHighlightType() : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String attributeKey = DefaultInspectionToolPresentation.getTextAttributeKey(this.getRefManager().getProject(), severity, problemHighlightType);
                problemClassElement.setAttribute("severity", severity.myName);
                problemClassElement.setAttribute("attribute_key", attributeKey);
            }
            element.addContent(problemClassElement);
            if (this.myToolWrapper instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionTool globalInspectionTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)this.myToolWrapper).getTool();
                QuickFix[] fixes = descriptor.getFixes();
                if (fixes != null) {
                    Element hintsElement = new Element("hints");
                    for (QuickFix fix : fixes) {
                        String hint = globalInspectionTool.getHint(fix);
                        if (hint == null) continue;
                        Element hintElement = new Element("hint");
                        hintElement.setAttribute("value", hint);
                        hintsElement.addContent(hintElement);
                    }
                    element.addContent(hintsElement);
                }
            }
            try {
                Element descriptionElement = new Element(InspectionsBundle.message((String)"inspection.export.results.description.tag", (Object[])new Object[0]));
                descriptionElement.addContent(problemText);
                element.addContent(descriptionElement);
            }
            catch (IllegalDataException e) {
                System.out.println("Cannot save results for " + refEntity.getName() + ", inspection which caused problem: " + this.myToolWrapper.getShortName());
            }
        }
    }

    @Override
    public synchronized boolean hasReportedProblems() {
        return !this.myContents.isEmpty();
    }

    @Override
    public synchronized void updateContent() {
        this.myContents.clear();
        this.updateProblemElements();
    }

    protected void updateProblemElements() {
        Object elements;
        if (this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS) {
            elements = this.getProblemElements().keys().stream().filter(entity -> !this.isExcluded((RefEntity)entity)).collect(Collectors.toSet());
        } else {
            elements = new THashSet(this.getProblemElements().keys());
            elements.addAll(this.getResolvedElements());
            elements.addAll(this.mySuppressedElements.keys());
        }
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            RefEntity element = (RefEntity)iterator.next();
            String groupName = element instanceof RefElement ? element.getRefManager().getGroupName((RefElement)element) : element.getQualifiedName();
            this.registerContentEntry(element, groupName);
        }
    }

    protected void registerContentEntry(RefEntity element, String packageName) {
        Set content = this.myContents.computeIfAbsent(packageName, k -> new HashSet());
        content.add(element);
    }

    @Override
    @NotNull
    public Map<String, Set<RefEntity>> getContent() {
        Map<String, Set<RefEntity>> map = this.myContents;
        if (map == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(41);
        }
        return map;
    }

    @Override
    @NotNull
    public QuickFixAction[] getQuickFixes(RefEntity ... refElements) {
        if (refElements == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(42);
        }
        if (QuickFixAction.EMPTY == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(43);
        }
        return QuickFixAction.EMPTY;
    }

    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(44);
        }
        return this.myProblemElements.getKeyFor(descriptor);
    }

    @Override
    @NotNull
    public SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> getProblemElements() {
        SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> synchronizedBidiMultiMap = this.myProblemElements;
        if (synchronizedBidiMultiMap == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(45);
        }
        return synchronizedBidiMultiMap;
    }

    @Override
    public void createToolNode(@NotNull GlobalInspectionContextImpl globalInspectionContext, @NotNull InspectionNode node, @NotNull InspectionRVContentProvider provider, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity) {
        if (globalInspectionContext == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(46);
        }
        if (node == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(47);
        }
        if (provider == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(48);
        }
        if (parentNode == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(49);
        }
        this.myToolNode = node;
    }

    @Override
    @Nullable
    public IntentionAction findQuickFixes(final @NotNull CommonProblemDescriptor problemDescriptor, String hint) {
        InspectionProfileEntry tool;
        if (problemDescriptor == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(50);
        }
        if (!((tool = this.getToolWrapper().getTool()) instanceof GlobalInspectionTool)) {
            return null;
        }
        final QuickFix fix = ((GlobalInspectionTool)tool).getQuickFix(hint);
        if (fix == null) {
            return null;
        }
        if (problemDescriptor instanceof ProblemDescriptor) {
            ProblemDescriptorImpl descriptor = new ProblemDescriptorImpl(((ProblemDescriptor)problemDescriptor).getStartElement(), ((ProblemDescriptor)problemDescriptor).getEndElement(), problemDescriptor.getDescriptionTemplate(), new LocalQuickFix[]{(LocalQuickFix)fix}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false);
            return QuickFixWrapper.wrap(descriptor, 0);
        }
        return new IntentionAction(){

            @NotNull
            public String getText() {
                String string = fix.getName();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = fix.getFamilyName();
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
                if (project == null) {
                    2.$$$reportNull$$$0(3);
                }
                fix.applyFix(project, problemDescriptor);
            }

            public boolean startInWriteAction() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> createBidiMap() {
        return new SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor>(){

            @Override
            @NotNull
            protected ArrayFactory<CommonProblemDescriptor> arrayFactory() {
                ArrayFactory arrayFactory = CommonProblemDescriptor[]::new;
                if (arrayFactory == null) {
                    3.$$$reportNull$$$0(0);
                }
                return arrayFactory;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation$3", "arrayFactory"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 33: 
            case 41: 
            case 43: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 33: 
            case 41: 
            case 43: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 15: 
            case 16: 
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 33: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 23: 
            case 34: 
            case 39: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedEntities";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDescriptors";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 27: 
            case 37: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 31: 
            case 32: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isDescriptorExcluded";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElements";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedProblems";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressedProblems";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWrapper";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefManager";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemDescriptors";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposer";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveProblem";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 33: 
            case 41: 
            case 43: 
            case 45: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedProblems";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suppressProblem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedProblems";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "amnesty";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributeKey";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "exportResults";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addProblemElement";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "writeOutput";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "ignoreElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createToolNode";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findQuickFixes";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addProblemElement$1";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$exclude$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 33: 
            case 41: 
            case 43: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

