/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offlineViewer.OfflineInspectionRVContentProvider;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.CloseAction;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionNodeInfo;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsViewUtil;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionViewChangeAdapter;
import com.intellij.codeInspection.ui.InspectionViewNavigationPanel;
import com.intellij.codeInspection.ui.InspectionViewSuppressActionHolder;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.ProblemPreviewEditorPresentation;
import com.intellij.codeInspection.ui.QuickFixPreviewPanelFactory;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.RerunAction;
import com.intellij.codeInspection.ui.actions.ExportHTMLAction;
import com.intellij.codeInspection.ui.actions.InvokeQuickFixAction;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SmartExpander;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionResultsView
extends JPanel
implements Disposable,
DataProvider,
OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance(InspectionResultsView.class);
    public static final DataKey<InspectionResultsView> DATA_KEY = DataKey.create((String)"inspectionView");
    private static final Key<Boolean> PREVIEW_EDITOR_IS_REUSED_KEY = Key.create((String)"inspection.tool.window.preview.editor.is.reused");
    @NotNull
    private final InspectionTree myTree;
    @NotNull
    private final OccurenceNavigator myOccurenceNavigator;
    private volatile InspectionProfileImpl myInspectionProfile;
    private final boolean mySettingsEnabled;
    @NotNull
    private final AnalysisScope myScope;
    @NonNls
    public static final String HELP_ID = "reference.toolWindows.inspections";
    private final Splitter mySplitter;
    @NotNull
    private final GlobalInspectionContextImpl myGlobalInspectionContext;
    private boolean myRerun;
    private volatile boolean myDisposed;
    private int myUpdatingRequestors;
    private boolean myApplyingFix;
    @NotNull
    private final InspectionRVContentProvider myProvider;
    @NotNull
    private final ExclusionHandler<InspectionTreeNode> myExclusionHandler;
    private EditorEx myPreviewEditor;
    private InspectionTreeLoadingProgressAware myLoadingProgressPreview;
    private final InspectionViewSuppressActionHolder mySuppressActionHolder;
    private final Object myTreeStructureUpdateLock;
    private final ExecutorService myTreeUpdater;

    public InspectionResultsView(@NotNull GlobalInspectionContextImpl globalInspectionContext, @NotNull InspectionRVContentProvider provider) {
        String toolId;
        InspectionProfileImpl profile2;
        InspectionToolWrapper tool;
        JComponent toolPanel;
        if (globalInspectionContext == null) {
            InspectionResultsView.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            InspectionResultsView.$$$reportNull$$$0(1);
        }
        this.mySuppressActionHolder = new InspectionViewSuppressActionHolder();
        this.myTreeStructureUpdateLock = new Object();
        this.myTreeUpdater = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"inspection-view-tree-updater", (int)1);
        this.setLayout(new BorderLayout());
        this.myInspectionProfile = globalInspectionContext.getCurrentProfile();
        this.myScope = globalInspectionContext.getCurrentScope();
        this.myGlobalInspectionContext = globalInspectionContext;
        this.myProvider = provider;
        this.myTree = new InspectionTree(globalInspectionContext, this);
        this.initTreeListeners();
        this.myOccurenceNavigator = this.initOccurenceNavigator();
        this.mySplitter = new OnePixelSplitter(false, AnalysisUIOptions.getInstance((Project)globalInspectionContext.getProject()).SPLITTER_PROPORTION);
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)1));
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.mySplitter.addPropertyChangeListener(evt -> {
            if ("proportion".equals(evt.getPropertyName())) {
                this.myGlobalInspectionContext.setSplitterProportion(((Float)evt.getNewValue()).floatValue());
            }
        });
        this.add((Component)this.mySplitter, "Center");
        this.myExclusionHandler = new ExclusionHandler<InspectionTreeNode>(){

            public boolean isNodeExclusionAvailable(@NotNull InspectionTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            public boolean isNodeExcluded(@NotNull InspectionTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                return node.isExcluded();
            }

            public void excludeNode(@NotNull InspectionTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                node.excludeElement();
            }

            public void includeNode(@NotNull InspectionTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                node.amnestyElement();
            }

            public boolean isActionEnabled(boolean isExcludeAction) {
                return isExcludeAction || !((InspectionResultsView)InspectionResultsView.this).myGlobalInspectionContext.getUIOptions().FILTER_RESOLVED_ITEMS;
            }

            public void onDone(boolean isExcludeAction) {
                if (isExcludeAction) {
                    if (((InspectionResultsView)InspectionResultsView.this).myGlobalInspectionContext.getUIOptions().FILTER_RESOLVED_ITEMS) {
                        InspectionResultsView.this.removeSelectedNodes();
                    }
                    InspectionResultsView.this.myTree.repaint();
                } else {
                    InspectionResultsView.this.resetTree();
                }
                InspectionResultsView.this.syncRightPanel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionResultsView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExclusionAvailable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExcluded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "excludeNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "includeNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.createActionsToolbar();
        PsiManager.getInstance((Project)this.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)new InspectionViewChangeAdapter(this), (Disposable)this);
        final ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance(this.getProject());
        profileManager.addProfileChangeListener(new ProfileChangeAdapter(){

            public void profileChanged(InspectionProfile profile2) {
                if (profile2 == profileManager.getCurrentProfile()) {
                    InspectionResultsView.this.profileChanged();
                }
            }
        }, this);
        this.mySettingsEnabled = !this.isSingleInspectionRun() ? true : (toolPanel = (tool = (InspectionToolWrapper)ObjectUtils.notNull((Object)(profile2 = this.getCurrentProfile()).getInspectionTool(toolId = (String)ObjectUtils.notNull((Object)profile2.getSingleTool()), this.getProject()))).getTool().createOptionsPanel()) != null;
    }

    void profileChanged() {
        this.myTree.revalidate();
        this.myTree.repaint();
        this.syncRightPanel();
    }

    private void initTreeListeners() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myTree.getSelectionModel().addTreeSelectionListener(e -> {
            if (this.myTree.isUnderQueueUpdate()) {
                return;
            }
            this.syncRightPanel();
            if (this.isAutoScrollMode()) {
                OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)this), (boolean)false);
            }
        });
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)InspectionResultsView.this), (boolean)false);
                }
            }
        });
        PopupHandler.installPopupHandler((JComponent)((Object)this.myTree), (String)"InspectionToolWindow.TreePopup", (String)"CodeInspection");
        SmartExpander.installOn((JTree)((Object)this.myTree));
    }

    private OccurenceNavigatorSupport initOccurenceNavigator() {
        return new OccurenceNavigatorSupport((JTree)((Object)this.myTree)){

            @Nullable
            protected Navigatable createDescriptorForNode(DefaultMutableTreeNode node) {
                if (node instanceof InspectionTreeNode && ((InspectionTreeNode)node).isExcluded()) {
                    return null;
                }
                if (node instanceof RefElementNode) {
                    RefElementNode refNode = (RefElementNode)node;
                    if (refNode.hasDescriptorsUnder()) {
                        return null;
                    }
                    RefEntity element = refNode.getElement();
                    if (element == null || !element.isValid()) {
                        return null;
                    }
                    CommonProblemDescriptor problem = refNode.getDescriptor();
                    if (problem != null) {
                        return this.navigate(problem);
                    }
                    if (element instanceof RefElement) {
                        return InspectionResultsView.getOpenFileDescriptor((RefElement)element);
                    }
                } else if (node instanceof ProblemDescriptionNode) {
                    boolean isValid = ((ProblemDescriptionNode)node).isValid() ? (((ProblemDescriptionNode)node).isQuickFixAppliedFromView() ? ((ProblemDescriptionNode)node).calculateIsValid() : true) : false;
                    return isValid ? this.navigate(((ProblemDescriptionNode)node).getDescriptor()) : InspectionResultsViewUtil.getNavigatableForInvalidNode((ProblemDescriptionNode)node);
                }
                return null;
            }

            @Nullable
            private Navigatable navigate(CommonProblemDescriptor descriptor) {
                return InspectionResultsView.this.getSelectedNavigatable(descriptor);
            }

            public String getNextOccurenceActionName() {
                return InspectionsBundle.message((String)"inspection.action.go.next", (Object[])new Object[0]);
            }

            public String getPreviousOccurenceActionName() {
                return InspectionsBundle.message((String)"inspection.action.go.prev", (Object[])new Object[0]);
            }
        };
    }

    private void createActionsToolbar() {
        BorderLayoutPanel westPanel = JBUI.Panels.simplePanel().addToLeft((Component)this.createLeftActionsToolbar()).addToRight((Component)this.createRightActionsToolbar());
        this.add((Component)westPanel, "West");
    }

    private JComponent createRightActionsToolbar() {
        DefaultActionGroup specialGroup = new DefaultActionGroup();
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupBySeverityAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupByDirectoryAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createFilterResolvedItemsAction(this));
        specialGroup.add((AnAction)this.myGlobalInspectionContext.createToggleAutoscrollAction());
        specialGroup.add((AnAction)new ExportHTMLAction(this));
        specialGroup.add(ActionManager.getInstance().getAction("EditInspectionSettings"));
        specialGroup.add((AnAction)new InvokeQuickFixAction(this));
        return InspectionResultsView.createToolbar(specialGroup);
    }

    private JComponent createLeftActionsToolbar() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RerunAction(this));
        group.add((AnAction)new CloseAction(this.myGlobalInspectionContext));
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)this.myTree));
        group.add(actionsManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        group.add(actionsManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        group.add(actionsManager.createPrevOccurenceAction(this.myOccurenceNavigator));
        group.add(actionsManager.createNextOccurenceAction(this.myOccurenceNavigator));
        return InspectionResultsView.createToolbar(group);
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator.hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator.goPreviousOccurence();
    }

    public String getNextOccurenceActionName() {
        return this.myOccurenceNavigator.getNextOccurenceActionName();
    }

    public String getPreviousOccurenceActionName() {
        return this.myOccurenceNavigator.getPreviousOccurenceActionName();
    }

    private static JComponent createToolbar(DefaultActionGroup specialGroup) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CodeInspection", (ActionGroup)specialGroup, false);
        return toolbar.getComponent();
    }

    public void dispose() {
        InspectionResultsViewUtil.releaseEditor(this.myPreviewEditor);
        this.mySplitter.dispose();
        this.myInspectionProfile = null;
        this.myDisposed = true;
        if (this.myLoadingProgressPreview != null) {
            Disposer.dispose((Disposable)this.myLoadingProgressPreview);
            this.myLoadingProgressPreview = null;
        }
    }

    private boolean isAutoScrollMode() {
        String activeToolWindowId = ToolWindowManager.getInstance((Project)this.getProject()).getActiveToolWindowId();
        return this.myGlobalInspectionContext.getUIOptions().AUTOSCROLL_TO_SOURCE && (activeToolWindowId == null || activeToolWindowId.equals(ToolWindowId.INSPECTION));
    }

    Object getTreeStructureUpdateLock() {
        return this.myTreeStructureUpdateLock;
    }

    @Nullable
    private static OpenFileDescriptor getOpenFileDescriptor(RefElement refElement) {
        PsiElement psiElement = refElement.getElement();
        if (psiElement == null) {
            return null;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile file2 = containingFile.getVirtualFile();
        if (file2 == null) {
            return null;
        }
        return new OpenFileDescriptor(refElement.getRefManager().getProject(), file2, psiElement.getTextOffset());
    }

    public void setApplyingFix(boolean applyingFix) {
        this.myApplyingFix = applyingFix;
        this.syncRightPanel();
    }

    void openRightPanelIfNeed() {
        if (this.mySplitter.getSecondComponent() == null) {
            this.syncRightPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRightPanel() {
        EditorEx oldEditor = this.myPreviewEditor;
        try {
            if (this.myLoadingProgressPreview != null) {
                Disposer.dispose((Disposable)this.myLoadingProgressPreview);
                this.myLoadingProgressPreview = null;
            }
            if (this.myApplyingFix) {
                InspectionToolWrapper wrapper = this.myTree.getSelectedToolWrapper(true);
                LOG.assertTrue(wrapper != null);
                this.mySplitter.setSecondComponent(InspectionResultsViewUtil.getApplyingFixLabel(wrapper));
            } else if (this.myTree.getSelectionModel().getSelectionCount() != 1) {
                if (this.myTree.getSelectedToolWrapper(true) == null) {
                    this.mySplitter.setSecondComponent((JComponent)InspectionResultsViewUtil.getNothingToShowTextLabel());
                } else {
                    this.showInRightPanel(this.myTree.getCommonSelectedElement());
                }
            } else {
                TreePath pathSelected = this.myTree.getSelectionModel().getLeadSelectionPath();
                if (pathSelected != null) {
                    InspectionTreeNode node = (InspectionTreeNode)pathSelected.getLastPathComponent();
                    if (node instanceof ProblemDescriptionNode) {
                        ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node;
                        this.showInRightPanel(problemNode.getElement());
                    } else if (node instanceof InspectionPackageNode || node instanceof InspectionModuleNode || node instanceof RefElementNode) {
                        this.showInRightPanel(node.getContainingFileLocalEntity());
                    } else if (node instanceof InspectionNode) {
                        if (this.myGlobalInspectionContext.getPresentation(((InspectionNode)node).getToolWrapper()).isDummy()) {
                            this.mySplitter.setSecondComponent((JComponent)InspectionResultsViewUtil.getNothingToShowTextLabel());
                        } else {
                            this.showInRightPanel(null);
                        }
                    } else if (node instanceof InspectionGroupNode || node instanceof InspectionSeverityGroupNode) {
                        InspectionViewNavigationPanel panel2 = new InspectionViewNavigationPanel(node, this.myTree);
                        this.myLoadingProgressPreview = panel2;
                        this.mySplitter.setSecondComponent((JComponent)panel2);
                    } else {
                        LOG.error("Unexpected node: " + node.getClass());
                    }
                }
            }
        }
        finally {
            if (oldEditor != null) {
                if (Boolean.TRUE.equals(oldEditor.getUserData(PREVIEW_EDITOR_IS_REUSED_KEY))) {
                    oldEditor.putUserData(PREVIEW_EDITOR_IS_REUSED_KEY, null);
                } else {
                    InspectionResultsViewUtil.releaseEditor(oldEditor);
                    if (oldEditor == this.myPreviewEditor) {
                        this.myPreviewEditor = null;
                    }
                }
            }
        }
    }

    private void showInRightPanel(@Nullable RefEntity refEntity) {
        JComponent fixToolbar;
        TreePath path;
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BorderLayout());
        int problemCount = this.myTree.getSelectedProblemCount(true);
        JComponent previewPanel = null;
        InspectionToolWrapper tool = this.myTree.getSelectedToolWrapper(true);
        if (tool != null && refEntity != null && refEntity.isValid() && ((path = this.myTree.getSelectionPath()) == null || !(path.getLastPathComponent() instanceof ProblemDescriptionNode))) {
            InspectionToolPresentation presentation = this.myGlobalInspectionContext.getPresentation(tool);
            previewPanel = presentation.getCustomPreviewPanel(refEntity);
        }
        EditorEx previewEditor = null;
        if (previewPanel == null) {
            Pair<JComponent, EditorEx> panelAndEditor = this.createBaseRightComponentFor(problemCount, refEntity);
            previewPanel = (JComponent)panelAndEditor.getFirst();
            previewEditor = (EditorEx)panelAndEditor.getSecond();
        }
        editorPanel.add(previewPanel, "Center");
        if (problemCount > 0 && (fixToolbar = QuickFixPreviewPanelFactory.create(this)) != null) {
            if (fixToolbar instanceof InspectionTreeLoadingProgressAware) {
                this.myLoadingProgressPreview = (InspectionTreeLoadingProgressAware)((Object)fixToolbar);
            }
            if (previewEditor != null) {
                previewPanel.setBorder(IdeBorderFactory.createBorder((int)2));
            }
            editorPanel.add((Component)fixToolbar, "North");
        }
        if (previewEditor != null) {
            ProblemPreviewEditorPresentation.setupFoldingsAndHighlightProblems(previewEditor, this);
        }
        this.mySplitter.setSecondComponent((JComponent)editorPanel);
    }

    private Pair<JComponent, EditorEx> createBaseRightComponentFor(int problemCount, RefEntity selectedEntity) {
        if (selectedEntity instanceof RefElement && selectedEntity.isValid() && !(((RefElement)selectedEntity).getElement() instanceof PsiDirectory)) {
            PsiFile file2;
            Document document;
            PsiElement element;
            CommonProblemDescriptor descriptor;
            CommonProblemDescriptor[] descriptors;
            PsiElement selectedElement = ((RefElement)selectedEntity).getElement();
            if (problemCount == 1 && (descriptors = this.myTree.getSelectedDescriptors()).length != 0 && (descriptor = descriptors[0]) instanceof ProblemDescriptorBase && (element = ((ProblemDescriptorBase)descriptor).getPsiElement()) != null) {
                selectedElement = element;
            }
            if ((document = PsiDocumentManager.getInstance((Project)(file2 = selectedElement.getContainingFile()).getProject()).getDocument(file2)) == null) {
                return Pair.create((Object)InspectionResultsViewUtil.createLabelForText("Can't open preview for '" + file2.getName() + "'"), null);
            }
            if (this.reuseEditorFor(document)) {
                this.myPreviewEditor.putUserData(PREVIEW_EDITOR_IS_REUSED_KEY, true);
                this.myPreviewEditor.getFoldingModel().runBatchFoldingOperation(() -> this.myPreviewEditor.getFoldingModel().clearFoldRegions());
                this.myPreviewEditor.getMarkupModel().removeAllHighlighters();
            } else {
                this.myPreviewEditor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.getProject(), file2.getVirtualFile(), true);
                DiffUtil.setFoldingModelSupport(this.myPreviewEditor);
                EditorSettings settings = this.myPreviewEditor.getSettings();
                settings.setLineNumbersShown(false);
                settings.setFoldingOutlineShown(true);
                settings.setLineMarkerAreaShown(true);
                settings.setGutterIconsShown(false);
                settings.setAdditionalColumnsCount(0);
                settings.setAdditionalLinesCount(0);
                settings.setLeadingWhitespaceShown(true);
                this.myPreviewEditor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, this.myPreviewEditor.getColorsScheme().getDefaultBackground());
                this.myPreviewEditor.getScrollPane().setBorder((Border)JBUI.Borders.empty());
            }
            if (problemCount == 0) {
                this.myPreviewEditor.getScrollingModel().scrollTo(this.myPreviewEditor.offsetToLogicalPosition(selectedElement.getTextOffset()), ScrollType.CENTER_UP);
            }
            this.myPreviewEditor.getComponent().setBorder((Border)JBUI.Borders.empty());
            return Pair.create((Object)this.myPreviewEditor.getComponent(), (Object)this.myPreviewEditor);
        }
        if (selectedEntity == null) {
            return Pair.create((Object)new InspectionNodeInfo(this.myTree, this.getProject()), null);
        }
        if (selectedEntity.isValid()) {
            return Pair.create((Object)InspectionResultsViewUtil.getPreviewIsNotAvailable(selectedEntity), null);
        }
        return Pair.create((Object)InspectionResultsViewUtil.getInvalidEntityLabel(selectedEntity), null);
    }

    private boolean reuseEditorFor(Document document) {
        return this.myPreviewEditor != null && !this.myPreviewEditor.isDisposed() && this.myPreviewEditor.getDocument() == document;
    }

    private void addTool(@NotNull InspectionToolWrapper toolWrapper, HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        if (toolWrapper == null) {
            InspectionResultsView.$$$reportNull$$$0(2);
        }
        InspectionTreeNode parentNode = this.myTree.getToolParentNode(toolWrapper, errorLevel, groupedBySeverity, isSingleInspectionRun);
        InspectionNode toolNode = new InspectionNode(toolWrapper, this.myInspectionProfile);
        boolean showStructure = this.myGlobalInspectionContext.getUIOptions().SHOW_STRUCTURE;
        toolNode = this.myProvider.appendToolNodeContent(this.myGlobalInspectionContext, toolNode, parentNode, showStructure, groupedBySeverity);
        InspectionToolPresentation presentation = this.myGlobalInspectionContext.getPresentation(toolWrapper);
        presentation.createToolNode(this.myGlobalInspectionContext, toolNode, this.myProvider, parentNode, showStructure, groupedBySeverity);
        this.registerActionShortcuts(presentation);
    }

    private void registerActionShortcuts(@NotNull InspectionToolPresentation presentation) {
        if (presentation == null) {
            InspectionResultsView.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (presentation == null) {
                InspectionResultsView.$$$reportNull$$$0(15);
            }
            for (QuickFixAction fix : presentation.getQuickFixes(RefEntity.EMPTY_ELEMENTS_ARRAY)) {
                fix.registerCustomShortcutSet(fix.getShortcutSet(), this);
            }
        });
    }

    public InspectionViewSuppressActionHolder getSuppressActionHolder() {
        return this.mySuppressActionHolder;
    }

    @Nullable
    public String getCurrentProfileName() {
        return this.myInspectionProfile == null ? null : this.myInspectionProfile.getDisplayName();
    }

    public InspectionProfileImpl getCurrentProfile() {
        return this.myInspectionProfile;
    }

    void addProblemDescriptors(InspectionToolWrapper wrapper, RefEntity refElement, CommonProblemDescriptor[] descriptors) {
        this.myTreeUpdater.submit(() -> ReadAction.run(() -> {
            if (!this.isDisposed()) {
                ApplicationManager.getApplication().assertReadAccessAllowed();
                Object object = this.myTreeStructureUpdateLock;
                synchronized (object) {
                    AnalysisUIOptions uiOptions = this.myGlobalInspectionContext.getUIOptions();
                    InspectionToolPresentation presentation = this.myGlobalInspectionContext.getPresentation(wrapper);
                    if (presentation.getToolNode() == null) {
                        presentation.updateContent();
                        this.addTool(wrapper, HighlightDisplayLevel.find((HighlightSeverity)presentation.getSeverity((RefElement)refElement)), uiOptions.GROUP_BY_SEVERITY, this.isSingleInspectionRun());
                        return;
                    }
                    InspectionNode toolNode = presentation.getToolNode();
                    LOG.assertTrue(toolNode != null);
                    HashMap<RefEntity, CommonProblemDescriptor[]> problems = new HashMap<RefEntity, CommonProblemDescriptor[]>(1);
                    problems.put(refElement, descriptors);
                    HashMap<String, Set<RefEntity>> contents = new HashMap<String, Set<RefEntity>>();
                    String groupName = refElement.getRefManager().getGroupName((RefElement)refElement);
                    Set content = contents.computeIfAbsent(groupName, __ -> new HashSet());
                    content.add(refElement);
                    this.getProvider().appendToolNodeContent(this.myGlobalInspectionContext, toolNode, (InspectionTreeNode)toolNode.getParent(), uiOptions.SHOW_STRUCTURE, true, contents, problems::get);
                }
            }
        }));
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Application app = ApplicationManager.getApplication();
        Runnable buildAction = () -> {
            try {
                this.setUpdating(true);
                Object object = this.myTreeStructureUpdateLock;
                synchronized (object) {
                    this.myTree.removeAllNodes();
                    this.addToolsSynchronously(this.myGlobalInspectionContext.getTools().values());
                }
            }
            finally {
                this.setUpdating(false);
                UIUtil.invokeLaterIfNeeded(() -> this.myTree.restoreExpansionAndSelection(false));
            }
        };
        if (app.isUnitTestMode()) {
            buildAction.run();
        } else {
            this.myTreeUpdater.execute(buildAction);
        }
    }

    public void setUpdating(boolean isUpdating) {
        Runnable update = () -> {
            int count;
            this.myUpdatingRequestors = isUpdating ? ++this.myUpdatingRequestors : --this.myUpdatingRequestors;
            boolean hasUpdatingRequestors = this.myUpdatingRequestors > 0;
            this.myTree.setPaintBusy(hasUpdatingRequestors);
            if (!hasUpdatingRequestors && this.myLoadingProgressPreview != null) {
                this.myLoadingProgressPreview.treeLoaded();
            }
            if (!hasUpdatingRequestors && this.mySplitter.getSecondComponent() == null && (count = this.myTree.getRoot().getChildCount()) != 0) {
                if (this.myTree.getSelectionCount() == 0) {
                    TreeUtil.selectFirstNode((JTree)((Object)this.myTree));
                }
                this.syncRightPanel();
            }
        };
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            update.run();
        } else {
            app.invokeLater(update, ModalityState.any());
        }
    }

    public void addTools(Collection<Tools> tools) {
        this.myTreeUpdater.submit(() -> this.addToolsSynchronously(tools));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToolsSynchronously(Collection<Tools> tools) {
        if (this.isDisposed()) {
            return;
        }
        Object object = this.myTreeStructureUpdateLock;
        synchronized (object) {
            InspectionProfileImpl profile2 = this.myInspectionProfile;
            boolean isGroupedBySeverity = this.myGlobalInspectionContext.getUIOptions().GROUP_BY_SEVERITY;
            boolean singleInspectionRun = this.isSingleInspectionRun();
            for (Tools currentTools : tools) {
                InspectionToolWrapper defaultToolWrapper = currentTools.getDefaultState().getTool();
                HighlightDisplayKey key = HighlightDisplayKey.find((String)defaultToolWrapper.getShortName());
                for (ScopeToolState scopeToolState : this.myProvider.getTools(currentTools)) {
                    InspectionToolWrapper toolWrapper = scopeToolState.getTool();
                    if (!((Boolean)ReadAction.compute(() -> this.myProvider.checkReportedProblems(this.myGlobalInspectionContext, toolWrapper))).booleanValue()) continue;
                    this.addTool(toolWrapper, profile2.getErrorLevel(key, scopeToolState.getScope(this.getProject()), this.getProject()), isGroupedBySeverity, singleInspectionRun);
                }
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myTree.getSelectionCount() == 0) {
                TreeUtil.selectFirstNode((JTree)((Object)this.myTree));
            }
            this.syncRightPanel();
        });
    }

    @NotNull
    public Project getProject() {
        Project project = this.myGlobalInspectionContext.getProject();
        if (project == null) {
            InspectionResultsView.$$$reportNull$$$0(4);
        }
        return project;
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (ExclusionHandler.EXCLUSION_HANDLER.is(dataId)) {
            return this.myExclusionHandler;
        }
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        if (paths.length > 1) {
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                return this.collectPsiElements();
            }
            return null;
        }
        TreePath path = paths[0];
        InspectionTreeNode selectedNode = (InspectionTreeNode)path.getLastPathComponent();
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return null;
        }
        if (selectedNode instanceof RefElementNode) {
            PsiElement psiElement;
            RefElementNode refElementNode = (RefElementNode)selectedNode;
            RefEntity refElement = refElementNode.getElement();
            if (refElement == null) {
                return null;
            }
            RefEntity item = refElement.getRefManager().getRefinedElement(refElement);
            if (!item.isValid()) {
                return null;
            }
            PsiElement psiElement2 = psiElement = item instanceof RefElement ? ((RefElement)item).getElement() : null;
            if (psiElement == null) {
                return null;
            }
            CommonProblemDescriptor problem = refElementNode.getDescriptor();
            if (problem instanceof ProblemDescriptor) {
                PsiElement elementFromDescriptor = ((ProblemDescriptor)problem).getPsiElement();
                if (elementFromDescriptor == null && CommonDataKeys.NAVIGATABLE.is(dataId) && refElementNode.getChildCount() != 0) {
                    InspectionTreeNode node = (InspectionTreeNode)refElementNode.getChildAt(0);
                    if (node.isValid()) {
                        return InspectionResultsViewUtil.getNavigatableForInvalidNode((ProblemDescriptionNode)node);
                    }
                } else {
                    psiElement = elementFromDescriptor;
                }
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return this.getSelectedNavigatable(problem, psiElement);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return psiElement != null && psiElement.isValid() ? psiElement : null;
            }
        } else if (selectedNode instanceof ProblemDescriptionNode && CommonDataKeys.NAVIGATABLE.is(dataId)) {
            Navigatable navigatable = this.getSelectedNavigatable(((ProblemDescriptionNode)selectedNode).getDescriptor());
            return navigatable == null ? InspectionResultsViewUtil.getNavigatableForInvalidNode((ProblemDescriptionNode)selectedNode) : navigatable;
        }
        return null;
    }

    void resetTree() {
        try {
            this.myTree.setQueueUpdate(true);
            TreePath[] selectionPath = this.myTree.getSelectionPaths();
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)((Object)this.myTree));
            ((DefaultTreeModel)this.myTree.getModel()).reload();
            TreeUtil.restoreExpandedPaths((JTree)((Object)this.myTree), (List)expandedPaths);
            this.myTree.setSelectionPaths(selectionPath);
        }
        finally {
            this.myTree.setQueueUpdate(false);
        }
    }

    @Nullable
    private Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor) {
        return this.getSelectedNavigatable(descriptor, descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null);
    }

    @Nullable
    private Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor, PsiElement psiElement) {
        VirtualFile virtualFile;
        Navigatable navigatable;
        if (descriptor instanceof ProblemDescriptorBase && (navigatable = ((ProblemDescriptorBase)descriptor).getNavigatable()) != null) {
            return navigatable;
        }
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = containingFile == null ? null : containingFile.getVirtualFile();
        if (virtualFile != null) {
            TextRange textRange;
            int startOffset = psiElement.getTextOffset();
            if (descriptor instanceof ProblemDescriptorBase && (textRange = ((ProblemDescriptorBase)descriptor).getTextRangeForNavigation()) != null) {
                if (virtualFile instanceof VirtualFileWindow) {
                    virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
                }
                startOffset = textRange.getStartOffset();
            }
            return new OpenFileDescriptor(this.getProject(), virtualFile, startOffset);
        }
        return null;
    }

    @NotNull
    private PsiElement[] collectPsiElements() {
        RefEntity[] refElements = this.myTree.getSelectedElements();
        ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
        for (RefEntity refElement : refElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null;
            if (psiElement == null || !psiElement.isValid()) continue;
            psiElements.add(psiElement);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(psiElements);
        if (psiElementArray == null) {
            InspectionResultsView.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    @NotNull
    public InspectionTree getTree() {
        InspectionTree inspectionTree = this.myTree;
        if (inspectionTree == null) {
            InspectionResultsView.$$$reportNull$$$0(6);
        }
        return inspectionTree;
    }

    @NotNull
    public GlobalInspectionContextImpl getGlobalInspectionContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myGlobalInspectionContext;
        if (globalInspectionContextImpl == null) {
            InspectionResultsView.$$$reportNull$$$0(7);
        }
        return globalInspectionContextImpl;
    }

    @NotNull
    public InspectionRVContentProvider getProvider() {
        InspectionRVContentProvider inspectionRVContentProvider = this.myProvider;
        if (inspectionRVContentProvider == null) {
            InspectionResultsView.$$$reportNull$$$0(8);
        }
        return inspectionRVContentProvider;
    }

    public boolean isSingleToolInSelection() {
        return this.myTree.getSelectedToolWrapper(true) != null;
    }

    public boolean isRerun() {
        boolean rerun = this.myRerun;
        this.myRerun = false;
        return rerun;
    }

    public boolean areSettingsEnabled() {
        return this.mySettingsEnabled;
    }

    public boolean isSingleInspectionRun() {
        return this.myInspectionProfile.getSingleTool() != null;
    }

    public static void showPopup(AnActionEvent e, JBPopup popup2) {
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            popup2.showUnderneathOf(event.getComponent());
        } else {
            popup2.showInBestPositionFor(e.getDataContext());
        }
    }

    @NotNull
    public AnalysisScope getScope() {
        AnalysisScope analysisScope = this.myScope;
        if (analysisScope == null) {
            InspectionResultsView.$$$reportNull$$$0(9);
        }
        return analysisScope;
    }

    public boolean isUpdating() {
        return this.myUpdatingRequestors > 0;
    }

    void updateRightPanelLoading() {
        if (!this.myDisposed && this.isUpdating() && this.myLoadingProgressPreview != null) {
            this.myLoadingProgressPreview.updateLoadingProgress();
        }
    }

    public boolean hasProblems() {
        return InspectionResultsView.hasProblems(this.myGlobalInspectionContext.getTools().values(), this.myGlobalInspectionContext, this.myProvider);
    }

    public static boolean hasProblems(@NotNull Collection<Tools> tools, @NotNull GlobalInspectionContextImpl context, @NotNull InspectionRVContentProvider contentProvider) {
        if (tools == null) {
            InspectionResultsView.$$$reportNull$$$0(10);
        }
        if (context == null) {
            InspectionResultsView.$$$reportNull$$$0(11);
        }
        if (contentProvider == null) {
            InspectionResultsView.$$$reportNull$$$0(12);
        }
        for (Tools currentTools : tools) {
            for (ScopeToolState scopeToolState : contentProvider.getTools(currentTools)) {
                InspectionToolWrapper toolWrapper = scopeToolState.getTool();
                if (!context.getPresentation(toolWrapper).hasReportedProblems() && !contentProvider.checkReportedProblems(context, toolWrapper)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isRerunAvailable() {
        return !(this.myProvider instanceof OfflineInspectionRVContentProvider) && this.myScope.isValid();
    }

    public void rerun() {
        this.myRerun = true;
        if (this.myScope.isValid()) {
            AnalysisUIOptions.getInstance(this.getProject()).save(this.myGlobalInspectionContext.getUIOptions());
            this.myGlobalInspectionContext.setTreeState(this.getTree().getTreeState());
            this.myGlobalInspectionContext.doInspections(this.myScope);
        } else {
            GlobalInspectionContextImpl.NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.view.invalid.scope.message", (Object[])new Object[0]), NotificationType.INFORMATION).notify(this.getProject());
        }
    }

    private boolean selectCommonNextSibling(@NotNull TreePath[] selected, @NotNull TreePath commonParent) {
        if (selected == null) {
            InspectionResultsView.$$$reportNull$$$0(13);
        }
        if (commonParent == null) {
            InspectionResultsView.$$$reportNull$$$0(14);
        }
        int pathCount = commonParent.getPathCount() + 1;
        for (TreePath treePath : selected) {
            if (treePath.getPathCount() == pathCount) continue;
            return false;
        }
        InspectionTreeNode parent = (InspectionTreeNode)commonParent.getLastPathComponent();
        int[] indices = new int[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            TreePath treePath = selected[i];
            indices[i] = parent.getIndex((TreeNode)treePath.getLastPathComponent());
        }
        Arrays.sort(indices);
        int prevIdx = -1;
        for (int idx : indices) {
            if (prevIdx != -1 && idx - prevIdx != 1) {
                return false;
            }
            prevIdx = idx;
        }
        int n = indices[indices.length - 1] + 1;
        if (parent.getChildCount() > n) {
            TreeNode nodeToSelect = parent.getChildAt(n);
            TreeUtil.removeSelected((JTree)((Object)this.myTree));
            TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)nodeToSelect);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedNodes() {
        Object object = this.myTreeStructureUpdateLock;
        synchronized (object) {
            TreePath commonParent;
            TreePath[] selected = this.myTree.getSelectionPaths();
            if (selected != null && !this.selectCommonNextSibling(selected, commonParent = TreeUtil.findCommonPath((TreePath[])selected))) {
                TreeUtil.removeSelected((JTree)((Object)this.myTree));
                TreeUtil.selectPath((JTree)((Object)this.myTree), (TreePath)commonParent);
            }
        }
        this.myTree.revalidate();
        this.myTree.repaint();
    }

    public void dispatchTreeUpdate() throws Exception {
        this.myTreeUpdater.submit(EmptyRunnable.getInstance()).get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionResultsView";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionResultsView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPsiElements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalInspectionContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTool";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerActionShortcuts";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasProblems";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectCommonNextSibling";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerActionShortcuts$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

