/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KeyAwareInspectionViewAction
extends InspectionViewActionBase {
    private static final Logger LOG = Logger.getInstance(KeyAwareInspectionViewAction.class);

    public KeyAwareInspectionViewAction(String name) {
        super(name);
    }

    @Override
    protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
        InspectionToolWrapper wrapper;
        if (view == null) {
            KeyAwareInspectionViewAction.$$$reportNull$$$0(0);
        }
        return (wrapper = view.getTree().getSelectedToolWrapper(true)) != null && HighlightDisplayKey.find((String)wrapper.getShortName()) != null;
    }

    public void actionPerformed(AnActionEvent e) {
        InspectionResultsView view = KeyAwareInspectionViewAction.getView(e);
        HighlightDisplayKey key = HighlightDisplayKey.find((String)view.getTree().getSelectedToolWrapper(true).getShortName());
        this.actionPerformed(view, key);
    }

    protected abstract void actionPerformed(@NotNull InspectionResultsView var1, @NotNull HighlightDisplayKey var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction", "isEnabled"));
    }

    public static class RunInspectionOn
    extends KeyAwareInspectionViewAction {
        public RunInspectionOn() {
            super(InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]));
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
            if (view == null) {
                RunInspectionOn.$$$reportNull$$$0(0);
            }
            return super.isEnabled(view, e) && RunInspectionOn.getPsiElement(view) != null;
        }

        @Override
        protected void actionPerformed(@NotNull InspectionResultsView view, @NotNull HighlightDisplayKey key) {
            AnalysisScope scope;
            PsiFile context;
            if (view == null) {
                RunInspectionOn.$$$reportNull$$$0(1);
            }
            if (key == null) {
                RunInspectionOn.$$$reportNull$$$0(2);
            }
            THashSet files = new THashSet();
            for (RefEntity entity : view.getTree().getSelectedElements()) {
                if (!(entity instanceof RefElement) || !entity.isValid()) continue;
                PsiElement element = ((RefElement)entity).getElement();
                PsiFile file2 = element.getContainingFile();
                files.add(file2);
            }
            boolean useModule = true;
            Module module = null;
            for (PsiFile file3 : files) {
                Module currentFileModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)file3);
                if (currentFileModule != null) {
                    if (module == null) {
                        module = currentFileModule;
                        continue;
                    }
                    if (currentFileModule == module) continue;
                    useModule = false;
                    break;
                }
                useModule = false;
                break;
            }
            switch (files.size()) {
                case 0: {
                    context = null;
                    scope = view.getScope();
                    break;
                }
                case 1: {
                    PsiFile theFile = (PsiFile)ContainerUtil.getFirstItem((Collection)files);
                    LOG.assertTrue(theFile != null);
                    context = theFile;
                    scope = new AnalysisScope(theFile);
                    break;
                }
                default: {
                    context = null;
                    scope = new AnalysisScope(view.getProject(), (Collection)files.stream().map(PsiFile::getVirtualFile).collect(Collectors.toList()));
                }
            }
            RunInspectionIntention.selectScopeAndRunInspection(key.toString(), scope, (Module)(useModule ? module : null), (PsiElement)context, view.getProject());
        }

        @Nullable
        private static PsiElement getPsiElement(InspectionResultsView view) {
            RefEntity[] selectedElements = view.getTree().getSelectedElements();
            PsiElement psiElement = selectedElements.length > 0 && selectedElements[0] instanceof RefElement ? ((RefElement)selectedElements[0]).getElement() : null;
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$RunInspectionOn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DisableInspection
    extends KeyAwareInspectionViewAction {
        public DisableInspection() {
            super(DisableInspectionToolAction.NAME);
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
            boolean enabled;
            if (view == null) {
                DisableInspection.$$$reportNull$$$0(0);
            }
            if (!(enabled = super.isEnabled(view, e))) {
                return false;
            }
            HighlightDisplayKey key = HighlightDisplayKey.find((String)view.getTree().getSelectedToolWrapper(true).getShortName());
            InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(view.getProject()).getCurrentProfile();
            return profile2.isToolEnabled(key);
        }

        @Override
        protected void actionPerformed(@NotNull InspectionResultsView view, @NotNull HighlightDisplayKey key) {
            if (view == null) {
                DisableInspection.$$$reportNull$$$0(1);
            }
            if (key == null) {
                DisableInspection.$$$reportNull$$$0(2);
            }
            if (view.isSingleInspectionRun()) {
                view.getCurrentProfile().modifyProfile((Consumer<InspectionProfileModifiableModel>)((Consumer)it -> {
                    if (key == null) {
                        DisableInspection.$$$reportNull$$$0(4);
                    }
                    it.setToolEnabled(key.toString(), false);
                }));
            } else {
                RefEntity[] selectedElements = view.getTree().getSelectedElements();
                HashSet<PsiElement> files = new HashSet<PsiElement>();
                for (RefEntity selectedElement : selectedElements) {
                    if (!(selectedElement instanceof RefElement)) continue;
                    files.add(((RefElement)selectedElement).getElement());
                }
                InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile(view.getProject(), (Consumer<InspectionProfileModifiableModel>)((Consumer)it -> {
                    if (key == null) {
                        DisableInspection.$$$reportNull$$$0(3);
                    }
                    for (PsiElement element : files) {
                        it.disableTool(key.toString(), element);
                    }
                }));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$DisableInspection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$actionPerformed$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$actionPerformed$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

