/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.KeePassCredentialStoreKt;
import com.intellij.credentialStore.MasterKeyFileStorage;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.SecureString;
import com.intellij.credentialStore.kdbx.KdbxEntry;
import com.intellij.credentialStore.kdbx.KdbxGroup;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KdbxPassword;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.ide.passwordSafe.PasswordStorage;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.util.io.PathKt;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BI\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0001J\b\u0010&\u001a\u00020#H\u0007J\u0013\u0010'\u001a\u0004\u0018\u00010\u00062\u0006\u0010(\u001a\u00020\u0005H\u0096\u0002J\b\u0010)\u001a\u00020#H\u0007J\u001b\u0010*\u001a\u00020#2\u0006\u0010(\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010\u0006H\u0096\u0002J\u000e\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/credentialStore/KeePassCredentialStore;", "Lcom/intellij/ide/passwordSafe/PasswordStorage;", "Lcom/intellij/credentialStore/CredentialStore;", "keyToValue", "", "Lcom/intellij/credentialStore/CredentialAttributes;", "Lcom/intellij/credentialStore/Credentials;", "baseDirectory", "Ljava/nio/file/Path;", "memoryOnly", "", "dbFile", "existingMasterPassword", "", "(Ljava/util/Map;Ljava/nio/file/Path;ZLjava/nio/file/Path;[B)V", "db", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "path", "getDbFile$intellij_platform_credentialStore", "()Ljava/nio/file/Path;", "setDbFile$intellij_platform_credentialStore", "(Ljava/nio/file/Path;)V", "masterKeyStorage", "Lcom/intellij/credentialStore/MasterKeyFileStorage;", "getMasterKeyStorage", "()Lcom/intellij/credentialStore/MasterKeyFileStorage;", "masterKeyStorage$delegate", "Lkotlin/Lazy;", "getMemoryOnly", "()Z", "setMemoryOnly", "(Z)V", "needToSave", "Ljava/util/concurrent/atomic/AtomicBoolean;", "clear", "", "copyTo", "store", "deleteFileStorage", "get", "attributes", "save", "set", "credentials", "setMasterPassword", "masterPassword", "intellij.platform.credentialStore"})
public final class KeePassCredentialStore
implements PasswordStorage,
CredentialStore {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private Path dbFile;
    private final KeePassDatabase db;
    private final Lazy masterKeyStorage$delegate;
    private final AtomicBoolean needToSave;
    private boolean memoryOnly;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KeePassCredentialStore.class), "masterKeyStorage", "getMasterKeyStorage()Lcom/intellij/credentialStore/MasterKeyFileStorage;"))};
    }

    @NotNull
    public final Path getDbFile$intellij_platform_credentialStore() {
        return this.dbFile;
    }

    public final void setDbFile$intellij_platform_credentialStore(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (Intrinsics.areEqual((Object)this.dbFile, (Object)path)) {
            return;
        }
        this.dbFile = path;
        this.needToSave.set(true);
        this.save();
    }

    private final MasterKeyFileStorage getMasterKeyStorage() {
        Lazy lazy = this.masterKeyStorage$delegate;
        KeePassCredentialStore keePassCredentialStore = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (MasterKeyFileStorage)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void save() {
        if (this.memoryOnly || !this.needToSave.compareAndSet(true, false) && !this.db.isDirty()) {
            return;
        }
        try {
            void masterKey;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = this.getMasterKeyStorage().get();
            if ((byte[])masterKey.element == null) {
                byte[] bytes = new byte[32];
                new SecureRandom().nextBytes(bytes);
                masterKey.element = Base64.getEncoder().withoutPadding().encode(bytes);
                this.getMasterKeyStorage().set((byte[])masterKey.element);
            }
            PathKt.writeSafe((Path)this.dbFile, (Function1)((Function1)new Function1<OutputStream, Unit>(this, (Ref.ObjectRef)masterKey){
                final /* synthetic */ KeePassCredentialStore this$0;
                final /* synthetic */ Ref.ObjectRef $masterKey;

                public final void invoke(@NotNull OutputStream it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    KeePassDatabase keePassDatabase = KeePassCredentialStore.access$getDb$p(this.this$0);
                    byte[] byArray = (byte[])this.$masterKey.element;
                    if (byArray == null) {
                        Intrinsics.throwNpe();
                    }
                    keePassDatabase.save(new KdbxPassword(byArray), it);
                }
                {
                    this.this$0 = keePassCredentialStore;
                    this.$masterKey = objectRef;
                    super(1);
                }
            }));
            FileUtilKt.setOwnerPermissions(this.dbFile);
        }
        catch (Throwable e) {
            this.needToSave.set(true);
            CredentialStoreKt.getLOG().error("Cannot save password database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void deleteFileStorage() {
        try {
            PathKt.delete((Path)this.dbFile);
        }
        finally {
            this.getMasterKeyStorage().set(null);
        }
    }

    public final void clear() {
        this.db.getRootGroup().removeGroup("IntelliJ Platform");
        this.needToSave.set(this.db.isDirty());
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        KdbxEntry entry;
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Class requestor = attributes.getRequestor();
        String userName = attributes.getUserName();
        KdbxGroup kdbxGroup = this.db.getRootGroup().getGroup("IntelliJ Platform");
        KdbxEntry kdbxEntry = entry = kdbxGroup != null ? kdbxGroup.getEntry(attributes.getServiceName(), attributes.getUserName()) : null;
        if (entry != null) {
            String string = attributes.getUserName();
            if (string == null) {
                string = entry.getUserName();
            }
            SecureString secureString = entry.getPassword();
            return new Credentials(string, secureString != null ? SecureString.get$default(secureString, false, 1, null) : null);
        }
        if (requestor == null || userName == null) {
            return null;
        }
        CredentialAttributes oldAttributes = CredentialStoreKt.toOldKey(requestor, userName);
        Object object = this.db.getRootGroup().getGroup("IntelliJ Platform");
        if (object != null && (object = ((KdbxGroup)object).removeEntry(oldAttributes.getServiceName(), oldAttributes.getUserName())) != null) {
            Object object2;
            Object it = object2 = object;
            Function0<Credentials> createCredentials$ = new Function0<Credentials>((KdbxEntry)it, this, userName, requestor){
                final /* synthetic */ KdbxEntry $it;
                final /* synthetic */ KeePassCredentialStore this$0;
                final /* synthetic */ String $userName$inlined;
                final /* synthetic */ Class $requestor$inlined;
                {
                    this.$it = kdbxEntry;
                    this.this$0 = keePassCredentialStore;
                    this.$userName$inlined = string;
                    this.$requestor$inlined = clazz;
                    super(0);
                }

                @NotNull
                public final Credentials invoke() {
                    SecureString secureString = this.$it.getPassword();
                    return new Credentials(this.$userName$inlined, secureString != null ? SecureString.get$default(secureString, false, 1, null) : null);
                }
            };
            this.set(CredentialAttributesKt.CredentialAttributes((Class)requestor, (String)userName), createCredentials$.invoke());
            return createCredentials$.invoke();
        }
        return null;
    }

    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        if (credentials == null) {
            KdbxGroup kdbxGroup = this.db.getRootGroup().getGroup("IntelliJ Platform");
            if (kdbxGroup != null) {
                kdbxGroup.removeEntry(attributes.getServiceName(), attributes.getUserName());
            }
        } else {
            SecureString secureString;
            KdbxGroup group = this.db.getRootGroup().getOrCreateGroup("IntelliJ Platform");
            String string = attributes.getUserName();
            if (string == null) {
                string = credentials.getUserName();
            }
            String userName = string;
            KdbxEntry entry = group.getEntry(attributes.getServiceName(), Intrinsics.areEqual((Object)attributes.getServiceName(), (Object)"IntelliJ Platform") ? userName : null);
            if (entry == null) {
                entry = group.getOrCreateEntry(attributes.getServiceName(), userName);
            }
            entry.setUserName(userName);
            if (attributes.isPasswordMemoryOnly() || credentials.getPassword() == null) {
                secureString = null;
            } else {
                OneTimeString oneTimeString = credentials.getPassword();
                if (oneTimeString == null) {
                    Intrinsics.throwNpe();
                }
                secureString = CredentialStoreKt.SecureString((CharSequence)oneTimeString);
            }
            entry.setPassword(secureString);
        }
        if (this.db.isDirty()) {
            this.needToSave.set(true);
        }
    }

    public final void copyTo(@NotNull PasswordStorage store) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        KdbxGroup kdbxGroup = this.db.getRootGroup().getGroup("IntelliJ Platform");
        if (kdbxGroup == null) {
            return;
        }
        KdbxGroup group = kdbxGroup;
        for (KdbxEntry entry : group.getEntries()) {
            String title = entry.getTitle();
            if (title == null) continue;
            SecureString secureString = entry.getPassword();
            store.set(new CredentialAttributes(title, entry.getUserName(), null, false, 12, null), new Credentials(entry.getUserName(), secureString != null ? SecureString.get$default(secureString, false, 1, null) : null));
        }
    }

    public final void setMasterPassword(@NotNull byte[] masterPassword) {
        Intrinsics.checkParameterIsNotNull((Object)masterPassword, (String)"masterPassword");
        CredentialStoreKt.getLOG().assertTrue(!this.memoryOnly);
        this.getMasterKeyStorage().set(masterPassword);
        PathKt.writeSafe((Path)this.dbFile, (Function1)((Function1)new Function1<OutputStream, Unit>(this, masterPassword){
            final /* synthetic */ KeePassCredentialStore this$0;
            final /* synthetic */ byte[] $masterPassword;

            public final void invoke(@NotNull OutputStream it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                KeePassCredentialStore.access$getDb$p(this.this$0).save(new KdbxPassword(this.$masterPassword), it);
            }
            {
                this.this$0 = keePassCredentialStore;
                this.$masterPassword = byArray;
                super(1);
            }
        }));
        FileUtilKt.setOwnerPermissions(this.dbFile);
    }

    public final boolean getMemoryOnly() {
        return this.memoryOnly;
    }

    public final void setMemoryOnly(boolean bl) {
        this.memoryOnly = bl;
    }

    public KeePassCredentialStore(@Nullable Map<CredentialAttributes, Credentials> keyToValue, @NotNull Path baseDirectory, boolean memoryOnly, @Nullable Path dbFile, @Nullable byte[] existingMasterPassword) {
        block12: {
            block10: {
                byte[] masterPassword;
                block13: {
                    block11: {
                        Intrinsics.checkParameterIsNotNull((Object)baseDirectory, (String)"baseDirectory");
                        this.memoryOnly = memoryOnly;
                        Path path = dbFile;
                        if (path == null) {
                            Path path2 = baseDirectory.resolve(KeePassCredentialStoreKt.getDB_FILE_NAME());
                            path = path2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"baseDirectory.resolve(DB_FILE_NAME)");
                        }
                        this.dbFile = path;
                        this.masterKeyStorage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MasterKeyFileStorage>(baseDirectory){
                            final /* synthetic */ Path $baseDirectory;

                            @NotNull
                            public final MasterKeyFileStorage invoke() {
                                return new MasterKeyFileStorage(this.$baseDirectory);
                            }
                            {
                                this.$baseDirectory = path;
                                super(0);
                            }
                        }));
                        if (keyToValue != null) break block10;
                        this.needToSave = new AtomicBoolean(false);
                        if (!this.memoryOnly) break block11;
                        this.db = new KeePassDatabase(null, 1, null);
                        break block12;
                    }
                    byte[] byArray = existingMasterPassword;
                    if (existingMasterPassword == null) {
                        byArray = masterPassword = this.getMasterKeyStorage().get();
                    }
                    if (masterPassword != null) break block13;
                    Logger $receiver$iv = CredentialStoreKt.getLOG();
                    try {
                        if (PathKt.exists((Path)this.dbFile)) {
                            Path renameTo = baseDirectory.resolve("old.c.kdbx");
                            CredentialStoreKt.getLOG().warn("Credentials database file exists (" + this.dbFile + "), but no master password file. Moved to " + renameTo);
                            Path path = renameTo;
                            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"renameTo");
                            PathKt.move((Path)this.dbFile, (Path)path);
                        }
                    }
                    catch (ProcessCanceledException e$iv) {
                    }
                    catch (Throwable e$iv) {
                        $receiver$iv.error(e$iv);
                    }
                    this.db = new KeePassDatabase(null, 1, null);
                    break block12;
                }
                KeePassDatabase keePassDatabase = KdbxKt.loadKdbx(this.dbFile, new KdbxPassword(masterPassword));
                if (keePassDatabase == null) {
                    keePassDatabase = this.db = new KeePassDatabase(null, 1, null);
                }
                if (existingMasterPassword == null) break block12;
                this.getMasterKeyStorage().set(existingMasterPassword);
                break block12;
            }
            this.needToSave = new AtomicBoolean(!this.memoryOnly);
            this.db = new KeePassDatabase(null, 1, null);
            KdbxGroup group = this.db.getRootGroup().getOrCreateGroup("IntelliJ Platform");
            Map<CredentialAttributes, Credentials> $i$a$1$runAndLogException = keyToValue;
            Iterator<Map.Entry<CredentialAttributes, Credentials>> iterator = $i$a$1$runAndLogException.entrySet().iterator();
            while (iterator.hasNext()) {
                SecureString secureString;
                Map.Entry<CredentialAttributes, Credentials> entry;
                Map.Entry<CredentialAttributes, Credentials> $i$f$runAndLogException = entry = iterator.next();
                CredentialAttributes attributes = $i$f$runAndLogException.getKey();
                $i$f$runAndLogException = entry;
                Credentials credentials = $i$f$runAndLogException.getValue();
                KdbxEntry entry2 = this.db.createEntry(attributes.getServiceName());
                entry2.setUserName(credentials.getUserName());
                KdbxEntry kdbxEntry = entry2;
                if (credentials.getPassword() != null) {
                    OneTimeString oneTimeString;
                    KdbxEntry kdbxEntry2 = kdbxEntry;
                    CharSequence p1 = (CharSequence)oneTimeString;
                    SecureString secureString2 = CredentialStoreKt.SecureString(p1);
                    kdbxEntry = kdbxEntry2;
                    secureString = secureString2;
                } else {
                    secureString = null;
                }
                kdbxEntry.setPassword(secureString);
                group.addEntry(entry2);
            }
        }
    }

    public /* synthetic */ KeePassCredentialStore(Map map, Path path, boolean bl, Path path2, byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = null;
        }
        if ((n & 2) != 0) {
            Path path3 = Paths.get(PathManager.getConfigPath(), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(PathManager.getConfigPath())");
            path = path3;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            path2 = null;
        }
        if ((n & 0x10) != 0) {
            byArray = null;
        }
        this(map, path, bl, path2, byArray);
    }

    public KeePassCredentialStore() {
        this(null, null, false, null, null, 31, null);
    }

    @NotNull
    public static final /* synthetic */ KeePassDatabase access$getDb$p(KeePassCredentialStore $this) {
        return $this.db;
    }
}

