/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProviderBase;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleTextDiffProvider
extends TwosideTextDiffProviderBase
implements TwosideTextDiffProvider {
    static final DiffUserDataKeysEx.DiffComputer DEFAULT_COMPUTER = (text1, text2, policy, innerChanges, indicator) -> {
        if (innerChanges) {
            return ComparisonManager.getInstance().compareLinesInner(text1, text2, policy, indicator);
        }
        return ComparisonManager.getInstance().compareLines(text1, text2, policy, indicator);
    };
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES_CHUNKS};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD, HighlightPolicy.BY_WORD_SPLIT, HighlightPolicy.DO_NOT_HIGHLIGHT};
    @NotNull
    private final DiffUserDataKeysEx.DiffComputer myDiffComputer;

    public SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        if (settings == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(0);
        }
        if (rediff == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(2);
        }
        this(settings, rediff, disposable, DEFAULT_COMPUTER);
    }

    public SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffUserDataKeysEx.DiffComputer diffComputer) {
        if (settings == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(3);
        }
        if (rediff == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(5);
        }
        if (diffComputer == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(6);
        }
        this(settings, rediff, disposable, diffComputer, IGNORE_POLICIES, HIGHLIGHT_POLICIES);
    }

    private SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffUserDataKeysEx.DiffComputer diffComputer, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        if (settings == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(7);
        }
        if (rediff == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(8);
        }
        if (disposable == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(9);
        }
        if (diffComputer == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(10);
        }
        if (ignorePolicies == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(11);
        }
        if (highlightPolicies == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(12);
        }
        super(settings, rediff, disposable, ignorePolicies, highlightPolicies);
        this.myDiffComputer = diffComputer;
    }

    @Override
    @NotNull
    protected List<List<LineFragment>> doCompare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull List<Range> linesRanges, @NotNull IgnorePolicy ignorePolicy, boolean innerFragments, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(13);
        }
        if (text2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(14);
        }
        if (lineOffsets1 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(15);
        }
        if (lineOffsets2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(16);
        }
        if (linesRanges == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(17);
        }
        if (ignorePolicy == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(19);
        }
        List<List<LineFragment>> list2 = SimpleTextDiffProvider.compareRange(this.myDiffComputer, text1, text2, lineOffsets1, lineOffsets2, linesRanges, ignorePolicy, innerFragments, indicator);
        if (list2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    public static List<List<LineFragment>> compareRange(@NotNull DiffUserDataKeysEx.DiffComputer diffComputer, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull List<Range> linesRanges, @NotNull IgnorePolicy ignorePolicy, boolean innerFragments, @NotNull ProgressIndicator indicator) {
        if (diffComputer == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(21);
        }
        if (text1 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(22);
        }
        if (text2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(23);
        }
        if (lineOffsets1 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(24);
        }
        if (lineOffsets2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(25);
        }
        if (linesRanges == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(26);
        }
        if (ignorePolicy == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(27);
        }
        if (indicator == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(28);
        }
        ComparisonPolicy policy = ignorePolicy.getComparisonPolicy();
        ArrayList<List<LineFragment>> result2 = new ArrayList<List<LineFragment>>();
        for (Range range2 : linesRanges) {
            CharSequence content1 = DiffUtil.getLinesContent(text1, lineOffsets1, range2.start1, range2.end1, true);
            CharSequence content2 = DiffUtil.getLinesContent(text2, lineOffsets2, range2.start2, range2.end2, true);
            if (range2.start1 == range2.end1 || range2.start2 == range2.end2) {
                boolean isEquals = ComparisonUtil.isEquals(content1, content2, policy);
                result2.add(Collections.singletonList(SimpleTextDiffProvider.createSimpleFragment(range2, lineOffsets1, lineOffsets2, isEquals)));
                continue;
            }
            List<LineFragment> fragments = diffComputer.compute(content1, content2, policy, innerFragments, indicator);
            int startOffset1 = lineOffsets1.getLineStart(range2.start1);
            int startOffset2 = lineOffsets2.getLineStart(range2.start2);
            result2.add(ContainerUtil.map(fragments, fragment -> SimpleTextDiffProvider.transferFragment(fragment, range2.start1, range2.start2, startOffset1, startOffset2)));
        }
        ArrayList<List<LineFragment>> arrayList = result2;
        if (arrayList == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @NotNull
    public static LineFragment createSimpleFragment(@NotNull Range linesRange, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, boolean isEquals) {
        if (linesRange == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(30);
        }
        if (lineOffsets1 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(31);
        }
        if (lineOffsets2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(32);
        }
        TextRange textRange1 = DiffUtil.getLinesRange(lineOffsets1, linesRange.start1, linesRange.end1, true);
        TextRange textRange2 = DiffUtil.getLinesRange(lineOffsets2, linesRange.start2, linesRange.end2, true);
        LineFragmentImpl lineFragmentImpl = new LineFragmentImpl(linesRange.start1, linesRange.end1, linesRange.start2, linesRange.end2, textRange1.getStartOffset(), textRange1.getEndOffset(), textRange2.getStartOffset(), textRange2.getEndOffset(), isEquals ? Collections.emptyList() : null);
        if (lineFragmentImpl == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(33);
        }
        return lineFragmentImpl;
    }

    @NotNull
    public static LineFragment transferFragment(@NotNull LineFragment fragment, int startLine1, int startLine2, int startOffset1, int startOffset2) {
        if (fragment == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(34);
        }
        if (startLine1 == 0 && startLine2 == 0 && startOffset1 == 0 && startOffset2 == 0) {
            LineFragment lineFragment = fragment;
            if (lineFragment == null) {
                SimpleTextDiffProvider.$$$reportNull$$$0(35);
            }
            return lineFragment;
        }
        LineFragmentImpl lineFragmentImpl = new LineFragmentImpl(fragment.getStartLine1() + startLine1, fragment.getEndLine1() + startLine1, fragment.getStartLine2() + startLine2, fragment.getEndLine2() + startLine2, fragment.getStartOffset1() + startOffset1, fragment.getEndOffset1() + startOffset1, fragment.getStartOffset2() + startOffset2, fragment.getEndOffset2() + startOffset2, fragment.getInnerFragments());
        if (lineFragmentImpl == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(36);
        }
        return lineFragmentImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 29: 
            case 33: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 29: 
            case 33: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: 
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffComputer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicies";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightPolicies";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 15: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets1";
                break;
            }
            case 16: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets2";
                break;
            }
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linesRanges";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicy";
                break;
            }
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 20: 
            case 29: 
            case 33: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/text/SimpleTextDiffProvider";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linesRange";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/text/SimpleTextDiffProvider";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompare";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "compareRange";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleFragment";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "transferFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doCompare";
                break;
            }
            case 20: 
            case 29: 
            case 33: 
            case 35: 
            case 36: {
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "compareRange";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleFragment";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "transferFragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 29: 
            case 33: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NoIgnore
    extends SimpleTextDiffProvider
    implements TwosideTextDiffProvider.NoIgnore {
        public NoIgnore(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
            if (settings == null) {
                NoIgnore.$$$reportNull$$$0(0);
            }
            if (rediff == null) {
                NoIgnore.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                NoIgnore.$$$reportNull$$$0(2);
            }
            this(settings, rediff, disposable, DEFAULT_COMPUTER);
        }

        public NoIgnore(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffUserDataKeysEx.DiffComputer diffComputer) {
            if (settings == null) {
                NoIgnore.$$$reportNull$$$0(3);
            }
            if (rediff == null) {
                NoIgnore.$$$reportNull$$$0(4);
            }
            if (disposable == null) {
                NoIgnore.$$$reportNull$$$0(5);
            }
            if (diffComputer == null) {
                NoIgnore.$$$reportNull$$$0(6);
            }
            super(settings, rediff, disposable, diffComputer, IGNORE_POLICIES, (HighlightPolicy[])ArrayUtil.remove((Object[])HIGHLIGHT_POLICIES, (Object)((Object)HighlightPolicy.DO_NOT_HIGHLIGHT)));
        }

        @Override
        @NotNull
        public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                NoIgnore.$$$reportNull$$$0(7);
            }
            if (text2 == null) {
                NoIgnore.$$$reportNull$$$0(8);
            }
            if (indicator == null) {
                NoIgnore.$$$reportNull$$$0(9);
            }
            List list2 = super.compare(text1, text2, indicator);
            if (list2 == null) {
                NoIgnore.$$$reportNull$$$0(10);
            }
            return list2;
        }

        @Override
        @NotNull
        public List<List<LineFragment>> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<Range> linesRanges, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                NoIgnore.$$$reportNull$$$0(11);
            }
            if (text2 == null) {
                NoIgnore.$$$reportNull$$$0(12);
            }
            if (linesRanges == null) {
                NoIgnore.$$$reportNull$$$0(13);
            }
            if (indicator == null) {
                NoIgnore.$$$reportNull$$$0(14);
            }
            List list2 = super.compare(text1, text2, (List)linesRanges, indicator);
            if (list2 == null) {
                NoIgnore.$$$reportNull$$$0(15);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rediff";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffComputer";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linesRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore";
                    break;
                }
                case 10: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 10: 
                case 15: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

