/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentVariablesTextFieldWithBrowseButton
extends TextFieldWithBrowseButton
implements UserActivityProviderComponent {
    private EnvironmentVariablesData myData = EnvironmentVariablesData.DEFAULT;
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public EnvironmentVariablesTextFieldWithBrowseButton() {
        this.setEditable(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new MyEnvironmentVariablesDialog().show();
            }
        });
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myData.getEnvs();
        if (map == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(0);
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(1);
        }
        this.setData(EnvironmentVariablesData.create(envs, this.myData.isPassParentEnvs()));
    }

    @NotNull
    public EnvironmentVariablesData getData() {
        EnvironmentVariablesData environmentVariablesData = this.myData;
        if (environmentVariablesData == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(2);
        }
        return environmentVariablesData;
    }

    public void setData(@NotNull EnvironmentVariablesData data) {
        if (data == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(3);
        }
        EnvironmentVariablesData oldData = this.myData;
        this.myData = data;
        this.setText(EnvironmentVariablesTextFieldWithBrowseButton.stringifyEnvs(data.getEnvs()));
        if (!oldData.equals(data)) {
            this.fireStateChanged();
        }
    }

    @NotNull
    private static String stringifyEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(4);
        }
        if (envs.isEmpty()) {
            if ("" == null) {
                EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(5);
            }
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(entry.getKey()).append("=").append(entry.getValue());
        }
        String string = buf.toString();
        if (string == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isPassParentEnvs() {
        return this.myData.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.setData(EnvironmentVariablesData.create(this.myData.getEnvs(), passParentEnvs));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.myListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.myListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        for (ChangeListener listener2 : this.myListeners) {
            listener2.stateChanged(new ChangeEvent((Object)this));
        }
    }

    public static void showParentEnvironmentDialog(@NotNull Component parent) {
        if (parent == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(7);
        }
        EnvVariablesTable table = new EnvVariablesTable();
        table.setValues(EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(new TreeMap<String, String>(new GeneralCommandLine().getParentEnvironment()), true));
        table.getActionsPanel().setVisible(false);
        DialogBuilder builder = new DialogBuilder(parent);
        builder.setTitle(ExecutionBundle.message((String)"environment.variables.system.dialog.title", (Object[])new Object[0]));
        builder.centerPanel(table.getComponent());
        builder.addCloseButton();
        builder.show();
    }

    private static List<EnvironmentVariable> convertToVariables(Map<String, String> map, final boolean readOnly) {
        return ContainerUtil.map(map.entrySet(), entry -> new EnvironmentVariable((String)entry.getKey(), (String)entry.getValue(), readOnly){

            public boolean getNameIsWriteable() {
                return !readOnly;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "stringifyEnvs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showParentEnvironmentDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEnvironmentVariablesDialog
    extends DialogWrapper {
        private final EnvVariablesTable myEnvVariablesTable;
        private final JCheckBox myUseDefaultCb;
        private final JPanel myWholePanel;

        protected MyEnvironmentVariablesDialog() {
            super((Component)((Object)EnvironmentVariablesTextFieldWithBrowseButton.this), true);
            this.myUseDefaultCb = new JCheckBox(ExecutionBundle.message((String)"env.vars.checkbox.title", (Object[])new Object[0]));
            this.myWholePanel = new JPanel(new BorderLayout());
            this.myEnvVariablesTable = new EnvVariablesTable();
            this.myEnvVariablesTable.setValues(EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(EnvironmentVariablesTextFieldWithBrowseButton.this.myData.getEnvs(), false));
            this.myUseDefaultCb.setSelected(EnvironmentVariablesTextFieldWithBrowseButton.this.isPassParentEnvs());
            this.myWholePanel.add((Component)this.myEnvVariablesTable.getComponent(), "Center");
            JPanel useDefaultPanel = new JPanel(new BorderLayout());
            useDefaultPanel.add((Component)this.myUseDefaultCb, "Center");
            HyperlinkLabel showLink = new HyperlinkLabel(ExecutionBundle.message((String)"env.vars.show.system", (Object[])new Object[0]));
            useDefaultPanel.add((Component)showLink, "East");
            showLink.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        EnvironmentVariablesTextFieldWithBrowseButton.showParentEnvironmentDialog(MyEnvironmentVariablesDialog.this.getWindow());
                    }
                }
            });
            this.myWholePanel.add((Component)useDefaultPanel, "South");
            this.setTitle(ExecutionBundle.message((String)"environment.variables.dialog.title", (Object[])new Object[0]));
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myWholePanel;
        }

        protected void doOKAction() {
            this.myEnvVariablesTable.stopEditing();
            LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>();
            for (EnvironmentVariable variable : this.myEnvVariablesTable.getEnvironmentVariables()) {
                envs.put(variable.getName(), variable.getValue());
            }
            EnvironmentVariablesTextFieldWithBrowseButton.this.setEnvs(envs);
            EnvironmentVariablesTextFieldWithBrowseButton.this.setPassParentEnvs(this.myUseDefaultCb.isSelected());
            super.doOKAction();
        }
    }
}

